/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.GuardianSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiCommandBlock;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.GuiScreenDemo;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.recipebook.GuiRecipeBook;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.toasts.RecipeToast;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleItemPickup;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.client.player.inventory.LocalBlockIntercommunication;
import net.minecraft.client.renderer.debug.DebugRendererNeighborsUpdate;
import net.minecraft.client.renderer.debug.DebugRendererWorldGenAttempts;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.NBTQueryManager;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.NpcMerchant;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityTrident;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketConfirmTeleport;
import net.minecraft.network.play.client.CPacketConfirmTransaction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.network.play.server.SPacketAdvancementInfo;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketBlockAction;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketCamera;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketCloseWindow;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.network.play.server.SPacketCombatEvent;
import net.minecraft.network.play.server.SPacketCommandList;
import net.minecraft.network.play.server.SPacketConfirmTransaction;
import net.minecraft.network.play.server.SPacketCooldown;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.network.play.server.SPacketDisplayObjective;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntity;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.network.play.server.SPacketEntityHeadLook;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketJoinGame;
import net.minecraft.network.play.server.SPacketKeepAlive;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.network.play.server.SPacketMoveVehicle;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.network.play.server.SPacketNBTQueryResponse;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.network.play.server.SPacketPlaceGhostRecipe;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerListHeaderFooter;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketPlayerLook;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.network.play.server.SPacketRecipeBook;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketSelectAdvancementsTab;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketSignEditorOpen;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketSpawnExperienceOrb;
import net.minecraft.network.play.server.SPacketSpawnGlobalEntity;
import net.minecraft.network.play.server.SPacketSpawnMob;
import net.minecraft.network.play.server.SPacketSpawnObject;
import net.minecraft.network.play.server.SPacketSpawnPainting;
import net.minecraft.network.play.server.SPacketSpawnPlayer;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.network.play.server.SPacketStatistics;
import net.minecraft.network.play.server.SPacketStopSound;
import net.minecraft.network.play.server.SPacketTabComplete;
import net.minecraft.network.play.server.SPacketTagsList;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.network.play.server.SPacketUpdateBossInfo;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.network.play.server.SPacketUpdateRecipes;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.network.play.server.SPacketWindowItems;
import net.minecraft.network.play.server.SPacketWindowProperty;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.Stat;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tags.TagCollection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityConduit;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class NetHandlerPlayClient
implements INetHandlerPlayClient {
    private static final Logger field_147301_d = LogManager.getLogger();
    private final NetworkManager field_147302_e;
    private final GameProfile field_175107_d;
    private final GuiScreen field_147307_j;
    private Minecraft field_147299_f;
    private WorldClient field_147300_g;
    private boolean field_147309_h;
    private final Map<UUID, NetworkPlayerInfo> field_147310_i = Maps.newHashMap();
    private final ClientAdvancementManager field_191983_k;
    private final ClientSuggestionProvider field_195516_l;
    private NetworkTagManager field_199725_m = new NetworkTagManager();
    private final NBTQueryManager field_211524_l = new NBTQueryManager(this);
    private final Random field_147306_l = new Random();
    private CommandDispatcher<ISuggestionProvider> field_195517_n = new CommandDispatcher();
    private final RecipeManager field_199528_o = new RecipeManager();

    public NetHandlerPlayClient(Minecraft mcIn, GuiScreen p_i46300_2_, NetworkManager networkManagerIn, GameProfile profileIn) {
        this.field_147299_f = mcIn;
        this.field_147307_j = p_i46300_2_;
        this.field_147302_e = networkManagerIn;
        this.field_175107_d = profileIn;
        this.field_191983_k = new ClientAdvancementManager(mcIn);
        this.field_195516_l = new ClientSuggestionProvider(this, mcIn);
    }

    public ClientSuggestionProvider func_195513_b() {
        return this.field_195516_l;
    }

    public void func_147296_c() {
        this.field_147300_g = null;
    }

    public RecipeManager func_199526_e() {
        return this.field_199528_o;
    }

    public void func_147282_a(SPacketJoinGame packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71442_b = new PlayerControllerMP(this.field_147299_f, this);
        this.field_147300_g = new WorldClient(this, new WorldSettings(0L, packetIn.func_149198_e(), false, packetIn.func_149195_d(), packetIn.func_149196_i()), packetIn.func_212642_e(), packetIn.func_149192_g(), this.field_147299_f.field_71424_I);
        this.field_147299_f.field_71474_y.field_74318_M = packetIn.func_149192_g();
        this.field_147299_f.func_71403_a(this.field_147300_g);
        this.field_147299_f.field_71439_g.field_71093_bK = packetIn.func_212642_e();
        this.field_147299_f.func_147108_a((GuiScreen)new GuiDownloadTerrain());
        this.field_147299_f.field_71439_g.func_145769_d(packetIn.func_149197_c());
        this.field_147299_f.field_71439_g.func_175150_k(packetIn.func_179744_h());
        this.field_147299_f.field_71442_b.func_78746_a(packetIn.func_149198_e());
        this.field_147299_f.field_71474_y.func_82879_c();
        this.field_147302_e.func_179290_a(new CPacketCustomPayload(CPacketCustomPayload.field_210344_a, new PacketBuffer(Unpooled.buffer()).func_180714_a(ClientBrandRetriever.getClientModName())));
    }

    public void func_147235_a(SPacketSpawnObject packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        double d0 = packetIn.func_186880_c();
        double d1 = packetIn.func_186882_d();
        double d2 = packetIn.func_186881_e();
        Entity entity = null;
        if (packetIn.func_148993_l() == 10) {
            entity = EntityMinecart.func_184263_a(this.field_147300_g, d0, d1, d2, EntityMinecart.Type.func_184955_a(packetIn.func_149009_m()));
        } else if (packetIn.func_148993_l() == 90) {
            Entity entity1 = this.field_147300_g.func_73045_a(packetIn.func_149009_m());
            if (entity1 instanceof EntityPlayer) {
                entity = new EntityFishHook(this.field_147300_g, (EntityPlayer)entity1, d0, d1, d2);
            }
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 60) {
            entity = new EntityTippedArrow((World)this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 91) {
            entity = new EntitySpectralArrow((World)this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 94) {
            entity = new EntityTrident((World)this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 61) {
            entity = new EntitySnowball((World)this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 68) {
            entity = new EntityLlamaSpit(this.field_147300_g, d0, d1, d2, (double)packetIn.func_149010_g() / 8000.0, (double)packetIn.func_149004_h() / 8000.0, (double)packetIn.func_148999_i() / 8000.0);
        } else if (packetIn.func_148993_l() == 71) {
            entity = new EntityItemFrame(this.field_147300_g, new BlockPos(d0, d1, d2), EnumFacing.func_82600_a(packetIn.func_149009_m()));
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 77) {
            entity = new EntityLeashKnot(this.field_147300_g, new BlockPos(MathHelper.func_76128_c((double)d0), MathHelper.func_76128_c((double)d1), MathHelper.func_76128_c((double)d2)));
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 65) {
            entity = new EntityEnderPearl(this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 72) {
            entity = new EntityEnderEye((World)this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 76) {
            entity = new EntityFireworkRocket((World)this.field_147300_g, d0, d1, d2, ItemStack.field_190927_a);
        } else if (packetIn.func_148993_l() == 63) {
            entity = new EntityLargeFireball(this.field_147300_g, d0, d1, d2, (double)packetIn.func_149010_g() / 8000.0, (double)packetIn.func_149004_h() / 8000.0, (double)packetIn.func_148999_i() / 8000.0);
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 93) {
            entity = new EntityDragonFireball((World)this.field_147300_g, d0, d1, d2, (double)packetIn.func_149010_g() / 8000.0, (double)packetIn.func_149004_h() / 8000.0, (double)packetIn.func_148999_i() / 8000.0);
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 64) {
            entity = new EntitySmallFireball(this.field_147300_g, d0, d1, d2, (double)packetIn.func_149010_g() / 8000.0, (double)packetIn.func_149004_h() / 8000.0, (double)packetIn.func_148999_i() / 8000.0);
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 66) {
            entity = new EntityWitherSkull(this.field_147300_g, d0, d1, d2, (double)packetIn.func_149010_g() / 8000.0, (double)packetIn.func_149004_h() / 8000.0, (double)packetIn.func_148999_i() / 8000.0);
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 67) {
            entity = new EntityShulkerBullet(this.field_147300_g, d0, d1, d2, (double)packetIn.func_149010_g() / 8000.0, (double)packetIn.func_149004_h() / 8000.0, (double)packetIn.func_148999_i() / 8000.0);
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 62) {
            entity = new EntityEgg((World)this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 79) {
            entity = new EntityEvokerFangs((World)this.field_147300_g, d0, d1, d2, 0.0f, 0, (EntityLivingBase)null);
        } else if (packetIn.func_148993_l() == 73) {
            entity = new EntityPotion((World)this.field_147300_g, d0, d1, d2, ItemStack.field_190927_a);
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 75) {
            entity = new EntityExpBottle((World)this.field_147300_g, d0, d1, d2);
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 1) {
            entity = new EntityBoat(this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 50) {
            entity = new EntityTNTPrimed((World)this.field_147300_g, d0, d1, d2, (EntityLivingBase)null);
        } else if (packetIn.func_148993_l() == 78) {
            entity = new EntityArmorStand(this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 51) {
            entity = new EntityEnderCrystal((World)this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 2) {
            entity = new EntityItem(this.field_147300_g, d0, d1, d2);
        } else if (packetIn.func_148993_l() == 70) {
            entity = new EntityFallingBlock(this.field_147300_g, d0, d1, d2, Block.func_196257_b(packetIn.func_149009_m()));
            packetIn.func_149002_g(0);
        } else if (packetIn.func_148993_l() == 3) {
            entity = new EntityAreaEffectCloud((World)this.field_147300_g, d0, d1, d2);
        }
        if (entity != null) {
            EntityTracker.func_187254_a(entity, d0, d1, d2);
            entity.field_70125_A = (float)(packetIn.func_149008_j() * 360) / 256.0f;
            entity.field_70177_z = (float)(packetIn.func_149006_k() * 360) / 256.0f;
            Entity[] aentity = entity.func_70021_al();
            if (aentity != null) {
                int i = packetIn.func_149001_c() - entity.func_145782_y();
                for (Entity entity2 : aentity) {
                    entity2.func_145769_d(entity2.func_145782_y() + i);
                }
            }
            entity.func_145769_d(packetIn.func_149001_c());
            entity.func_184221_a(packetIn.func_186879_b());
            this.field_147300_g.func_73027_a(packetIn.func_149001_c(), entity);
            if (packetIn.func_149009_m() > 0) {
                Entity entity3;
                if ((packetIn.func_148993_l() == 60 || packetIn.func_148993_l() == 91 || packetIn.func_148993_l() == 94) && (entity3 = this.field_147300_g.func_73045_a(packetIn.func_149009_m() - 1)) instanceof EntityLivingBase && entity instanceof EntityArrow) {
                    EntityArrow entityarrow = (EntityArrow)entity;
                    entityarrow.func_212361_a(entity3);
                    if (entity3 instanceof EntityPlayer) {
                        entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                        if (((EntityPlayer)entity3).field_71075_bZ.field_75098_d) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                    }
                }
                entity.func_70016_h((double)packetIn.func_149010_g() / 8000.0, (double)packetIn.func_149004_h() / 8000.0, (double)packetIn.func_148999_i() / 8000.0);
            }
        }
    }

    public void func_147286_a(SPacketSpawnExperienceOrb packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        double d0 = packetIn.func_186885_b();
        double d1 = packetIn.func_186886_c();
        double d2 = packetIn.func_186884_d();
        EntityXPOrb entity = new EntityXPOrb(this.field_147300_g, d0, d1, d2, packetIn.func_148986_g());
        EntityTracker.func_187254_a(entity, d0, d1, d2);
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = 0.0f;
        entity.func_145769_d(packetIn.func_148985_c());
        this.field_147300_g.func_73027_a(packetIn.func_148985_c(), entity);
    }

    public void func_147292_a(SPacketSpawnGlobalEntity packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        double d0 = packetIn.func_186888_b();
        double d1 = packetIn.func_186889_c();
        double d2 = packetIn.func_186887_d();
        EntityLightningBolt entity = null;
        if (packetIn.func_149053_g() == 1) {
            entity = new EntityLightningBolt(this.field_147300_g, d0, d1, d2, false);
        }
        if (entity != null) {
            EntityTracker.func_187254_a(entity, d0, d1, d2);
            ((Entity)((Object)entity)).field_70177_z = 0.0f;
            ((Entity)((Object)entity)).field_70125_A = 0.0f;
            ((Entity)((Object)entity)).func_145769_d(packetIn.func_149052_c());
            this.field_147300_g.func_72942_c((Entity)((Object)entity));
        }
    }

    public void func_147288_a(SPacketSpawnPainting packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPainting entitypainting = new EntityPainting((World)this.field_147300_g, packetIn.func_179837_b(), packetIn.func_179836_c(), packetIn.func_201063_e());
        entitypainting.func_184221_a(packetIn.func_186895_b());
        this.field_147300_g.func_73027_a(packetIn.func_148965_c(), (Entity)entitypainting);
    }

    public void func_147244_a(SPacketEntityVelocity packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149412_c());
        if (entity != null) {
            entity.func_70016_h((double)packetIn.func_149411_d() / 8000.0, (double)packetIn.func_149410_e() / 8000.0, (double)packetIn.func_149409_f() / 8000.0);
        }
    }

    public void func_147284_a(SPacketEntityMetadata packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149375_d());
        if (entity != null && packetIn.func_149376_c() != null) {
            entity.func_184212_Q().func_187218_a(packetIn.func_149376_c());
        }
    }

    public void func_147237_a(SPacketSpawnPlayer packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        double d0 = packetIn.func_186898_d();
        double d1 = packetIn.func_186897_e();
        double d2 = packetIn.func_186899_f();
        float f = (float)(packetIn.func_148941_i() * 360) / 256.0f;
        float f1 = (float)(packetIn.func_148945_j() * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP(this.field_147299_f.field_71441_e, this.func_175102_a(packetIn.func_179819_c()).func_178845_a());
        entityotherplayermp.field_70169_q = d0;
        entityotherplayermp.field_70142_S = d0;
        entityotherplayermp.field_70167_r = d1;
        entityotherplayermp.field_70137_T = d1;
        entityotherplayermp.field_70166_s = d2;
        entityotherplayermp.field_70136_U = d2;
        EntityTracker.func_187254_a(entityotherplayermp, d0, d1, d2);
        entityotherplayermp.func_70080_a(d0, d1, d2, f, f1);
        this.field_147300_g.func_73027_a(packetIn.func_148943_d(), entityotherplayermp);
        List list = packetIn.func_148944_c();
        if (list != null) {
            entityotherplayermp.func_184212_Q().func_187218_a(list);
        }
    }

    public void func_147275_a(SPacketEntityTeleport packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149451_c());
        if (entity != null) {
            double d0 = packetIn.func_186982_b();
            double d1 = packetIn.func_186983_c();
            double d2 = packetIn.func_186981_d();
            EntityTracker.func_187254_a(entity, d0, d1, d2);
            if (!entity.func_184186_bw()) {
                float f = (float)(packetIn.func_149450_g() * 360) / 256.0f;
                float f1 = (float)(packetIn.func_149447_h() * 360) / 256.0f;
                if (!(Math.abs(entity.field_70165_t - d0) >= 0.03125 || Math.abs(entity.field_70163_u - d1) >= 0.015625 || Math.abs(entity.field_70161_v - d2) >= 0.03125)) {
                    entity.func_180426_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, f, f1, 0, true);
                } else {
                    entity.func_180426_a(d0, d1, d2, f, f1, 3, true);
                }
                entity.field_70122_E = packetIn.func_179697_g();
            }
        }
    }

    public void func_147257_a(SPacketHeldItemChange packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        if (InventoryPlayer.func_184435_e(packetIn.func_149385_c())) {
            this.field_147299_f.field_71439_g.field_71071_by.field_70461_c = packetIn.func_149385_c();
        }
    }

    public void func_147259_a(SPacketEntity packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = packetIn.func_149065_a((World)this.field_147300_g);
        if (entity != null) {
            entity.field_70118_ct += (long)packetIn.func_186952_a();
            entity.field_70117_cu += (long)packetIn.func_186953_b();
            entity.field_70116_cv += (long)packetIn.func_186951_c();
            double d0 = (double)entity.field_70118_ct / 4096.0;
            double d1 = (double)entity.field_70117_cu / 4096.0;
            double d2 = (double)entity.field_70116_cv / 4096.0;
            if (!entity.func_184186_bw()) {
                float f = packetIn.func_149060_h() ? (float)(packetIn.func_149066_f() * 360) / 256.0f : entity.field_70177_z;
                float f1 = packetIn.func_149060_h() ? (float)(packetIn.func_149063_g() * 360) / 256.0f : entity.field_70125_A;
                entity.func_180426_a(d0, d1, d2, f, f1, 3, false);
                entity.field_70122_E = packetIn.func_179742_g();
            }
        }
    }

    public void func_147267_a(SPacketEntityHeadLook packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = packetIn.func_149381_a((World)this.field_147300_g);
        if (entity != null) {
            float f = (float)(packetIn.func_149380_c() * 360) / 256.0f;
            entity.func_208000_a(f, 3);
        }
    }

    public void func_147238_a(SPacketDestroyEntities packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        for (int i = 0; i < packetIn.func_149098_c().length; ++i) {
            this.field_147300_g.func_73028_b(packetIn.func_149098_c()[i]);
        }
    }

    public void func_184330_a(SPacketPlayerPosLook packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPlayerSP entityplayer = this.field_147299_f.field_71439_g;
        double d0 = packetIn.func_148932_c();
        double d1 = packetIn.func_148928_d();
        double d2 = packetIn.func_148933_e();
        float f = packetIn.func_148931_f();
        float f1 = packetIn.func_148930_g();
        if (packetIn.func_179834_f().contains(SPacketPlayerPosLook.EnumFlags.X)) {
            d0 += entityplayer.field_70165_t;
        } else {
            entityplayer.field_70159_w = 0.0;
        }
        if (packetIn.func_179834_f().contains(SPacketPlayerPosLook.EnumFlags.Y)) {
            d1 += entityplayer.field_70163_u;
        } else {
            entityplayer.field_70181_x = 0.0;
        }
        if (packetIn.func_179834_f().contains(SPacketPlayerPosLook.EnumFlags.Z)) {
            d2 += entityplayer.field_70161_v;
        } else {
            entityplayer.field_70179_y = 0.0;
        }
        if (packetIn.func_179834_f().contains(SPacketPlayerPosLook.EnumFlags.X_ROT)) {
            f1 += entityplayer.field_70125_A;
        }
        if (packetIn.func_179834_f().contains(SPacketPlayerPosLook.EnumFlags.Y_ROT)) {
            f += entityplayer.field_70177_z;
        }
        entityplayer.func_70080_a(d0, d1, d2, f, f1);
        this.field_147302_e.func_179290_a((Packet<?>)new CPacketConfirmTeleport(packetIn.func_186965_f()));
        this.field_147302_e.func_179290_a((Packet<?>)new CPacketPlayer.PositionRotation(entityplayer.field_70165_t, entityplayer.func_174813_aQ().field_72338_b, entityplayer.field_70161_v, entityplayer.field_70177_z, entityplayer.field_70125_A, false));
        if (!this.field_147309_h) {
            this.field_147299_f.field_71439_g.field_70169_q = this.field_147299_f.field_71439_g.field_70165_t;
            this.field_147299_f.field_71439_g.field_70167_r = this.field_147299_f.field_71439_g.field_70163_u;
            this.field_147299_f.field_71439_g.field_70166_s = this.field_147299_f.field_71439_g.field_70161_v;
            this.field_147309_h = true;
            this.field_147299_f.func_147108_a(null);
        }
    }

    public void func_147287_a(SPacketMultiBlockChange packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        for (SPacketMultiBlockChange.BlockUpdateData spacketmultiblockchange$blockupdatedata : packetIn.func_179844_a()) {
            this.field_147300_g.func_195597_b(spacketmultiblockchange$blockupdatedata.func_180090_a(), spacketmultiblockchange$blockupdatedata.func_180088_c());
        }
    }

    public void func_147263_a(SPacketChunkData packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        int i = packetIn.func_149273_e();
        int j = packetIn.func_149271_f();
        Chunk chunk = this.field_147300_g.func_72863_F().func_212474_a(i, j, packetIn.func_186946_a(), packetIn.func_149276_g(), packetIn.func_149274_i());
        this.field_147300_g.func_147458_c(i << 4, 0, j << 4, (i << 4) + 15, 256, (j << 4) + 15);
        if (!packetIn.func_149274_i() || this.field_147300_g.field_73011_w.shouldClientCheckLighting()) {
            chunk.func_76613_n();
        }
        for (NBTTagCompound nbttagcompound : packetIn.func_189554_f()) {
            BlockPos blockpos = new BlockPos(nbttagcompound.func_74762_e("x"), nbttagcompound.func_74762_e("y"), nbttagcompound.func_74762_e("z"));
            TileEntity tileentity = this.field_147300_g.func_175625_s(blockpos);
            if (tileentity == null) continue;
            tileentity.handleUpdateTag(nbttagcompound);
        }
    }

    public void func_184326_a(SPacketUnloadChunk packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        int i = packetIn.func_186940_a();
        int j = packetIn.func_186941_b();
        this.field_147300_g.func_72863_F().func_73234_b(i, j);
        this.field_147300_g.func_147458_c(i << 4, 0, j << 4, (i << 4) + 15, 256, (j << 4) + 15);
    }

    public void func_147234_a(SPacketBlockChange packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147300_g.func_195597_b(packetIn.func_179827_b(), packetIn.func_197685_a());
    }

    public void func_147253_a(SPacketDisconnect packetIn) {
        this.field_147302_e.func_150718_a(packetIn.func_149165_c());
    }

    public void func_147231_a(ITextComponent reason) {
        this.field_147299_f.func_71403_a(null);
        if (this.field_147307_j != null) {
            if (this.field_147307_j instanceof GuiScreenRealmsProxy) {
                this.field_147299_f.func_147108_a((GuiScreen)new DisconnectedRealmsScreen(((GuiScreenRealmsProxy)this.field_147307_j).func_154321_a(), "disconnect.lost", reason).getProxy());
            } else {
                this.field_147299_f.func_147108_a((GuiScreen)new GuiDisconnected(this.field_147307_j, "disconnect.lost", reason));
            }
        } else {
            this.field_147299_f.func_147108_a((GuiScreen)new GuiDisconnected((GuiScreen)new GuiMultiplayer((GuiScreen)new GuiMainMenu()), "disconnect.lost", reason));
        }
    }

    public void func_147297_a(Packet<?> packetIn) {
        this.field_147302_e.func_179290_a(packetIn);
    }

    public void func_147246_a(SPacketCollectItem packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149354_c());
        EntityLivingBase entitylivingbase = (EntityLivingBase)this.field_147300_g.func_73045_a(packetIn.func_149353_d());
        if (entitylivingbase == null) {
            entitylivingbase = this.field_147299_f.field_71439_g;
        }
        if (entity != null) {
            if (entity instanceof EntityXPOrb) {
                this.field_147300_g.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (this.field_147306_l.nextFloat() - this.field_147306_l.nextFloat()) * 0.35f + 0.9f, false);
            } else {
                this.field_147300_g.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (this.field_147306_l.nextFloat() - this.field_147306_l.nextFloat()) * 1.4f + 2.0f, false);
            }
            if (entity instanceof EntityItem) {
                ((EntityItem)entity).func_92059_d().func_190920_e(packetIn.func_191208_c());
            }
            this.field_147299_f.field_71452_i.func_78873_a((Particle)new ParticleItemPickup((World)this.field_147300_g, entity, (Entity)entitylivingbase, 0.5f));
            this.field_147300_g.func_73028_b(packetIn.func_149354_c());
        }
    }

    public void func_147251_a(SPacketChat packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        ITextComponent message = ForgeEventFactory.onClientChat((ChatType)packetIn.func_192590_c(), (ITextComponent)packetIn.func_148915_c());
        if (message == null) {
            return;
        }
        this.field_147299_f.field_71456_v.func_191742_a(packetIn.func_192590_c(), message);
    }

    public void func_147279_a(SPacketAnimation packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_148978_c());
        if (entity != null) {
            if (packetIn.func_148977_d() == 0) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                entitylivingbase.func_184609_a(EnumHand.MAIN_HAND);
            } else if (packetIn.func_148977_d() == 3) {
                EntityLivingBase entitylivingbase1 = (EntityLivingBase)entity;
                entitylivingbase1.func_184609_a(EnumHand.OFF_HAND);
            } else if (packetIn.func_148977_d() == 1) {
                entity.func_70057_ab();
            } else if (packetIn.func_148977_d() == 2) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.func_70999_a(false, false, false);
            } else if (packetIn.func_148977_d() == 4) {
                this.field_147299_f.field_71452_i.func_199282_a(entity, (IParticleData)Particles.field_197614_g);
            } else if (packetIn.func_148977_d() == 5) {
                this.field_147299_f.field_71452_i.func_199282_a(entity, (IParticleData)Particles.field_197622_o);
            }
        }
    }

    public void func_147278_a(SPacketUseBed packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        packetIn.func_149091_a((World)this.field_147300_g).func_180469_a(packetIn.func_179798_a());
    }

    public void func_147281_a(SPacketSpawnMob packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        double d0 = packetIn.func_186891_e();
        double d1 = packetIn.func_186892_f();
        double d2 = packetIn.func_186893_g();
        float f = (float)(packetIn.func_149028_l() * 360) / 256.0f;
        float f1 = (float)(packetIn.func_149030_m() * 360) / 256.0f;
        EntityLivingBase entitylivingbase = (EntityLivingBase)EntityType.func_200717_a(packetIn.func_149025_e(), this.field_147299_f.field_71441_e);
        if (entitylivingbase != null) {
            EntityTracker.func_187254_a(entitylivingbase, d0, d1, d2);
            entitylivingbase.field_70761_aq = (float)(packetIn.func_149032_n() * 360) / 256.0f;
            entitylivingbase.field_70759_as = (float)(packetIn.func_149032_n() * 360) / 256.0f;
            Entity[] aentity = entitylivingbase.func_70021_al();
            if (aentity != null) {
                int i = packetIn.func_149024_d() - entitylivingbase.func_145782_y();
                for (Entity entity : aentity) {
                    entity.func_145769_d(entity.func_145782_y() + i);
                }
            }
            entitylivingbase.func_145769_d(packetIn.func_149024_d());
            entitylivingbase.func_184221_a(packetIn.func_186890_c());
            entitylivingbase.func_70080_a(d0, d1, d2, f, f1);
            entitylivingbase.field_70159_w = (float)packetIn.func_149026_i() / 8000.0f;
            entitylivingbase.field_70181_x = (float)packetIn.func_149033_j() / 8000.0f;
            entitylivingbase.field_70179_y = (float)packetIn.func_149031_k() / 8000.0f;
            this.field_147300_g.func_73027_a(packetIn.func_149024_d(), entitylivingbase);
            List list = packetIn.func_149027_c();
            if (list != null) {
                entitylivingbase.func_184212_Q().func_187218_a(list);
            }
        } else {
            field_147301_d.warn("Skipping Entity with id {}", (Object)packetIn.func_149025_e());
        }
    }

    public void func_147285_a(SPacketTimeUpdate packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71441_e.func_82738_a(packetIn.func_149366_c());
        this.field_147299_f.field_71441_e.func_72877_b(packetIn.func_149365_d());
    }

    public void func_147271_a(SPacketSpawnPosition packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71439_g.func_180473_a(packetIn.func_179800_a(), true);
        this.field_147299_f.field_71441_e.func_72912_H().func_176143_a(packetIn.func_179800_a());
    }

    public void func_184328_a(SPacketSetPassengers packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_186972_b());
        if (entity == null) {
            field_147301_d.warn("Received passengers for unknown entity");
        } else {
            boolean flag = entity.func_184215_y(this.field_147299_f.field_71439_g);
            entity.func_184226_ay();
            for (int i : packetIn.func_186971_a()) {
                Entity entity1 = this.field_147300_g.func_73045_a(i);
                if (entity1 == null) continue;
                entity1.func_184205_a(entity, true);
                if (entity1 != this.field_147299_f.field_71439_g || flag) continue;
                this.field_147299_f.field_71456_v.func_110326_a(I18n.func_135052_a("mount.onboard", this.field_147299_f.field_71474_y.field_74311_E.func_197978_k()), false);
            }
        }
    }

    public void func_147243_a(SPacketEntityAttach packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149403_d());
        Entity entity1 = this.field_147300_g.func_73045_a(packetIn.func_149402_e());
        if (entity instanceof EntityLiving) {
            if (entity1 != null) {
                ((EntityLiving)entity).func_110162_b(entity1, false);
            } else {
                ((EntityLiving)entity).func_110160_i(false, false);
            }
        }
    }

    public void func_147236_a(SPacketEntityStatus packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = packetIn.func_149161_a((World)this.field_147300_g);
        if (entity != null) {
            if (packetIn.func_149160_c() == 21) {
                this.field_147299_f.func_147118_V().func_147682_a((ISound)new GuardianSound((EntityGuardian)entity));
            } else if (packetIn.func_149160_c() == 35) {
                int i = 40;
                this.field_147299_f.field_71452_i.func_199281_a(entity, (IParticleData)Particles.field_197604_O, 30);
                this.field_147300_g.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_191263_gW, entity.func_184176_by(), 1.0f, 1.0f, false);
                if (entity == this.field_147299_f.field_71439_g) {
                    this.field_147299_f.field_71460_t.func_190565_a(new ItemStack(Items.field_190929_cY));
                }
            } else {
                entity.func_70103_a(packetIn.func_149160_c());
            }
        }
    }

    public void func_147249_a(SPacketUpdateHealth packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71439_g.func_71150_b(packetIn.func_149332_c());
        this.field_147299_f.field_71439_g.func_71024_bL().func_75114_a(packetIn.func_149330_d());
        this.field_147299_f.field_71439_g.func_71024_bL().func_75119_b(packetIn.func_149331_e());
    }

    public void func_147295_a(SPacketSetExperience packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71439_g.func_71152_a(packetIn.func_149397_c(), packetIn.func_149396_d(), packetIn.func_149395_e());
    }

    public void func_147280_a(SPacketRespawn packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        DimensionType dimensiontype = packetIn.func_212643_b();
        if (dimensiontype != this.field_147299_f.field_71439_g.field_71093_bK) {
            this.field_147309_h = false;
            Scoreboard scoreboard = this.field_147300_g.func_96441_U();
            this.field_147300_g = new WorldClient(this, new WorldSettings(0L, packetIn.func_149083_e(), false, this.field_147299_f.field_71441_e.func_72912_H().func_76093_s(), packetIn.func_149080_f()), packetIn.func_212643_b(), packetIn.func_149081_d(), this.field_147299_f.field_71424_I);
            this.field_147300_g.func_96443_a(scoreboard);
            this.field_147299_f.func_71403_a(this.field_147300_g);
            this.field_147299_f.field_71439_g.field_71093_bK = dimensiontype;
            this.field_147299_f.func_147108_a((GuiScreen)new GuiDownloadTerrain());
        }
        this.field_147299_f.func_212315_a(packetIn.func_212643_b());
        this.field_147299_f.field_71442_b.func_78746_a(packetIn.func_149083_e());
    }

    public void func_147283_a(SPacketExplosion packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Explosion explosion = new Explosion(this.field_147299_f.field_71441_e, null, packetIn.func_149148_f(), packetIn.func_149143_g(), packetIn.func_149145_h(), packetIn.func_149146_i(), packetIn.func_149150_j());
        explosion.func_77279_a(true);
        this.field_147299_f.field_71439_g.field_70159_w += (double)packetIn.func_149149_c();
        this.field_147299_f.field_71439_g.field_70181_x += (double)packetIn.func_149144_d();
        this.field_147299_f.field_71439_g.field_70179_y += (double)packetIn.func_149147_e();
    }

    public void func_147265_a(SPacketOpenWindow packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPlayerSP entityplayersp = this.field_147299_f.field_71439_g;
        if ("minecraft:container".equals(packetIn.func_148902_e())) {
            entityplayersp.func_71007_a((IInventory)new InventoryBasic(packetIn.func_179840_c(), packetIn.func_148898_f()));
            entityplayersp.field_71070_bA.field_75152_c = packetIn.func_148901_c();
        } else if ("minecraft:villager".equals(packetIn.func_148902_e())) {
            entityplayersp.func_180472_a(new NpcMerchant(entityplayersp, packetIn.func_179840_c()));
            entityplayersp.field_71070_bA.field_75152_c = packetIn.func_148901_c();
        } else if ("EntityHorse".equals(packetIn.func_148902_e())) {
            Entity entity = this.field_147300_g.func_73045_a(packetIn.func_148897_h());
            if (entity instanceof AbstractHorse) {
                entityplayersp.func_184826_a((AbstractHorse)((Object)entity), (IInventory)new ContainerHorseChest(packetIn.func_179840_c(), packetIn.func_148898_f()));
                entityplayersp.field_71070_bA.field_75152_c = packetIn.func_148901_c();
            }
        } else if (!packetIn.func_148900_g()) {
            entityplayersp.func_180468_a((IInteractionObject)new LocalBlockIntercommunication(packetIn.func_148902_e(), packetIn.func_179840_c()));
            entityplayersp.field_71070_bA.field_75152_c = packetIn.func_148901_c();
        } else {
            ContainerLocalMenu iinventory = new ContainerLocalMenu(packetIn.func_148902_e(), packetIn.func_179840_c(), packetIn.func_148898_f());
            entityplayersp.func_71007_a((IInventory)iinventory);
            entityplayersp.field_71070_bA.field_75152_c = packetIn.func_148901_c();
        }
    }

    public void func_147266_a(SPacketSetSlot packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPlayerSP entityplayer = this.field_147299_f.field_71439_g;
        ItemStack itemstack = packetIn.func_149174_e();
        int i = packetIn.func_149173_d();
        this.field_147299_f.func_193032_ao().func_193301_a(itemstack);
        if (packetIn.func_149175_c() == -1) {
            entityplayer.field_71071_by.func_70437_b(itemstack);
        } else if (packetIn.func_149175_c() == -2) {
            entityplayer.field_71071_by.func_70299_a(i, itemstack);
        } else {
            boolean flag = false;
            if (this.field_147299_f.field_71462_r instanceof GuiContainerCreative) {
                GuiContainerCreative guicontainercreative = (GuiContainerCreative)this.field_147299_f.field_71462_r;
                boolean bl = flag = guicontainercreative.func_147056_g() != ItemGroup.field_78036_m.func_78021_a();
            }
            if (packetIn.func_149175_c() == 0 && packetIn.func_149173_d() >= 36 && i < 45) {
                ItemStack itemstack1;
                if (!itemstack.func_190926_b() && ((itemstack1 = entityplayer.field_71069_bz.func_75139_a(i).func_75211_c()).func_190926_b() || itemstack1.func_190916_E() < itemstack.func_190916_E())) {
                    itemstack.func_190915_d(5);
                }
                entityplayer.field_71069_bz.func_75141_a(i, itemstack);
            } else if (!(packetIn.func_149175_c() != entityplayer.field_71070_bA.field_75152_c || packetIn.func_149175_c() == 0 && flag)) {
                entityplayer.field_71070_bA.func_75141_a(i, itemstack);
            }
        }
    }

    public void func_147239_a(SPacketConfirmTransaction packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Container container = null;
        EntityPlayerSP entityplayer = this.field_147299_f.field_71439_g;
        if (packetIn.func_148889_c() == 0) {
            container = entityplayer.field_71069_bz;
        } else if (packetIn.func_148889_c() == entityplayer.field_71070_bA.field_75152_c) {
            container = entityplayer.field_71070_bA;
        }
        if (container != null && !packetIn.func_148888_e()) {
            this.func_147297_a((Packet<?>)new CPacketConfirmTransaction(packetIn.func_148889_c(), packetIn.func_148890_d(), true));
        }
    }

    public void func_147241_a(SPacketWindowItems packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPlayerSP entityplayer = this.field_147299_f.field_71439_g;
        if (packetIn.func_148911_c() == 0) {
            entityplayer.field_71069_bz.func_190896_a(packetIn.func_148910_d());
        } else if (packetIn.func_148911_c() == entityplayer.field_71070_bA.field_75152_c) {
            entityplayer.field_71070_bA.func_190896_a(packetIn.func_148910_d());
        }
    }

    public void func_147268_a(SPacketSignEditorOpen packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        TileEntity tileentity = this.field_147300_g.func_175625_s(packetIn.func_179777_a());
        if (!(tileentity instanceof TileEntitySign)) {
            tileentity = new TileEntitySign();
            tileentity.func_145834_a(this.field_147300_g);
            tileentity.func_174878_a(packetIn.func_179777_a());
        }
        this.field_147299_f.field_71439_g.func_175141_a((TileEntitySign)tileentity);
    }

    public void func_147273_a(SPacketUpdateTileEntity packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        if (this.field_147299_f.field_71441_e.func_175667_e(packetIn.func_179823_a())) {
            boolean flag;
            TileEntity tileentity = this.field_147299_f.field_71441_e.func_175625_s(packetIn.func_179823_a());
            int i = packetIn.func_148853_f();
            boolean bl = flag = i == 2 && tileentity instanceof TileEntityCommandBlock;
            if (i == 1 && tileentity instanceof TileEntityMobSpawner || flag || i == 3 && tileentity instanceof TileEntityBeacon || i == 4 && tileentity instanceof TileEntitySkull || i == 6 && tileentity instanceof TileEntityBanner || i == 7 && tileentity instanceof TileEntityStructure || i == 8 && tileentity instanceof TileEntityEndGateway || i == 9 && tileentity instanceof TileEntitySign || i == 10 && tileentity instanceof TileEntityShulkerBox || i == 11 && tileentity instanceof TileEntityBed || i == 5 && tileentity instanceof TileEntityConduit) {
                tileentity.func_145839_a(packetIn.func_148857_g());
            } else {
                if (tileentity == null) {
                    field_147301_d.error("Received invalid update packet for null tile entity at {} with data: {}", (Object)packetIn.func_179823_a(), (Object)packetIn.func_148857_g());
                    return;
                }
                tileentity.onDataPacket(this.field_147302_e, packetIn);
            }
            if (flag && this.field_147299_f.field_71462_r instanceof GuiCommandBlock) {
                ((GuiCommandBlock)this.field_147299_f.field_71462_r).func_184075_a();
            }
        }
    }

    public void func_147245_a(SPacketWindowProperty packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPlayerSP entityplayer = this.field_147299_f.field_71439_g;
        if (entityplayer.field_71070_bA != null && entityplayer.field_71070_bA.field_75152_c == packetIn.func_149182_c()) {
            entityplayer.field_71070_bA.func_75137_b(packetIn.func_149181_d(), packetIn.func_149180_e());
        }
    }

    public void func_147242_a(SPacketEntityEquipment packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149389_d());
        if (entity != null) {
            entity.func_184201_a(packetIn.func_186969_c(), packetIn.func_149390_c());
        }
    }

    public void func_147276_a(SPacketCloseWindow packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71439_g.func_175159_q();
    }

    public void func_147261_a(SPacketBlockAction packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71441_e.func_175641_c(packetIn.func_179825_a(), packetIn.func_148868_c(), packetIn.func_148869_g(), packetIn.func_148864_h());
    }

    public void func_147294_a(SPacketBlockBreakAnim packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71441_e.func_175715_c(packetIn.func_148845_c(), packetIn.func_179821_b(), packetIn.func_148846_g());
    }

    public void func_147252_a(SPacketChangeGameState packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPlayerSP entityplayer = this.field_147299_f.field_71439_g;
        int i = packetIn.func_149138_c();
        float f = packetIn.func_149137_d();
        int j = MathHelper.func_76141_d((float)(f + 0.5f));
        if (i >= 0 && i < SPacketChangeGameState.field_149142_a.length && SPacketChangeGameState.field_149142_a[i] != null) {
            ((EntityPlayer)entityplayer).func_146105_b((ITextComponent)new TextComponentTranslation(SPacketChangeGameState.field_149142_a[i], new Object[0]), false);
        }
        if (i == 1) {
            this.field_147300_g.func_72912_H().func_76084_b(true);
            this.field_147300_g.func_72894_k(0.0f);
        } else if (i == 2) {
            this.field_147300_g.func_72912_H().func_76084_b(false);
            this.field_147300_g.func_72894_k(1.0f);
        } else if (i == 3) {
            this.field_147299_f.field_71442_b.func_78746_a(GameType.func_77146_a((int)j));
        } else if (i == 4) {
            if (j == 0) {
                this.field_147299_f.field_71439_g.field_71174_a.func_147297_a((Packet<?>)new CPacketClientStatus(CPacketClientStatus.State.PERFORM_RESPAWN));
                this.field_147299_f.func_147108_a((GuiScreen)new GuiDownloadTerrain());
            } else if (j == 1) {
                this.field_147299_f.func_147108_a((GuiScreen)new GuiWinGame(true, () -> this.field_147299_f.field_71439_g.field_71174_a.func_147297_a((Packet<?>)new CPacketClientStatus(CPacketClientStatus.State.PERFORM_RESPAWN))));
            }
        } else if (i == 5) {
            GameSettings gamesettings = this.field_147299_f.field_71474_y;
            if (f == 0.0f) {
                this.field_147299_f.func_147108_a((GuiScreen)new GuiScreenDemo());
            } else if (f == 101.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("demo.help.movement", gamesettings.field_74351_w.func_197978_k(), gamesettings.field_74370_x.func_197978_k(), gamesettings.field_74368_y.func_197978_k(), gamesettings.field_74366_z.func_197978_k()));
            } else if (f == 102.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("demo.help.jump", gamesettings.field_74314_A.func_197978_k()));
            } else if (f == 103.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("demo.help.inventory", gamesettings.field_151445_Q.func_197978_k()));
            } else if (f == 104.0f) {
                this.field_147299_f.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("demo.day.6", gamesettings.field_151447_Z.func_197978_k()));
            }
        } else if (i == 6) {
            this.field_147300_g.func_184148_a(entityplayer, entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v, SoundEvents.field_187734_u, SoundCategory.PLAYERS, 0.18f, 0.45f);
        } else if (i == 7) {
            this.field_147300_g.func_72894_k(f);
        } else if (i == 8) {
            this.field_147300_g.func_147442_i(f);
        } else if (i == 9) {
            this.field_147300_g.func_184148_a(entityplayer, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_203830_gs, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        } else if (i == 10) {
            this.field_147300_g.func_195594_a((IParticleData)Particles.field_197621_n, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 0.0, 0.0, 0.0);
            this.field_147300_g.func_184148_a(entityplayer, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187514_aD, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
    }

    public void func_147264_a(SPacketMaps packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        MapItemRenderer mapitemrenderer = this.field_147299_f.field_71460_t.func_147701_i();
        String s = "map_" + packetIn.func_149188_c();
        MapData mapdata = ItemMap.func_195953_a(this.field_147299_f.field_71441_e, s);
        if (mapdata == null) {
            MapData mapdata1;
            mapdata = new MapData(s);
            if (mapitemrenderer.func_191205_a(s) != null && (mapdata1 = mapitemrenderer.func_191207_a(mapitemrenderer.func_191205_a(s))) != null) {
                mapdata = mapdata1;
            }
            this.field_147299_f.field_71441_e.func_212409_a(DimensionType.OVERWORLD, s, mapdata);
        }
        packetIn.func_179734_a(mapdata);
        mapitemrenderer.func_148246_a(mapdata);
    }

    public void func_147277_a(SPacketEffect packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        if (packetIn.func_149244_c()) {
            this.field_147299_f.field_71441_e.func_175669_a(packetIn.func_149242_d(), packetIn.func_179746_d(), packetIn.func_149241_e());
        } else {
            this.field_147299_f.field_71441_e.func_175718_b(packetIn.func_149242_d(), packetIn.func_179746_d(), packetIn.func_149241_e());
        }
    }

    public void func_191981_a(SPacketAdvancementInfo packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_191983_k.func_192799_a(packetIn);
    }

    public void func_194022_a(SPacketSelectAdvancementsTab packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        ResourceLocation resourcelocation = packetIn.func_194154_a();
        if (resourcelocation == null) {
            this.field_191983_k.func_194230_a((Advancement)null, false);
        } else {
            Advancement advancement = this.field_191983_k.func_194229_a().func_192084_a(resourcelocation);
            this.field_191983_k.func_194230_a(advancement, false);
        }
    }

    public void func_195511_a(SPacketCommandList packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_195517_n = new CommandDispatcher(packetIn.func_197693_a());
    }

    public void func_195512_a(SPacketStopSound packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.func_147118_V().func_195478_a(packetIn.func_197703_a(), packetIn.func_197704_b());
    }

    public void func_195510_a(SPacketTabComplete packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_195516_l.func_197015_a(packetIn.func_197689_a(), packetIn.func_197687_b());
    }

    public void func_199525_a(SPacketUpdateRecipes packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_199528_o.func_199518_d();
        for (IRecipe irecipe : packetIn.func_199616_a()) {
            this.field_199528_o.func_199509_a(irecipe);
        }
        SearchTree searchtree = (SearchTree)this.field_147299_f.func_193987_a(SearchTreeManager.field_194012_b);
        searchtree.func_199550_b();
        RecipeBookClient recipebookclient = this.field_147299_f.field_71439_g.func_199507_B();
        recipebookclient.func_199644_c();
        recipebookclient.func_199642_d().forEach(arg_0 -> ((SearchTree)searchtree).func_194043_a(arg_0));
        searchtree.func_194040_a();
        ForgeHooksClient.onRecipesUpdated();
    }

    public void func_200232_a(SPacketPlayerLook packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Vec3d vec3d = packetIn.func_200531_a((World)this.field_147300_g);
        if (vec3d != null) {
            this.field_147299_f.field_71439_g.func_200602_a(packetIn.func_201064_a(), vec3d);
        }
    }

    public void func_211522_a(SPacketNBTQueryResponse packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        if (!this.field_211524_l.func_211548_a(packetIn.func_211713_b(), packetIn.func_211712_c())) {
            field_147301_d.debug("Got unhandled response to tag query {}", (Object)packetIn.func_211713_b());
        }
    }

    public void func_147293_a(SPacketStatistics packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        for (Map.Entry entry : packetIn.func_148974_c().entrySet()) {
            Stat stat = (Stat)entry.getKey();
            int i = (Integer)entry.getValue();
            this.field_147299_f.field_71439_g.func_146107_m().func_150873_a((EntityPlayer)this.field_147299_f.field_71439_g, stat, i);
        }
        if (this.field_147299_f.field_71462_r instanceof IProgressMeter) {
            ((IProgressMeter)this.field_147299_f.field_71462_r).func_193026_g();
        }
    }

    public void func_191980_a(SPacketRecipeBook packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        RecipeBookClient recipebookclient = this.field_147299_f.field_71439_g.func_199507_B();
        recipebookclient.func_192813_a(packetIn.func_192593_c());
        recipebookclient.func_192810_b(packetIn.func_192594_d());
        recipebookclient.func_202881_c(packetIn.func_202492_e());
        recipebookclient.func_202882_d(packetIn.func_202493_f());
        SPacketRecipeBook.State spacketrecipebook$state = packetIn.func_194151_e();
        switch (spacketrecipebook$state) {
            case REMOVE: {
                for (ResourceLocation resourcelocation3 : packetIn.func_192595_a()) {
                    IRecipe irecipe3 = this.field_199528_o.func_199517_a(resourcelocation3);
                    if (irecipe3 == null) continue;
                    recipebookclient.func_193831_b(irecipe3);
                }
                break;
            }
            case INIT: {
                for (ResourceLocation resourcelocation1 : packetIn.func_192595_a()) {
                    IRecipe irecipe1 = this.field_199528_o.func_199517_a(resourcelocation1);
                    if (irecipe1 == null) continue;
                    recipebookclient.func_194073_a(irecipe1);
                }
                for (ResourceLocation resourcelocation2 : packetIn.func_193644_b()) {
                    IRecipe irecipe2 = this.field_199528_o.func_199517_a(resourcelocation2);
                    if (irecipe2 == null) continue;
                    recipebookclient.func_193825_e(irecipe2);
                }
                break;
            }
            case ADD: {
                for (ResourceLocation resourcelocation : packetIn.func_192595_a()) {
                    IRecipe irecipe = this.field_199528_o.func_199517_a(resourcelocation);
                    if (irecipe == null) continue;
                    recipebookclient.func_194073_a(irecipe);
                    recipebookclient.func_193825_e(irecipe);
                    RecipeToast.func_193665_a(this.field_147299_f.func_193033_an(), irecipe);
                }
                break;
            }
        }
        recipebookclient.func_199642_d().forEach(p_199527_1_ -> p_199527_1_.func_194214_a((RecipeBook)recipebookclient));
        if (this.field_147299_f.field_71462_r instanceof IRecipeShownListener) {
            ((IRecipeShownListener)this.field_147299_f.field_71462_r).func_192043_J_();
        }
    }

    public void func_147260_a(SPacketEntityEffect packetIn) {
        Potion potion;
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149426_d());
        if (entity instanceof EntityLivingBase && (potion = Potion.func_188412_a(packetIn.func_149427_e() & 0xFF)) != null) {
            PotionEffect potioneffect = new PotionEffect(potion, packetIn.func_180755_e(), packetIn.func_149428_f(), packetIn.func_186984_g(), packetIn.func_179707_f(), packetIn.func_205527_h());
            potioneffect.func_100012_b(packetIn.func_149429_c());
            ((EntityLivingBase)entity).func_195064_c(potioneffect);
        }
    }

    public void func_199723_a(SPacketTagsList packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_199725_m = packetIn.func_199858_a();
        if (!this.field_147302_e.func_150731_c()) {
            BlockTags.func_199895_a((TagCollection)this.field_199725_m.func_199717_a());
            ItemTags.func_199902_a((TagCollection)this.field_199725_m.func_199715_b());
            FluidTags.func_206953_a((TagCollection)this.field_199725_m.func_205704_c());
        }
    }

    public void func_175098_a(SPacketCombatEvent packetIn) {
        Entity entity;
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        if (packetIn.field_179776_a == SPacketCombatEvent.Event.ENTITY_DIED && (entity = this.field_147300_g.func_73045_a(packetIn.field_179774_b)) == this.field_147299_f.field_71439_g) {
            this.field_147299_f.func_147108_a((GuiScreen)new GuiGameOver(packetIn.field_179773_e));
        }
    }

    public void func_175101_a(SPacketServerDifficulty packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71441_e.func_72912_H().func_176144_a(packetIn.func_179831_b());
        this.field_147299_f.field_71441_e.func_72912_H().func_180783_e(packetIn.func_179830_a());
    }

    public void func_175094_a(SPacketCamera packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = packetIn.func_179780_a((World)this.field_147300_g);
        if (entity != null) {
            this.field_147299_f.func_175607_a(entity);
        }
    }

    public void func_175093_a(SPacketWorldBorder packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        packetIn.func_179788_a(this.field_147300_g.func_175723_af());
    }

    public void func_175099_a(SPacketTitle packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        SPacketTitle.Type spackettitle$type = packetIn.func_179807_a();
        String s = null;
        String s1 = null;
        String s2 = packetIn.func_179805_b() != null ? packetIn.func_179805_b().func_150254_d() : "";
        switch (spackettitle$type) {
            case TITLE: {
                s = s2;
                break;
            }
            case SUBTITLE: {
                s1 = s2;
                break;
            }
            case ACTIONBAR: {
                this.field_147299_f.field_71456_v.func_110326_a(s2, false);
                return;
            }
            case RESET: {
                this.field_147299_f.field_71456_v.func_175178_a("", "", -1, -1, -1);
                this.field_147299_f.field_71456_v.func_175177_a();
                return;
            }
        }
        this.field_147299_f.field_71456_v.func_175178_a(s, s1, packetIn.func_179806_c(), packetIn.func_179804_d(), packetIn.func_179803_e());
    }

    public void func_175096_a(SPacketPlayerListHeaderFooter packetIn) {
        this.field_147299_f.field_71456_v.func_175181_h().func_175244_b(packetIn.func_179700_a().func_150254_d().isEmpty() ? null : packetIn.func_179700_a());
        this.field_147299_f.field_71456_v.func_175181_h().func_175248_a(packetIn.func_179701_b().func_150254_d().isEmpty() ? null : packetIn.func_179701_b());
    }

    public void func_147262_a(SPacketRemoveEntityEffect packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = packetIn.func_186967_a((World)this.field_147300_g);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_184596_c(packetIn.func_186968_a());
        }
    }

    public void func_147256_a(SPacketPlayerListItem packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        for (SPacketPlayerListItem.AddPlayerData spacketplayerlistitem$addplayerdata : packetIn.func_179767_a()) {
            if (packetIn.func_179768_b() == SPacketPlayerListItem.Action.REMOVE_PLAYER) {
                this.field_147310_i.remove(spacketplayerlistitem$addplayerdata.func_179962_a().getId());
                continue;
            }
            NetworkPlayerInfo networkplayerinfo = this.field_147310_i.get(spacketplayerlistitem$addplayerdata.func_179962_a().getId());
            if (packetIn.func_179768_b() == SPacketPlayerListItem.Action.ADD_PLAYER) {
                networkplayerinfo = new NetworkPlayerInfo(spacketplayerlistitem$addplayerdata);
                this.field_147310_i.put(networkplayerinfo.func_178845_a().getId(), networkplayerinfo);
            }
            if (networkplayerinfo == null) continue;
            switch (packetIn.func_179768_b()) {
                case ADD_PLAYER: {
                    networkplayerinfo.func_178839_a(spacketplayerlistitem$addplayerdata.func_179960_c());
                    networkplayerinfo.func_178838_a(spacketplayerlistitem$addplayerdata.func_179963_b());
                    networkplayerinfo.func_178859_a(spacketplayerlistitem$addplayerdata.func_179961_d());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    networkplayerinfo.func_178839_a(spacketplayerlistitem$addplayerdata.func_179960_c());
                    break;
                }
                case UPDATE_LATENCY: {
                    networkplayerinfo.func_178838_a(spacketplayerlistitem$addplayerdata.func_179963_b());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    networkplayerinfo.func_178859_a(spacketplayerlistitem$addplayerdata.func_179961_d());
                }
            }
        }
    }

    public void func_147272_a(SPacketKeepAlive packetIn) {
        this.func_147297_a((Packet<?>)new CPacketKeepAlive(packetIn.func_149134_c()));
    }

    public void func_147270_a(SPacketPlayerAbilities packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        EntityPlayerSP entityplayer = this.field_147299_f.field_71439_g;
        entityplayer.field_71075_bZ.field_75100_b = packetIn.func_149106_d();
        entityplayer.field_71075_bZ.field_75098_d = packetIn.func_149103_f();
        entityplayer.field_71075_bZ.field_75102_a = packetIn.func_149112_c();
        entityplayer.field_71075_bZ.field_75101_c = packetIn.func_149105_e();
        entityplayer.field_71075_bZ.func_195931_a((double)packetIn.func_149101_g());
        entityplayer.field_71075_bZ.func_82877_b(packetIn.func_149107_h());
    }

    public void func_184327_a(SPacketSoundEffect packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71441_e.func_184148_a(this.field_147299_f.field_71439_g, packetIn.func_149207_d(), packetIn.func_149211_e(), packetIn.func_149210_f(), packetIn.func_186978_a(), packetIn.func_186977_b(), packetIn.func_149208_g(), packetIn.func_149209_h());
    }

    public void func_184329_a(SPacketCustomSound packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.func_147118_V().func_147682_a((ISound)new SimpleSound(packetIn.func_197698_a(), packetIn.func_186929_b(), packetIn.func_186927_f(), packetIn.func_186928_g(), false, 0, ISound.AttenuationType.LINEAR, (float)packetIn.func_186932_c(), (float)packetIn.func_186926_d(), (float)packetIn.func_186925_e()));
    }

    public void func_175095_a(SPacketResourcePackSend packetIn) {
        String s = packetIn.func_179783_a();
        String s1 = packetIn.func_179784_b();
        if (this.func_189688_b(s)) {
            if (s.startsWith("level://")) {
                try {
                    String s2 = URLDecoder.decode(s.substring("level://".length()), StandardCharsets.UTF_8.toString());
                    File file1 = new File(this.field_147299_f.field_71412_D, "saves");
                    File file2 = new File(file1, s2);
                    if (file2.isFile()) {
                        this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.ACCEPTED));
                        Futures.addCallback((ListenableFuture)this.field_147299_f.func_195541_I().func_195741_a(file2), this.func_189686_f());
                        return;
                    }
                }
                catch (UnsupportedEncodingException s2) {
                    // empty catch block
                }
                this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.FAILED_DOWNLOAD));
            } else {
                ServerData serverdata = this.field_147299_f.func_147104_D();
                if (serverdata != null && serverdata.func_152586_b() == ServerData.ServerResourceMode.ENABLED) {
                    this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.ACCEPTED));
                    Futures.addCallback((ListenableFuture)this.field_147299_f.func_195541_I().func_195744_a(s, s1), this.func_189686_f());
                } else if (serverdata != null && serverdata.func_152586_b() != ServerData.ServerResourceMode.PROMPT) {
                    this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.DECLINED));
                } else {
                    this.field_147299_f.func_152344_a(() -> this.field_147299_f.func_147108_a((GuiScreen)new GuiYesNo((p_210146_3_, p_210146_4_) -> {
                        this.field_147299_f = Minecraft.func_71410_x();
                        ServerData serverdata1 = this.field_147299_f.func_147104_D();
                        if (p_210146_3_) {
                            if (serverdata1 != null) {
                                serverdata1.func_152584_a(ServerData.ServerResourceMode.ENABLED);
                            }
                            this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.ACCEPTED));
                            Futures.addCallback((ListenableFuture)this.field_147299_f.func_195541_I().func_195744_a(s, s1), this.func_189686_f());
                        } else {
                            if (serverdata1 != null) {
                                serverdata1.func_152584_a(ServerData.ServerResourceMode.DISABLED);
                            }
                            this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.DECLINED));
                        }
                        ServerList.func_147414_b((ServerData)serverdata1);
                        this.field_147299_f.func_147108_a(null);
                    }, I18n.func_135052_a("multiplayer.texturePrompt.line1", new Object[0]), I18n.func_135052_a("multiplayer.texturePrompt.line2", new Object[0]), 0)));
                }
            }
        }
    }

    private boolean func_189688_b(String url) {
        try {
            URI uri = new URI(url);
            String s = uri.getScheme();
            boolean flag = "level".equals(s);
            if (!("http".equals(s) || "https".equals(s) || flag)) {
                throw new URISyntaxException(url, "Wrong protocol");
            }
            if (!flag || !url.contains("..") && url.endsWith("/resources.zip")) {
                return true;
            }
            throw new URISyntaxException(url, "Invalid levelstorage resourcepack path");
        }
        catch (URISyntaxException var5) {
            this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.FAILED_DOWNLOAD));
            return false;
        }
    }

    private FutureCallback<Object> func_189686_f() {
        return new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object p_onSuccess_1_) {
                NetHandlerPlayClient.this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.SUCCESSFULLY_LOADED));
            }

            public void onFailure(Throwable p_onFailure_1_) {
                NetHandlerPlayClient.this.field_147302_e.func_179290_a((Packet<?>)new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.FAILED_DOWNLOAD));
            }
        };
    }

    public void func_184325_a(SPacketUpdateBossInfo packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        this.field_147299_f.field_71456_v.func_184046_j().func_184055_a(packetIn);
    }

    public void func_184324_a(SPacketCooldown packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        if (packetIn.func_186922_b() == 0) {
            this.field_147299_f.field_71439_g.func_184811_cZ().func_185142_b(packetIn.func_186920_a());
        } else {
            this.field_147299_f.field_71439_g.func_184811_cZ().func_185145_a(packetIn.func_186920_a(), packetIn.func_186922_b());
        }
    }

    public void func_184323_a(SPacketMoveVehicle packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147299_f.field_71439_g.func_184208_bv();
        if (entity != this.field_147299_f.field_71439_g && entity.func_184186_bw()) {
            entity.func_70080_a(packetIn.func_186957_a(), packetIn.func_186955_b(), packetIn.func_186956_c(), packetIn.func_186959_d(), packetIn.func_186958_e());
            this.field_147302_e.func_179290_a((Packet<?>)new CPacketVehicleMove(entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147240_a(SPacketCustomPayload packetIn) {
        block26: {
            PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
            ResourceLocation resourcelocation = packetIn.func_149169_c();
            PacketBuffer packetbuffer = null;
            try {
                packetbuffer = packetIn.func_180735_b();
                if (SPacketCustomPayload.field_209910_a.equals((Object)resourcelocation)) {
                    try {
                        int i = packetbuffer.readInt();
                        GuiScreen guiscreen = this.field_147299_f.field_71462_r;
                        if (guiscreen instanceof GuiMerchant && i == this.field_147299_f.field_71439_g.field_71070_bA.field_75152_c) {
                            IMerchant imerchant = ((GuiMerchant)guiscreen).func_147035_g();
                            MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_151390_b((PacketBuffer)packetbuffer);
                            imerchant.func_70930_a(merchantrecipelist);
                        }
                        break block26;
                    }
                    catch (IOException ioexception) {
                        field_147301_d.error("Couldn't load trade info", (Throwable)ioexception);
                    }
                    break block26;
                }
                if (SPacketCustomPayload.field_209911_b.equals((Object)resourcelocation)) {
                    this.field_147299_f.field_71439_g.func_175158_f(packetbuffer.func_150789_c(Short.MAX_VALUE));
                } else if (SPacketCustomPayload.field_209912_c.equals((Object)resourcelocation)) {
                    ItemStack itemstack;
                    EnumHand enumhand = packetbuffer.func_179257_a(EnumHand.class);
                    ItemStack itemStack = itemstack = enumhand == EnumHand.OFF_HAND ? this.field_147299_f.field_71439_g.func_184592_cb() : this.field_147299_f.field_71439_g.func_184614_ca();
                    if (itemstack.func_77973_b() == Items.field_151164_bB) {
                        this.field_147299_f.func_147108_a((GuiScreen)new GuiScreenBook((EntityPlayer)this.field_147299_f.field_71439_g, itemstack, false, enumhand));
                    }
                } else if (SPacketCustomPayload.field_209913_d.equals((Object)resourcelocation)) {
                    int l = packetbuffer.readInt();
                    float f = packetbuffer.readFloat();
                    Path path = Path.func_186311_b((PacketBuffer)packetbuffer);
                    this.field_147299_f.field_184132_p.field_188286_a.func_188289_a(l, path, f);
                } else if (SPacketCustomPayload.field_209914_e.equals((Object)resourcelocation)) {
                    long i1 = packetbuffer.func_179260_f();
                    BlockPos blockpos1 = packetbuffer.func_179259_c();
                    ((DebugRendererNeighborsUpdate)this.field_147299_f.field_184132_p.field_191557_f).func_191553_a(i1, blockpos1);
                } else if (SPacketCustomPayload.field_209915_f.equals((Object)resourcelocation)) {
                    BlockPos blockpos = packetbuffer.func_179259_c();
                    int k1 = packetbuffer.readInt();
                    ArrayList list = Lists.newArrayList();
                    ArrayList list1 = Lists.newArrayList();
                    for (int j = 0; j < k1; ++j) {
                        list.add(packetbuffer.func_179259_c());
                        list1.add(Float.valueOf(packetbuffer.readFloat()));
                    }
                    this.field_147299_f.field_184132_p.field_201747_g.func_201742_a(blockpos, (List)list, (List)list1);
                } else if (SPacketCustomPayload.field_209916_g.equals((Object)resourcelocation)) {
                    int j1 = packetbuffer.readInt();
                    MutableBoundingBox mutableboundingbox = new MutableBoundingBox(packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt());
                    int l1 = packetbuffer.readInt();
                    ArrayList list2 = Lists.newArrayList();
                    ArrayList list3 = Lists.newArrayList();
                    for (int k = 0; k < l1; ++k) {
                        list2.add(new MutableBoundingBox(packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt(), packetbuffer.readInt()));
                        list3.add(packetbuffer.readBoolean());
                    }
                    this.field_147299_f.field_184132_p.field_201748_h.func_201729_a(mutableboundingbox, (List)list2, (List)list3, j1);
                } else if (SPacketCustomPayload.field_209917_h.equals((Object)resourcelocation)) {
                    ((DebugRendererWorldGenAttempts)this.field_147299_f.field_184132_p.field_201750_j).func_201734_a(packetbuffer.func_179259_c(), packetbuffer.readFloat(), packetbuffer.readFloat(), packetbuffer.readFloat(), packetbuffer.readFloat(), packetbuffer.readFloat());
                    field_147301_d.warn("Unknown custom packed identifier: {}", (Object)resourcelocation);
                } else if (!NetworkHooks.onCustomPayload((ICustomPacket)packetIn, (NetworkManager)this.field_147302_e)) {
                    field_147301_d.warn("Unknown custom packed identifier: {}", (Object)resourcelocation);
                }
            }
            finally {
                if (packetbuffer != null) {
                    // empty if block
                }
            }
        }
    }

    public void func_147291_a(SPacketScoreboardObjective packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        String s = packetIn.func_149339_c();
        if (packetIn.func_149338_e() == 0) {
            scoreboard.func_199868_a(s, ScoreCriteria.field_96641_b, packetIn.func_149337_d(), packetIn.func_199856_d());
        } else if (scoreboard.func_197900_b(s)) {
            ScoreObjective scoreobjective = scoreboard.func_96518_b(s);
            if (packetIn.func_149338_e() == 1) {
                scoreboard.func_96519_k(scoreobjective);
            } else if (packetIn.func_149338_e() == 2) {
                scoreobjective.func_199866_a(packetIn.func_199856_d());
                scoreobjective.func_199864_a(packetIn.func_149337_d());
            }
        }
    }

    public void func_147250_a(SPacketUpdateScore packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        String s = packetIn.func_149321_d();
        switch (packetIn.func_197701_d()) {
            case CHANGE: {
                ScoreObjective scoreobjective = scoreboard.func_197899_c(s);
                Score score = scoreboard.func_96529_a(packetIn.func_149324_c(), scoreobjective);
                score.func_96647_c(packetIn.func_149323_e());
                break;
            }
            case REMOVE: {
                scoreboard.func_178822_d(packetIn.func_149324_c(), scoreboard.func_96518_b(s));
            }
        }
    }

    public void func_147254_a(SPacketDisplayObjective packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        String s = packetIn.func_149370_d();
        ScoreObjective scoreobjective = s == null ? null : scoreboard.func_197899_c(s);
        scoreboard.func_96530_a(packetIn.func_149371_c(), scoreobjective);
    }

    public void func_147247_a(SPacketTeams packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Scoreboard scoreboard = this.field_147300_g.func_96441_U();
        ScorePlayerTeam scoreplayerteam = packetIn.func_149307_h() == 0 ? scoreboard.func_96527_f(packetIn.func_149312_c()) : scoreboard.func_96508_e(packetIn.func_149312_c());
        if (packetIn.func_149307_h() == 0 || packetIn.func_149307_h() == 2) {
            Team.CollisionRule team$collisionrule;
            scoreplayerteam.func_96664_a(packetIn.func_149306_d());
            scoreplayerteam.func_178774_a(packetIn.func_200537_f());
            scoreplayerteam.func_98298_a(packetIn.func_149308_i());
            Team.EnumVisible team$enumvisible = Team.EnumVisible.func_178824_a((String)packetIn.func_179814_i());
            if (team$enumvisible != null) {
                scoreplayerteam.func_178772_a(team$enumvisible);
            }
            if ((team$collisionrule = Team.CollisionRule.func_186686_a((String)packetIn.func_186975_j())) != null) {
                scoreplayerteam.func_186682_a(team$collisionrule);
            }
            scoreplayerteam.func_207408_a(packetIn.func_207507_i());
            scoreplayerteam.func_207409_b(packetIn.func_207508_j());
        }
        if (packetIn.func_149307_h() == 0 || packetIn.func_149307_h() == 3) {
            for (String s : packetIn.func_149310_g()) {
                scoreboard.func_197901_a(s, scoreplayerteam);
            }
        }
        if (packetIn.func_149307_h() == 4) {
            for (String s1 : packetIn.func_149310_g()) {
                scoreboard.func_96512_b(s1, scoreplayerteam);
            }
        }
        if (packetIn.func_149307_h() == 1) {
            scoreboard.func_96511_d(scoreplayerteam);
        }
    }

    public void func_147289_a(SPacketParticles packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        if (packetIn.func_149222_k() == 0) {
            double d0 = packetIn.func_149227_j() * packetIn.func_149221_g();
            double d2 = packetIn.func_149227_j() * packetIn.func_149224_h();
            double d4 = packetIn.func_149227_j() * packetIn.func_149223_i();
            try {
                this.field_147300_g.func_195590_a(packetIn.func_197699_j(), packetIn.func_179750_b(), packetIn.func_149220_d(), packetIn.func_149226_e(), packetIn.func_149225_f(), d0, d2, d4);
            }
            catch (Throwable var17) {
                field_147301_d.warn("Could not spawn particle effect {}", (Object)packetIn.func_197699_j());
            }
        } else {
            for (int i = 0; i < packetIn.func_149222_k(); ++i) {
                double d1 = this.field_147306_l.nextGaussian() * (double)packetIn.func_149221_g();
                double d3 = this.field_147306_l.nextGaussian() * (double)packetIn.func_149224_h();
                double d5 = this.field_147306_l.nextGaussian() * (double)packetIn.func_149223_i();
                double d6 = this.field_147306_l.nextGaussian() * (double)packetIn.func_149227_j();
                double d7 = this.field_147306_l.nextGaussian() * (double)packetIn.func_149227_j();
                double d8 = this.field_147306_l.nextGaussian() * (double)packetIn.func_149227_j();
                try {
                    this.field_147300_g.func_195590_a(packetIn.func_197699_j(), packetIn.func_179750_b(), packetIn.func_149220_d() + d1, packetIn.func_149226_e() + d3, packetIn.func_149225_f() + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable var16) {
                    field_147301_d.warn("Could not spawn particle effect {}", (Object)packetIn.func_197699_j());
                    return;
                }
            }
        }
    }

    public void func_147290_a(SPacketEntityProperties packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Entity entity = this.field_147300_g.func_73045_a(packetIn.func_149442_c());
        if (entity != null) {
            if (!(entity instanceof EntityLivingBase)) {
                throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + (Object)((Object)entity) + ")");
            }
            AbstractAttributeMap abstractattributemap = ((EntityLivingBase)entity).func_110140_aT();
            for (SPacketEntityProperties.Snapshot spacketentityproperties$snapshot : packetIn.func_149441_d()) {
                IAttributeInstance iattributeinstance = abstractattributemap.func_111152_a(spacketentityproperties$snapshot.func_151409_a());
                if (iattributeinstance == null) {
                    iattributeinstance = abstractattributemap.func_111150_b((IAttribute)new RangedAttribute((IAttribute)null, spacketentityproperties$snapshot.func_151409_a(), 0.0, Double.MIN_NORMAL, Double.MAX_VALUE));
                }
                iattributeinstance.func_111128_a(spacketentityproperties$snapshot.func_151410_b());
                iattributeinstance.func_142049_d();
                for (AttributeModifier attributemodifier : spacketentityproperties$snapshot.func_151408_c()) {
                    iattributeinstance.func_111121_a(attributemodifier);
                }
            }
        }
    }

    public void func_194307_a(SPacketPlaceGhostRecipe packetIn) {
        IRecipe irecipe;
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147299_f);
        Container container = this.field_147299_f.field_71439_g.field_71070_bA;
        if (container.field_75152_c == packetIn.func_194313_b() && container.func_75129_b(this.field_147299_f.field_71439_g) && (irecipe = this.field_199528_o.func_199517_a(packetIn.func_199615_a())) != null) {
            if (this.field_147299_f.field_71462_r instanceof IRecipeShownListener) {
                GuiRecipeBook guirecipebook = ((IRecipeShownListener)this.field_147299_f.field_71462_r).func_194310_f();
                guirecipebook.func_193951_a(irecipe, container.field_75151_b);
            } else if (this.field_147299_f.field_71462_r instanceof GuiFurnace) {
                ((GuiFurnace)this.field_147299_f.field_71462_r).field_201557_v.func_193951_a(irecipe, container.field_75151_b);
            }
        }
    }

    public NetworkManager func_147298_b() {
        return this.field_147302_e;
    }

    public Collection<NetworkPlayerInfo> func_175106_d() {
        return this.field_147310_i.values();
    }

    public NetworkPlayerInfo func_175102_a(UUID uniqueId) {
        return this.field_147310_i.get(uniqueId);
    }

    @Nullable
    public NetworkPlayerInfo func_175104_a(String name) {
        for (NetworkPlayerInfo networkplayerinfo : this.field_147310_i.values()) {
            if (!networkplayerinfo.func_178845_a().getName().equals(name)) continue;
            return networkplayerinfo;
        }
        return null;
    }

    public GameProfile func_175105_e() {
        return this.field_175107_d;
    }

    public ClientAdvancementManager func_191982_f() {
        return this.field_191983_k;
    }

    public CommandDispatcher<ISuggestionProvider> func_195515_i() {
        return this.field_195517_n;
    }

    public WorldClient func_195514_j() {
        return this.field_147300_g;
    }

    public NetworkTagManager func_199724_l() {
        return this.field_199725_m;
    }

    public NBTQueryManager func_211523_k() {
        return this.field_211524_l;
    }
}

