/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.ScreenChatOptions;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class KeyboardListener {
    private final Minecraft field_197972_a;
    private boolean field_197973_b;
    private long field_197974_c = -1L;
    private long field_204871_d = -1L;
    private long field_204872_e = -1L;
    private boolean field_197975_d;
    private final ByteBuffer field_211563_g = ByteBuffer.allocateDirect(1024);

    public KeyboardListener(Minecraft mcIn) {
        this.field_197972_a = mcIn;
    }

    private void func_197964_a(String message, Object ... args) {
        this.field_197972_a.field_71456_v.func_146158_b().func_146227_a(new TextComponentString("").func_150257_a(new TextComponentTranslation("debug.prefix", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation(message, args)));
    }

    private void func_204869_b(String message, Object ... args) {
        this.field_197972_a.field_71456_v.func_146158_b().func_146227_a(new TextComponentString("").func_150257_a(new TextComponentTranslation("debug.prefix", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD})).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation(message, args)));
    }

    private boolean func_197962_c(int key) {
        if (this.field_197974_c > 0L && this.field_197974_c < Util.func_211177_b() - 100L) {
            return true;
        }
        switch (key) {
            case 65: {
                this.field_197972_a.field_71438_f.func_72712_a();
                this.func_197964_a("debug.reload_chunks.message", new Object[0]);
                return true;
            }
            case 66: {
                boolean flag = !this.field_197972_a.func_175598_ae().func_178634_b();
                this.field_197972_a.func_175598_ae().func_178629_b(flag);
                this.func_197964_a(flag ? "debug.show_hitboxes.on" : "debug.show_hitboxes.off", new Object[0]);
                return true;
            }
            case 67: {
                if (this.field_197972_a.field_71439_g.func_175140_cp()) {
                    return false;
                }
                this.func_197964_a("debug.copy_location.message", new Object[0]);
                this.func_197960_a(String.format(Locale.ROOT, "/execute in %s run tp @s %.2f %.2f %.2f %.2f %.2f", DimensionType.func_212678_a(this.field_197972_a.field_71439_g.field_70170_p.field_73011_w.func_186058_p()), this.field_197972_a.field_71439_g.field_70165_t, this.field_197972_a.field_71439_g.field_70163_u, this.field_197972_a.field_71439_g.field_70161_v, Float.valueOf(this.field_197972_a.field_71439_g.field_70177_z), Float.valueOf(this.field_197972_a.field_71439_g.field_70125_A)));
                return true;
            }
            case 68: {
                if (this.field_197972_a.field_71456_v != null) {
                    this.field_197972_a.field_71456_v.func_146158_b().func_146231_a(false);
                }
                return true;
            }
            default: {
                return false;
            }
            case 70: {
                this.field_197972_a.field_71474_y.func_74306_a(GameSettings.Options.RENDER_DISTANCE, GuiScreen.func_146272_n() ? -1 : 1);
                this.func_197964_a("debug.cycle_renderdistance.message", this.field_197972_a.field_71474_y.field_151451_c);
                return true;
            }
            case 71: {
                boolean flag1 = this.field_197972_a.field_184132_p.func_190075_b();
                this.func_197964_a(flag1 ? "debug.chunk_boundaries.on" : "debug.chunk_boundaries.off", new Object[0]);
                return true;
            }
            case 72: {
                this.field_197972_a.field_71474_y.field_82882_x = !this.field_197972_a.field_71474_y.field_82882_x;
                this.func_197964_a(this.field_197972_a.field_71474_y.field_82882_x ? "debug.advanced_tooltips.on" : "debug.advanced_tooltips.off", new Object[0]);
                this.field_197972_a.field_71474_y.func_74303_b();
                return true;
            }
            case 73: {
                if (!this.field_197972_a.field_71439_g.func_175140_cp()) {
                    this.func_211556_a(this.field_197972_a.field_71439_g.func_211513_k(2), !GuiScreen.func_146272_n());
                }
                return true;
            }
            case 78: {
                if (!this.field_197972_a.field_71439_g.func_211513_k(2)) {
                    this.func_197964_a("debug.creative_spectator.error", new Object[0]);
                } else if (this.field_197972_a.field_71439_g.func_184812_l_()) {
                    this.field_197972_a.field_71439_g.func_71165_d("/gamemode spectator");
                } else if (this.field_197972_a.field_71439_g.func_175149_v()) {
                    this.field_197972_a.field_71439_g.func_71165_d("/gamemode creative");
                }
                return true;
            }
            case 80: {
                this.field_197972_a.field_71474_y.field_82881_y = !this.field_197972_a.field_71474_y.field_82881_y;
                this.field_197972_a.field_71474_y.func_74303_b();
                this.func_197964_a(this.field_197972_a.field_71474_y.field_82881_y ? "debug.pause_focus.on" : "debug.pause_focus.off", new Object[0]);
                return true;
            }
            case 81: {
                this.func_197964_a("debug.help.message", new Object[0]);
                GuiNewChat guinewchat = this.field_197972_a.field_71456_v.func_146158_b();
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.reload_chunks.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.show_hitboxes.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.copy_location.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.clear_chat.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.cycle_renderdistance.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.chunk_boundaries.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.advanced_tooltips.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.inspect.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.creative_spectator.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.pause_focus.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.help.help", new Object[0]));
                guinewchat.func_146227_a((ITextComponent)new TextComponentTranslation("debug.reload_resourcepacks.help", new Object[0]));
                return true;
            }
            case 84: 
        }
        this.func_197964_a("debug.reload_resourcepacks.message", new Object[0]);
        this.field_197972_a.func_110436_a();
        return true;
    }

    private void func_211556_a(boolean p_211556_1_, boolean p_211556_2_) {
        if (this.field_197972_a.field_71476_x != null) {
            switch (this.field_197972_a.field_71476_x.field_72313_a) {
                case BLOCK: {
                    BlockPos blockpos = this.field_197972_a.field_71476_x.func_178782_a();
                    IBlockState iblockstate = this.field_197972_a.field_71439_g.field_70170_p.func_180495_p(blockpos);
                    if (p_211556_1_) {
                        if (p_211556_2_) {
                            this.field_197972_a.field_71439_g.field_71174_a.func_211523_k().func_211547_a(blockpos, p_211561_3_ -> {
                                this.func_211558_a(iblockstate, blockpos, (NBTTagCompound)p_211561_3_);
                                this.func_197964_a("debug.inspect.server.block", new Object[0]);
                            });
                            break;
                        }
                        TileEntity tileentity = this.field_197972_a.field_71439_g.field_70170_p.func_175625_s(blockpos);
                        NBTTagCompound nbttagcompound1 = tileentity != null ? tileentity.func_189515_b(new NBTTagCompound()) : null;
                        this.func_211558_a(iblockstate, blockpos, nbttagcompound1);
                        this.func_197964_a("debug.inspect.client.block", new Object[0]);
                        break;
                    }
                    this.func_211558_a(iblockstate, blockpos, null);
                    this.func_197964_a("debug.inspect.client.block", new Object[0]);
                    break;
                }
                case ENTITY: {
                    Entity entity = this.field_197972_a.field_71476_x.field_72308_g;
                    if (entity == null) {
                        return;
                    }
                    ResourceLocation resourcelocation = IRegistry.field_212629_r.func_177774_c(entity.func_200600_R());
                    Vec3d vec3d = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    if (p_211556_1_) {
                        if (p_211556_2_) {
                            this.field_197972_a.field_71439_g.field_71174_a.func_211523_k().func_211549_a(entity.func_145782_y(), p_211560_3_ -> {
                                this.func_211557_a(resourcelocation, vec3d, (NBTTagCompound)p_211560_3_);
                                this.func_197964_a("debug.inspect.server.entity", new Object[0]);
                            });
                            break;
                        }
                        NBTTagCompound nbttagcompound = entity.func_189511_e(new NBTTagCompound());
                        this.func_211557_a(resourcelocation, vec3d, nbttagcompound);
                        this.func_197964_a("debug.inspect.client.entity", new Object[0]);
                        break;
                    }
                    this.func_211557_a(resourcelocation, vec3d, null);
                    this.func_197964_a("debug.inspect.client.entity", new Object[0]);
                }
            }
        }
    }

    private void func_211558_a(IBlockState state, BlockPos pos, @Nullable NBTTagCompound compound) {
        if (compound != null) {
            compound.func_82580_o("x");
            compound.func_82580_o("y");
            compound.func_82580_o("z");
            compound.func_82580_o("id");
        }
        String s = BlockStateParser.func_197247_a(state, compound);
        String s1 = String.format(Locale.ROOT, "/setblock %d %d %d %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), s);
        this.func_197960_a(s1);
    }

    private void func_211557_a(ResourceLocation entityIdIn, Vec3d pos, @Nullable NBTTagCompound compound) {
        String s;
        if (compound != null) {
            compound.func_82580_o("UUIDMost");
            compound.func_82580_o("UUIDLeast");
            compound.func_82580_o("Pos");
            compound.func_82580_o("Dimension");
            String s1 = compound.func_197637_c().getString();
            s = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f %s", entityIdIn.toString(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, s1);
        } else {
            s = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f", entityIdIn.toString(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        this.func_197960_a(s);
    }

    public void func_197961_a(long windowPointer, int key, int scanCode, int action, int modifiers) {
        if (windowPointer == this.field_197972_a.field_195558_d.func_198092_i()) {
            if (this.field_197974_c > 0L) {
                if (!InputMappings.func_197956_a((int)67) || !InputMappings.func_197956_a((int)292)) {
                    this.field_197974_c = -1L;
                }
            } else if (InputMappings.func_197956_a((int)67) && InputMappings.func_197956_a((int)292)) {
                this.field_197975_d = true;
                this.field_197974_c = Util.func_211177_b();
                this.field_204871_d = Util.func_211177_b();
                this.field_204872_e = 0L;
            }
            GuiScreen iguieventlistener = this.field_197972_a.field_71462_r;
            if (!(this.field_197972_a.field_71462_r instanceof GuiControls) || ((GuiControls)iguieventlistener).field_152177_g <= Util.func_211177_b() - 20L) {
                if (action == 1) {
                    if (this.field_197972_a.field_71474_y.field_152395_am.func_197976_a(key, scanCode)) {
                        this.field_197972_a.field_195558_d.func_198077_g();
                        return;
                    }
                    if (this.field_197972_a.field_71474_y.field_151447_Z.func_197976_a(key, scanCode)) {
                        if (GuiScreen.func_146271_m()) {
                            // empty if block
                        }
                        ScreenShotHelper.func_148260_a(this.field_197972_a.field_71412_D, this.field_197972_a.field_195558_d.func_198109_k(), this.field_197972_a.field_195558_d.func_198091_l(), this.field_197972_a.func_147110_a(), p_212449_1_ -> this.field_197972_a.func_152344_a(() -> this.field_197972_a.field_71456_v.func_146158_b().func_146227_a(p_212449_1_)));
                        return;
                    }
                } else if (action == 0 && this.field_197972_a.field_71462_r instanceof GuiControls) {
                    ((GuiControls)this.field_197972_a.field_71462_r).field_146491_f = null;
                }
            }
            if (iguieventlistener != null) {
                boolean[] aboolean = new boolean[]{false};
                GuiScreen.func_195121_a(() -> this.lambda$onKeyEvent$4(action, aboolean, key, scanCode, modifiers, (IGuiEventListener)iguieventlistener), "keyPressed event handler", ((Object)((Object)iguieventlistener)).getClass().getCanonicalName());
                if (aboolean[0]) {
                    return;
                }
            }
            if (this.field_197972_a.field_71462_r == null || this.field_197972_a.field_71462_r.field_146291_p) {
                InputMappings.Input inputmappings$input = InputMappings.func_197954_a((int)key, (int)scanCode);
                if (action == 0) {
                    KeyBinding.func_197980_a(inputmappings$input, false);
                    if (key == 292) {
                        if (this.field_197975_d) {
                            this.field_197975_d = false;
                        } else {
                            this.field_197972_a.field_71474_y.field_74330_P = !this.field_197972_a.field_71474_y.field_74330_P;
                            this.field_197972_a.field_71474_y.field_74329_Q = this.field_197972_a.field_71474_y.field_74330_P && GuiScreen.func_146272_n();
                            this.field_197972_a.field_71474_y.field_181657_aC = this.field_197972_a.field_71474_y.field_74330_P && GuiScreen.func_175283_s();
                        }
                    }
                } else {
                    if (key == 66 && GuiScreen.func_146271_m()) {
                        this.field_197972_a.field_71474_y.func_74306_a(GameSettings.Options.NARRATOR, 1);
                        if (iguieventlistener instanceof ScreenChatOptions) {
                            ((ScreenChatOptions)iguieventlistener).func_193024_a();
                        }
                    }
                    if (key == 293 && this.field_197972_a.field_71460_t != null) {
                        this.field_197972_a.field_71460_t.func_175071_c();
                    }
                    boolean flag = false;
                    if (this.field_197972_a.field_71462_r == null) {
                        if (key == 256) {
                            this.field_197972_a.func_71385_j();
                        }
                        flag = InputMappings.func_197956_a((int)292) && this.func_197962_c(key);
                        this.field_197975_d |= flag;
                        if (key == 290) {
                            boolean bl = this.field_197972_a.field_71474_y.field_74319_N = !this.field_197972_a.field_71474_y.field_74319_N;
                        }
                    }
                    if (flag) {
                        KeyBinding.func_197980_a(inputmappings$input, false);
                    } else {
                        KeyBinding.func_197980_a(inputmappings$input, true);
                        KeyBinding.func_197981_a(inputmappings$input);
                    }
                    if (this.field_197972_a.field_71474_y.field_74329_Q) {
                        if (key == 48) {
                            this.field_197972_a.func_71383_b(0);
                        }
                        for (int i = 0; i < 9; ++i) {
                            if (key != 49 + i) continue;
                            this.field_197972_a.func_71383_b(i + 1);
                        }
                    }
                }
            }
            ForgeHooksClient.fireKeyInput((int)key, (int)scanCode, (int)action, (int)modifiers);
        }
    }

    private void func_197963_a(long windowPointer, int codePoint, int modifiers) {
        GuiScreen iguieventlistener;
        if (windowPointer == this.field_197972_a.field_195558_d.func_198092_i() && (iguieventlistener = this.field_197972_a.field_71462_r) != null) {
            if (Character.charCount(codePoint) == 1) {
                GuiScreen.func_195121_a(() -> this.lambda$onCharEvent$5(codePoint, modifiers, (IGuiEventListener)iguieventlistener), "charTyped event handler", ((Object)((Object)iguieventlistener)).getClass().getCanonicalName());
            } else {
                for (char c0 : Character.toChars(codePoint)) {
                    GuiScreen.func_195121_a(() -> this.lambda$onCharEvent$6(c0, modifiers, (IGuiEventListener)iguieventlistener), "charTyped event handler", ((Object)((Object)iguieventlistener)).getClass().getCanonicalName());
                }
            }
        }
    }

    public void func_197967_a(boolean p_197967_1_) {
        this.field_197973_b = p_197967_1_;
    }

    public void func_197968_a(long window) {
        GLFW.glfwSetKeyCallback((long)window, this::func_197961_a);
        GLFW.glfwSetCharModsCallback((long)window, this::func_197963_a);
    }

    public String func_197965_a() {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((p_197966_1_, p_197966_2_) -> {
            if (p_197966_1_ != 65545) {
                this.field_197972_a.field_195558_d.func_198084_a(p_197966_1_, p_197966_2_);
            }
        });
        String s = GLFW.glfwGetClipboardString((long)this.field_197972_a.field_195558_d.func_198092_i());
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)glfwerrorcallback).free();
        return s == null ? "" : s;
    }

    private void func_211559_a(ByteBuffer p_211559_1_, String p_211559_2_) {
        MemoryUtil.memUTF8((CharSequence)p_211559_2_, (boolean)true, (ByteBuffer)p_211559_1_);
        GLFW.glfwSetClipboardString((long)this.field_197972_a.field_195558_d.func_198092_i(), (ByteBuffer)p_211559_1_);
    }

    public void func_197960_a(String string) {
        int i = MemoryUtil.memLengthUTF8((CharSequence)string, (boolean)true);
        if (i < this.field_211563_g.capacity()) {
            this.func_211559_a(this.field_211563_g, string);
            this.field_211563_g.clear();
        } else {
            ByteBuffer bytebuffer = ByteBuffer.allocateDirect(i);
            this.func_211559_a(bytebuffer, string);
        }
    }

    public void func_204870_b() {
        if (this.field_197974_c > 0L) {
            long i = Util.func_211177_b();
            long j = 10000L - (i - this.field_197974_c);
            long k = i - this.field_204871_d;
            if (j < 0L) {
                if (GuiScreen.func_146271_m()) {
                    MemoryUtil.memSet((long)0L, (int)0, (long)1L);
                }
                throw new ReportedException(new CrashReport("Manually triggered debug crash", new Throwable()));
            }
            if (k >= 1000L) {
                if (this.field_204872_e == 0L) {
                    this.func_197964_a("debug.crash.message", new Object[0]);
                } else {
                    this.func_204869_b("debug.crash.warning", MathHelper.func_76123_f((float)((float)j / 1000.0f)));
                }
                this.field_204871_d = i;
                ++this.field_204872_e;
            }
        }
    }

    private /* synthetic */ void lambda$onCharEvent$6(char c0, int modifiers, IGuiEventListener iguieventlistener) {
        if (ForgeHooksClient.onGuiCharTypedPre((GuiScreen)this.field_197972_a.field_71462_r, (char)c0, (int)modifiers)) {
            return;
        }
        if (iguieventlistener.charTyped(c0, modifiers)) {
            return;
        }
        ForgeHooksClient.onGuiCharTypedPost((GuiScreen)this.field_197972_a.field_71462_r, (char)c0, (int)modifiers);
    }

    private /* synthetic */ void lambda$onCharEvent$5(int codePoint, int modifiers, IGuiEventListener iguieventlistener) {
        if (ForgeHooksClient.onGuiCharTypedPre((GuiScreen)this.field_197972_a.field_71462_r, (char)((char)codePoint), (int)modifiers)) {
            return;
        }
        if (iguieventlistener.charTyped((char)codePoint, modifiers)) {
            return;
        }
        ForgeHooksClient.onGuiCharTypedPost((GuiScreen)this.field_197972_a.field_71462_r, (char)((char)codePoint), (int)modifiers);
    }

    private /* synthetic */ void lambda$onKeyEvent$4(int action, boolean[] aboolean, int key, int scanCode, int modifiers, IGuiEventListener iguieventlistener) {
        if (!(action == 1 || action == 2 && this.field_197973_b)) {
            if (action == 0) {
                aboolean[0] = ForgeHooksClient.onGuiKeyReleasedPre((GuiScreen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
                if (!aboolean[0]) {
                    aboolean[0] = iguieventlistener.keyReleased(key, scanCode, modifiers);
                }
                if (!aboolean[0]) {
                    aboolean[0] = ForgeHooksClient.onGuiKeyReleasedPost((GuiScreen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
                }
            }
        } else {
            aboolean[0] = ForgeHooksClient.onGuiKeyPressedPre((GuiScreen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
            if (!aboolean[0]) {
                aboolean[0] = iguieventlistener.keyPressed(key, scanCode, modifiers);
            }
            if (!aboolean[0]) {
                aboolean[0] = ForgeHooksClient.onGuiKeyPressedPost((GuiScreen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
            }
        }
    }
}

