/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSixWay;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockVine
extends Block
implements IShearable {
    public static final BooleanProperty field_176277_a = BlockSixWay.field_196496_z;
    public static final BooleanProperty field_176273_b = BlockSixWay.field_196488_a;
    public static final BooleanProperty field_176278_M = BlockSixWay.field_196490_b;
    public static final BooleanProperty field_176279_N = BlockSixWay.field_196492_c;
    public static final BooleanProperty field_176280_O = BlockSixWay.field_196495_y;
    public static final Map<EnumFacing, BooleanProperty> field_196546_A = (Map)BlockSixWay.field_196491_B.entrySet().stream().filter(p_199782_0_ -> p_199782_0_.getKey() != EnumFacing.DOWN).collect(Util.func_199749_a());
    protected static final VoxelShape field_185757_g = Block.func_208617_a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185753_B = Block.func_208617_a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    protected static final VoxelShape field_185754_C = Block.func_208617_a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185755_D = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    protected static final VoxelShape field_185756_E = Block.func_208617_a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);

    public BlockVine(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176277_a, Boolean.valueOf(false))).func_206870_a((IProperty)field_176273_b, Boolean.valueOf(false))).func_206870_a((IProperty)field_176278_M, Boolean.valueOf(false))).func_206870_a((IProperty)field_176279_N, Boolean.valueOf(false))).func_206870_a((IProperty)field_176280_O, Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        if (((Boolean)state.func_177229_b((IProperty)field_176277_a)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185757_g);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176273_b)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185755_D);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176278_M)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185754_C);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176279_N)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185756_E);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176280_O)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185753_B);
        }
        return voxelshape;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        return this.func_196543_i(this.func_196545_h(state, (IBlockReader)worldIn, pos));
    }

    private boolean func_196543_i(IBlockState p_196543_1_) {
        return this.func_208496_w(p_196543_1_) > 0;
    }

    private int func_208496_w(IBlockState p_208496_1_) {
        int i = 0;
        for (BooleanProperty booleanproperty : field_196546_A.values()) {
            if (!((Boolean)p_208496_1_.func_177229_b((IProperty)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean func_196541_a(IBlockReader p_196541_1_, BlockPos p_196541_2_, EnumFacing p_196541_3_) {
        if (p_196541_3_ == EnumFacing.DOWN) {
            return false;
        }
        BlockPos blockpos = p_196541_2_.func_177972_a(p_196541_3_);
        if (this.func_196542_b(p_196541_1_, blockpos, p_196541_3_)) {
            return true;
        }
        if (p_196541_3_.func_176740_k() == EnumFacing.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = field_196546_A.get((Object)p_196541_3_);
        IBlockState iblockstate = p_196541_1_.func_180495_p(p_196541_2_.func_177984_a());
        return iblockstate.func_177230_c() == this && (Boolean)iblockstate.func_177229_b((IProperty)booleanproperty) != false;
    }

    private boolean func_196542_b(IBlockReader p_196542_1_, BlockPos p_196542_2_, EnumFacing p_196542_3_) {
        IBlockState iblockstate = p_196542_1_.func_180495_p(p_196542_2_);
        return iblockstate.func_193401_d(p_196542_1_, p_196542_2_, p_196542_3_.func_176734_d()) == BlockFaceShape.SOLID && !BlockVine.func_193397_e(iblockstate.func_177230_c());
    }

    protected static boolean func_193397_e(Block p_193397_0_) {
        return p_193397_0_ instanceof BlockShulkerBox || p_193397_0_ instanceof BlockStainedGlass || p_193397_0_ == Blocks.field_150461_bJ || p_193397_0_ == Blocks.field_150383_bp || p_193397_0_ == Blocks.field_150359_w || p_193397_0_ == Blocks.field_150331_J || p_193397_0_ == Blocks.field_150320_F || p_193397_0_ == Blocks.field_150332_K || p_193397_0_.func_203417_a(BlockTags.field_212186_k);
    }

    private IBlockState func_196545_h(IBlockState p_196545_1_, IBlockReader p_196545_2_, BlockPos p_196545_3_) {
        BlockPos blockpos = p_196545_3_.func_177984_a();
        if (((Boolean)p_196545_1_.func_177229_b((IProperty)field_176277_a)).booleanValue()) {
            p_196545_1_ = (IBlockState)p_196545_1_.func_206870_a((IProperty)field_176277_a, Boolean.valueOf(this.func_196542_b(p_196545_2_, blockpos, EnumFacing.DOWN)));
        }
        IBlockState iblockstate = null;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = BlockVine.func_176267_a(enumfacing);
            if (!((Boolean)p_196545_1_.func_177229_b((IProperty)booleanproperty)).booleanValue()) continue;
            boolean flag = this.func_196541_a(p_196545_2_, p_196545_3_, enumfacing);
            if (!flag) {
                if (iblockstate == null) {
                    iblockstate = p_196545_2_.func_180495_p(blockpos);
                }
                flag = iblockstate.func_177230_c() == this && (Boolean)iblockstate.func_177229_b((IProperty)booleanproperty) != false;
            }
            p_196545_1_ = (IBlockState)p_196545_1_.func_206870_a((IProperty)booleanproperty, Boolean.valueOf(flag));
        }
        return p_196545_1_;
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == EnumFacing.DOWN) {
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        IBlockState iblockstate = this.func_196545_h(stateIn, (IBlockReader)worldIn, currentPos);
        return !this.func_196543_i(iblockstate) ? Blocks.field_150350_a.func_176223_P() : iblockstate;
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = this.func_196545_h(state, (IBlockReader)worldIn, pos);
            if (iblockstate != state) {
                if (this.func_196543_i(iblockstate)) {
                    worldIn.func_180501_a(pos, iblockstate, 2);
                } else {
                    state.func_196949_c(worldIn, pos, 0);
                    worldIn.func_175698_g(pos);
                }
            } else if (worldIn.field_73012_v.nextInt(4) == 0 && worldIn.func_205050_e(pos, 4)) {
                EnumFacing enumfacing = EnumFacing.func_176741_a(random);
                BlockPos blockpos = pos.func_177984_a();
                if (enumfacing.func_176740_k().func_176722_c() && !((Boolean)state.func_177229_b((IProperty)BlockVine.func_176267_a(enumfacing))).booleanValue()) {
                    if (this.func_196539_a((IBlockReader)worldIn, pos)) {
                        BlockPos blockpos4 = pos.func_177972_a(enumfacing);
                        IBlockState iblockstate5 = worldIn.func_180495_p(blockpos4);
                        if (iblockstate5.func_196958_f()) {
                            EnumFacing enumfacing3 = enumfacing.func_176746_e();
                            EnumFacing enumfacing4 = enumfacing.func_176735_f();
                            boolean flag = (Boolean)state.func_177229_b((IProperty)BlockVine.func_176267_a(enumfacing3));
                            boolean flag1 = (Boolean)state.func_177229_b((IProperty)BlockVine.func_176267_a(enumfacing4));
                            BlockPos blockpos2 = blockpos4.func_177972_a(enumfacing3);
                            BlockPos blockpos3 = blockpos4.func_177972_a(enumfacing4);
                            if (flag && this.func_196542_b((IBlockReader)worldIn, blockpos2, enumfacing3)) {
                                worldIn.func_180501_a(blockpos4, (IBlockState)this.func_176223_P().func_206870_a((IProperty)BlockVine.func_176267_a(enumfacing3), Boolean.valueOf(true)), 2);
                            } else if (flag1 && this.func_196542_b((IBlockReader)worldIn, blockpos3, enumfacing4)) {
                                worldIn.func_180501_a(blockpos4, (IBlockState)this.func_176223_P().func_206870_a((IProperty)BlockVine.func_176267_a(enumfacing4), Boolean.valueOf(true)), 2);
                            } else {
                                EnumFacing enumfacing1 = enumfacing.func_176734_d();
                                if (flag && worldIn.func_175623_d(blockpos2) && this.func_196542_b((IBlockReader)worldIn, pos.func_177972_a(enumfacing3), enumfacing1)) {
                                    worldIn.func_180501_a(blockpos2, (IBlockState)this.func_176223_P().func_206870_a((IProperty)BlockVine.func_176267_a(enumfacing1), Boolean.valueOf(true)), 2);
                                } else if (flag1 && worldIn.func_175623_d(blockpos3) && this.func_196542_b((IBlockReader)worldIn, pos.func_177972_a(enumfacing4), enumfacing1)) {
                                    worldIn.func_180501_a(blockpos3, (IBlockState)this.func_176223_P().func_206870_a((IProperty)BlockVine.func_176267_a(enumfacing1), Boolean.valueOf(true)), 2);
                                } else if ((double)worldIn.field_73012_v.nextFloat() < 0.05 && this.func_196542_b((IBlockReader)worldIn, blockpos4.func_177984_a(), EnumFacing.UP)) {
                                    worldIn.func_180501_a(blockpos4, (IBlockState)this.func_176223_P().func_206870_a((IProperty)field_176277_a, Boolean.valueOf(true)), 2);
                                }
                            }
                        } else if (this.func_196542_b((IBlockReader)worldIn, blockpos4, enumfacing)) {
                            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockVine.func_176267_a(enumfacing), Boolean.valueOf(true)), 2);
                        }
                    }
                } else {
                    IBlockState iblockstate3;
                    IBlockState iblockstate2;
                    BlockPos blockpos1;
                    IBlockState iblockstate1;
                    if (enumfacing == EnumFacing.UP && pos.func_177956_o() < 255) {
                        if (this.func_196541_a((IBlockReader)worldIn, pos, enumfacing)) {
                            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176277_a, Boolean.valueOf(true)), 2);
                            return;
                        }
                        if (worldIn.func_175623_d(blockpos)) {
                            if (!this.func_196539_a((IBlockReader)worldIn, pos)) {
                                return;
                            }
                            IBlockState iblockstate4 = state;
                            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                                if (!random.nextBoolean() && this.func_196542_b((IBlockReader)worldIn, blockpos.func_177972_a(enumfacing2), EnumFacing.UP)) continue;
                                iblockstate4 = (IBlockState)iblockstate4.func_206870_a((IProperty)BlockVine.func_176267_a(enumfacing2), Boolean.valueOf(false));
                            }
                            if (this.func_196540_x(iblockstate4)) {
                                worldIn.func_180501_a(blockpos, iblockstate4, 2);
                            }
                            return;
                        }
                    }
                    if (pos.func_177956_o() > 0 && ((iblockstate1 = worldIn.func_180495_p(blockpos1 = pos.func_177977_b())).func_196958_f() || iblockstate1.func_177230_c() == this) && (iblockstate2 = iblockstate1.func_196958_f() ? this.func_176223_P() : iblockstate1) != (iblockstate3 = this.func_196544_a(state, iblockstate2, random)) && this.func_196540_x(iblockstate3)) {
                        worldIn.func_180501_a(blockpos1, iblockstate3, 2);
                    }
                }
            }
        }
    }

    private IBlockState func_196544_a(IBlockState p_196544_1_, IBlockState p_196544_2_, Random p_196544_3_) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!p_196544_3_.nextBoolean() || !((Boolean)p_196544_1_.func_177229_b((IProperty)(booleanproperty = BlockVine.func_176267_a(enumfacing)))).booleanValue()) continue;
            p_196544_2_ = (IBlockState)p_196544_2_.func_206870_a((IProperty)booleanproperty, Boolean.valueOf(true));
        }
        return p_196544_2_;
    }

    private boolean func_196540_x(IBlockState p_196540_1_) {
        return (Boolean)p_196540_1_.func_177229_b((IProperty)field_176273_b) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)field_176278_M) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)field_176279_N) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)field_176280_O) != false;
    }

    private boolean func_196539_a(IBlockReader p_196539_1_, BlockPos p_196539_2_) {
        int i = 4;
        Iterable iterable = BlockPos.MutableBlockPos.func_191531_b((int)(p_196539_2_.func_177958_n() - 4), (int)(p_196539_2_.func_177956_o() - 1), (int)(p_196539_2_.func_177952_p() - 4), (int)(p_196539_2_.func_177958_n() + 4), (int)(p_196539_2_.func_177956_o() + 1), (int)(p_196539_2_.func_177952_p() + 4));
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (p_196539_1_.func_180495_p(blockpos).func_177230_c() != this || --j > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_196253_a(IBlockState state, BlockItemUseContext useContext) {
        IBlockState iblockstate = useContext.func_195991_k().func_180495_p(useContext.func_195995_a());
        if (iblockstate.func_177230_c() == this) {
            return this.func_208496_w(iblockstate) < field_196546_A.size();
        }
        return super.func_196253_a(state, useContext);
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        IBlockState iblockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        boolean flag = iblockstate.func_177230_c() == this;
        IBlockState iblockstate1 = flag ? iblockstate : this.func_176223_P();
        for (EnumFacing enumfacing : context.func_196009_e()) {
            boolean flag1;
            if (enumfacing == EnumFacing.DOWN) continue;
            BooleanProperty booleanproperty = BlockVine.func_176267_a(enumfacing);
            boolean bl = flag1 = flag && (Boolean)iblockstate.func_177229_b((IProperty)booleanproperty) != false;
            if (flag1 || !this.func_196541_a((IBlockReader)context.func_195991_k(), context.func_195995_a(), enumfacing)) continue;
            return (IBlockState)iblockstate1.func_206870_a((IProperty)booleanproperty, Boolean.valueOf(true));
        }
        return flag ? iblockstate1 : null;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_190931_a;
    }

    @Override
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.field_188065_ae.func_199076_b((Object)this));
            player.func_71020_j(0.005f);
            BlockVine.func_180635_a(worldIn, pos, new ItemStack(Blocks.field_150395_bd));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O});
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176279_N))).func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176280_O))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176273_b))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176278_M));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176278_M))).func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176279_N))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176280_O))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176273_b));
            }
            case CLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176280_O))).func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176273_b))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176278_M))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176279_N));
            }
        }
        return state;
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176279_N))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176273_b));
            }
            case FRONT_BACK: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176280_O))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176278_M));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public static BooleanProperty func_176267_a(EnumFacing side) {
        return field_196546_A.get((Object)side);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isLadder(IBlockState state, IWorldReader world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        return Arrays.asList(new ItemStack(this));
    }
}

