/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;

public class BlockTallGrass
extends BlockBush
implements IGrowable,
IShearable {
    protected static final VoxelShape field_196389_a = Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 13.0, 14.0);

    protected BlockTallGrass(Block.Properties builder) {
        super(builder);
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196389_a;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_190931_a;
    }

    @Override
    public int func_196251_a(IBlockState state, int fortune, World worldIn, BlockPos pos, Random random) {
        return 1 + random.nextInt(fortune * 2 + 1);
    }

    @Override
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.field_188065_ae.func_199076_b((Object)this));
            player.func_71020_j(0.005f);
            BlockTallGrass.func_180635_a(worldIn, pos, new ItemStack(this));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockDoublePlant blockdoubleplant = (BlockDoublePlant)(this == Blocks.field_196554_aH ? Blocks.field_196805_gi : Blocks.field_196804_gh);
        if (blockdoubleplant.func_176223_P().func_196955_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a())) {
            blockdoubleplant.func_196390_a(worldIn, pos, 2);
        }
    }

    @Override
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        return Arrays.asList(new ItemStack(this));
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        if (world.field_73012_v.nextInt(8) != 0) {
            return;
        }
        ItemStack seed = ForgeHooks.getGrassSeed((Random)world.field_73012_v, (int)fortune);
        if (!seed.func_190926_b()) {
            drops.add((Object)seed);
        }
    }
}

