/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockSnowLayer
extends Block {
    public static final IntegerProperty field_176315_a = BlockStateProperties.field_208129_ad;
    protected static final VoxelShape[] field_196508_b = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    protected BlockSnowLayer(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176315_a, Integer.valueOf(1)));
    }

    @Override
    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Integer)state.func_177229_b((IProperty)field_176315_a) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_176315_a) == 8;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196508_b[(Integer)state.func_177229_b((IProperty)field_176315_a)];
    }

    @Override
    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196508_b[(Integer)state.func_177229_b((IProperty)field_176315_a) - 1];
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        if (block != Blocks.field_150432_aD && block != Blocks.field_150403_cj && block != Blocks.field_180401_cv) {
            BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockReader)worldIn, pos.func_177977_b(), EnumFacing.UP);
            return blockfaceshape == BlockFaceShape.SOLID || iblockstate.func_203425_a(BlockTags.field_206952_E) || block == this && (Integer)iblockstate.func_177229_b((IProperty)field_176315_a) == 8;
        }
        return false;
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c(worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        Integer integer = (Integer)state.func_177229_b((IProperty)field_176315_a);
        NonNullList items = NonNullList.func_191196_a();
        int fortune = EnchantmentHelper.func_77506_a(Enchantments.field_185308_t, stack);
        float chance = 1.0f;
        if (this.canSilkHarvest(state, worldIn, pos, player) && EnchantmentHelper.func_77506_a(Enchantments.field_185306_r, stack) > 0) {
            if (integer == 8) {
                items.add((Object)new ItemStack(Blocks.field_196604_cC));
            } else {
                for (int i = 0; i < integer; ++i) {
                    items.add((Object)this.func_180643_i(state));
                }
            }
            chance = ForgeEventFactory.fireBlockHarvesting((NonNullList)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        } else {
            this.getDrops(state, items, worldIn, pos, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((NonNullList)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        }
        for (ItemStack item : items) {
            if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
            BlockSnowLayer.func_180635_a(worldIn, pos, item);
        }
        worldIn.func_175698_g(pos);
        player.func_71029_a(StatList.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_151126_ay;
    }

    @Override
    public int func_196264_a(IBlockState state, Random random) {
        return (Integer)state.func_177229_b((IProperty)field_176315_a) + 1;
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (worldIn.func_175642_b(EnumLightType.BLOCK, pos) > 11) {
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public boolean func_196253_a(IBlockState state, BlockItemUseContext useContext) {
        int i = (Integer)state.func_177229_b((IProperty)field_176315_a);
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && i < 8) {
            if (useContext.func_196012_c()) {
                return useContext.func_196000_l() == EnumFacing.UP;
            }
            return true;
        }
        return i == 1;
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        IBlockState iblockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (iblockstate.func_177230_c() == this) {
            int i = (Integer)iblockstate.func_177229_b((IProperty)field_176315_a);
            return (IBlockState)iblockstate.func_206870_a((IProperty)field_176315_a, Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.func_196258_a(context);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176315_a});
    }

    @Override
    protected boolean func_149700_E() {
        return true;
    }
}

