/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockReed
extends Block
implements IPlantable {
    public static final IntegerProperty field_176355_a = BlockStateProperties.field_208171_X;
    protected static final VoxelShape field_196503_b = Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    protected BlockReed(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176355_a, Integer.valueOf(0)));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196503_b;
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (state.func_196955_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)field_176355_a);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                        worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176355_a, Integer.valueOf(0)), 4);
                    } else {
                        worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176355_a, Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state);
                }
            }
        }
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c(worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (soil.canSustainPlant((IBlockReader)worldIn, pos.func_177977_b(), EnumFacing.UP, this)) {
            return true;
        }
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (block == this) {
            return true;
        }
        if (block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150354_m || block == Blocks.field_196611_F) {
            BlockPos blockpos = pos.func_177977_b();
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177972_a(enumfacing));
                IFluidState ifluidstate = worldIn.func_204610_c(blockpos.func_177972_a(enumfacing));
                if (!ifluidstate.func_206884_a(FluidTags.field_206959_a) && iblockstate.func_177230_c() != Blocks.field_185778_de) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176355_a});
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumPlantType getPlantType(IBlockReader world, BlockPos pos) {
        return EnumPlantType.Beach;
    }

    public IBlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

