/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockRedstoneWire
extends Block {
    public static final EnumProperty<RedstoneSide> field_176348_a = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> field_176347_b = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> field_176349_M = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> field_176350_N = BlockStateProperties.field_208162_O;
    public static final IntegerProperty field_176351_O = BlockStateProperties.field_208136_ak;
    public static final Map<EnumFacing, EnumProperty<RedstoneSide>> field_196498_A = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)EnumFacing.NORTH), field_176348_a, (Object)((Object)EnumFacing.EAST), field_176347_b, (Object)((Object)EnumFacing.SOUTH), field_176349_M, (Object)((Object)EnumFacing.WEST), field_176350_N));
    protected static final VoxelShape[] field_196499_B = new VoxelShape[]{Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0)};
    private boolean field_150181_a = true;
    private final Set<BlockPos> field_150179_b = Sets.newHashSet();

    public BlockRedstoneWire(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176348_a, (Comparable)RedstoneSide.NONE)).func_206870_a((IProperty)field_176347_b, (Comparable)RedstoneSide.NONE)).func_206870_a((IProperty)field_176349_M, (Comparable)RedstoneSide.NONE)).func_206870_a((IProperty)field_176350_N, (Comparable)RedstoneSide.NONE)).func_206870_a((IProperty)field_176351_O, Integer.valueOf(0)));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196499_B[BlockRedstoneWire.func_185699_x(state)];
    }

    private static int func_185699_x(IBlockState state) {
        boolean flag3;
        int i = 0;
        boolean flag = state.func_177229_b((IProperty)field_176348_a) != RedstoneSide.NONE;
        boolean flag1 = state.func_177229_b((IProperty)field_176347_b) != RedstoneSide.NONE;
        boolean flag2 = state.func_177229_b((IProperty)field_176349_M) != RedstoneSide.NONE;
        boolean bl = flag3 = state.func_177229_b((IProperty)field_176350_N) != RedstoneSide.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_176350_N, (Comparable)this.func_208074_a((IBlockReader)iblockreader, blockpos, EnumFacing.WEST))).func_206870_a((IProperty)field_176347_b, (Comparable)this.func_208074_a((IBlockReader)iblockreader, blockpos, EnumFacing.EAST))).func_206870_a((IProperty)field_176348_a, (Comparable)this.func_208074_a((IBlockReader)iblockreader, blockpos, EnumFacing.NORTH))).func_206870_a((IProperty)field_176349_M, (Comparable)this.func_208074_a((IBlockReader)iblockreader, blockpos, EnumFacing.SOUTH));
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == EnumFacing.DOWN) {
            return stateIn;
        }
        return facing == EnumFacing.UP ? (IBlockState)((IBlockState)((IBlockState)((IBlockState)stateIn.func_206870_a((IProperty)field_176350_N, (Comparable)this.func_208074_a((IBlockReader)worldIn, currentPos, EnumFacing.WEST))).func_206870_a((IProperty)field_176347_b, (Comparable)this.func_208074_a((IBlockReader)worldIn, currentPos, EnumFacing.EAST))).func_206870_a((IProperty)field_176348_a, (Comparable)this.func_208074_a((IBlockReader)worldIn, currentPos, EnumFacing.NORTH))).func_206870_a((IProperty)field_176349_M, (Comparable)this.func_208074_a((IBlockReader)worldIn, currentPos, EnumFacing.SOUTH)) : (IBlockState)stateIn.func_206870_a((IProperty)field_196498_A.get((Object)facing), (Comparable)this.func_208074_a((IBlockReader)worldIn, currentPos, facing));
    }

    @Override
    public void func_196248_b(IBlockState state, IWorld worldIn, BlockPos pos, int flags) {
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((IProperty)field_196498_A.get((Object)enumfacing));
                if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing)).func_177230_c() == this) continue;
                blockpos$pooledmutableblockpos.func_189536_c(EnumFacing.DOWN);
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                if (iblockstate.func_177230_c() != Blocks.field_190976_dk) {
                    BlockPos blockpos = blockpos$pooledmutableblockpos.func_177972_a(enumfacing.func_176734_d());
                    IBlockState iblockstate1 = iblockstate.func_196956_a(enumfacing.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)blockpos$pooledmutableblockpos, blockpos);
                    BlockRedstoneWire.func_196263_a(iblockstate, iblockstate1, worldIn, (BlockPos)blockpos$pooledmutableblockpos, flags);
                }
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing).func_189536_c(EnumFacing.UP);
                IBlockState iblockstate3 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                if (iblockstate3.func_177230_c() == Blocks.field_190976_dk) continue;
                BlockPos blockpos1 = blockpos$pooledmutableblockpos.func_177972_a(enumfacing.func_176734_d());
                IBlockState iblockstate2 = iblockstate3.func_196956_a(enumfacing.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)blockpos$pooledmutableblockpos, blockpos1);
                BlockRedstoneWire.func_196263_a(iblockstate3, iblockstate2, worldIn, (BlockPos)blockpos$pooledmutableblockpos, flags);
            }
        }
    }

    private RedstoneSide func_208074_a(IBlockReader worldIn, BlockPos pos, EnumFacing face) {
        BlockPos blockpos = pos.func_177972_a(face);
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177984_a());
        if (!iblockstate1.func_185915_l()) {
            boolean flag;
            boolean bl = flag = iblockstate.func_193401_d(worldIn, blockpos, EnumFacing.UP) == BlockFaceShape.SOLID || iblockstate.func_177230_c() == Blocks.field_150426_aN;
            if (flag && this.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
                if (iblockstate.func_185898_k()) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !this.canConnectTo(worldIn.func_180495_p(blockpos), worldIn, blockpos, face) && (iblockstate.func_185915_l() || !this.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        return iblockstate.func_185896_q() || iblockstate.func_177230_c() == Blocks.field_150426_aN || iblockstate.func_193401_d((IBlockReader)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    private IBlockState func_176338_e(World worldIn, BlockPos pos, IBlockState state) {
        state = this.func_212568_b(worldIn, pos, state);
        ArrayList list = Lists.newArrayList(this.field_150179_b);
        this.field_150179_b.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_195593_d(blockpos, this);
        }
        return state;
    }

    private IBlockState func_212568_b(World p_212568_1_, BlockPos p_212568_2_, IBlockState p_212568_3_) {
        IBlockState iblockstate = p_212568_3_;
        int i = (Integer)p_212568_3_.func_177229_b((IProperty)field_176351_O);
        int j = 0;
        j = this.func_212567_a(j, p_212568_3_);
        this.field_150181_a = false;
        int k = p_212568_1_.func_175687_A(p_212568_2_);
        this.field_150181_a = true;
        if (k > 0 && k > j - 1) {
            j = k;
        }
        int l = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = p_212568_2_.func_177972_a(enumfacing);
            boolean flag = blockpos.func_177958_n() != p_212568_2_.func_177958_n() || blockpos.func_177952_p() != p_212568_2_.func_177952_p();
            IBlockState iblockstate1 = p_212568_1_.func_180495_p(blockpos);
            if (flag) {
                l = this.func_212567_a(l, iblockstate1);
            }
            if (iblockstate1.func_185915_l() && !p_212568_1_.func_180495_p(p_212568_2_.func_177984_a()).func_185915_l()) {
                if (!flag || p_212568_2_.func_177956_o() < p_212568_2_.func_177956_o()) continue;
                l = this.func_212567_a(l, p_212568_1_.func_180495_p(blockpos.func_177984_a()));
                continue;
            }
            if (iblockstate1.func_185915_l() || !flag || p_212568_2_.func_177956_o() > p_212568_2_.func_177956_o()) continue;
            l = this.func_212567_a(l, p_212568_1_.func_180495_p(blockpos.func_177977_b()));
        }
        j = l > j ? l - 1 : (j > 0 ? --j : 0);
        if (k > j - 1) {
            j = k;
        }
        if (i != j) {
            p_212568_3_ = (IBlockState)p_212568_3_.func_206870_a((IProperty)field_176351_O, Integer.valueOf(j));
            if (p_212568_1_.func_180495_p(p_212568_2_) == iblockstate) {
                p_212568_1_.func_180501_a(p_212568_2_, p_212568_3_, 2);
            }
            this.field_150179_b.add(p_212568_2_);
            for (EnumFacing enumfacing1 : EnumFacing.values()) {
                this.field_150179_b.add(p_212568_2_.func_177972_a(enumfacing1));
            }
        }
        return p_212568_3_;
    }

    private void func_176344_d(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_195593_d(pos, this);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_195593_d(pos.func_177972_a(enumfacing), this);
            }
        }
    }

    @Override
    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            this.func_176338_e(worldIn, pos, state);
            for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(enumfacing), this);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.func_176344_d(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.func_176344_d(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.func_176344_d(worldIn, blockpos.func_177977_b());
            }
        }
    }

    @Override
    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(enumfacing), this);
                }
                this.func_176338_e(worldIn, pos, state);
                for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                    this.func_176344_d(worldIn, pos.func_177972_a(enumfacing1));
                }
                for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                    BlockPos blockpos = pos.func_177972_a(enumfacing2);
                    if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                        this.func_176344_d(worldIn, blockpos.func_177984_a());
                        continue;
                    }
                    this.func_176344_d(worldIn, blockpos.func_177977_b());
                }
            }
        }
    }

    private int func_212567_a(int p_212567_1_, IBlockState p_212567_2_) {
        if (p_212567_2_.func_177230_c() != this) {
            return p_212567_1_;
        }
        int i = (Integer)p_212567_2_.func_177229_b((IProperty)field_176351_O);
        return i > p_212567_1_ ? i : p_212567_1_;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (state.func_196955_c(worldIn, pos)) {
                this.func_176338_e(worldIn, pos, state);
            } else {
                state.func_196949_c(worldIn, pos, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return !this.field_150181_a ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.field_150181_a) {
            return 0;
        }
        int i = (Integer)blockState.func_177229_b((IProperty)field_176351_O);
        if (i == 0) {
            return 0;
        }
        if (side == EnumFacing.UP) {
            return i;
        }
        EnumSet<EnumFacing> enumset = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.func_176339_d(blockAccess, pos, enumfacing)) continue;
            enumset.add(enumfacing);
        }
        if (side.func_176740_k().func_176722_c() && enumset.isEmpty()) {
            return i;
        }
        if (enumset.contains((Object)side) && !enumset.contains((Object)side.func_176735_f()) && !enumset.contains((Object)side.func_176746_e())) {
            return i;
        }
        return 0;
    }

    private boolean func_176339_d(IBlockReader worldIn, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_185915_l();
        boolean flag1 = worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        if (!flag1 && flag && this.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
            return true;
        }
        if (this.canConnectTo(iblockstate, worldIn, blockpos, side)) {
            return true;
        }
        if (iblockstate.func_177230_c() == Blocks.field_196633_cV && ((Boolean)iblockstate.func_177229_b((IProperty)BlockRedstoneDiode.field_196348_c)).booleanValue() && iblockstate.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) == side) {
            return true;
        }
        return !flag && this.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null);
    }

    protected boolean canConnectTo(IBlockState blockState, IBlockReader world, BlockPos pos, @Nullable EnumFacing side) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (blockState.func_177230_c() == Blocks.field_196633_cV) {
            EnumFacing enumfacing = (EnumFacing)((Object)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D));
            return enumfacing == side || enumfacing.func_176734_d() == side;
        }
        if (Blocks.field_190976_dk == blockState.func_177230_c()) {
            return side == blockState.func_177229_b((IProperty)BlockObserver.field_176387_N);
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return this.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_176337_b(int p_176337_0_) {
        float f = (float)p_176337_0_ / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (p_176337_0_ == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((IProperty)field_176351_O);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)pos.func_177956_o() + 0.0625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176349_M))).func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176350_N))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176348_a))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176347_b));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176347_b))).func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176349_M))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176350_N))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176348_a));
            }
            case CLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176350_N))).func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176348_a))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176347_b))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176349_M));
            }
        }
        return state;
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176349_M))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176348_a));
            }
            case FRONT_BACK: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176350_N))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176347_b));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176348_a, field_176347_b, field_176349_M, field_176350_N, field_176351_O});
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

