/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootingEnchantBonus
extends LootFunction {
    private final RandomValueRange field_186563_a;
    private final int field_189971_b;

    public LootingEnchantBonus(LootCondition[] lootConditionArray, RandomValueRange randomValueRange, int n) {
        super(lootConditionArray);
        this.field_186563_a = randomValueRange;
        this.field_189971_b = n;
    }

    @Override
    public ItemStack func_186553_a(ItemStack itemStack, Random random, LootContext lootContext) {
        Entity entity = lootContext.func_186492_c();
        if (entity instanceof EntityLivingBase) {
            int n = EnchantmentHelper.func_185283_h((EntityLivingBase)entity);
            if (n == 0) {
                return itemStack;
            }
            float \u26032 = (float)n * this.field_186563_a.func_186507_b(random);
            itemStack.func_190917_f(Math.round(\u26032));
            if (this.field_189971_b != 0 && itemStack.func_190916_E() > this.field_189971_b) {
                itemStack.func_190920_e(this.field_189971_b);
            }
        }
        return itemStack;
    }

    public static class Serializer
    extends LootFunction.Serializer<LootingEnchantBonus> {
        protected Serializer() {
            super(new ResourceLocation("looting_enchant"), LootingEnchantBonus.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject, LootingEnchantBonus lootingEnchantBonus, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("count", jsonSerializationContext.serialize((Object)lootingEnchantBonus.field_186563_a));
            if (lootingEnchantBonus.field_189971_b > 0) {
                jsonObject.add("limit", jsonSerializationContext.serialize((Object)lootingEnchantBonus.field_189971_b));
            }
        }

        @Override
        public LootingEnchantBonus func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray) {
            int n = JsonUtils.func_151208_a(jsonObject, "limit", 0);
            return new LootingEnchantBonus(lootConditionArray, JsonUtils.func_188174_a(jsonObject, "count", jsonDeserializationContext, RandomValueRange.class), n);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, lootConditionArray);
        }
    }
}

