/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormatOld
implements ISaveFormat {
    private static final Logger field_151479_b = LogManager.getLogger();
    protected final Path field_75808_a;
    protected final Path field_197717_b;
    protected final DataFixer field_186354_b;

    public SaveFormatOld(Path path, Path path2, DataFixer dataFixer) {
        this.field_186354_b = dataFixer;
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_75808_a = path;
        this.field_197717_b = path2;
    }

    @Override
    @Nullable
    public WorldInfo func_75803_c(String string) {
        File file = new File(this.field_75808_a.toFile(), string);
        if (!file.exists()) {
            return null;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists() && (\u2603 = SaveFormatOld.func_186353_a(\u2603, this.field_186354_b)) != null) {
            return \u2603;
        }
        \u2603 = new File(file, "level.dat_old");
        if (\u2603.exists()) {
            return SaveFormatOld.func_186353_a(\u2603, this.field_186354_b);
        }
        return null;
    }

    @Nullable
    public static WorldInfo func_186353_a(File file, DataFixer dataFixer) {
        try {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            \u2603 = nBTTagCompound.func_74775_l("Data");
            \u2603 = \u2603.func_150297_b("Player", 10) ? \u2603.func_74775_l("Player") : null;
            \u2603.func_82580_o("Player");
            int \u26032 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
            return new WorldInfo(NBTUtil.func_210822_a(dataFixer, (DSL.TypeReference)DataFixTypes.LEVEL, \u2603, \u26032), dataFixer, \u26032, \u2603);
        }
        catch (Exception exception) {
            field_151479_b.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    @Override
    public ISaveHandler func_197715_a(String string, @Nullable MinecraftServer minecraftServer) {
        return new SaveHandler(this.field_75808_a.toFile(), string, minecraftServer, this.field_186354_b);
    }

    @Override
    public boolean func_75801_b(String string) {
        return false;
    }

    @Override
    public boolean func_75805_a(String string, IProgressUpdate iProgressUpdate) {
        return false;
    }

    @Override
    public File func_186352_b(String string, String string2) {
        return this.field_75808_a.resolve(string).resolve(string2).toFile();
    }
}

