/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class MineshaftStructure
extends Structure<MineshaftConfig> {
    @Override
    protected boolean func_202372_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2) {
        ((SharedSeedRandom)random).func_202425_c(iChunkGenerator.func_202089_c(), n, n2);
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        if (iChunkGenerator.func_202094_a(biome, Feature.field_202329_g)) {
            MineshaftConfig mineshaftConfig = (MineshaftConfig)iChunkGenerator.func_202087_b(biome, Feature.field_202329_g);
            double \u26032 = mineshaftConfig.field_202439_a;
            return random.nextDouble() < \u26032;
        }
        return false;
    }

    @Override
    protected boolean func_202365_a(IWorld iWorld) {
        return iWorld.func_72912_H().func_76089_r();
    }

    @Override
    protected StructureStart func_202369_a(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        return new Start(iWorld, iChunkGenerator, sharedSeedRandom, n, n2, biome);
    }

    @Override
    protected String func_143025_a() {
        return "Mineshaft";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        private Type field_202507_c;

        public Start() {
        }

        public Start(IWorld iWorld2, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome) {
            super(n, n2, biome, sharedSeedRandom, iWorld2.func_72905_C());
            MineshaftConfig mineshaftConfig = (MineshaftConfig)iChunkGenerator.func_202087_b(biome, Feature.field_202329_g);
            this.field_202507_c = mineshaftConfig.field_202440_b;
            MineshaftPieces.Room \u26032 = new MineshaftPieces.Room(0, sharedSeedRandom, (n << 4) + 2, (n2 << 4) + 2, this.field_202507_c);
            this.field_75075_a.add(\u26032);
            \u26032.func_74861_a(\u26032, this.field_75075_a, sharedSeedRandom);
            this.func_202500_a(iWorld2);
            if (mineshaftConfig.field_202440_b == Type.MESA) {
                int n3 = -5;
                \u2603 = iWorld2.func_181545_F() - this.field_75074_b.field_78894_e + this.field_75074_b.func_78882_c() / 2 - -5;
                this.field_75074_b.func_78886_a(0, \u2603, 0);
                for (StructurePiece structurePiece : this.field_75075_a) {
                    structurePiece.func_181138_a(0, \u2603, 0);
                }
            } else {
                IWorld iWorld2;
                this.func_75067_a(iWorld2, sharedSeedRandom, 10);
            }
        }
    }

    public static enum Type {
        NORMAL,
        MESA;


        public static Type func_189910_a(int n) {
            if (n < 0 || n >= Type.values().length) {
                return NORMAL;
            }
            return Type.values()[n];
        }
    }
}

