/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureIndexesSavedData;
import net.minecraft.world.storage.WorldSavedDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LegacyStructureDataUtil {
    private static final Logger field_208219_a = LogManager.getLogger();
    private static final Map<String, String> field_208220_b = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put("Village", "Village");
        hashMap.put("Mineshaft", "Mineshaft");
        hashMap.put("Mansion", "Mansion");
        hashMap.put("Igloo", "Temple");
        hashMap.put("Desert_Pyramid", "Temple");
        hashMap.put("Jungle_Pyramid", "Temple");
        hashMap.put("Swamp_Hut", "Temple");
        hashMap.put("Stronghold", "Stronghold");
        hashMap.put("Monument", "Monument");
        hashMap.put("Fortress", "Fortress");
        hashMap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> field_208221_c = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put("Iglu", "Igloo");
        hashMap.put("TeDP", "Desert_Pyramid");
        hashMap.put("TeJP", "Jungle_Pyramid");
        hashMap.put("TeSH", "Swamp_Hut");
    });
    private final boolean field_208222_d;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> field_208223_e = Maps.newHashMap();
    private final Map<String, StructureIndexesSavedData> field_208224_f = Maps.newHashMap();

    public LegacyStructureDataUtil(@Nullable WorldSavedDataStorage worldSavedDataStorage) {
        this.func_212184_a(worldSavedDataStorage);
        boolean bl = false;
        for (String string : this.func_208218_b()) {
            bl |= this.field_208223_e.get(string) != null;
        }
        this.field_208222_d = bl;
    }

    public void func_208216_a(long l) {
        for (String string : this.func_208214_a()) {
            StructureIndexesSavedData structureIndexesSavedData = this.field_208224_f.get(string);
            if (structureIndexesSavedData == null || !structureIndexesSavedData.func_208023_c(l)) continue;
            structureIndexesSavedData.func_201762_c(l);
            structureIndexesSavedData.func_76185_a();
        }
    }

    public NBTTagCompound func_212181_a(NBTTagCompound nBTTagCompound4) {
        NBTTagCompound nBTTagCompound2;
        NBTTagCompound nBTTagCompound3;
        nBTTagCompound3 = nBTTagCompound4.func_74775_l("Level");
        ChunkPos chunkPos = new ChunkPos(nBTTagCompound3.func_74762_e("xPos"), nBTTagCompound3.func_74762_e("zPos"));
        if (this.func_208209_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
            NBTTagCompound nBTTagCompound4 = this.func_212182_a(nBTTagCompound4, chunkPos);
        }
        nBTTagCompound2 = nBTTagCompound3.func_74775_l("Structures");
        nBTTagCompound5 = nBTTagCompound2.func_74775_l("References");
        for (String string : this.func_208218_b()) {
            NBTTagCompound nBTTagCompound5;
            Structure<?> structure = Feature.field_202300_at.get(string.toLowerCase(Locale.ROOT));
            if (nBTTagCompound5.func_150297_b(string, 12) || structure == null) continue;
            int \u26032 = structure.func_202367_b();
            LongArrayList \u26033 = new LongArrayList();
            for (int i = chunkPos.field_77276_a - \u26032; i <= chunkPos.field_77276_a + \u26032; ++i) {
                for (\u2603 = chunkPos.field_77275_b - \u26032; \u2603 <= chunkPos.field_77275_b + \u26032; ++\u2603) {
                    if (!this.func_208211_a(i, \u2603, string)) continue;
                    \u26033.add(ChunkPos.func_77272_a(i, \u2603));
                }
            }
            nBTTagCompound5.func_202168_c(string, (List<Long>)\u26033);
        }
        nBTTagCompound2.func_74782_a("References", nBTTagCompound5);
        nBTTagCompound3.func_74782_a("Structures", nBTTagCompound2);
        nBTTagCompound4.func_74782_a("Level", nBTTagCompound3);
        return nBTTagCompound4;
    }

    protected abstract String[] func_208214_a();

    protected abstract String[] func_208218_b();

    private boolean func_208211_a(int n, int n2, String string) {
        if (!this.field_208222_d) {
            return false;
        }
        return this.field_208223_e.get(string) != null && this.field_208224_f.get(field_208220_b.get(string)).func_208024_b(ChunkPos.func_77272_a(n, n2));
    }

    private boolean func_208209_a(int n, int n2) {
        if (!this.field_208222_d) {
            return false;
        }
        for (String string : this.func_208218_b()) {
            if (this.field_208223_e.get(string) == null || !this.field_208224_f.get(field_208220_b.get(string)).func_208023_c(ChunkPos.func_77272_a(n, n2))) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound func_212182_a(NBTTagCompound nBTTagCompound, ChunkPos chunkPos) {
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("Level");
        \u2603 = nBTTagCompound2.func_74775_l("Structures");
        \u2603 = \u2603.func_74775_l("Starts");
        for (String string : this.func_208218_b()) {
            Long2ObjectMap<NBTTagCompound> long2ObjectMap = this.field_208223_e.get(string);
            if (long2ObjectMap == null) continue;
            long \u26032 = chunkPos.func_201841_a();
            if (!this.field_208224_f.get(field_208220_b.get(string)).func_208023_c(\u26032) || (\u2603 = (NBTTagCompound)long2ObjectMap.get(\u26032)) == null) continue;
            \u2603.func_74782_a(string, \u2603);
        }
        \u2603.func_74782_a("Starts", \u2603);
        nBTTagCompound2.func_74782_a("Structures", \u2603);
        nBTTagCompound.func_74782_a("Level", nBTTagCompound2);
        return nBTTagCompound;
    }

    private void func_212184_a(@Nullable WorldSavedDataStorage worldSavedDataStorage2) {
        if (worldSavedDataStorage2 == null) {
            return;
        }
        for (String string22 : this.func_208214_a()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            try {
                nBTTagCompound = worldSavedDataStorage2.func_208028_a(string22, 1493).func_74775_l("data").func_74775_l("Features");
                if (nBTTagCompound.isEmpty()) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String string2 : nBTTagCompound.func_150296_c()) {
                String string3;
                NBTTagCompound object = nBTTagCompound.func_74775_l(string2);
                long l = ChunkPos.func_77272_a(object.func_74762_e("ChunkX"), object.func_74762_e("ChunkZ"));
                NBTTagList \u26032 = object.func_150295_c("Children", 10);
                if (!\u26032.isEmpty() && (string3 = field_208221_c.get(\u2603 = \u26032.func_150305_b(0).func_74779_i("id"))) != null) {
                    object.func_74778_a("id", string3);
                }
                String \u26033 = object.func_74779_i("id");
                this.field_208223_e.computeIfAbsent(\u26033, string -> new Long2ObjectOpenHashMap()).put(l, (Object)object);
            }
            String string3 = string22 + "_index";
            StructureIndexesSavedData structureIndexesSavedData = worldSavedDataStorage2.func_212426_a(DimensionType.OVERWORLD, StructureIndexesSavedData::new, string3);
            if (structureIndexesSavedData == null || structureIndexesSavedData.func_208025_a().isEmpty()) {
                StructureIndexesSavedData structureIndexesSavedData2 = new StructureIndexesSavedData(string3);
                this.field_208224_f.put(string22, structureIndexesSavedData2);
                for (String string4 : nBTTagCompound.func_150296_c()) {
                    NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l(string4);
                    structureIndexesSavedData2.func_201763_a(ChunkPos.func_77272_a(nBTTagCompound2.func_74762_e("ChunkX"), nBTTagCompound2.func_74762_e("ChunkZ")));
                }
                worldSavedDataStorage2.func_212424_a(DimensionType.OVERWORLD, string3, structureIndexesSavedData2);
                structureIndexesSavedData2.func_76185_a();
                continue;
            }
            this.field_208224_f.put(string22, structureIndexesSavedData);
        }
    }

    public static LegacyStructureDataUtil func_212183_a(DimensionType dimensionType, @Nullable WorldSavedDataStorage worldSavedDataStorage) {
        if (dimensionType == DimensionType.OVERWORLD) {
            return new Overworld(worldSavedDataStorage);
        }
        if (dimensionType == DimensionType.NETHER) {
            return new Nether(worldSavedDataStorage);
        }
        if (dimensionType == DimensionType.THE_END) {
            return new End(worldSavedDataStorage);
        }
        throw new RuntimeException(String.format("Unknown dimension type : %s", dimensionType));
    }

    public static class End
    extends LegacyStructureDataUtil {
        private static final String[] field_208227_a = new String[]{"EndCity"};

        public End(@Nullable WorldSavedDataStorage worldSavedDataStorage) {
            super(worldSavedDataStorage);
        }

        @Override
        protected String[] func_208214_a() {
            return field_208227_a;
        }

        @Override
        protected String[] func_208218_b() {
            return field_208227_a;
        }
    }

    public static class Nether
    extends LegacyStructureDataUtil {
        private static final String[] field_208228_a = new String[]{"Fortress"};

        public Nether(@Nullable WorldSavedDataStorage worldSavedDataStorage) {
            super(worldSavedDataStorage);
        }

        @Override
        protected String[] func_208214_a() {
            return field_208228_a;
        }

        @Override
        protected String[] func_208218_b() {
            return field_208228_a;
        }
    }

    public static class Overworld
    extends LegacyStructureDataUtil {
        private static final String[] field_208225_a = new String[]{"Monument", "Stronghold", "Village", "Mineshaft", "Temple", "Mansion"};
        private static final String[] field_208226_b = new String[]{"Village", "Mineshaft", "Mansion", "Igloo", "Desert_Pyramid", "Jungle_Pyramid", "Swamp_Hut", "Stronghold", "Monument"};

        public Overworld(@Nullable WorldSavedDataStorage worldSavedDataStorage) {
            super(worldSavedDataStorage);
        }

        @Override
        protected String[] func_208214_a() {
            return field_208225_a;
        }

        @Override
        protected String[] func_208218_b() {
            return field_208226_b;
        }
    }
}

