/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.AbstractChunkGenerator;
import net.minecraft.world.gen.DebugGenSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.WorldGenRegion;

public class ChunkGeneratorDebug
extends AbstractChunkGenerator<DebugGenSettings> {
    private static final List<IBlockState> field_177464_a = StreamSupport.stream(IRegistry.field_212618_g.spliterator(), false).flatMap(block -> block.func_176194_O().func_177619_a().stream()).collect(Collectors.toList());
    private static final int field_177462_b = MathHelper.func_76123_f(MathHelper.func_76129_c(field_177464_a.size()));
    private static final int field_181039_c = MathHelper.func_76123_f((float)field_177464_a.size() / (float)field_177462_b);
    protected static final IBlockState field_185934_a = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState field_185935_b = Blocks.field_180401_cv.func_176223_P();
    private final DebugGenSettings field_202098_i;

    public ChunkGeneratorDebug(IWorld iWorld, BiomeProvider biomeProvider, DebugGenSettings debugGenSettings) {
        super(iWorld, biomeProvider);
        this.field_202098_i = debugGenSettings;
    }

    @Override
    public void func_202088_a(IChunk iChunk) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        Biome[] \u26034 = this.field_202097_c.func_201539_b(\u26032 * 16, \u26033 * 16, 16, 16);
        iChunk.func_201577_a(\u26034);
        iChunk.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        iChunk.func_201574_a(ChunkStatus.BASE);
    }

    @Override
    public void func_202091_a(WorldGenRegion worldGenRegion, GenerationStage.Carving carving) {
    }

    @Override
    public DebugGenSettings func_201496_a_() {
        return this.field_202098_i;
    }

    @Override
    public double[] func_205473_a(int n, int n2) {
        return new double[0];
    }

    @Override
    public int func_205470_d() {
        return this.field_202095_a.func_181545_F() + 1;
    }

    @Override
    public void func_202092_b(WorldGenRegion worldGenRegion) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int \u26032 = worldGenRegion.func_201679_a();
        int \u26033 = worldGenRegion.func_201680_b();
        for (int i = 0; i < 16; ++i) {
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                \u2603 = (\u26032 << 4) + i;
                \u2603 = (\u26033 << 4) + \u2603;
                worldGenRegion.func_180501_a(mutableBlockPos.func_181079_c(\u2603, 60, \u2603), field_185935_b, 2);
                IBlockState iBlockState = ChunkGeneratorDebug.func_177461_b(\u2603, \u2603);
                if (iBlockState == null) continue;
                worldGenRegion.func_180501_a(mutableBlockPos.func_181079_c(\u2603, 70, \u2603), iBlockState, 2);
            }
        }
    }

    @Override
    public void func_202093_c(WorldGenRegion worldGenRegion) {
    }

    public static IBlockState func_177461_b(int n, int n2) {
        IBlockState iBlockState = field_185934_a;
        if (n > 0 && n2 > 0 && n % 2 != 0 && n2 % 2 != 0 && (n /= 2) <= field_177462_b && (n2 /= 2) <= field_181039_c && (\u2603 = MathHelper.func_76130_a(n * field_177462_b + n2)) < field_177464_a.size()) {
            iBlockState = field_177464_a.get(\u2603);
        }
        return iBlockState;
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        Biome biome = this.field_202095_a.func_180494_b(blockPos);
        return biome.func_76747_a(enumCreatureType);
    }

    @Override
    public int func_203222_a(World world, boolean bl, boolean bl2) {
        return 0;
    }

    @Override
    public /* synthetic */ IChunkGenSettings func_201496_a_() {
        return this.func_201496_a_();
    }
}

