/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkPrimer
implements IChunk {
    private static final Logger field_201653_a = LogManager.getLogger();
    private final ChunkPos field_201654_b;
    private boolean field_201655_c;
    private final AtomicInteger field_205768_d = new AtomicInteger();
    private Biome[] field_201656_d;
    private final Map<Heightmap.Type, Heightmap> field_201657_e = Maps.newEnumMap(Heightmap.Type.class);
    private volatile ChunkStatus field_201658_f = ChunkStatus.EMPTY;
    private final Map<BlockPos, TileEntity> field_201659_g = Maps.newHashMap();
    private final Map<BlockPos, NBTTagCompound> field_201660_h = Maps.newHashMap();
    private final ChunkSection[] field_201661_i = new ChunkSection[16];
    private final List<NBTTagCompound> field_201662_j = Lists.newArrayList();
    private final List<BlockPos> field_201663_k = Lists.newArrayList();
    private final ShortList[] field_201665_m = new ShortList[16];
    private final Map<String, StructureStart> field_201666_n = Maps.newHashMap();
    private final Map<String, LongSet> field_201667_o = Maps.newHashMap();
    private final UpgradeData field_201668_p;
    private final ChunkPrimerTickList<Block> field_201664_l;
    private final ChunkPrimerTickList<Fluid> field_205333_q;
    private long field_209217_s;
    private final Map<GenerationStage.Carving, BitSet> field_205769_s = Maps.newHashMap();
    private boolean field_207740_t;

    public ChunkPrimer(int n, int n2, UpgradeData upgradeData) {
        this(new ChunkPos(n, n2), upgradeData);
    }

    public ChunkPrimer(ChunkPos chunkPos, UpgradeData upgradeData) {
        this.field_201654_b = chunkPos;
        this.field_201668_p = upgradeData;
        this.field_201664_l = new ChunkPrimerTickList<Block>(block -> block == null || block.func_176223_P().func_196958_f(), IRegistry.field_212618_g::func_177774_c, IRegistry.field_212618_g::func_82594_a, chunkPos);
        this.field_205333_q = new ChunkPrimerTickList<Fluid>(fluid -> fluid == null || fluid == Fluids.field_204541_a, IRegistry.field_212619_h::func_177774_c, IRegistry.field_212619_h::func_82594_a, chunkPos);
    }

    public static ShortList func_205330_a(ShortList[] shortListArray, int n) {
        if (shortListArray[n] == null) {
            shortListArray[n] = new ShortArrayList();
        }
        return shortListArray[n];
    }

    @Override
    @Nullable
    public IBlockState func_180495_p(BlockPos blockPos) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        if (\u2603 < 0 || \u2603 >= 256) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        if (this.field_201661_i[\u2603 >> 4] == Chunk.field_186036_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.field_201661_i[\u2603 >> 4].func_177485_a(n & 0xF, \u2603 & 0xF, \u2603 & 0xF);
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        if (\u2603 < 0 || \u2603 >= 256 || this.field_201661_i[\u2603 >> 4] == Chunk.field_186036_a) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return this.field_201661_i[\u2603 >> 4].func_206914_b(n & 0xF, \u2603 & 0xF, \u2603 & 0xF);
    }

    @Override
    public List<BlockPos> func_201582_h() {
        return this.field_201663_k;
    }

    public ShortList[] func_201647_i() {
        ShortList[] shortListArray = new ShortList[16];
        for (BlockPos blockPos : this.field_201663_k) {
            ChunkPrimer.func_205330_a(shortListArray, blockPos.func_177956_o() >> 4).add(ChunkPrimer.func_201651_i(blockPos));
        }
        return shortListArray;
    }

    public void func_201646_a(short s, int n) {
        this.func_201637_h(ChunkPrimer.func_201635_a(s, n, this.field_201654_b));
    }

    public void func_201637_h(BlockPos blockPos) {
        this.field_201663_k.add(blockPos);
    }

    @Override
    @Nullable
    public IBlockState func_177436_a(BlockPos blockPos, IBlockState iBlockState, boolean bl) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        if (\u2603 < 0 || \u2603 >= 256) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        if (iBlockState.func_185906_d() > 0) {
            this.field_201663_k.add(new BlockPos((n & 0xF) + this.func_76632_l().func_180334_c(), \u2603, (\u2603 & 0xF) + this.func_76632_l().func_180333_d()));
        }
        if (this.field_201661_i[\u2603 >> 4] == Chunk.field_186036_a) {
            if (iBlockState.func_177230_c() == Blocks.field_150350_a) {
                return iBlockState;
            }
            this.field_201661_i[\u2603 >> 4] = new ChunkSection(\u2603 >> 4 << 4, this.func_201649_r());
        }
        IBlockState \u26032 = this.field_201661_i[\u2603 >> 4].func_177485_a(n & 0xF, \u2603 & 0xF, \u2603 & 0xF);
        this.field_201661_i[\u2603 >> 4].func_177484_a(n & 0xF, \u2603 & 0xF, \u2603 & 0xF, iBlockState);
        if (this.field_207740_t) {
            this.func_207902_c(Heightmap.Type.MOTION_BLOCKING).func_202270_a(n & 0xF, \u2603, \u2603 & 0xF, iBlockState);
            this.func_207902_c(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_202270_a(n & 0xF, \u2603, \u2603 & 0xF, iBlockState);
            this.func_207902_c(Heightmap.Type.OCEAN_FLOOR).func_202270_a(n & 0xF, \u2603, \u2603 & 0xF, iBlockState);
            this.func_207902_c(Heightmap.Type.WORLD_SURFACE).func_202270_a(n & 0xF, \u2603, \u2603 & 0xF, iBlockState);
        }
        return \u26032;
    }

    @Override
    public void func_177426_a(BlockPos blockPos, TileEntity tileEntity) {
        tileEntity.func_174878_a(blockPos);
        this.field_201659_g.put(blockPos, tileEntity);
    }

    public Set<BlockPos> func_201638_j() {
        HashSet hashSet = Sets.newHashSet(this.field_201660_h.keySet());
        hashSet.addAll(this.field_201659_g.keySet());
        return hashSet;
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        return this.field_201659_g.get(blockPos);
    }

    public Map<BlockPos, TileEntity> func_201627_k() {
        return this.field_201659_g;
    }

    public void func_201626_b(NBTTagCompound nBTTagCompound) {
        this.field_201662_j.add(nBTTagCompound);
    }

    @Override
    public void func_76612_a(Entity entity) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        entity.func_70039_c(nBTTagCompound);
        this.func_201626_b(nBTTagCompound);
    }

    public List<NBTTagCompound> func_201652_l() {
        return this.field_201662_j;
    }

    @Override
    public void func_201577_a(Biome[] biomeArray) {
        this.field_201656_d = biomeArray;
    }

    @Override
    public Biome[] func_201590_e() {
        return this.field_201656_d;
    }

    public void func_177427_f(boolean bl) {
        this.field_201655_c = bl;
    }

    public boolean func_201593_f() {
        return this.field_201655_c;
    }

    @Override
    public ChunkStatus func_201589_g() {
        return this.field_201658_f;
    }

    @Override
    public void func_201574_a(ChunkStatus chunkStatus) {
        this.field_201658_f = chunkStatus;
        this.func_177427_f(true);
    }

    public void func_201650_c(String string) {
        this.func_201574_a(ChunkStatus.func_202127_a(string));
    }

    @Override
    public ChunkSection[] func_76587_i() {
        return this.field_201661_i;
    }

    @Override
    public int func_201587_a(EnumLightType enumLightType, BlockPos blockPos, boolean bl) {
        int n = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        \u2603 = \u2603 >> 4;
        if (\u2603 < 0 || \u2603 > this.field_201661_i.length - 1) {
            return 0;
        }
        ChunkSection \u26032 = this.field_201661_i[\u2603];
        if (\u26032 == Chunk.field_186036_a) {
            if (this.func_177444_d(blockPos)) {
                return enumLightType.field_77198_c;
            }
            return 0;
        }
        if (enumLightType == EnumLightType.SKY) {
            if (!bl) {
                return 0;
            }
            return \u26032.func_76670_c(n, \u2603 & 0xF, \u2603);
        }
        if (enumLightType == EnumLightType.BLOCK) {
            return \u26032.func_76674_d(n, \u2603 & 0xF, \u2603);
        }
        return enumLightType.field_77198_c;
    }

    @Override
    public int func_201586_a(BlockPos blockPos, int n, boolean bl) {
        int n2 = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        \u2603 = \u2603 >> 4;
        if (\u2603 < 0 || \u2603 > this.field_201661_i.length - 1) {
            return 0;
        }
        ChunkSection \u26032 = this.field_201661_i[\u2603];
        if (\u26032 == Chunk.field_186036_a) {
            if (this.func_201649_r() && n < EnumLightType.SKY.field_77198_c) {
                return EnumLightType.SKY.field_77198_c - n;
            }
            return 0;
        }
        \u2603 = bl ? \u26032.func_76670_c(n2, \u2603 & 0xF, \u2603) : 0;
        \u2603 = \u26032.func_76674_d(n2, \u2603 & 0xF, \u2603);
        if (\u2603 > (\u2603 -= n)) {
            \u2603 = \u2603;
        }
        return \u2603;
    }

    @Override
    public boolean func_177444_d(BlockPos blockPos) {
        int n = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        return \u2603 >= this.func_201576_a(Heightmap.Type.MOTION_BLOCKING, n, \u2603 = blockPos.func_177952_p() & 0xF);
    }

    public void func_201630_a(ChunkSection[] chunkSectionArray) {
        if (this.field_201661_i.length != chunkSectionArray.length) {
            field_201653_a.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)chunkSectionArray.length, (Object)this.field_201661_i.length);
            return;
        }
        System.arraycopy(chunkSectionArray, 0, this.field_201661_i, 0, this.field_201661_i.length);
    }

    public Set<Heightmap.Type> func_201634_m() {
        return this.field_201657_e.keySet();
    }

    @Nullable
    public Heightmap func_201642_a(Heightmap.Type type) {
        return this.field_201657_e.get((Object)type);
    }

    public void func_201643_a(Heightmap.Type type, long[] lArray) {
        this.func_207902_c(type).func_202268_a(lArray);
    }

    @Override
    public void func_201588_a(Heightmap.Type ... typeArray) {
        for (Heightmap.Type type : typeArray) {
            this.func_207902_c(type);
        }
    }

    private Heightmap func_207902_c(Heightmap.Type type2) {
        return this.field_201657_e.computeIfAbsent(type2, type -> {
            Heightmap heightmap = new Heightmap(this, (Heightmap.Type)((Object)type));
            heightmap.func_202266_a();
            return heightmap;
        });
    }

    @Override
    public int func_201576_a(Heightmap.Type type, int n, int n2) {
        Heightmap heightmap = this.field_201657_e.get((Object)type);
        if (heightmap == null) {
            this.func_201588_a(type);
            heightmap = this.field_201657_e.get((Object)type);
        }
        return heightmap.func_202273_a(n & 0xF, n2 & 0xF) - 1;
    }

    @Override
    public ChunkPos func_76632_l() {
        return this.field_201654_b;
    }

    @Override
    public void func_177432_b(long l) {
    }

    @Override
    @Nullable
    public StructureStart func_201585_a(String string) {
        return this.field_201666_n.get(string);
    }

    @Override
    public void func_201584_a(String string, StructureStart structureStart) {
        this.field_201666_n.put(string, structureStart);
        this.field_201655_c = true;
    }

    @Override
    public Map<String, StructureStart> func_201609_c() {
        return Collections.unmodifiableMap(this.field_201666_n);
    }

    public void func_201648_a(Map<String, StructureStart> map) {
        this.field_201666_n.clear();
        this.field_201666_n.putAll(map);
        this.field_201655_c = true;
    }

    @Override
    @Nullable
    public LongSet func_201578_b(String string2) {
        return this.field_201667_o.computeIfAbsent(string2, string -> new LongOpenHashSet());
    }

    @Override
    public void func_201583_a(String string2, long l) {
        this.field_201667_o.computeIfAbsent(string2, string -> new LongOpenHashSet()).add(l);
        this.field_201655_c = true;
    }

    @Override
    public Map<String, LongSet> func_201604_d() {
        return Collections.unmodifiableMap(this.field_201667_o);
    }

    public void func_201641_b(Map<String, LongSet> map) {
        this.field_201667_o.clear();
        this.field_201667_o.putAll(map);
        this.field_201655_c = true;
    }

    @Override
    public void func_201580_a(EnumLightType enumLightType, boolean bl, BlockPos blockPos, int n) {
        \u2603 = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        \u2603 = \u2603 >> 4;
        if (\u2603 >= 16 || \u2603 < 0) {
            return;
        }
        if (this.field_201661_i[\u2603] == Chunk.field_186036_a) {
            if (n == enumLightType.field_77198_c) {
                return;
            }
            this.field_201661_i[\u2603] = new ChunkSection(\u2603 << 4, this.func_201649_r());
        }
        if (enumLightType == EnumLightType.SKY) {
            if (bl) {
                this.field_201661_i[\u2603].func_76657_c(\u2603, \u2603 & 0xF, \u2603, n);
            }
        } else if (enumLightType == EnumLightType.BLOCK) {
            this.field_201661_i[\u2603].func_76677_d(\u2603, \u2603 & 0xF, \u2603, n);
        }
    }

    public static short func_201651_i(BlockPos blockPos) {
        int n = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        \u2603 = n & 0xF;
        \u2603 = \u2603 & 0xF;
        \u2603 = \u2603 & 0xF;
        return (short)(\u2603 | \u2603 << 4 | \u2603 << 8);
    }

    public static BlockPos func_201635_a(short s, int n, ChunkPos chunkPos) {
        int n2 = (s & 0xF) + (chunkPos.field_77276_a << 4);
        \u2603 = (s >>> 4 & 0xF) + (n << 4);
        \u2603 = (s >>> 8 & 0xF) + (chunkPos.field_77275_b << 4);
        return new BlockPos(n2, \u2603, \u2603);
    }

    @Override
    public void func_201594_d(BlockPos blockPos) {
        if (!World.func_189509_E(blockPos)) {
            ChunkPrimer.func_205330_a(this.field_201665_m, blockPos.func_177956_o() >> 4).add(ChunkPrimer.func_201651_i(blockPos));
        }
    }

    public ShortList[] func_201645_n() {
        return this.field_201665_m;
    }

    public void func_201636_b(short s, int n) {
        ChunkPrimer.func_205330_a(this.field_201665_m, n).add(s);
    }

    public ChunkPrimerTickList<Block> func_205218_i_() {
        return this.field_201664_l;
    }

    public ChunkPrimerTickList<Fluid> func_212247_j() {
        return this.field_205333_q;
    }

    private boolean func_201649_r() {
        return true;
    }

    public UpgradeData func_201631_p() {
        return this.field_201668_p;
    }

    public void func_209215_b(long l) {
        this.field_209217_s = l;
    }

    public long func_209216_m() {
        return this.field_209217_s;
    }

    @Override
    public void func_201591_a(NBTTagCompound nBTTagCompound) {
        this.field_201660_h.put(new BlockPos(nBTTagCompound.func_74762_e("x"), nBTTagCompound.func_74762_e("y"), nBTTagCompound.func_74762_e("z")), nBTTagCompound);
    }

    public Map<BlockPos, NBTTagCompound> func_201632_q() {
        return Collections.unmodifiableMap(this.field_201660_h);
    }

    @Override
    public NBTTagCompound func_201579_g(BlockPos blockPos) {
        return this.field_201660_h.get(blockPos);
    }

    @Override
    public void func_177425_e(BlockPos blockPos) {
        this.field_201659_g.remove(blockPos);
        this.field_201660_h.remove(blockPos);
    }

    @Override
    public BitSet func_205749_a(GenerationStage.Carving carving2) {
        return this.field_205769_s.computeIfAbsent(carving2, carving -> new BitSet(65536));
    }

    public void func_205767_a(GenerationStage.Carving carving, BitSet bitSet) {
        this.field_205769_s.put(carving, bitSet);
    }

    public void func_205747_a(int n) {
        this.field_205768_d.addAndGet(n);
    }

    public boolean func_205748_B() {
        return this.field_205768_d.get() > 0;
    }

    public void func_207739_b(boolean bl) {
        this.field_207740_t = bl;
    }

    public /* synthetic */ ITickList func_212247_j() {
        return this.func_212247_j();
    }

    public /* synthetic */ ITickList func_205218_i_() {
        return this.func_205218_i_();
    }
}

