/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFlowingFluid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.biome.BadlandsBiome;
import net.minecraft.world.biome.BadlandsPlateauBiome;
import net.minecraft.world.biome.BeachBiome;
import net.minecraft.world.biome.BirchForestBiome;
import net.minecraft.world.biome.BirchForestHillsBiome;
import net.minecraft.world.biome.ColdOceanBiome;
import net.minecraft.world.biome.DarkForestBiome;
import net.minecraft.world.biome.DarkForestHillsBiome;
import net.minecraft.world.biome.DeepColdOceanBiome;
import net.minecraft.world.biome.DeepFrozenOceanBiome;
import net.minecraft.world.biome.DeepLukewarmOceanBiome;
import net.minecraft.world.biome.DeepOceanBiome;
import net.minecraft.world.biome.DeepWarmOceanBiome;
import net.minecraft.world.biome.DesertBiome;
import net.minecraft.world.biome.DesertHillsBiome;
import net.minecraft.world.biome.DesertLakesBiome;
import net.minecraft.world.biome.EndBarrensBiome;
import net.minecraft.world.biome.EndHighlandsBiome;
import net.minecraft.world.biome.EndMidlandsBiome;
import net.minecraft.world.biome.ErodedBadlandsBiome;
import net.minecraft.world.biome.FlowerForestBiome;
import net.minecraft.world.biome.ForestBiome;
import net.minecraft.world.biome.FrozenOceanBiome;
import net.minecraft.world.biome.FrozenRiverBiome;
import net.minecraft.world.biome.GiantSpruceTaigaBiome;
import net.minecraft.world.biome.GiantSpruceTaigaHillsBiome;
import net.minecraft.world.biome.GiantTreeTaigaBiome;
import net.minecraft.world.biome.GiantTreeTaigaHillsBiome;
import net.minecraft.world.biome.GravellyMountainsBiome;
import net.minecraft.world.biome.IceSpikesBiome;
import net.minecraft.world.biome.JungleBiome;
import net.minecraft.world.biome.JungleEdgeBiome;
import net.minecraft.world.biome.JungleHillsBiome;
import net.minecraft.world.biome.LukewarmOceanBiome;
import net.minecraft.world.biome.ModifiedBadlandsPlateauBiome;
import net.minecraft.world.biome.ModifiedGravellyMountainsBiome;
import net.minecraft.world.biome.ModifiedJungleBiome;
import net.minecraft.world.biome.ModifiedJungleEdgeBiome;
import net.minecraft.world.biome.ModifiedWoodedBadlandsPlateauBiome;
import net.minecraft.world.biome.MountainEdgeBiome;
import net.minecraft.world.biome.MountainsBiome;
import net.minecraft.world.biome.MushroomFieldShoreBiome;
import net.minecraft.world.biome.MushroomFieldsBiome;
import net.minecraft.world.biome.NetherBiome;
import net.minecraft.world.biome.OceanBiome;
import net.minecraft.world.biome.PlainsBiome;
import net.minecraft.world.biome.RiverBiome;
import net.minecraft.world.biome.SavannaBiome;
import net.minecraft.world.biome.SavannaPlateauBiome;
import net.minecraft.world.biome.ShatteredSavannaBiome;
import net.minecraft.world.biome.ShatteredSavannaPlateauBiome;
import net.minecraft.world.biome.SmallEndIslandsBiome;
import net.minecraft.world.biome.SnowyBeachBiome;
import net.minecraft.world.biome.SnowyMountainsBiome;
import net.minecraft.world.biome.SnowyTaigaBiome;
import net.minecraft.world.biome.SnowyTaigaHillsBiome;
import net.minecraft.world.biome.SnowyTaigaMountainsBiome;
import net.minecraft.world.biome.SnowyTundraBiome;
import net.minecraft.world.biome.StoneShoreBiome;
import net.minecraft.world.biome.SunflowerPlainsBiome;
import net.minecraft.world.biome.SwampBiome;
import net.minecraft.world.biome.SwampHillsBiome;
import net.minecraft.world.biome.TaigaBiome;
import net.minecraft.world.biome.TaigaHillsBiome;
import net.minecraft.world.biome.TaigaMountainsBiome;
import net.minecraft.world.biome.TallBirchForestBiome;
import net.minecraft.world.biome.TallBirchHillsBiome;
import net.minecraft.world.biome.TheEndBiome;
import net.minecraft.world.biome.TheVoidBiome;
import net.minecraft.world.biome.WarmOceanBiome;
import net.minecraft.world.biome.WoodedBadlandsPlateauBiome;
import net.minecraft.world.biome.WoodedHillsBiome;
import net.minecraft.world.biome.WoodedMountainsBiome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.carver.CanyonWorldCarver;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.IWorldCarver;
import net.minecraft.world.gen.carver.NetherCaveWorldCarver;
import net.minecraft.world.gen.carver.UnderwaterCanyonWorldCarver;
import net.minecraft.world.gen.carver.UnderwaterCaveWorldCarver;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.carver.WorldCarverWrapper;
import net.minecraft.world.gen.feature.AbstractFlowersFeature;
import net.minecraft.world.gen.feature.CompositeFeature;
import net.minecraft.world.gen.feature.CompositeFlowerFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.structure.BuriedTreasureConfig;
import net.minecraft.world.gen.feature.structure.DesertPyramidConfig;
import net.minecraft.world.gen.feature.structure.IglooConfig;
import net.minecraft.world.gen.feature.structure.JunglePyramidConfig;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanMonumentConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.StrongholdConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.SwampHutConfig;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillagePieces;
import net.minecraft.world.gen.feature.structure.WoodlandMansionConfig;
import net.minecraft.world.gen.placement.AtHeight64;
import net.minecraft.world.gen.placement.AtSurface;
import net.minecraft.world.gen.placement.AtSurfaceRandomCount;
import net.minecraft.world.gen.placement.AtSurfaceWithChance;
import net.minecraft.world.gen.placement.AtSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.AtSurfaceWithExtra;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.BasePlacement;
import net.minecraft.world.gen.placement.CaveEdge;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRange;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.ChorusPlant;
import net.minecraft.world.gen.placement.CountRange;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverage;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.DungeonRoom;
import net.minecraft.world.gen.placement.DungeonRoomConfig;
import net.minecraft.world.gen.placement.EndGateway;
import net.minecraft.world.gen.placement.EndIsland;
import net.minecraft.world.gen.placement.EndSpikes;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.Height4To32;
import net.minecraft.world.gen.placement.HeightBiasedRange;
import net.minecraft.world.gen.placement.HeightVeryBiasedRange;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.IcebergPlacement;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.LakeLava;
import net.minecraft.world.gen.placement.LakeWater;
import net.minecraft.world.gen.placement.NetherFire;
import net.minecraft.world.gen.placement.NetherGlowstone;
import net.minecraft.world.gen.placement.NetherMagma;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Passthrough;
import net.minecraft.world.gen.placement.RandomCountWithRange;
import net.minecraft.world.gen.placement.RoofedTree;
import net.minecraft.world.gen.placement.SurfacePlus32;
import net.minecraft.world.gen.placement.SurfacePlus32WithNoise;
import net.minecraft.world.gen.placement.TopSolid;
import net.minecraft.world.gen.placement.TopSolidOnce;
import net.minecraft.world.gen.placement.TopSolidRange;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.placement.TopSolidWithChance;
import net.minecraft.world.gen.placement.TopSolidWithNoise;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.placement.TwiceSurface;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChance;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.TwiceSurfaceWithNoise;
import net.minecraft.world.gen.placement.WithChance;
import net.minecraft.world.gen.surfacebuilders.CompositeSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.DefaultSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ExtremeHillsMutatedSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ExtremeHillsSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.FrozenOceanSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.MesaBryceSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.MesaForestSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.MesaSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.NetherSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.NoopSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SavanaMutatedSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SwampSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.TaigaMegaSurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Biome {
    public static final Logger field_150586_aC = LogManager.getLogger();
    public static final WorldCarver<ProbabilityConfig> field_201907_b = new CaveWorldCarver();
    public static final WorldCarver<ProbabilityConfig> field_201908_c = new NetherCaveWorldCarver();
    public static final WorldCarver<ProbabilityConfig> field_201909_d = new CanyonWorldCarver();
    public static final WorldCarver<ProbabilityConfig> field_203612_e = new UnderwaterCanyonWorldCarver();
    public static final WorldCarver<ProbabilityConfig> field_203613_f = new UnderwaterCaveWorldCarver();
    public static final BasePlacement<FrequencyConfig> field_201910_e = new AtSurface();
    public static final BasePlacement<FrequencyConfig> field_201911_f = new TopSolid();
    public static final BasePlacement<FrequencyConfig> field_201912_g = new SurfacePlus32();
    public static final BasePlacement<FrequencyConfig> field_201913_h = new TwiceSurface();
    public static final BasePlacement<FrequencyConfig> field_201914_i = new AtHeight64();
    public static final BasePlacement<NoiseDependant> field_201915_j = new SurfacePlus32WithNoise();
    public static final BasePlacement<NoiseDependant> field_201916_k = new TwiceSurfaceWithNoise();
    public static final BasePlacement<NoPlacementConfig> field_201917_l = new Passthrough();
    public static final BasePlacement<ChanceConfig> field_201919_n = new AtSurfaceWithChance();
    public static final BasePlacement<ChanceConfig> field_201920_o = new TwiceSurfaceWithChance();
    public static final BasePlacement<ChanceConfig> field_201921_p = new WithChance();
    public static final BasePlacement<ChanceConfig> field_204908_s = new TopSolidWithChance();
    public static final BasePlacement<AtSurfaceWithExtraConfig> field_201922_q = new AtSurfaceWithExtra();
    public static final BasePlacement<CountRangeConfig> field_201923_r = new CountRange();
    public static final BasePlacement<CountRangeConfig> field_201924_s = new HeightBiasedRange();
    public static final BasePlacement<CountRangeConfig> field_201925_t = new HeightVeryBiasedRange();
    public static final BasePlacement<CountRangeConfig> field_205162_x = new RandomCountWithRange();
    public static final BasePlacement<ChanceRangeConfig> field_201926_u = new ChanceRange();
    public static final BasePlacement<HeightWithChanceConfig> field_201927_v = new AtSurfaceWithChanceMultiple();
    public static final BasePlacement<HeightWithChanceConfig> field_201928_w = new TwiceSurfaceWithChanceMultiple();
    public static final BasePlacement<DepthAverageConfig> field_201929_x = new DepthAverage();
    public static final BasePlacement<NoPlacementConfig> field_203197_y = new TopSolidOnce();
    public static final BasePlacement<TopSolidRangeConfig> field_204617_B = new TopSolidRange();
    public static final BasePlacement<TopSolidWithNoiseConfig> field_204618_C = new TopSolidWithNoise();
    public static final BasePlacement<CaveEdgeConfig> field_206855_F = new CaveEdge();
    public static final BasePlacement<FrequencyConfig> field_201930_y = new AtSurfaceRandomCount();
    public static final BasePlacement<FrequencyConfig> field_201931_z = new NetherFire();
    public static final BasePlacement<FrequencyConfig> field_201881_A = new NetherMagma();
    public static final BasePlacement<NoPlacementConfig> field_201882_B = new Height4To32();
    public static final BasePlacement<LakeChanceConfig> field_201883_C = new LakeLava();
    public static final BasePlacement<LakeChanceConfig> field_201884_D = new LakeWater();
    public static final BasePlacement<DungeonRoomConfig> field_201885_E = new DungeonRoom();
    public static final BasePlacement<NoPlacementConfig> field_201886_F = new RoofedTree();
    public static final BasePlacement<ChanceConfig> field_205161_N = new IcebergPlacement();
    public static final BasePlacement<FrequencyConfig> field_201887_G = new NetherGlowstone();
    public static final BasePlacement<NoPlacementConfig> field_201888_H = new EndSpikes();
    public static final BasePlacement<NoPlacementConfig> field_201889_I = new EndIsland();
    public static final BasePlacement<NoPlacementConfig> field_201890_J = new ChorusPlant();
    public static final BasePlacement<NoPlacementConfig> field_201891_K = new EndGateway();
    protected static final IBlockState field_205411_T = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState field_203802_aB = Blocks.field_150346_d.func_176223_P();
    protected static final IBlockState field_203803_aC = Blocks.field_196658_i.func_176223_P();
    protected static final IBlockState field_203804_aD = Blocks.field_196661_l.func_176223_P();
    protected static final IBlockState field_203805_aE = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState field_203806_aF = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState field_203807_aG = Blocks.field_196660_k.func_176223_P();
    protected static final IBlockState field_203956_U = Blocks.field_150354_m.func_176223_P();
    protected static final IBlockState field_203957_V = Blocks.field_196611_F.func_176223_P();
    protected static final IBlockState field_203958_W = Blocks.field_196777_fo.func_176223_P();
    protected static final IBlockState field_203959_X = Blocks.field_150391_bh.func_176223_P();
    protected static final IBlockState field_205406_ae = Blocks.field_150424_aL.func_176223_P();
    protected static final IBlockState field_205407_af = Blocks.field_150377_bs.func_176223_P();
    public static final SurfaceBuilderConfig field_205408_ag = new SurfaceBuilderConfig(field_205411_T, field_205411_T, field_205411_T);
    public static final SurfaceBuilderConfig field_203960_Y = new SurfaceBuilderConfig(field_203802_aB, field_203802_aB, field_203805_aE);
    public static final SurfaceBuilderConfig field_203961_Z = new SurfaceBuilderConfig(field_203803_aC, field_203802_aB, field_203805_aE);
    public static final SurfaceBuilderConfig field_203946_aa = new SurfaceBuilderConfig(field_203806_aF, field_203806_aF, field_203805_aE);
    public static final SurfaceBuilderConfig field_203947_ab = new SurfaceBuilderConfig(field_203805_aE, field_203805_aE, field_203805_aE);
    public static final SurfaceBuilderConfig field_203948_ac = new SurfaceBuilderConfig(field_203807_aG, field_203802_aB, field_203805_aE);
    public static final SurfaceBuilderConfig field_203949_ad = new SurfaceBuilderConfig(field_203804_aD, field_203802_aB, field_203805_aE);
    public static final SurfaceBuilderConfig field_203950_ae = new SurfaceBuilderConfig(field_203956_U, field_203956_U, field_203956_U);
    public static final SurfaceBuilderConfig field_203951_af = new SurfaceBuilderConfig(field_203803_aC, field_203802_aB, field_203956_U);
    public static final SurfaceBuilderConfig field_203952_ag = new SurfaceBuilderConfig(field_203956_U, field_203956_U, field_203805_aE);
    public static final SurfaceBuilderConfig field_203953_ah = new SurfaceBuilderConfig(field_203957_V, field_203958_W, field_203805_aE);
    public static final SurfaceBuilderConfig field_203954_ai = new SurfaceBuilderConfig(field_203959_X, field_203802_aB, field_203805_aE);
    public static final SurfaceBuilderConfig field_205409_as = new SurfaceBuilderConfig(field_205406_ae, field_205406_ae, field_205406_ae);
    public static final SurfaceBuilderConfig field_205410_at = new SurfaceBuilderConfig(field_205407_af, field_205407_af, field_205407_af);
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_203955_aj = new DefaultSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201899_S = new ExtremeHillsSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201900_T = new SavanaMutatedSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201901_U = new ExtremeHillsMutatedSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201902_V = new TaigaMegaSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201903_W = new SwampSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201904_X = new MesaSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201905_Y = new MesaForestSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201906_Z = new MesaBryceSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_205160_ax = new FrozenOceanSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_205404_aE = new NetherSurfaceBuilder();
    public static final ISurfaceBuilder<SurfaceBuilderConfig> field_201869_aa = new NoopSurfaceBuilder();
    public static final Set<Biome> field_201870_ab = Sets.newHashSet();
    public static final ObjectIntIdentityMap<Biome> field_185373_j = new ObjectIntIdentityMap();
    protected static final NoiseGeneratorPerlin field_150605_ac = new NoiseGeneratorPerlin(new Random(1234L), 1);
    public static final NoiseGeneratorPerlin field_180281_af = new NoiseGeneratorPerlin(new Random(2345L), 1);
    @Nullable
    protected String field_205405_aL;
    protected final float field_76748_D;
    protected final float field_76749_E;
    protected final float field_76750_F;
    protected final float field_76751_G;
    protected final int field_76759_H;
    protected final int field_204275_aE;
    @Nullable
    protected final String field_185364_H;
    protected final CompositeSurfaceBuilder<?> field_201875_ar;
    protected final Category field_201877_au;
    protected final RainType field_201878_av;
    protected final Map<GenerationStage.Carving, List<WorldCarverWrapper<?>>> field_201871_ag = Maps.newHashMap();
    protected final Map<GenerationStage.Decoration, List<CompositeFeature<?, ?>>> field_201872_ah = Maps.newHashMap();
    protected final List<CompositeFlowerFeature<?>> field_201873_ai = Lists.newArrayList();
    protected final Map<Structure<?>, IFeatureConfig> field_201874_aj = Maps.newHashMap();
    private final Map<EnumCreatureType, List<SpawnListEntry>> field_201880_ax = Maps.newHashMap();

    @Nullable
    public static Biome func_185356_b(Biome biome) {
        return field_185373_j.func_148745_a(IRegistry.field_212624_m.func_148757_b(biome));
    }

    public static <C extends IFeatureConfig> WorldCarverWrapper<C> func_203606_a(IWorldCarver<C> iWorldCarver, C c) {
        return new WorldCarverWrapper<C>(iWorldCarver, c);
    }

    public static <F extends IFeatureConfig, D extends IPlacementConfig> CompositeFeature<F, D> func_201864_a(Feature<F> feature, F f, BasePlacement<D> basePlacement, D d) {
        return new CompositeFeature<F, D>(feature, f, basePlacement, d);
    }

    public static <D extends IPlacementConfig> CompositeFlowerFeature<D> func_201861_a(AbstractFlowersFeature abstractFlowersFeature, BasePlacement<D> basePlacement, D d) {
        return new CompositeFlowerFeature<D>(abstractFlowersFeature, basePlacement, d);
    }

    protected Biome(BiomeBuilder biomeBuilder) {
        if (biomeBuilder.field_205422_a == null || biomeBuilder.field_205423_b == null || biomeBuilder.field_205424_c == null || biomeBuilder.field_205425_d == null || biomeBuilder.field_205426_e == null || biomeBuilder.field_205427_f == null || biomeBuilder.field_205428_g == null || biomeBuilder.field_205429_h == null || biomeBuilder.field_205430_i == null) {
            throw new IllegalStateException("You are missing parameters to build a proper biome for " + this.getClass().getSimpleName() + "\n" + biomeBuilder);
        }
        this.field_201875_ar = biomeBuilder.field_205422_a;
        this.field_201878_av = biomeBuilder.field_205423_b;
        this.field_201877_au = biomeBuilder.field_205424_c;
        this.field_76748_D = biomeBuilder.field_205425_d.floatValue();
        this.field_76749_E = biomeBuilder.field_205426_e.floatValue();
        this.field_76750_F = biomeBuilder.field_205427_f.floatValue();
        this.field_76751_G = biomeBuilder.field_205428_g.floatValue();
        this.field_76759_H = biomeBuilder.field_205429_h;
        this.field_204275_aE = biomeBuilder.field_205430_i;
        this.field_185364_H = biomeBuilder.field_205431_j;
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            this.field_201872_ah.put(decoration, Lists.newArrayList());
        }
        for (Enum enum_ : EnumCreatureType.values()) {
            this.field_201880_ax.put((EnumCreatureType)enum_, Lists.newArrayList());
        }
    }

    protected void func_203605_a() {
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_201864_a(Feature.field_202329_g, new MineshaftConfig(0.004f, MineshaftStructure.Type.NORMAL), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_202328_f, new VillageConfig(0, VillagePieces.Type.OAK), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_201864_a(Feature.field_202335_m, new StrongholdConfig(), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_202334_l, new SwampHutConfig(), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_202332_j, new DesertPyramidConfig(), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_202331_i, new JunglePyramidConfig(), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_202333_k, new IglooConfig(), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_204751_l, new ShipwreckConfig(false), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_202336_n, new OceanMonumentConfig(), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_202330_h, new WoodlandMansionConfig(), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_201864_a(Feature.field_204029_o, new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.9f), field_201917_l, IPlacementConfig.field_202468_e));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_201864_a(Feature.field_204292_r, new BuriedTreasureConfig(0.01f), field_201917_l, IPlacementConfig.field_202468_e));
    }

    public boolean func_185363_b() {
        return this.field_185364_H != null;
    }

    protected void func_201866_a(EnumCreatureType enumCreatureType, SpawnListEntry spawnListEntry) {
        this.field_201880_ax.get((Object)enumCreatureType).add(spawnListEntry);
    }

    public List<SpawnListEntry> func_76747_a(EnumCreatureType enumCreatureType) {
        return this.field_201880_ax.get((Object)enumCreatureType);
    }

    public RainType func_201851_b() {
        return this.field_201878_av;
    }

    public boolean func_76736_e() {
        return this.func_76727_i() > 0.85f;
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public float func_180626_a(BlockPos blockPos) {
        if (blockPos.func_177956_o() > 64) {
            float f = (float)(field_150605_ac.func_151601_a((float)blockPos.func_177958_n() / 8.0f, (float)blockPos.func_177952_p() / 8.0f) * 4.0);
            return this.func_185353_n() - (f + (float)blockPos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return this.func_185353_n();
    }

    public boolean func_201848_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        return this.func_201854_a(iWorldReaderBase, blockPos, true);
    }

    public boolean func_201854_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos, boolean bl) {
        if (this.func_180626_a(blockPos) >= 0.15f) {
            return false;
        }
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReaderBase.func_175642_b(EnumLightType.BLOCK, blockPos) < 10) {
            IBlockState iBlockState = iWorldReaderBase.func_180495_p(blockPos);
            IFluidState \u26032 = iWorldReaderBase.func_204610_c(blockPos);
            if (\u26032.func_206886_c() == Fluids.field_204546_a && iBlockState.func_177230_c() instanceof BlockFlowingFluid) {
                if (!bl) {
                    return true;
                }
                boolean bl2 = \u2603 = iWorldReaderBase.func_201671_F(blockPos.func_177976_e()) && iWorldReaderBase.func_201671_F(blockPos.func_177974_f()) && iWorldReaderBase.func_201671_F(blockPos.func_177978_c()) && iWorldReaderBase.func_201671_F(blockPos.func_177968_d());
                if (!\u2603) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        if (this.func_180626_a(blockPos) >= 0.15f) {
            return false;
        }
        return blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReaderBase.func_175642_b(EnumLightType.BLOCK, blockPos) < 10 && (\u2603 = iWorldReaderBase.func_180495_p(blockPos)).func_196958_f() && Blocks.field_150433_aE.func_176223_P().func_196955_c(iWorldReaderBase, blockPos);
    }

    public void func_203611_a(GenerationStage.Decoration decoration, CompositeFeature<?, ?> compositeFeature) {
        if (compositeFeature instanceof CompositeFlowerFeature) {
            this.field_201873_ai.add((CompositeFlowerFeature)compositeFeature);
        }
        this.field_201872_ah.get((Object)decoration).add(compositeFeature);
    }

    public <C extends IFeatureConfig> void func_203609_a(GenerationStage.Carving carving2, WorldCarverWrapper<C> worldCarverWrapper) {
        this.field_201871_ag.computeIfAbsent(carving2, carving -> Lists.newArrayList()).add(worldCarverWrapper);
    }

    public List<WorldCarverWrapper<?>> func_203603_a(GenerationStage.Carving carving2) {
        return this.field_201871_ag.computeIfAbsent(carving2, carving -> Lists.newArrayList());
    }

    public <C extends IFeatureConfig> void func_201865_a(Structure<C> structure, C c) {
        this.field_201874_aj.put(structure, c);
    }

    public <C extends IFeatureConfig> boolean func_201858_a(Structure<C> structure) {
        return this.field_201874_aj.containsKey(structure);
    }

    @Nullable
    public <C extends IFeatureConfig> IFeatureConfig func_201857_b(Structure<C> structure) {
        return this.field_201874_aj.get(structure);
    }

    public List<CompositeFlowerFeature<?>> func_201853_g() {
        return this.field_201873_ai;
    }

    public List<CompositeFeature<?, ?>> func_203607_a(GenerationStage.Decoration decoration) {
        return this.field_201872_ah.get((Object)decoration);
    }

    public void func_203608_a(GenerationStage.Decoration decoration, IChunkGenerator<? extends IChunkGenSettings> iChunkGenerator, IWorld iWorld, long l, SharedSeedRandom sharedSeedRandom, BlockPos blockPos) {
        int n = 0;
        for (CompositeFeature<?, ?> compositeFeature : this.field_201872_ah.get((Object)decoration)) {
            sharedSeedRandom.func_202426_b(l, n, decoration.ordinal());
            compositeFeature.func_212245_a(iWorld, iChunkGenerator, (Random)sharedSeedRandom, blockPos, IFeatureConfig.field_202429_e);
            ++n;
        }
    }

    public void func_206854_a(Random random, IChunk iChunk, int n, int n2, int n3, double d, IBlockState iBlockState, IBlockState iBlockState2, int n4, long l) {
        this.field_201875_ar.func_205548_a(l);
        this.field_201875_ar.func_205610_a_(random, iChunk, this, n, n2, n3, d, iBlockState, iBlockState2, n4, l, field_205408_ag);
    }

    public TempCategory func_150561_m() {
        if (this.field_201877_au == Category.OCEAN) {
            return TempCategory.OCEAN;
        }
        if ((double)this.func_185353_n() < 0.2) {
            return TempCategory.COLD;
        }
        if ((double)this.func_185353_n() < 1.0) {
            return TempCategory.MEDIUM;
        }
        return TempCategory.WARM;
    }

    public static Biome func_180276_a(int n, Biome biome) {
        \u2603 = IRegistry.field_212624_m.func_148754_a(n);
        return \u2603 == null ? biome : \u2603;
    }

    public final float func_185355_j() {
        return this.field_76748_D;
    }

    public final float func_76727_i() {
        return this.field_76751_G;
    }

    public String func_210773_k() {
        if (this.field_205405_aL == null) {
            this.field_205405_aL = Util.func_200697_a("biome", IRegistry.field_212624_m.func_177774_c(this));
        }
        return this.field_205405_aL;
    }

    public final float func_185360_m() {
        return this.field_76749_E;
    }

    public final float func_185353_n() {
        return this.field_76750_F;
    }

    public final int func_185361_o() {
        return this.field_76759_H;
    }

    public final int func_204274_p() {
        return this.field_204275_aE;
    }

    public final Category func_201856_r() {
        return this.field_201877_au;
    }

    public CompositeSurfaceBuilder<?> func_205401_q() {
        return this.field_201875_ar;
    }

    public ISurfaceBuilderConfig func_203944_q() {
        return this.field_201875_ar.func_205549_a();
    }

    @Nullable
    public String func_205402_s() {
        return this.field_185364_H;
    }

    public static void func_185358_q() {
        Biome.func_185354_a(0, "ocean", new OceanBiome());
        Biome.func_185354_a(1, "plains", new PlainsBiome());
        Biome.func_185354_a(2, "desert", new DesertBiome());
        Biome.func_185354_a(3, "mountains", new MountainsBiome());
        Biome.func_185354_a(4, "forest", new ForestBiome());
        Biome.func_185354_a(5, "taiga", new TaigaBiome());
        Biome.func_185354_a(6, "swamp", new SwampBiome());
        Biome.func_185354_a(7, "river", new RiverBiome());
        Biome.func_185354_a(8, "nether", new NetherBiome());
        Biome.func_185354_a(9, "the_end", new TheEndBiome());
        Biome.func_185354_a(10, "frozen_ocean", new FrozenOceanBiome());
        Biome.func_185354_a(11, "frozen_river", new FrozenRiverBiome());
        Biome.func_185354_a(12, "snowy_tundra", new SnowyTundraBiome());
        Biome.func_185354_a(13, "snowy_mountains", new SnowyMountainsBiome());
        Biome.func_185354_a(14, "mushroom_fields", new MushroomFieldsBiome());
        Biome.func_185354_a(15, "mushroom_field_shore", new MushroomFieldShoreBiome());
        Biome.func_185354_a(16, "beach", new BeachBiome());
        Biome.func_185354_a(17, "desert_hills", new DesertHillsBiome());
        Biome.func_185354_a(18, "wooded_hills", new WoodedHillsBiome());
        Biome.func_185354_a(19, "taiga_hills", new TaigaHillsBiome());
        Biome.func_185354_a(20, "mountain_edge", new MountainEdgeBiome());
        Biome.func_185354_a(21, "jungle", new JungleBiome());
        Biome.func_185354_a(22, "jungle_hills", new JungleHillsBiome());
        Biome.func_185354_a(23, "jungle_edge", new JungleEdgeBiome());
        Biome.func_185354_a(24, "deep_ocean", new DeepOceanBiome());
        Biome.func_185354_a(25, "stone_shore", new StoneShoreBiome());
        Biome.func_185354_a(26, "snowy_beach", new SnowyBeachBiome());
        Biome.func_185354_a(27, "birch_forest", new BirchForestBiome());
        Biome.func_185354_a(28, "birch_forest_hills", new BirchForestHillsBiome());
        Biome.func_185354_a(29, "dark_forest", new DarkForestBiome());
        Biome.func_185354_a(30, "snowy_taiga", new SnowyTaigaBiome());
        Biome.func_185354_a(31, "snowy_taiga_hills", new SnowyTaigaHillsBiome());
        Biome.func_185354_a(32, "giant_tree_taiga", new GiantTreeTaigaBiome());
        Biome.func_185354_a(33, "giant_tree_taiga_hills", new GiantTreeTaigaHillsBiome());
        Biome.func_185354_a(34, "wooded_mountains", new WoodedMountainsBiome());
        Biome.func_185354_a(35, "savanna", new SavannaBiome());
        Biome.func_185354_a(36, "savanna_plateau", new SavannaPlateauBiome());
        Biome.func_185354_a(37, "badlands", new BadlandsBiome());
        Biome.func_185354_a(38, "wooded_badlands_plateau", new WoodedBadlandsPlateauBiome());
        Biome.func_185354_a(39, "badlands_plateau", new BadlandsPlateauBiome());
        Biome.func_185354_a(40, "small_end_islands", new SmallEndIslandsBiome());
        Biome.func_185354_a(41, "end_midlands", new EndMidlandsBiome());
        Biome.func_185354_a(42, "end_highlands", new EndHighlandsBiome());
        Biome.func_185354_a(43, "end_barrens", new EndBarrensBiome());
        Biome.func_185354_a(44, "warm_ocean", new WarmOceanBiome());
        Biome.func_185354_a(45, "lukewarm_ocean", new LukewarmOceanBiome());
        Biome.func_185354_a(46, "cold_ocean", new ColdOceanBiome());
        Biome.func_185354_a(47, "deep_warm_ocean", new DeepWarmOceanBiome());
        Biome.func_185354_a(48, "deep_lukewarm_ocean", new DeepLukewarmOceanBiome());
        Biome.func_185354_a(49, "deep_cold_ocean", new DeepColdOceanBiome());
        Biome.func_185354_a(50, "deep_frozen_ocean", new DeepFrozenOceanBiome());
        Biome.func_185354_a(127, "the_void", new TheVoidBiome());
        Biome.func_185354_a(129, "sunflower_plains", new SunflowerPlainsBiome());
        Biome.func_185354_a(130, "desert_lakes", new DesertLakesBiome());
        Biome.func_185354_a(131, "gravelly_mountains", new GravellyMountainsBiome());
        Biome.func_185354_a(132, "flower_forest", new FlowerForestBiome());
        Biome.func_185354_a(133, "taiga_mountains", new TaigaMountainsBiome());
        Biome.func_185354_a(134, "swamp_hills", new SwampHillsBiome());
        Biome.func_185354_a(140, "ice_spikes", new IceSpikesBiome());
        Biome.func_185354_a(149, "modified_jungle", new ModifiedJungleBiome());
        Biome.func_185354_a(151, "modified_jungle_edge", new ModifiedJungleEdgeBiome());
        Biome.func_185354_a(155, "tall_birch_forest", new TallBirchForestBiome());
        Biome.func_185354_a(156, "tall_birch_hills", new TallBirchHillsBiome());
        Biome.func_185354_a(157, "dark_forest_hills", new DarkForestHillsBiome());
        Biome.func_185354_a(158, "snowy_taiga_mountains", new SnowyTaigaMountainsBiome());
        Biome.func_185354_a(160, "giant_spruce_taiga", new GiantSpruceTaigaBiome());
        Biome.func_185354_a(161, "giant_spruce_taiga_hills", new GiantSpruceTaigaHillsBiome());
        Biome.func_185354_a(162, "modified_gravelly_mountains", new ModifiedGravellyMountainsBiome());
        Biome.func_185354_a(163, "shattered_savanna", new ShatteredSavannaBiome());
        Biome.func_185354_a(164, "shattered_savanna_plateau", new ShatteredSavannaPlateauBiome());
        Biome.func_185354_a(165, "eroded_badlands", new ErodedBadlandsBiome());
        Biome.func_185354_a(166, "modified_wooded_badlands_plateau", new ModifiedWoodedBadlandsPlateauBiome());
        Biome.func_185354_a(167, "modified_badlands_plateau", new ModifiedBadlandsPlateauBiome());
        Collections.addAll(field_201870_ab, Biomes.field_76771_b, Biomes.field_76772_c, Biomes.field_76769_d, Biomes.field_76770_e, Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76780_h, Biomes.field_76781_i, Biomes.field_76777_m, Biomes.field_76774_n, Biomes.field_76775_o, Biomes.field_76789_p, Biomes.field_76788_q, Biomes.field_76787_r, Biomes.field_76786_s, Biomes.field_76785_t, Biomes.field_76784_u, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_150575_M, Biomes.field_150576_N, Biomes.field_150577_O, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150585_R, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_150578_U, Biomes.field_150581_V, Biomes.field_150580_W, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab);
    }

    private static void func_185354_a(int n, String string, Biome biome) {
        IRegistry.field_212624_m.func_177775_a(n, new ResourceLocation(string), biome);
        if (biome.func_185363_b()) {
            field_185373_j.func_148746_a(biome, IRegistry.field_212624_m.func_148757_b(IRegistry.field_212624_m.func_212608_b(new ResourceLocation(biome.field_185364_H))));
        }
    }

    public static class BiomeBuilder {
        @Nullable
        private CompositeSurfaceBuilder<?> field_205422_a;
        @Nullable
        private RainType field_205423_b;
        @Nullable
        private Category field_205424_c;
        @Nullable
        private Float field_205425_d;
        @Nullable
        private Float field_205426_e;
        @Nullable
        private Float field_205427_f;
        @Nullable
        private Float field_205428_g;
        @Nullable
        private Integer field_205429_h;
        @Nullable
        private Integer field_205430_i;
        @Nullable
        private String field_205431_j;

        public BiomeBuilder func_205416_a(CompositeSurfaceBuilder<?> compositeSurfaceBuilder) {
            this.field_205422_a = compositeSurfaceBuilder;
            return this;
        }

        public BiomeBuilder func_205415_a(RainType rainType) {
            this.field_205423_b = rainType;
            return this;
        }

        public BiomeBuilder func_205419_a(Category category) {
            this.field_205424_c = category;
            return this;
        }

        public BiomeBuilder func_205421_a(float f) {
            this.field_205425_d = Float.valueOf(f);
            return this;
        }

        public BiomeBuilder func_205420_b(float f) {
            this.field_205426_e = Float.valueOf(f);
            return this;
        }

        public BiomeBuilder func_205414_c(float f) {
            this.field_205427_f = Float.valueOf(f);
            return this;
        }

        public BiomeBuilder func_205417_d(float f) {
            this.field_205428_g = Float.valueOf(f);
            return this;
        }

        public BiomeBuilder func_205412_a(int n) {
            this.field_205429_h = n;
            return this;
        }

        public BiomeBuilder func_205413_b(int n) {
            this.field_205430_i = n;
            return this;
        }

        public BiomeBuilder func_205418_a(@Nullable String string) {
            this.field_205431_j = string;
            return this;
        }

        public String toString() {
            return "BiomeBuilder{\nsurfaceBuilder=" + this.field_205422_a + ",\nprecipitation=" + (Object)((Object)this.field_205423_b) + ",\nbiomeCategory=" + (Object)((Object)this.field_205424_c) + ",\ndepth=" + this.field_205425_d + ",\nscale=" + this.field_205426_e + ",\ntemperature=" + this.field_205427_f + ",\ndownfall=" + this.field_205428_g + ",\nwaterColor=" + this.field_205429_h + ",\nwaterFogColor=" + this.field_205430_i + ",\nparent='" + this.field_205431_j + '\'' + "\n" + '}';
        }
    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public EntityType<? extends EntityLiving> field_200702_b;
        public int field_76301_c;
        public int field_76299_d;

        public SpawnListEntry(EntityType<? extends EntityLiving> entityType, int n, int n2, int n3) {
            super(n);
            this.field_200702_b = entityType;
            this.field_76301_c = n2;
            this.field_76299_d = n3;
        }

        public String toString() {
            return EntityType.func_200718_a(this.field_200702_b) + "*(" + this.field_76301_c + "-" + this.field_76299_d + "):" + this.field_76292_a;
        }
    }

    public static enum RainType {
        NONE,
        RAIN,
        SNOW;

    }

    public static enum Category {
        NONE,
        TAIGA,
        EXTREME_HILLS,
        JUNGLE,
        MESA,
        PLAINS,
        SAVANNA,
        ICY,
        THEEND,
        BEACH,
        FOREST,
        OCEAN,
        DESERT,
        RIVER,
        SWAMP,
        MUSHROOM,
        NETHER;

    }

    public static enum TempCategory {
        OCEAN,
        COLD,
        MEDIUM,
        WARM;

    }
}

