/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ITickList;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class ServerTickList<T>
implements ITickList<T> {
    protected final Predicate<T> field_205371_a;
    protected final Function<T, ResourceLocation> field_205372_b;
    protected final Function<ResourceLocation, T> field_205373_c;
    protected final Set<NextTickListEntry<T>> field_205374_d = Sets.newHashSet();
    protected final TreeSet<NextTickListEntry<T>> field_205375_e = new TreeSet();
    private final WorldServer field_205376_f;
    private final List<NextTickListEntry<T>> field_205377_g = Lists.newArrayList();
    private final Consumer<NextTickListEntry<T>> field_205378_h;

    public ServerTickList(WorldServer worldServer, Predicate<T> predicate, Function<T, ResourceLocation> function, Function<ResourceLocation, T> function2, Consumer<NextTickListEntry<T>> consumer) {
        this.field_205371_a = predicate;
        this.field_205372_b = function;
        this.field_205373_c = function2;
        this.field_205376_f = worldServer;
        this.field_205378_h = consumer;
    }

    public void func_205365_a() {
        NextTickListEntry<T> nextTickListEntry;
        int n = this.field_205375_e.size();
        if (n != this.field_205374_d.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 65536) {
            n = 65536;
        }
        this.field_205376_f.field_72984_F.func_76320_a("cleaning");
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            nextTickListEntry = this.field_205375_e.first();
            if (nextTickListEntry.field_77180_e > this.field_205376_f.func_82737_E()) break;
            this.field_205375_e.remove(nextTickListEntry);
            this.field_205374_d.remove(nextTickListEntry);
            this.field_205377_g.add(nextTickListEntry);
        }
        this.field_205376_f.field_72984_F.func_76319_b();
        this.field_205376_f.field_72984_F.func_76320_a("ticking");
        Iterator<NextTickListEntry<T>> iterator = this.field_205377_g.iterator();
        while (iterator.hasNext()) {
            nextTickListEntry = iterator.next();
            iterator.remove();
            boolean \u26032 = false;
            if (this.field_205376_f.func_175707_a(nextTickListEntry.field_180282_a.func_177982_a(0, 0, 0), nextTickListEntry.field_180282_a.func_177982_a(0, 0, 0))) {
                try {
                    this.field_205378_h.accept(nextTickListEntry);
                    continue;
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception while ticking");
                    CrashReportCategory \u26033 = crashReport.func_85058_a("Block being ticked");
                    CrashReportCategory.func_175750_a(\u26033, nextTickListEntry.field_180282_a, null);
                    throw new ReportedException(crashReport);
                }
            }
            this.func_205360_a(nextTickListEntry.field_180282_a, nextTickListEntry.func_151351_a(), 0);
        }
        this.field_205376_f.field_72984_F.func_76319_b();
        this.field_205377_g.clear();
    }

    @Override
    public boolean func_205361_b(BlockPos blockPos, T t) {
        return this.field_205377_g.contains(new NextTickListEntry<T>(blockPos, t));
    }

    public List<NextTickListEntry<T>> func_205364_a(Chunk chunk, boolean bl) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int \u26032 = (chunkPos.field_77276_a << 4) - 2;
        int \u26033 = \u26032 + 16 + 2;
        int \u26034 = (chunkPos.field_77275_b << 4) - 2;
        int \u26035 = \u26034 + 16 + 2;
        return this.func_205366_a(new MutableBoundingBox(\u26032, 0, \u26034, \u26033, 256, \u26035), bl);
    }

    public List<NextTickListEntry<T>> func_205366_a(MutableBoundingBox mutableBoundingBox, boolean bl) {
        ArrayList arrayList = null;
        for (int i = 0; i < 2; ++i) {
            Iterator<NextTickListEntry<T>> iterator = i == 0 ? this.field_205375_e.iterator() : this.field_205377_g.iterator();
            while (iterator.hasNext()) {
                NextTickListEntry<T> nextTickListEntry = iterator.next();
                BlockPos \u26032 = nextTickListEntry.field_180282_a;
                if (\u26032.func_177958_n() < mutableBoundingBox.field_78897_a || \u26032.func_177958_n() >= mutableBoundingBox.field_78893_d || \u26032.func_177952_p() < mutableBoundingBox.field_78896_c || \u26032.func_177952_p() >= mutableBoundingBox.field_78892_f) continue;
                if (bl) {
                    if (i == 0) {
                        this.field_205374_d.remove(nextTickListEntry);
                    }
                    iterator.remove();
                }
                if (arrayList == null) {
                    arrayList = Lists.newArrayList();
                }
                arrayList.add(nextTickListEntry);
            }
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    public void func_205368_a(MutableBoundingBox mutableBoundingBox, BlockPos blockPos) {
        List<NextTickListEntry<T>> list = this.func_205366_a(mutableBoundingBox, false);
        for (NextTickListEntry<T> nextTickListEntry : list) {
            if (!mutableBoundingBox.func_175898_b(nextTickListEntry.field_180282_a)) continue;
            BlockPos blockPos2 = nextTickListEntry.field_180282_a.func_177971_a(blockPos);
            this.func_205367_b(blockPos2, nextTickListEntry.func_151351_a(), (int)(nextTickListEntry.field_77180_e - this.field_205376_f.func_72912_H().func_82573_f()), nextTickListEntry.field_82754_f);
        }
    }

    public NBTTagList func_205363_a(Chunk chunk) {
        List<NextTickListEntry<T>> list = this.func_205364_a(chunk, false);
        long \u26032 = this.field_205376_f.func_82737_E();
        NBTTagList \u26033 = new NBTTagList();
        for (NextTickListEntry<T> nextTickListEntry : list) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("i", this.field_205372_b.apply(nextTickListEntry.func_151351_a()).toString());
            nBTTagCompound.func_74768_a("x", nextTickListEntry.field_180282_a.func_177958_n());
            nBTTagCompound.func_74768_a("y", nextTickListEntry.field_180282_a.func_177956_o());
            nBTTagCompound.func_74768_a("z", nextTickListEntry.field_180282_a.func_177952_p());
            nBTTagCompound.func_74768_a("t", (int)(nextTickListEntry.field_77180_e - \u26032));
            nBTTagCompound.func_74768_a("p", nextTickListEntry.field_82754_f.func_205398_a());
            \u26033.add(nBTTagCompound);
        }
        return \u26033;
    }

    public void func_205369_a(NBTTagList nBTTagList) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(i);
            T \u26032 = this.field_205373_c.apply(new ResourceLocation(nBTTagCompound.func_74779_i("i")));
            if (\u26032 == null) continue;
            this.func_205367_b(new BlockPos(nBTTagCompound.func_74762_e("x"), nBTTagCompound.func_74762_e("y"), nBTTagCompound.func_74762_e("z")), \u26032, nBTTagCompound.func_74762_e("t"), TickPriority.func_205397_a(nBTTagCompound.func_74762_e("p")));
        }
    }

    @Override
    public boolean func_205359_a(BlockPos blockPos, T t) {
        return this.field_205374_d.contains(new NextTickListEntry<T>(blockPos, t));
    }

    @Override
    public void func_205362_a(BlockPos blockPos, T t, int n, TickPriority tickPriority) {
        if (this.field_205371_a.test(t)) {
            return;
        }
        if (this.field_205376_f.func_175667_e(blockPos)) {
            this.func_205370_c(blockPos, t, n, tickPriority);
        }
    }

    protected void func_205367_b(BlockPos blockPos, T t, int n, TickPriority tickPriority) {
        if (!this.field_205371_a.test(t)) {
            this.func_205370_c(blockPos, t, n, tickPriority);
        }
    }

    private void func_205370_c(BlockPos blockPos, T t, int n, TickPriority tickPriority) {
        NextTickListEntry<T> nextTickListEntry = new NextTickListEntry<T>(blockPos, t, (long)n + this.field_205376_f.func_82737_E(), tickPriority);
        if (!this.field_205374_d.contains(nextTickListEntry)) {
            this.field_205374_d.add(nextTickListEntry);
            this.field_205375_e.add(nextTickListEntry);
        }
    }
}

