/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public enum EnumFacing implements IStringSerializable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    private final int field_176748_g;
    private final int field_176759_h;
    private final int field_176760_i;
    private final String field_176757_j;
    private final Axis field_176758_k;
    private final AxisDirection field_176755_l;
    private final Vec3i field_176756_m;
    private static final EnumFacing[] field_199792_n;
    private static final Map<String, EnumFacing> field_176761_p;
    private static final EnumFacing[] field_82609_l;
    private static final EnumFacing[] field_176754_o;

    private EnumFacing(int n2, int n3, int n4, String string2, AxisDirection axisDirection, Axis axis, Vec3i vec3i) {
        this.field_176748_g = n2;
        this.field_176760_i = n4;
        this.field_176759_h = n3;
        this.field_176757_j = string2;
        this.field_176758_k = axis;
        this.field_176755_l = axisDirection;
        this.field_176756_m = vec3i;
    }

    public static EnumFacing[] func_196054_a(Entity entity) {
        float f = entity.func_195050_f(1.0f) * ((float)Math.PI / 180);
        \u2603 = -entity.func_195046_g(1.0f) * ((float)Math.PI / 180);
        \u2603 = MathHelper.func_76126_a(f);
        \u2603 = MathHelper.func_76134_b(f);
        \u2603 = MathHelper.func_76126_a(\u2603);
        \u2603 = MathHelper.func_76134_b(\u2603);
        boolean \u26032 = \u2603 > 0.0f;
        boolean \u26033 = \u2603 < 0.0f;
        boolean \u26034 = \u2603 > 0.0f;
        \u2603 = \u26032 ? \u2603 : -\u2603;
        \u2603 = \u26033 ? -\u2603 : \u2603;
        \u2603 = \u26034 ? \u2603 : -\u2603;
        \u2603 = \u2603 * \u2603;
        \u2603 = \u2603 * \u2603;
        EnumFacing \u26035 = \u26032 ? EAST : WEST;
        EnumFacing \u26036 = \u26033 ? UP : DOWN;
        EnumFacing enumFacing = \u2603 = \u26034 ? SOUTH : NORTH;
        if (\u2603 > \u2603) {
            if (\u2603 > \u2603) {
                return EnumFacing.func_196053_a(\u26036, \u26035, \u2603);
            }
            if (\u2603 > \u2603) {
                return EnumFacing.func_196053_a(\u26035, \u2603, \u26036);
            }
            return EnumFacing.func_196053_a(\u26035, \u26036, \u2603);
        }
        if (\u2603 > \u2603) {
            return EnumFacing.func_196053_a(\u26036, \u2603, \u26035);
        }
        if (\u2603 > \u2603) {
            return EnumFacing.func_196053_a(\u2603, \u26035, \u26036);
        }
        return EnumFacing.func_196053_a(\u2603, \u26036, \u26035);
    }

    private static EnumFacing[] func_196053_a(EnumFacing enumFacing, EnumFacing enumFacing2, EnumFacing enumFacing3) {
        return new EnumFacing[]{enumFacing, enumFacing2, enumFacing3, enumFacing3.func_176734_d(), enumFacing2.func_176734_d(), enumFacing.func_176734_d()};
    }

    public int func_176745_a() {
        return this.field_176748_g;
    }

    public int func_176736_b() {
        return this.field_176760_i;
    }

    public AxisDirection func_176743_c() {
        return this.field_176755_l;
    }

    public EnumFacing func_176734_d() {
        return EnumFacing.func_82600_a(this.field_176759_h);
    }

    public EnumFacing func_176746_e() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
    }

    public EnumFacing func_176735_f() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + this);
    }

    public int func_82601_c() {
        return this.field_176758_k == Axis.X ? this.field_176755_l.func_179524_a() : 0;
    }

    public int func_96559_d() {
        return this.field_176758_k == Axis.Y ? this.field_176755_l.func_179524_a() : 0;
    }

    public int func_82599_e() {
        return this.field_176758_k == Axis.Z ? this.field_176755_l.func_179524_a() : 0;
    }

    public String func_176742_j() {
        return this.field_176757_j;
    }

    public Axis func_176740_k() {
        return this.field_176758_k;
    }

    public static EnumFacing func_82600_a(int n) {
        return field_82609_l[MathHelper.func_76130_a(n % field_82609_l.length)];
    }

    public static EnumFacing func_176731_b(int n) {
        return field_176754_o[MathHelper.func_76130_a(n % field_176754_o.length)];
    }

    public static EnumFacing func_176733_a(double d) {
        return EnumFacing.func_176731_b(MathHelper.func_76128_c(d / 90.0 + 0.5) & 3);
    }

    public static EnumFacing func_211699_a(Axis axis, AxisDirection axisDirection) {
        switch (axis) {
            case X: {
                return axisDirection == AxisDirection.POSITIVE ? EAST : WEST;
            }
            case Y: {
                return axisDirection == AxisDirection.POSITIVE ? UP : DOWN;
            }
        }
        return axisDirection == AxisDirection.POSITIVE ? SOUTH : NORTH;
    }

    public float func_185119_l() {
        return (this.field_176760_i & 3) * 90;
    }

    public static EnumFacing func_176741_a(Random random) {
        return EnumFacing.values()[random.nextInt(EnumFacing.values().length)];
    }

    public static EnumFacing func_210769_a(double d, double d2, double d3) {
        return EnumFacing.func_176737_a((float)d, (float)d2, (float)d3);
    }

    public static EnumFacing func_176737_a(float f, float f2, float f3) {
        EnumFacing \u26033 = NORTH;
        float \u26032 = Float.MIN_VALUE;
        for (EnumFacing enumFacing : field_199792_n) {
            float f4 = f * (float)enumFacing.field_176756_m.func_177958_n() + f2 * (float)enumFacing.field_176756_m.func_177956_o() + f3 * (float)enumFacing.field_176756_m.func_177952_p();
            if (!(f4 > \u26032)) continue;
            \u26032 = f4;
            \u26033 = enumFacing;
        }
        return \u26033;
    }

    public String toString() {
        return this.field_176757_j;
    }

    @Override
    public String func_176610_l() {
        return this.field_176757_j;
    }

    public static EnumFacing func_181076_a(AxisDirection axisDirection2, Axis axis) {
        AxisDirection axisDirection2;
        for (EnumFacing enumFacing : EnumFacing.values()) {
            if (enumFacing.func_176743_c() != axisDirection2 || enumFacing.func_176740_k() != axis) continue;
            return enumFacing;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)axisDirection2) + " " + axis);
    }

    static {
        field_199792_n = EnumFacing.values();
        field_176761_p = Arrays.stream(field_199792_n).collect(Collectors.toMap(EnumFacing::func_176742_j, enumFacing -> enumFacing));
        field_82609_l = (EnumFacing[])Arrays.stream(field_199792_n).sorted(Comparator.comparingInt(enumFacing -> enumFacing.field_176748_g)).toArray(EnumFacing[]::new);
        field_176754_o = (EnumFacing[])Arrays.stream(field_199792_n).filter(enumFacing -> enumFacing.func_176740_k().func_176722_c()).sorted(Comparator.comparingInt(enumFacing -> enumFacing.field_176760_i)).toArray(EnumFacing[]::new);
    }

    public static enum Plane implements Iterable<EnumFacing>,
    Predicate<EnumFacing>
    {
        HORIZONTAL(new EnumFacing[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new EnumFacing[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final EnumFacing[] field_209387_c;
        private final Axis[] field_209388_d;

        private Plane(EnumFacing[] enumFacingArray, Axis[] axisArray) {
            this.field_209387_c = enumFacingArray;
            this.field_209388_d = axisArray;
        }

        public EnumFacing func_179518_a(Random random) {
            return this.field_209387_c[random.nextInt(this.field_209387_c.length)];
        }

        @Override
        public boolean test(@Nullable EnumFacing enumFacing) {
            return enumFacing != null && enumFacing.func_176740_k().func_176716_d() == this;
        }

        @Override
        public Iterator<EnumFacing> iterator() {
            return Iterators.forArray((Object[])this.field_209387_c);
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EnumFacing)object);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int field_179528_c;
        private final String field_179525_d;

        private AxisDirection(int n2, String string2) {
            this.field_179528_c = n2;
            this.field_179525_d = string2;
        }

        public int func_179524_a() {
            return this.field_179528_c;
        }

        public String toString() {
            return this.field_179525_d;
        }
    }

    public static enum Axis implements Predicate<EnumFacing>,
    IStringSerializable
    {
        X("x"){

            @Override
            public int func_196052_a(int n, int n2, int n3) {
                return n;
            }

            @Override
            public double func_196051_a(double d, double d2, double d3) {
                return d;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumFacing)object);
            }
        }
        ,
        Y("y"){

            @Override
            public int func_196052_a(int n, int n2, int n3) {
                return n2;
            }

            @Override
            public double func_196051_a(double d, double d2, double d3) {
                return d2;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumFacing)object);
            }
        }
        ,
        Z("z"){

            @Override
            public int func_196052_a(int n, int n2, int n3) {
                return n3;
            }

            @Override
            public double func_196051_a(double d, double d2, double d3) {
                return d3;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumFacing)object);
            }
        };

        private static final Map<String, Axis> field_176725_d;
        private final String field_176726_e;

        private Axis(String string2) {
            this.field_176726_e = string2;
        }

        public String func_176719_a() {
            return this.field_176726_e;
        }

        public boolean func_200128_b() {
            return this == Y;
        }

        public boolean func_176722_c() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.field_176726_e;
        }

        @Override
        public boolean test(@Nullable EnumFacing enumFacing) {
            return enumFacing != null && enumFacing.func_176740_k() == this;
        }

        public Plane func_176716_d() {
            switch (this) {
                case X: 
                case Z: {
                    return Plane.HORIZONTAL;
                }
                case Y: {
                    return Plane.VERTICAL;
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        @Override
        public String func_176610_l() {
            return this.field_176726_e;
        }

        public abstract int func_196052_a(int var1, int var2, int var3);

        public abstract double func_196051_a(double var1, double var3, double var5);

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EnumFacing)object);
        }

        static {
            field_176725_d = Arrays.stream(Axis.values()).collect(Collectors.toMap(Axis::func_176719_a, axis -> axis));
        }
    }
}

