/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MobSpawnerBaseLogic {
    private static final Logger field_209160_a = LogManager.getLogger();
    private int field_98286_b = 20;
    private final List<WeightedSpawnerEntity> field_98285_e = Lists.newArrayList();
    private WeightedSpawnerEntity field_98282_f = new WeightedSpawnerEntity();
    private double field_98287_c;
    private double field_98284_d;
    private int field_98283_g = 200;
    private int field_98293_h = 800;
    private int field_98294_i = 4;
    private Entity field_98291_j;
    private int field_98292_k = 6;
    private int field_98289_l = 16;
    private int field_98290_m = 4;

    @Nullable
    private ResourceLocation func_190895_g() {
        String string = this.field_98282_f.func_185277_b().func_74779_i("id");
        try {
            return StringUtils.func_151246_b(string) ? null : new ResourceLocation(string);
        }
        catch (ResourceLocationException \u26032) {
            BlockPos blockPos = this.func_177221_b();
            field_209160_a.warn("Invalid entity id '{}' at spawner {}:[{},{},{}]", (Object)string, (Object)this.func_98271_a().field_73011_w.func_186058_p(), (Object)blockPos.func_177958_n(), (Object)blockPos.func_177956_o(), (Object)blockPos.func_177952_p());
            return null;
        }
    }

    public void func_200876_a(EntityType<?> entityType) {
        this.field_98282_f.func_185277_b().func_74778_a("id", IRegistry.field_212629_r.func_177774_c(entityType).toString());
    }

    private boolean func_98279_f() {
        BlockPos blockPos = this.func_177221_b();
        return this.func_98271_a().func_212417_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, this.field_98289_l);
    }

    public void func_98278_g() {
        if (!this.func_98279_f()) {
            this.field_98284_d = this.field_98287_c;
            return;
        }
        BlockPos blockPos = this.func_177221_b();
        if (this.func_98271_a().field_72995_K) {
            double d = (float)blockPos.func_177958_n() + this.func_98271_a().field_73012_v.nextFloat();
            \u2603 = (float)blockPos.func_177956_o() + this.func_98271_a().field_73012_v.nextFloat();
            \u2603 = (float)blockPos.func_177952_p() + this.func_98271_a().field_73012_v.nextFloat();
            this.func_98271_a().func_195594_a(Particles.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
            this.func_98271_a().func_195594_a(Particles.field_197631_x, d, \u2603, \u2603, 0.0, 0.0, 0.0);
            if (this.field_98286_b > 0) {
                --this.field_98286_b;
            }
            this.field_98284_d = this.field_98287_c;
            this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
        } else {
            if (this.field_98286_b == -1) {
                this.func_98273_j();
            }
            if (this.field_98286_b > 0) {
                --this.field_98286_b;
                return;
            }
            boolean \u26037 = false;
            for (int i = 0; i < this.field_98294_i; ++i) {
                NBTTagCompound nBTTagCompound = this.field_98282_f.func_185277_b();
                NBTTagList \u26032 = nBTTagCompound.func_150295_c("Pos", 6);
                World \u26033 = this.func_98271_a();
                Entity \u26034 = AnvilChunkLoader.func_186054_a(nBTTagCompound, \u26033, \u2603 = (\u2603 = \u26032.size()) >= 1 ? \u26032.func_150309_d(0) : (double)blockPos.func_177958_n() + (\u26033.field_73012_v.nextDouble() - \u26033.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5, \u2603 = \u2603 >= 2 ? \u26032.func_150309_d(1) : (double)(blockPos.func_177956_o() + \u26033.field_73012_v.nextInt(3) - 1), \u2603 = \u2603 >= 3 ? \u26032.func_150309_d(2) : (double)blockPos.func_177952_p() + (\u26033.field_73012_v.nextDouble() - \u26033.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5, false);
                if (\u26034 == null) {
                    this.func_98273_j();
                    return;
                }
                int \u26035 = \u26033.func_72872_a(\u26034.getClass(), new AxisAlignedBB(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n() + 1, blockPos.func_177956_o() + 1, blockPos.func_177952_p() + 1).func_186662_g(this.field_98290_m)).size();
                if (\u26035 >= this.field_98292_k) {
                    this.func_98273_j();
                    return;
                }
                EntityLiving \u26036 = \u26034 instanceof EntityLiving ? (EntityLiving)\u26034 : null;
                \u26034.func_70012_b(\u26034.field_70165_t, \u26034.field_70163_u, \u26034.field_70161_v, \u26033.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (\u26036 != null && (!\u26036.func_205020_a(\u26033, true) || !\u26036.func_70058_J())) continue;
                if (this.field_98282_f.func_185277_b().func_186856_d() == 1 && this.field_98282_f.func_185277_b().func_150297_b("id", 8) && \u26034 instanceof EntityLiving) {
                    ((EntityLiving)\u26034).func_204210_a(\u26033.func_175649_E(new BlockPos(\u26034)), null, null);
                }
                AnvilChunkLoader.func_186052_a(\u26034, \u26033);
                \u26033.func_175718_b(2004, blockPos, 0);
                if (\u26036 != null) {
                    \u26036.func_70656_aK();
                }
                \u26037 = true;
            }
            if (\u26037) {
                this.func_98273_j();
            }
        }
    }

    private void func_98273_j() {
        this.field_98286_b = this.field_98293_h <= this.field_98283_g ? this.field_98283_g : this.field_98283_g + this.func_98271_a().field_73012_v.nextInt(this.field_98293_h - this.field_98283_g);
        if (!this.field_98285_e.isEmpty()) {
            this.func_184993_a(WeightedRandom.func_76271_a(this.func_98271_a().field_73012_v, this.field_98285_e));
        }
        this.func_98267_a(1);
    }

    public void func_98270_a(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        this.field_98286_b = nBTTagCompound2.func_74765_d("Delay");
        this.field_98285_e.clear();
        if (nBTTagCompound2.func_150297_b("SpawnPotentials", 9)) {
            NBTTagList nBTTagList = nBTTagCompound2.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                this.field_98285_e.add(new WeightedSpawnerEntity(nBTTagList.func_150305_b(i)));
            }
        }
        if (nBTTagCompound2.func_150297_b("SpawnData", 10)) {
            this.func_184993_a(new WeightedSpawnerEntity(1, nBTTagCompound2.func_74775_l("SpawnData")));
        } else if (!this.field_98285_e.isEmpty()) {
            this.func_184993_a(WeightedRandom.func_76271_a(this.func_98271_a().field_73012_v, this.field_98285_e));
        }
        if (nBTTagCompound2.func_150297_b("MinSpawnDelay", 99)) {
            this.field_98283_g = nBTTagCompound2.func_74765_d("MinSpawnDelay");
            this.field_98293_h = nBTTagCompound2.func_74765_d("MaxSpawnDelay");
            this.field_98294_i = nBTTagCompound2.func_74765_d("SpawnCount");
        }
        if (nBTTagCompound2.func_150297_b("MaxNearbyEntities", 99)) {
            this.field_98292_k = nBTTagCompound2.func_74765_d("MaxNearbyEntities");
            this.field_98289_l = nBTTagCompound2.func_74765_d("RequiredPlayerRange");
        }
        if (nBTTagCompound2.func_150297_b("SpawnRange", 99)) {
            this.field_98290_m = nBTTagCompound2.func_74765_d("SpawnRange");
        }
        if (this.func_98271_a() != null) {
            this.field_98291_j = null;
        }
    }

    public NBTTagCompound func_189530_b(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        ResourceLocation resourceLocation = this.func_190895_g();
        if (resourceLocation == null) {
            return nBTTagCompound2;
        }
        nBTTagCompound2.func_74777_a("Delay", (short)this.field_98286_b);
        nBTTagCompound2.func_74777_a("MinSpawnDelay", (short)this.field_98283_g);
        nBTTagCompound2.func_74777_a("MaxSpawnDelay", (short)this.field_98293_h);
        nBTTagCompound2.func_74777_a("SpawnCount", (short)this.field_98294_i);
        nBTTagCompound2.func_74777_a("MaxNearbyEntities", (short)this.field_98292_k);
        nBTTagCompound2.func_74777_a("RequiredPlayerRange", (short)this.field_98289_l);
        nBTTagCompound2.func_74777_a("SpawnRange", (short)this.field_98290_m);
        nBTTagCompound2.func_74782_a("SpawnData", this.field_98282_f.func_185277_b().func_74737_b());
        NBTTagList \u26032 = new NBTTagList();
        if (this.field_98285_e.isEmpty()) {
            \u26032.add(this.field_98282_f.func_185278_a());
        } else {
            for (WeightedSpawnerEntity weightedSpawnerEntity : this.field_98285_e) {
                \u26032.add(weightedSpawnerEntity.func_185278_a());
            }
        }
        nBTTagCompound2.func_74782_a("SpawnPotentials", \u26032);
        return nBTTagCompound2;
    }

    public boolean func_98268_b(int n) {
        if (n == 1 && this.func_98271_a().field_72995_K) {
            this.field_98286_b = this.field_98283_g;
            return true;
        }
        return false;
    }

    public void func_184993_a(WeightedSpawnerEntity weightedSpawnerEntity) {
        this.field_98282_f = weightedSpawnerEntity;
    }

    public abstract void func_98267_a(int var1);

    public abstract World func_98271_a();

    public abstract BlockPos func_177221_b();
}

