/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.AbstractResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class FilePack
extends AbstractResourcePack {
    public static final Splitter field_195774_b = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private ZipFile field_195775_c;

    public FilePack(File file) {
        super(file);
    }

    private ZipFile func_195773_b() throws IOException {
        if (this.field_195775_c == null) {
            this.field_195775_c = new ZipFile(this.field_195771_a);
        }
        return this.field_195775_c;
    }

    @Override
    protected InputStream func_195766_a(String string) throws IOException {
        ZipFile zipFile = this.func_195773_b();
        ZipEntry \u26032 = zipFile.getEntry(string);
        if (\u26032 == null) {
            throw new ResourcePackFileNotFoundException(this.field_195771_a, string);
        }
        return zipFile.getInputStream(\u26032);
    }

    @Override
    public boolean func_195768_c(String string) {
        try {
            return this.func_195773_b().getEntry(string) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Set<String> func_195759_a(ResourcePackType resourcePackType) {
        try {
            ZipFile zipFile = this.func_195773_b();
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet \u26032 = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String \u26033 = zipEntry.getName();
            if (!\u26033.startsWith(resourcePackType.func_198956_a() + "/") || (\u2603 = Lists.newArrayList((Iterable)field_195774_b.split((CharSequence)\u26033))).size() <= 1) continue;
            String \u26034 = (String)\u2603.get(1);
            if (\u26034.equals(\u26034.toLowerCase(Locale.ROOT))) {
                \u26032.add(\u26034);
                continue;
            }
            this.func_195769_d(\u26034);
        }
        return \u26032;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.field_195775_c != null) {
            IOUtils.closeQuietly((Closeable)this.field_195775_c);
            this.field_195775_c = null;
        }
    }

    @Override
    public Collection<ResourceLocation> func_195758_a(ResourcePackType resourcePackType, String string, int n, Predicate<String> predicate) {
        try {
            ZipFile zipFile = this.func_195773_b();
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList \u26032 = Lists.newArrayList();
        String \u26033 = resourcePackType.func_198956_a() + "/";
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().startsWith(\u26033) || (\u2603 = zipEntry.getName().substring(\u26033.length())).endsWith(".mcmeta") || (\u2603 = \u2603.indexOf(47)) < 0 || !(\u2603 = \u2603.substring(\u2603 + 1)).startsWith(string + "/") || (\u2603 = \u2603.substring(string.length() + 2).split("/")).length < n + 1 || !predicate.test(\u2603)) continue;
            String \u26034 = \u2603.substring(0, \u2603);
            \u26032.add(new ResourceLocation(\u26034, \u2603));
        }
        return \u26032;
    }
}

