/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractResourcePack
implements IResourcePack {
    private static final Logger field_195772_b = LogManager.getLogger();
    protected final File field_195771_a;

    public AbstractResourcePack(File file) {
        this.field_195771_a = file;
    }

    private static String func_195765_c(ResourcePackType resourcePackType, ResourceLocation resourceLocation) {
        return String.format("%s/%s/%s", resourcePackType.func_198956_a(), resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
    }

    protected static String func_195767_a(File file, File file2) {
        return file.toURI().relativize(file2.toURI()).getPath();
    }

    @Override
    public InputStream func_195761_a(ResourcePackType resourcePackType, ResourceLocation resourceLocation) throws IOException {
        return this.func_195766_a(AbstractResourcePack.func_195765_c(resourcePackType, resourceLocation));
    }

    @Override
    public boolean func_195764_b(ResourcePackType resourcePackType, ResourceLocation resourceLocation) {
        return this.func_195768_c(AbstractResourcePack.func_195765_c(resourcePackType, resourceLocation));
    }

    protected abstract InputStream func_195766_a(String var1) throws IOException;

    protected abstract boolean func_195768_c(String var1);

    protected void func_195769_d(String string) {
        field_195772_b.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)string, (Object)this.field_195771_a);
    }

    @Override
    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> iMetadataSectionSerializer) throws IOException {
        return AbstractResourcePack.func_195770_a(iMetadataSectionSerializer, this.func_195766_a("pack.mcmeta"));
    }

    @Nullable
    public static <T> T func_195770_a(IMetadataSectionSerializer<T> iMetadataSectionSerializer, InputStream inputStream) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            JsonObject jsonObject = JsonUtils.func_212743_a(bufferedReader);
        }
        catch (JsonParseException | IOException throwable) {
            field_195772_b.error("Couldn't load {} metadata", (Object)iMetadataSectionSerializer.func_110483_a(), (Object)throwable);
            return null;
        }
        if (!jsonObject.has(iMetadataSectionSerializer.func_110483_a())) {
            return null;
        }
        try {
            return iMetadataSectionSerializer.func_195812_a(JsonUtils.func_152754_s(jsonObject, iMetadataSectionSerializer.func_110483_a()));
        }
        catch (JsonParseException jsonParseException) {
            field_195772_b.error("Couldn't load {} metadata", (Object)iMetadataSectionSerializer.func_110483_a(), (Object)jsonParseException);
            return null;
        }
    }

    @Override
    public String func_195762_a() {
        return this.field_195771_a.getName();
    }
}

