/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class WalkNodeProcessor
extends NodeProcessor {
    protected float field_176183_h;

    @Override
    public void func_186315_a(IBlockReader iBlockReader, EntityLiving entityLiving) {
        super.func_186315_a(iBlockReader, entityLiving);
        this.field_176183_h = entityLiving.func_184643_a(PathNodeType.WATER);
    }

    @Override
    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WATER, this.field_176183_h);
        super.func_176163_a();
    }

    @Override
    public PathPoint func_186318_b() {
        Object \u26033;
        BlockPos \u26032;
        int n;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            n = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            \u26032 = new BlockPos.MutableBlockPos(MathHelper.func_76128_c(this.field_186326_b.field_70165_t), n, MathHelper.func_76128_c(this.field_186326_b.field_70161_v));
            \u26033 = this.field_176169_a.func_180495_p(\u26032).func_177230_c();
            while (\u26033 == Blocks.field_150355_j) {
                ((BlockPos.MutableBlockPos)\u26032).func_181079_c(MathHelper.func_76128_c(this.field_186326_b.field_70165_t), ++n, MathHelper.func_76128_c(this.field_186326_b.field_70161_v));
                \u26033 = this.field_176169_a.func_180495_p(\u26032).func_177230_c();
            }
            --n;
        } else if (this.field_186326_b.field_70122_E) {
            n = MathHelper.func_76128_c(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5);
        } else {
            \u26032 = new BlockPos(this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(\u26032).func_196958_f() || this.field_176169_a.func_180495_p(\u26032).func_196957_g(this.field_176169_a, \u26032, PathType.LAND)) && \u26032.func_177956_o() > 0) {
                \u26032 = \u26032.func_177977_b();
            }
            n = \u26032.func_177984_a().func_177956_o();
        }
        \u26032 = new BlockPos(this.field_186326_b);
        \u26033 = this.func_186331_a(this.field_186326_b, \u26032.func_177958_n(), n, \u26032.func_177952_p());
        if (this.field_186326_b.func_184643_a((PathNodeType)((Object)\u26033)) < 0.0f) {
            HashSet \u26034 = Sets.newHashSet();
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)n, this.field_186326_b.func_174813_aQ().field_72339_c));
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)n, this.field_186326_b.func_174813_aQ().field_72334_f));
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)n, this.field_186326_b.func_174813_aQ().field_72339_c));
            \u26034.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)n, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockPos : \u26034) {
                PathNodeType pathNodeType = this.func_186329_a(this.field_186326_b, blockPos);
                if (!(this.field_186326_b.func_184643_a(pathNodeType) >= 0.0f)) continue;
                return this.func_176159_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            }
        }
        return this.func_176159_a(\u26032.func_177958_n(), n, \u26032.func_177952_p());
    }

    @Override
    public PathPoint func_186325_a(double d, double d2, double d3) {
        return this.func_176159_a(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3));
    }

    @Override
    public int func_186320_a(PathPoint[] pathPointArray, PathPoint pathPoint, PathPoint pathPoint2, float f) {
        int n = 0;
        \u2603 = 0;
        PathNodeType \u26032 = this.func_186331_a(this.field_186326_b, pathPoint.field_75839_a, pathPoint.field_75837_b + 1, pathPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(\u26032) >= 0.0f) {
            \u2603 = MathHelper.func_76141_d(Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        double \u26033 = WalkNodeProcessor.func_197682_a(this.field_176169_a, new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c));
        PathPoint \u26034 = this.func_186332_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u2603, \u26033, EnumFacing.SOUTH);
        PathPoint \u26035 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c, \u2603, \u26033, EnumFacing.WEST);
        PathPoint \u26036 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c, \u2603, \u26033, EnumFacing.EAST);
        PathPoint \u26037 = this.func_186332_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u2603, \u26033, EnumFacing.NORTH);
        if (\u26034 != null && !\u26034.field_75842_i && \u26034.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u26034;
        }
        if (\u26035 != null && !\u26035.field_75842_i && \u26035.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u26035;
        }
        if (\u26036 != null && !\u26036.field_75842_i && \u26036.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u26036;
        }
        if (\u26037 != null && !\u26037.field_75842_i && \u26037.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u26037;
        }
        boolean \u26038 = \u26037 == null || \u26037.field_186287_m == PathNodeType.OPEN || \u26037.field_186286_l != 0.0f;
        boolean \u26039 = \u26034 == null || \u26034.field_186287_m == PathNodeType.OPEN || \u26034.field_186286_l != 0.0f;
        boolean \u260310 = \u26036 == null || \u26036.field_186287_m == PathNodeType.OPEN || \u26036.field_186286_l != 0.0f;
        boolean bl = \u2603 = \u26035 == null || \u26035.field_186287_m == PathNodeType.OPEN || \u26035.field_186286_l != 0.0f;
        if (\u26038 && \u2603 && (\u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u2603, \u26033, EnumFacing.NORTH)) != null && !\u2603.field_75842_i && \u2603.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u2603;
        }
        if (\u26038 && \u260310 && (\u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c - 1, \u2603, \u26033, EnumFacing.NORTH)) != null && !\u2603.field_75842_i && \u2603.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u2603;
        }
        if (\u26039 && \u2603 && (\u2603 = this.func_186332_a(pathPoint.field_75839_a - 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u2603, \u26033, EnumFacing.SOUTH)) != null && !\u2603.field_75842_i && \u2603.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u2603;
        }
        if (\u26039 && \u260310 && (\u2603 = this.func_186332_a(pathPoint.field_75839_a + 1, pathPoint.field_75837_b, pathPoint.field_75838_c + 1, \u2603, \u26033, EnumFacing.SOUTH)) != null && !\u2603.field_75842_i && \u2603.func_75829_a(pathPoint2) < f) {
            pathPointArray[n++] = \u2603;
        }
        return n;
    }

    @Nullable
    private PathPoint func_186332_a(int n, int n2, int n3, int n4, double d, EnumFacing enumFacing) {
        PathPoint pathPoint = null;
        BlockPos \u26032 = new BlockPos(n, n2, n3);
        double \u26033 = WalkNodeProcessor.func_197682_a(this.field_176169_a, \u26032);
        if (\u26033 - d > 1.125) {
            return null;
        }
        PathNodeType \u26034 = this.func_186331_a(this.field_186326_b, n, n2, n3);
        float \u26035 = this.field_186326_b.func_184643_a(\u26034);
        double \u26036 = (double)this.field_186326_b.field_70130_N / 2.0;
        if (\u26035 >= 0.0f) {
            pathPoint = this.func_176159_a(n, n2, n3);
            pathPoint.field_186287_m = \u26034;
            pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, \u26035);
        }
        if (\u26034 == PathNodeType.WALKABLE) {
            return pathPoint;
        }
        if (pathPoint == null && n4 > 0 && \u26034 != PathNodeType.FENCE && \u26034 != PathNodeType.TRAPDOOR && (pathPoint = this.func_186332_a(n, n2 + 1, n3, n4 - 1, d, enumFacing)) != null && (pathPoint.field_186287_m == PathNodeType.OPEN || pathPoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f && !this.field_186326_b.field_70170_p.func_195586_b(null, \u2603 = new AxisAlignedBB((\u2603 = (double)(n - enumFacing.func_82601_c()) + 0.5) - \u26036, (double)n2 + 0.001, (\u2603 = (double)(n3 - enumFacing.func_82599_e()) + 0.5) - \u26036, \u2603 + \u26036, (double)this.field_186326_b.field_70131_O + WalkNodeProcessor.func_197682_a(this.field_176169_a, \u26032.func_177984_a()) - 0.002, \u2603 + \u26036))) {
            pathPoint = null;
        }
        if (\u26034 == PathNodeType.WATER && !this.func_186322_e()) {
            if (this.func_186331_a(this.field_186326_b, n, n2 - 1, n3) != PathNodeType.WATER) {
                return pathPoint;
            }
            while (n2 > 0) {
                if ((\u26034 = this.func_186331_a(this.field_186326_b, n, --n2, n3)) == PathNodeType.WATER) {
                    pathPoint = this.func_176159_a(n, n2, n3);
                    pathPoint.field_186287_m = \u26034;
                    pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, this.field_186326_b.func_184643_a(\u26034));
                    continue;
                }
                return pathPoint;
            }
        }
        if (\u26034 == PathNodeType.OPEN) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)n - \u26036 + 0.5, (double)n2 + 0.001, (double)n3 - \u26036 + 0.5, (double)n + \u26036 + 0.5, (float)n2 + this.field_186326_b.field_70131_O, (double)n3 + \u26036 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_195586_b(null, axisAlignedBB)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (\u2603 = this.func_186331_a(this.field_186326_b, n, n2 - 1, n3)) == PathNodeType.BLOCKED) {
                pathPoint = this.func_176159_a(n, n2, n3);
                pathPoint.field_186287_m = PathNodeType.WALKABLE;
                pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, \u26035);
                return pathPoint;
            }
            int n5 = 0;
            while (n2 > 0 && \u26034 == PathNodeType.OPEN) {
                --n2;
                if (n5++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                \u26034 = this.func_186331_a(this.field_186326_b, n, n2, n3);
                \u26035 = this.field_186326_b.func_184643_a(\u26034);
                if (\u26034 != PathNodeType.OPEN && \u26035 >= 0.0f) {
                    pathPoint = this.func_176159_a(n, n2, n3);
                    pathPoint.field_186287_m = \u26034;
                    pathPoint.field_186286_l = Math.max(pathPoint.field_186286_l, \u26035);
                    break;
                }
                if (!(\u26035 < 0.0f)) continue;
                return null;
            }
        }
        return pathPoint;
    }

    public static double func_197682_a(IBlockReader iBlockReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        VoxelShape voxelShape = iBlockReader.func_180495_p(\u2603).func_196952_d(iBlockReader, \u2603);
        return (double)\u2603.func_177956_o() + (voxelShape.func_197766_b() ? 0.0 : voxelShape.func_197758_c(EnumFacing.Axis.Y));
    }

    @Override
    public PathNodeType func_186319_a(IBlockReader iBlockReader, int n, int n2, int n3, EntityLiving entityLiving2, int n4, int n5, int n6, boolean bl, boolean bl2) {
        EntityLiving entityLiving2;
        EnumSet<PathNodeType> enumSet = EnumSet.noneOf(PathNodeType.class);
        PathNodeType \u26032 = PathNodeType.BLOCKED;
        double \u26033 = (double)entityLiving2.field_70130_N / 2.0;
        BlockPos \u26034 = new BlockPos(entityLiving2);
        \u26032 = this.func_193577_a(iBlockReader, n, n2, n3, n4, n5, n6, bl, bl2, enumSet, \u26032, \u26034);
        if (enumSet.contains((Object)PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType \u26035 = PathNodeType.BLOCKED;
        for (PathNodeType pathNodeType : enumSet) {
            if (entityLiving2.func_184643_a(pathNodeType) < 0.0f) {
                return pathNodeType;
            }
            if (!(entityLiving2.func_184643_a(pathNodeType) >= entityLiving2.func_184643_a(\u26035))) continue;
            \u26035 = pathNodeType;
        }
        if (\u26032 == PathNodeType.OPEN && entityLiving2.func_184643_a(\u26035) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return \u26035;
    }

    public PathNodeType func_193577_a(IBlockReader iBlockReader, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, EnumSet<PathNodeType> enumSet, PathNodeType pathNodeType2, BlockPos blockPos) {
        PathNodeType pathNodeType2;
        for (int i = 0; i < n4; ++i) {
            for (\u2603 = 0; \u2603 < n5; ++\u2603) {
                for (\u2603 = 0; \u2603 < n6; ++\u2603) {
                    \u2603 = i + n;
                    \u2603 = \u2603 + n2;
                    \u2603 = \u2603 + n3;
                    PathNodeType pathNodeType3 = this.func_186330_a(iBlockReader, \u2603, \u2603, \u2603);
                    if (pathNodeType3 == PathNodeType.DOOR_WOOD_CLOSED && bl && bl2) {
                        pathNodeType3 = PathNodeType.WALKABLE;
                    }
                    if (pathNodeType3 == PathNodeType.DOOR_OPEN && !bl2) {
                        pathNodeType3 = PathNodeType.BLOCKED;
                    }
                    if (pathNodeType3 == PathNodeType.RAIL && !(iBlockReader.func_180495_p(blockPos).func_177230_c() instanceof BlockRailBase) && !(iBlockReader.func_180495_p(blockPos.func_177977_b()).func_177230_c() instanceof BlockRailBase)) {
                        pathNodeType3 = PathNodeType.FENCE;
                    }
                    if (i == 0 && \u2603 == 0 && \u2603 == 0) {
                        pathNodeType2 = pathNodeType3;
                    }
                    enumSet.add(pathNodeType3);
                }
            }
        }
        return pathNodeType2;
    }

    private PathNodeType func_186329_a(EntityLiving entityLiving, BlockPos blockPos) {
        return this.func_186331_a(entityLiving, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    private PathNodeType func_186331_a(EntityLiving entityLiving, int n, int n2, int n3) {
        return this.func_186319_a(this.field_176169_a, n, n2, n3, entityLiving, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    @Override
    public PathNodeType func_186330_a(IBlockReader iBlockReader2, int n, int n2, int n3) {
        IBlockReader iBlockReader2;
        PathNodeType \u26033 = this.func_189553_b(iBlockReader2, n, n2, n3);
        if (\u26033 == PathNodeType.OPEN && n2 >= 1) {
            Block block = iBlockReader2.func_180495_p(new BlockPos(n, n2 - 1, n3)).func_177230_c();
            PathNodeType \u26032 = this.func_189553_b(iBlockReader2, n, n2 - 1, n3);
            PathNodeType pathNodeType = \u26033 = \u26032 == PathNodeType.WALKABLE || \u26032 == PathNodeType.OPEN || \u26032 == PathNodeType.WATER || \u26032 == PathNodeType.LAVA ? PathNodeType.OPEN : PathNodeType.WALKABLE;
            if (\u26032 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_196814_hQ) {
                \u26033 = PathNodeType.DAMAGE_FIRE;
            }
            if (\u26032 == PathNodeType.DAMAGE_CACTUS) {
                \u26033 = PathNodeType.DAMAGE_CACTUS;
            }
        }
        \u26033 = this.func_193578_a(iBlockReader2, n, n2, n3, \u26033);
        return \u26033;
    }

    public PathNodeType func_193578_a(IBlockReader iBlockReader, int n, int n2, int n3, PathNodeType \u260322) {
        PathNodeType \u260322;
        if (\u260322 == PathNodeType.WALKABLE) {
            try (BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (int i = -1; i <= 1; ++i) {
                    for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                        if (i == 0 && \u2603 == 0) continue;
                        Block block = iBlockReader.func_180495_p(pooledMutableBlockPos.func_181079_c(i + n, n2, \u2603 + n3)).func_177230_c();
                        if (block == Blocks.field_150434_aF) {
                            \u260322 = PathNodeType.DANGER_CACTUS;
                            continue;
                        }
                        if (block != Blocks.field_150480_ab) continue;
                        \u260322 = PathNodeType.DANGER_FIRE;
                    }
                }
            }
        }
        return \u260322;
    }

    protected PathNodeType func_189553_b(IBlockReader iBlockReader, int n, int n2, int n3) {
        BlockPos blockPos = new BlockPos(n, n2, n3);
        IBlockState \u26032 = iBlockReader.func_180495_p(blockPos);
        Block \u26033 = \u26032.func_177230_c();
        Material \u26034 = \u26032.func_185904_a();
        if (\u26032.func_196958_f()) {
            return PathNodeType.OPEN;
        }
        if (\u26033.func_203417_a(BlockTags.field_212185_E) || \u26033 == Blocks.field_196651_dG) {
            return PathNodeType.TRAPDOOR;
        }
        if (\u26033 == Blocks.field_150480_ab) {
            return PathNodeType.DAMAGE_FIRE;
        }
        if (\u26033 == Blocks.field_150434_aF) {
            return PathNodeType.DAMAGE_CACTUS;
        }
        if (\u26033 instanceof BlockDoor && \u26034 == Material.field_151575_d && !\u26032.func_177229_b(BlockDoor.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_WOOD_CLOSED;
        }
        if (\u26033 instanceof BlockDoor && \u26034 == Material.field_151573_f && !\u26032.func_177229_b(BlockDoor.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_IRON_CLOSED;
        }
        if (\u26033 instanceof BlockDoor && \u26032.func_177229_b(BlockDoor.field_176519_b).booleanValue()) {
            return PathNodeType.DOOR_OPEN;
        }
        if (\u26033 instanceof BlockRailBase) {
            return PathNodeType.RAIL;
        }
        if (\u26033 instanceof BlockFence || \u26033 instanceof BlockWall || \u26033 instanceof BlockFenceGate && !\u26032.func_177229_b(BlockFenceGate.field_176466_a).booleanValue()) {
            return PathNodeType.FENCE;
        }
        IFluidState \u26035 = iBlockReader.func_204610_c(blockPos);
        if (\u26035.func_206884_a(FluidTags.field_206959_a)) {
            return PathNodeType.WATER;
        }
        if (\u26035.func_206884_a(FluidTags.field_206960_b)) {
            return PathNodeType.LAVA;
        }
        if (\u26032.func_196957_g(iBlockReader, blockPos, PathType.LAND)) {
            return PathNodeType.OPEN;
        }
        return PathNodeType.BLOCKED;
    }
}

