/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.util.concurrent.Futures;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ServerRecipePlacer;
import net.minecraft.item.crafting.ServerRecipePlacerFurnace;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketConfirmTeleport;
import net.minecraft.network.play.client.CPacketConfirmTransaction;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketEditBook;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketNBTQueryEntity;
import net.minecraft.network.play.client.CPacketNBTQueryTileEntity;
import net.minecraft.network.play.client.CPacketPickItem;
import net.minecraft.network.play.client.CPacketPlaceRecipe;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerAbilities;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketRecipeInfo;
import net.minecraft.network.play.client.CPacketRenameItem;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketSeenAdvancements;
import net.minecraft.network.play.client.CPacketSelectTrade;
import net.minecraft.network.play.client.CPacketSpectate;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.network.play.client.CPacketTabComplete;
import net.minecraft.network.play.client.CPacketUpdateBeacon;
import net.minecraft.network.play.client.CPacketUpdateCommandBlock;
import net.minecraft.network.play.client.CPacketUpdateCommandMinecart;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.network.play.client.CPacketUpdateStructureBlock;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketConfirmTransaction;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketKeepAlive;
import net.minecraft.network.play.server.SPacketMoveVehicle;
import net.minecraft.network.play.server.SPacketNBTQueryResponse;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketTabComplete;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetHandlerPlayServer
implements INetHandlerPlayServer,
ITickable {
    private static final Logger field_147370_c = LogManager.getLogger();
    public final NetworkManager field_147371_a;
    private final MinecraftServer field_147367_d;
    public EntityPlayerMP field_147369_b;
    private int field_147368_e;
    private long field_194402_f;
    private boolean field_194403_g;
    private long field_194404_h;
    private int field_147374_l;
    private int field_147375_m;
    private final IntHashMap<Short> field_147372_n = new IntHashMap();
    private double field_184349_l;
    private double field_184350_m;
    private double field_184351_n;
    private double field_184352_o;
    private double field_184353_p;
    private double field_184354_q;
    private Entity field_184355_r;
    private double field_184356_s;
    private double field_184357_t;
    private double field_184358_u;
    private double field_184359_v;
    private double field_184360_w;
    private double field_184361_x;
    private Vec3d field_184362_y;
    private int field_184363_z;
    private int field_184343_A;
    private boolean field_184344_B;
    private int field_147365_f;
    private boolean field_184345_D;
    private int field_184346_E;
    private int field_184347_F;
    private int field_184348_G;

    public NetHandlerPlayServer(MinecraftServer minecraftServer, NetworkManager networkManager, EntityPlayerMP entityPlayerMP) {
        this.field_147367_d = minecraftServer;
        this.field_147371_a = networkManager;
        networkManager.func_150719_a(this);
        this.field_147369_b = entityPlayerMP;
        entityPlayerMP.field_71135_a = this;
    }

    @Override
    public void func_73660_a() {
        this.func_184342_d();
        this.field_147369_b.func_71127_g();
        this.field_147369_b.func_70080_a(this.field_184349_l, this.field_184350_m, this.field_184351_n, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
        ++this.field_147368_e;
        this.field_184348_G = this.field_184347_F;
        if (this.field_184344_B) {
            if (++this.field_147365_f > 80) {
                field_147370_c.warn("{} was kicked for floating too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                this.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.flying", new Object[0]));
                return;
            }
        } else {
            this.field_184344_B = false;
            this.field_147365_f = 0;
        }
        this.field_184355_r = this.field_147369_b.func_184208_bv();
        if (this.field_184355_r == this.field_147369_b || this.field_184355_r.func_184179_bs() != this.field_147369_b) {
            this.field_184355_r = null;
            this.field_184345_D = false;
            this.field_184346_E = 0;
        } else {
            this.field_184356_s = this.field_184355_r.field_70165_t;
            this.field_184357_t = this.field_184355_r.field_70163_u;
            this.field_184358_u = this.field_184355_r.field_70161_v;
            this.field_184359_v = this.field_184355_r.field_70165_t;
            this.field_184360_w = this.field_184355_r.field_70163_u;
            this.field_184361_x = this.field_184355_r.field_70161_v;
            if (this.field_184345_D && this.field_147369_b.func_184208_bv().func_184179_bs() == this.field_147369_b) {
                if (++this.field_184346_E > 80) {
                    field_147370_c.warn("{} was kicked for floating a vehicle too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                    this.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.flying", new Object[0]));
                    return;
                }
            } else {
                this.field_184345_D = false;
                this.field_184346_E = 0;
            }
        }
        this.field_147367_d.field_71304_b.func_76320_a("keepAlive");
        long l = Util.func_211177_b();
        if (l - this.field_194402_f >= 15000L) {
            if (this.field_194403_g) {
                this.func_194028_b(new TextComponentTranslation("disconnect.timeout", new Object[0]));
            } else {
                this.field_194403_g = true;
                this.field_194402_f = l;
                this.field_194404_h = l;
                this.func_147359_a(new SPacketKeepAlive(this.field_194404_h));
            }
        }
        this.field_147367_d.field_71304_b.func_76319_b();
        if (this.field_147374_l > 0) {
            --this.field_147374_l;
        }
        if (this.field_147375_m > 0) {
            --this.field_147375_m;
        }
        if (this.field_147369_b.func_154331_x() > 0L && this.field_147367_d.func_143007_ar() > 0 && Util.func_211177_b() - this.field_147369_b.func_154331_x() > (long)(this.field_147367_d.func_143007_ar() * 1000 * 60)) {
            this.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.idling", new Object[0]));
        }
    }

    public void func_184342_d() {
        this.field_184349_l = this.field_147369_b.field_70165_t;
        this.field_184350_m = this.field_147369_b.field_70163_u;
        this.field_184351_n = this.field_147369_b.field_70161_v;
        this.field_184352_o = this.field_147369_b.field_70165_t;
        this.field_184353_p = this.field_147369_b.field_70163_u;
        this.field_184354_q = this.field_147369_b.field_70161_v;
    }

    public NetworkManager func_147362_b() {
        return this.field_147371_a;
    }

    public void func_194028_b(ITextComponent iTextComponent) {
        this.field_147371_a.func_201058_a(new SPacketDisconnect(iTextComponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.field_147371_a.func_150718_a(iTextComponent)));
        this.field_147371_a.func_150721_g();
        Futures.getUnchecked(this.field_147367_d.func_152344_a(this.field_147371_a::func_179293_l));
    }

    @Override
    public void func_147358_a(CPacketInput cPacketInput) {
        PacketThreadUtil.func_180031_a(cPacketInput, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_110430_a(cPacketInput.func_149620_c(), cPacketInput.func_192620_b(), cPacketInput.func_149618_e(), cPacketInput.func_149617_f());
    }

    private static boolean func_183006_b(CPacketPlayer cPacketPlayer) {
        if (!(Doubles.isFinite((double)cPacketPlayer.func_186997_a(0.0)) && Doubles.isFinite((double)cPacketPlayer.func_186996_b(0.0)) && Doubles.isFinite((double)cPacketPlayer.func_187000_c(0.0)) && Floats.isFinite((float)cPacketPlayer.func_186998_b(0.0f)) && Floats.isFinite((float)cPacketPlayer.func_186999_a(0.0f)))) {
            return true;
        }
        return Math.abs(cPacketPlayer.func_186997_a(0.0)) > 3.0E7 || Math.abs(cPacketPlayer.func_186996_b(0.0)) > 3.0E7 || Math.abs(cPacketPlayer.func_187000_c(0.0)) > 3.0E7;
    }

    private static boolean func_184341_b(CPacketVehicleMove cPacketVehicleMove) {
        return !Doubles.isFinite((double)cPacketVehicleMove.func_187004_a()) || !Doubles.isFinite((double)cPacketVehicleMove.func_187002_b()) || !Doubles.isFinite((double)cPacketVehicleMove.func_187003_c()) || !Floats.isFinite((float)cPacketVehicleMove.func_187005_e()) || !Floats.isFinite((float)cPacketVehicleMove.func_187006_d());
    }

    @Override
    public void func_184338_a(CPacketVehicleMove cPacketVehicleMove) {
        PacketThreadUtil.func_180031_a(cPacketVehicleMove, this, this.field_147369_b.func_71121_q());
        if (NetHandlerPlayServer.func_184341_b(cPacketVehicleMove)) {
            this.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.invalid_vehicle_movement", new Object[0]));
            return;
        }
        Entity entity = this.field_147369_b.func_184208_bv();
        if (entity != this.field_147369_b && entity.func_184179_bs() == this.field_147369_b && entity == this.field_184355_r) {
            WorldServer worldServer = this.field_147369_b.func_71121_q();
            double \u26032 = entity.field_70165_t;
            double \u26033 = entity.field_70163_u;
            double \u26034 = entity.field_70161_v;
            double \u26035 = cPacketVehicleMove.func_187004_a();
            double \u26036 = cPacketVehicleMove.func_187002_b();
            double \u26037 = cPacketVehicleMove.func_187003_c();
            float \u26038 = cPacketVehicleMove.func_187006_d();
            float \u26039 = cPacketVehicleMove.func_187005_e();
            double \u260310 = \u26035 - this.field_184356_s;
            double \u260311 = \u26036 - this.field_184357_t;
            double \u260312 = \u26037 - this.field_184358_u;
            double \u260313 = \u260310 * \u260310 + \u260311 * \u260311 + \u260312 * \u260312;
            double \u260314 = entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y;
            if (!(!(\u260313 - \u260314 > 100.0) || this.field_147367_d.func_71264_H() && this.field_147367_d.func_71214_G().equals(entity.func_200200_C_().getString()))) {
                field_147370_c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)\u260310, (Object)\u260311, (Object)\u260312);
                this.field_147371_a.func_179290_a(new SPacketMoveVehicle(entity));
                return;
            }
            boolean \u260315 = worldServer.func_195586_b(entity, entity.func_174813_aQ().func_186664_h(0.0625));
            \u260310 = \u26035 - this.field_184359_v;
            \u260311 = \u26036 - this.field_184360_w - 1.0E-6;
            \u260312 = \u26037 - this.field_184361_x;
            entity.func_70091_d(MoverType.PLAYER, \u260310, \u260311, \u260312);
            double \u260316 = \u260311;
            \u260310 = \u26035 - entity.field_70165_t;
            \u260311 = \u26036 - entity.field_70163_u;
            if (\u260311 > -0.5 || \u260311 < 0.5) {
                \u260311 = 0.0;
            }
            \u260312 = \u26037 - entity.field_70161_v;
            \u260313 = \u260310 * \u260310 + \u260311 * \u260311 + \u260312 * \u260312;
            boolean \u260317 = false;
            if (\u260313 > 0.0625) {
                \u260317 = true;
                field_147370_c.warn("{} moved wrongly!", (Object)entity.func_200200_C_().getString());
            }
            entity.func_70080_a(\u26035, \u26036, \u26037, \u26038, \u26039);
            boolean \u260318 = worldServer.func_195586_b(entity, entity.func_174813_aQ().func_186664_h(0.0625));
            if (\u260315 && (\u260317 || !\u260318)) {
                entity.func_70080_a(\u26032, \u26033, \u26034, \u26038, \u26039);
                this.field_147371_a.func_179290_a(new SPacketMoveVehicle(entity));
                return;
            }
            this.field_147367_d.func_184103_al().func_72358_d(this.field_147369_b);
            this.field_147369_b.func_71000_j(this.field_147369_b.field_70165_t - \u26032, this.field_147369_b.field_70163_u - \u26033, this.field_147369_b.field_70161_v - \u26034);
            this.field_184345_D = \u260316 >= -0.03125 && !this.field_147367_d.func_71231_X() && !worldServer.func_72829_c(entity.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0));
            this.field_184359_v = entity.field_70165_t;
            this.field_184360_w = entity.field_70163_u;
            this.field_184361_x = entity.field_70161_v;
        }
    }

    @Override
    public void func_184339_a(CPacketConfirmTeleport cPacketConfirmTeleport) {
        PacketThreadUtil.func_180031_a(cPacketConfirmTeleport, this, this.field_147369_b.func_71121_q());
        if (cPacketConfirmTeleport.func_186987_a() == this.field_184363_z) {
            this.field_147369_b.func_70080_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
            this.field_184352_o = this.field_184362_y.field_72450_a;
            this.field_184353_p = this.field_184362_y.field_72448_b;
            this.field_184354_q = this.field_184362_y.field_72449_c;
            if (this.field_147369_b.func_184850_K()) {
                this.field_147369_b.func_184846_L();
            }
            this.field_184362_y = null;
        }
    }

    @Override
    public void func_191984_a(CPacketRecipeInfo cPacketRecipeInfo2) {
        CPacketRecipeInfo cPacketRecipeInfo2;
        PacketThreadUtil.func_180031_a(cPacketRecipeInfo2, this, this.field_147369_b.func_71121_q());
        if (cPacketRecipeInfo2.func_194156_a() == CPacketRecipeInfo.Purpose.SHOWN) {
            IRecipe iRecipe = this.field_147367_d.func_199529_aN().func_199517_a(cPacketRecipeInfo2.func_199619_b());
            if (iRecipe != null) {
                this.field_147369_b.func_192037_E().func_194074_f(iRecipe);
            }
        } else if (cPacketRecipeInfo2.func_194156_a() == CPacketRecipeInfo.Purpose.SETTINGS) {
            this.field_147369_b.func_192037_E().func_192813_a(cPacketRecipeInfo2.func_192624_c());
            this.field_147369_b.func_192037_E().func_192810_b(cPacketRecipeInfo2.func_192625_d());
            this.field_147369_b.func_192037_E().func_202881_c(cPacketRecipeInfo2.func_202496_e());
            this.field_147369_b.func_192037_E().func_202882_d(cPacketRecipeInfo2.func_202497_f());
        }
    }

    @Override
    public void func_194027_a(CPacketSeenAdvancements cPacketSeenAdvancements) {
        PacketThreadUtil.func_180031_a(cPacketSeenAdvancements, this, this.field_147369_b.func_71121_q());
        if (cPacketSeenAdvancements.func_194162_b() == CPacketSeenAdvancements.Action.OPENED_TAB) {
            ResourceLocation resourceLocation = cPacketSeenAdvancements.func_194165_c();
            Advancement \u26032 = this.field_147367_d.func_191949_aK().func_192778_a(resourceLocation);
            if (\u26032 != null) {
                this.field_147369_b.func_192039_O().func_194220_a(\u26032);
            }
        }
    }

    @Override
    public void func_195518_a(CPacketTabComplete cPacketTabComplete) {
        PacketThreadUtil.func_180031_a(cPacketTabComplete, this, this.field_147369_b.func_71121_q());
        StringReader stringReader = new StringReader(cPacketTabComplete.func_197707_b());
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        ParseResults \u26032 = this.field_147367_d.func_195571_aL().func_197054_a().parse(stringReader, (Object)this.field_147369_b.func_195051_bN());
        this.field_147367_d.func_195571_aL().func_197054_a().getCompletionSuggestions(\u26032).thenAccept(suggestions -> this.field_147371_a.func_179290_a(new SPacketTabComplete(cPacketTabComplete.func_197709_a(), (Suggestions)suggestions)));
    }

    @Override
    public void func_210153_a(CPacketUpdateCommandBlock cPacketUpdateCommandBlock) {
        PacketThreadUtil.func_180031_a(cPacketUpdateCommandBlock, this, this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a(new TextComponentTranslation("advMode.notEnabled", new Object[0]));
            return;
        }
        if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a(new TextComponentTranslation("advMode.notAllowed", new Object[0]));
            return;
        }
        CommandBlockBaseLogic commandBlockBaseLogic = null;
        TileEntityCommandBlock \u26032 = null;
        BlockPos \u26033 = cPacketUpdateCommandBlock.func_210361_a();
        TileEntity \u26034 = this.field_147369_b.field_70170_p.func_175625_s(\u26033);
        if (\u26034 instanceof TileEntityCommandBlock) {
            \u26032 = (TileEntityCommandBlock)\u26034;
            commandBlockBaseLogic = \u26032.func_145993_a();
        }
        String \u26035 = cPacketUpdateCommandBlock.func_210359_b();
        boolean \u26036 = cPacketUpdateCommandBlock.func_210363_c();
        if (commandBlockBaseLogic != null) {
            EnumFacing enumFacing = this.field_147369_b.field_70170_p.func_180495_p(\u26033).func_177229_b(BlockCommandBlock.field_185564_a);
            switch (cPacketUpdateCommandBlock.func_210360_f()) {
                case SEQUENCE: {
                    IBlockState iBlockState = Blocks.field_185777_dd.func_176223_P();
                    this.field_147369_b.field_70170_p.func_180501_a(\u26033, (IBlockState)((IBlockState)iBlockState.func_206870_a(BlockCommandBlock.field_185564_a, enumFacing)).func_206870_a(BlockCommandBlock.field_185565_b, cPacketUpdateCommandBlock.func_210364_d()), 2);
                    break;
                }
                case AUTO: {
                    IBlockState iBlockState = Blocks.field_185776_dc.func_176223_P();
                    this.field_147369_b.field_70170_p.func_180501_a(\u26033, (IBlockState)((IBlockState)iBlockState.func_206870_a(BlockCommandBlock.field_185564_a, enumFacing)).func_206870_a(BlockCommandBlock.field_185565_b, cPacketUpdateCommandBlock.func_210364_d()), 2);
                    break;
                }
                default: {
                    IBlockState iBlockState = Blocks.field_150483_bI.func_176223_P();
                    this.field_147369_b.field_70170_p.func_180501_a(\u26033, (IBlockState)((IBlockState)iBlockState.func_206870_a(BlockCommandBlock.field_185564_a, enumFacing)).func_206870_a(BlockCommandBlock.field_185565_b, cPacketUpdateCommandBlock.func_210364_d()), 2);
                }
            }
            \u26034.func_145829_t();
            this.field_147369_b.field_70170_p.func_175690_a(\u26033, \u26034);
            commandBlockBaseLogic.func_145752_a(\u26035);
            commandBlockBaseLogic.func_175573_a(\u26036);
            if (!\u26036) {
                commandBlockBaseLogic.func_145750_b(null);
            }
            \u26032.func_184253_b(cPacketUpdateCommandBlock.func_210362_e());
            commandBlockBaseLogic.func_145756_e();
            if (!StringUtils.func_151246_b(\u26035)) {
                this.field_147369_b.func_145747_a(new TextComponentTranslation("advMode.setCommand.success", \u26035));
            }
        }
    }

    @Override
    public void func_210158_a(CPacketUpdateCommandMinecart cPacketUpdateCommandMinecart) {
        PacketThreadUtil.func_180031_a(cPacketUpdateCommandMinecart, this, this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a(new TextComponentTranslation("advMode.notEnabled", new Object[0]));
            return;
        }
        if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a(new TextComponentTranslation("advMode.notAllowed", new Object[0]));
            return;
        }
        CommandBlockBaseLogic commandBlockBaseLogic = cPacketUpdateCommandMinecart.func_210371_a(this.field_147369_b.field_70170_p);
        if (commandBlockBaseLogic != null) {
            commandBlockBaseLogic.func_145752_a(cPacketUpdateCommandMinecart.func_210372_a());
            commandBlockBaseLogic.func_175573_a(cPacketUpdateCommandMinecart.func_210373_b());
            if (!cPacketUpdateCommandMinecart.func_210373_b()) {
                commandBlockBaseLogic.func_145750_b(null);
            }
            commandBlockBaseLogic.func_145756_e();
            this.field_147369_b.func_145747_a(new TextComponentTranslation("advMode.setCommand.success", cPacketUpdateCommandMinecart.func_210372_a()));
        }
    }

    @Override
    public void func_210152_a(CPacketPickItem cPacketPickItem) {
        PacketThreadUtil.func_180031_a(cPacketPickItem, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71071_by.func_184430_d(cPacketPickItem.func_210349_a());
        this.field_147369_b.field_71135_a.func_147359_a(new SPacketSetSlot(-2, this.field_147369_b.field_71071_by.field_70461_c, this.field_147369_b.field_71071_by.func_70301_a(this.field_147369_b.field_71071_by.field_70461_c)));
        this.field_147369_b.field_71135_a.func_147359_a(new SPacketSetSlot(-2, cPacketPickItem.func_210349_a(), this.field_147369_b.field_71071_by.func_70301_a(cPacketPickItem.func_210349_a())));
        this.field_147369_b.field_71135_a.func_147359_a(new SPacketHeldItemChange(this.field_147369_b.field_71071_by.field_70461_c));
    }

    @Override
    public void func_210155_a(CPacketRenameItem cPacketRenameItem) {
        PacketThreadUtil.func_180031_a(cPacketRenameItem, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof ContainerRepair) {
            ContainerRepair containerRepair = (ContainerRepair)this.field_147369_b.field_71070_bA;
            String \u26032 = SharedConstants.func_71565_a(cPacketRenameItem.func_210351_a());
            if (\u26032.length() <= 35) {
                containerRepair.func_82850_a(\u26032);
            }
        }
    }

    @Override
    public void func_210154_a(CPacketUpdateBeacon cPacketUpdateBeacon) {
        PacketThreadUtil.func_180031_a(cPacketUpdateBeacon, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof ContainerBeacon && (\u2603 = (\u2603 = (ContainerBeacon)this.field_147369_b.field_71070_bA).func_75139_a(0)).func_75216_d()) {
            \u2603.func_75209_a(1);
            IInventory iInventory = \u2603.func_180611_e();
            iInventory.func_174885_b(1, cPacketUpdateBeacon.func_210355_a());
            iInventory.func_174885_b(2, cPacketUpdateBeacon.func_210356_b());
            iInventory.func_70296_d();
        }
    }

    @Override
    public void func_210157_a(CPacketUpdateStructureBlock cPacketUpdateStructureBlock2) {
        PacketThreadUtil.func_180031_a(cPacketUpdateStructureBlock2, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_195070_dx()) {
            return;
        }
        BlockPos blockPos = cPacketUpdateStructureBlock2.func_210380_a();
        IBlockState \u26032 = this.field_147369_b.field_70170_p.func_180495_p(blockPos);
        TileEntity \u26033 = this.field_147369_b.field_70170_p.func_175625_s(blockPos);
        if (\u26033 instanceof TileEntityStructure) {
            TileEntityStructure tileEntityStructure = (TileEntityStructure)\u26033;
            tileEntityStructure.func_184405_a(cPacketUpdateStructureBlock2.func_210378_c());
            tileEntityStructure.func_184404_a(cPacketUpdateStructureBlock2.func_210377_d());
            tileEntityStructure.func_184414_b(cPacketUpdateStructureBlock2.func_210383_e());
            tileEntityStructure.func_184409_c(cPacketUpdateStructureBlock2.func_210385_f());
            tileEntityStructure.func_184411_a(cPacketUpdateStructureBlock2.func_210386_g());
            tileEntityStructure.func_184408_a(cPacketUpdateStructureBlock2.func_210379_h());
            tileEntityStructure.func_184410_b(cPacketUpdateStructureBlock2.func_210388_i());
            tileEntityStructure.func_184406_a(cPacketUpdateStructureBlock2.func_210389_j());
            tileEntityStructure.func_189703_e(cPacketUpdateStructureBlock2.func_210390_k());
            tileEntityStructure.func_189710_f(cPacketUpdateStructureBlock2.func_210387_l());
            tileEntityStructure.func_189718_a(cPacketUpdateStructureBlock2.func_210382_m());
            tileEntityStructure.func_189725_a(cPacketUpdateStructureBlock2.func_210381_n());
            if (tileEntityStructure.func_208404_d()) {
                String string = tileEntityStructure.func_189715_d();
                if (cPacketUpdateStructureBlock2.func_210384_b() == TileEntityStructure.UpdateCommand.SAVE_AREA) {
                    if (tileEntityStructure.func_184419_m()) {
                        this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.save_success", string), false);
                    } else {
                        this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.save_failure", string), false);
                    }
                } else if (cPacketUpdateStructureBlock2.func_210384_b() == TileEntityStructure.UpdateCommand.LOAD_AREA) {
                    if (!tileEntityStructure.func_189709_F()) {
                        this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.load_not_found", string), false);
                    } else if (tileEntityStructure.func_184412_n()) {
                        this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.load_success", string), false);
                    } else {
                        this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.load_prepare", string), false);
                    }
                } else if (cPacketUpdateStructureBlock2.func_210384_b() == TileEntityStructure.UpdateCommand.SCAN_AREA) {
                    if (tileEntityStructure.func_184417_l()) {
                        this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.size_success", string), false);
                    } else {
                        this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.size_failure", new Object[0]), false);
                    }
                }
            } else {
                CPacketUpdateStructureBlock cPacketUpdateStructureBlock2;
                this.field_147369_b.func_146105_b(new TextComponentTranslation("structure_block.invalid_structure_name", cPacketUpdateStructureBlock2.func_210377_d()), false);
            }
            tileEntityStructure.func_70296_d();
            this.field_147369_b.field_70170_p.func_184138_a(blockPos, \u26032, \u26032, 3);
        }
    }

    @Override
    public void func_210159_a(CPacketSelectTrade cPacketSelectTrade) {
        PacketThreadUtil.func_180031_a(cPacketSelectTrade, this, this.field_147369_b.func_71121_q());
        int n = cPacketSelectTrade.func_210353_a();
        Container \u26032 = this.field_147369_b.field_71070_bA;
        if (\u26032 instanceof ContainerMerchant) {
            ((ContainerMerchant)\u26032).func_75175_c(n);
        }
    }

    @Override
    public void func_210156_a(CPacketEditBook cPacketEditBook) {
        ItemStack itemStack = cPacketEditBook.func_210346_a();
        if (itemStack.func_190926_b()) {
            return;
        }
        if (!ItemWritableBook.func_150930_a(itemStack.func_77978_p())) {
            return;
        }
        itemStack2 = this.field_147369_b.func_184586_b(cPacketEditBook.func_212644_d());
        if (itemStack2.func_190926_b()) {
            return;
        }
        if (itemStack.func_77973_b() == Items.field_151099_bA && itemStack2.func_77973_b() == Items.field_151099_bA) {
            if (cPacketEditBook.func_210345_b()) {
                \u2603 = new ItemStack(Items.field_151164_bB);
                \u2603.func_77983_a("author", new NBTTagString(this.field_147369_b.func_200200_C_().getString()));
                \u2603.func_77983_a("title", new NBTTagString(itemStack.func_77978_p().func_74779_i("title")));
                NBTTagList nBTTagList = itemStack.func_77978_p().func_150295_c("pages", 8);
                for (int i = 0; i < nBTTagList.size(); ++i) {
                    String string = nBTTagList.func_150307_f(i);
                    TextComponentString \u26032 = new TextComponentString(string);
                    string = ITextComponent.Serializer.func_150696_a(\u26032);
                    nBTTagList.set(i, new NBTTagString(string));
                }
                \u2603.func_77983_a("pages", nBTTagList);
                EntityEquipmentSlot entityEquipmentSlot = cPacketEditBook.func_212644_d() == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
                this.field_147369_b.func_184201_a(entityEquipmentSlot, \u2603);
            } else {
                ItemStack itemStack2;
                itemStack2.func_77983_a("pages", itemStack.func_77978_p().func_150295_c("pages", 8));
            }
        }
    }

    @Override
    public void func_211526_a(CPacketNBTQueryEntity cPacketNBTQueryEntity) {
        PacketThreadUtil.func_180031_a(cPacketNBTQueryEntity, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_211513_k(2)) {
            return;
        }
        Entity entity = this.field_147369_b.func_71121_q().func_73045_a(cPacketNBTQueryEntity.func_211720_c());
        if (entity != null) {
            NBTTagCompound nBTTagCompound = entity.func_189511_e(new NBTTagCompound());
            this.field_147369_b.field_71135_a.func_147359_a(new SPacketNBTQueryResponse(cPacketNBTQueryEntity.func_211721_b(), nBTTagCompound));
        }
    }

    @Override
    public void func_211525_a(CPacketNBTQueryTileEntity cPacketNBTQueryTileEntity) {
        PacketThreadUtil.func_180031_a(cPacketNBTQueryTileEntity, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_211513_k(2)) {
            return;
        }
        TileEntity tileEntity = this.field_147369_b.func_71121_q().func_175625_s(cPacketNBTQueryTileEntity.func_211717_c());
        NBTTagCompound \u26032 = tileEntity != null ? tileEntity.func_189515_b(new NBTTagCompound()) : null;
        this.field_147369_b.field_71135_a.func_147359_a(new SPacketNBTQueryResponse(cPacketNBTQueryTileEntity.func_211716_b(), \u26032));
    }

    @Override
    public void func_147347_a(CPacketPlayer cPacketPlayer) {
        PacketThreadUtil.func_180031_a(cPacketPlayer, this, this.field_147369_b.func_71121_q());
        if (NetHandlerPlayServer.func_183006_b(cPacketPlayer)) {
            this.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.invalid_player_movement", new Object[0]));
            return;
        }
        WorldServer worldServer = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        if (this.field_147369_b.field_71136_j) {
            return;
        }
        if (this.field_147368_e == 0) {
            this.func_184342_d();
        }
        if (this.field_184362_y != null) {
            if (this.field_147368_e - this.field_184343_A > 20) {
                this.field_184343_A = this.field_147368_e;
                this.func_147364_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
            }
            return;
        }
        this.field_184343_A = this.field_147368_e;
        if (this.field_147369_b.func_184218_aH()) {
            this.field_147369_b.func_70080_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, cPacketPlayer.func_186999_a(this.field_147369_b.field_70177_z), cPacketPlayer.func_186998_b(this.field_147369_b.field_70125_A));
            this.field_147367_d.func_184103_al().func_72358_d(this.field_147369_b);
            return;
        }
        double \u26032 = this.field_147369_b.field_70165_t;
        double \u26033 = this.field_147369_b.field_70163_u;
        double \u26034 = this.field_147369_b.field_70161_v;
        double \u26035 = this.field_147369_b.field_70163_u;
        double \u26036 = cPacketPlayer.func_186997_a(this.field_147369_b.field_70165_t);
        double \u26037 = cPacketPlayer.func_186996_b(this.field_147369_b.field_70163_u);
        double \u26038 = cPacketPlayer.func_187000_c(this.field_147369_b.field_70161_v);
        float \u26039 = cPacketPlayer.func_186999_a(this.field_147369_b.field_70177_z);
        float \u260310 = cPacketPlayer.func_186998_b(this.field_147369_b.field_70125_A);
        double \u260311 = \u26036 - this.field_184349_l;
        double \u260312 = \u26037 - this.field_184350_m;
        double \u260313 = \u26038 - this.field_184351_n;
        double \u260314 = this.field_147369_b.field_70159_w * this.field_147369_b.field_70159_w + this.field_147369_b.field_70181_x * this.field_147369_b.field_70181_x + this.field_147369_b.field_70179_y * this.field_147369_b.field_70179_y;
        double \u260315 = \u260311 * \u260311 + \u260312 * \u260312 + \u260313 * \u260313;
        if (this.field_147369_b.func_70608_bn()) {
            if (\u260315 > 1.0) {
                this.func_147364_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, cPacketPlayer.func_186999_a(this.field_147369_b.field_70177_z), cPacketPlayer.func_186998_b(this.field_147369_b.field_70125_A));
            }
            return;
        }
        ++this.field_184347_F;
        int \u260316 = this.field_184347_F - this.field_184348_G;
        if (\u260316 > 5) {
            field_147370_c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)\u260316);
            \u260316 = 1;
        }
        if (!(this.field_147369_b.func_184850_K() || this.field_147369_b.func_71121_q().func_82736_K().func_82766_b("disableElytraMovementCheck") && this.field_147369_b.func_184613_cA())) {
            float f = \u2603 = this.field_147369_b.func_184613_cA() ? 300.0f : 100.0f;
            if (!(!(\u260315 - \u260314 > (double)(\u2603 * (float)\u260316)) || this.field_147367_d.func_71264_H() && this.field_147367_d.func_71214_G().equals(this.field_147369_b.func_146103_bH().getName()))) {
                field_147370_c.warn("{} moved too quickly! {},{},{}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)\u260311, (Object)\u260312, (Object)\u260313);
                this.func_147364_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                return;
            }
        }
        boolean \u260317 = worldServer.func_195586_b(this.field_147369_b, this.field_147369_b.func_174813_aQ().func_186664_h(0.0625));
        \u260311 = \u26036 - this.field_184352_o;
        \u260312 = \u26037 - this.field_184353_p;
        \u260313 = \u26038 - this.field_184354_q;
        if (this.field_147369_b.field_70122_E && !cPacketPlayer.func_149465_i() && \u260312 > 0.0) {
            this.field_147369_b.func_70664_aZ();
        }
        this.field_147369_b.func_70091_d(MoverType.PLAYER, \u260311, \u260312, \u260313);
        this.field_147369_b.field_70122_E = cPacketPlayer.func_149465_i();
        double \u260318 = \u260312;
        \u260311 = \u26036 - this.field_147369_b.field_70165_t;
        \u260312 = \u26037 - this.field_147369_b.field_70163_u;
        if (\u260312 > -0.5 || \u260312 < 0.5) {
            \u260312 = 0.0;
        }
        \u260313 = \u26038 - this.field_147369_b.field_70161_v;
        \u260315 = \u260311 * \u260311 + \u260312 * \u260312 + \u260313 * \u260313;
        boolean \u260319 = false;
        if (!this.field_147369_b.func_184850_K() && \u260315 > 0.0625 && !this.field_147369_b.func_70608_bn() && !this.field_147369_b.field_71134_c.func_73083_d() && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR) {
            \u260319 = true;
            field_147370_c.warn("{} moved wrongly!", (Object)this.field_147369_b.func_200200_C_().getString());
        }
        this.field_147369_b.func_70080_a(\u26036, \u26037, \u26038, \u26039, \u260310);
        this.field_147369_b.func_71000_j(this.field_147369_b.field_70165_t - \u26032, this.field_147369_b.field_70163_u - \u26033, this.field_147369_b.field_70161_v - \u26034);
        if (!this.field_147369_b.field_70145_X && !this.field_147369_b.func_70608_bn()) {
            boolean bl = worldServer.func_195586_b(this.field_147369_b, this.field_147369_b.func_174813_aQ().func_186664_h(0.0625));
            if (\u260317 && (\u260319 || !bl)) {
                this.func_147364_a(\u26032, \u26033, \u26034, \u26039, \u260310);
                return;
            }
        }
        this.field_184344_B = \u260318 >= -0.03125;
        this.field_184344_B &= !this.field_147367_d.func_71231_X() && !this.field_147369_b.field_71075_bZ.field_75101_c;
        this.field_184344_B &= !this.field_147369_b.func_70644_a(MobEffects.field_188424_y) && !this.field_147369_b.func_184613_cA() && !worldServer.func_72829_c(this.field_147369_b.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0));
        this.field_147369_b.field_70122_E = cPacketPlayer.func_149465_i();
        this.field_147367_d.func_184103_al().func_72358_d(this.field_147369_b);
        this.field_147369_b.func_71122_b(this.field_147369_b.field_70163_u - \u26035, cPacketPlayer.func_149465_i());
        this.field_184352_o = this.field_147369_b.field_70165_t;
        this.field_184353_p = this.field_147369_b.field_70163_u;
        this.field_184354_q = this.field_147369_b.field_70161_v;
    }

    public void func_147364_a(double d, double d2, double d3, float f, float f2) {
        this.func_175089_a(d, d2, d3, f, f2, Collections.emptySet());
    }

    public void func_175089_a(double d, double d2, double d3, float f, float f2, Set<SPacketPlayerPosLook.EnumFlags> set) {
        double d4 = set.contains((Object)SPacketPlayerPosLook.EnumFlags.X) ? this.field_147369_b.field_70165_t : 0.0;
        \u2603 = set.contains((Object)SPacketPlayerPosLook.EnumFlags.Y) ? this.field_147369_b.field_70163_u : 0.0;
        \u2603 = set.contains((Object)SPacketPlayerPosLook.EnumFlags.Z) ? this.field_147369_b.field_70161_v : 0.0;
        float \u26032 = set.contains((Object)SPacketPlayerPosLook.EnumFlags.Y_ROT) ? this.field_147369_b.field_70177_z : 0.0f;
        float \u26033 = set.contains((Object)SPacketPlayerPosLook.EnumFlags.X_ROT) ? this.field_147369_b.field_70125_A : 0.0f;
        this.field_184362_y = new Vec3d(d, d2, d3);
        if (++this.field_184363_z == Integer.MAX_VALUE) {
            this.field_184363_z = 0;
        }
        this.field_184343_A = this.field_147368_e;
        this.field_147369_b.func_70080_a(d, d2, d3, f, f2);
        this.field_147369_b.field_71135_a.func_147359_a(new SPacketPlayerPosLook(d - d4, d2 - \u2603, d3 - \u2603, f - \u26032, f2 - \u26033, set, this.field_184363_z));
    }

    @Override
    public void func_147345_a(CPacketPlayerDigging cPacketPlayerDigging2) {
        CPacketPlayerDigging cPacketPlayerDigging2;
        PacketThreadUtil.func_180031_a(cPacketPlayerDigging2, this, this.field_147369_b.func_71121_q());
        WorldServer worldServer = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        BlockPos \u26032 = cPacketPlayerDigging2.func_179715_a();
        this.field_147369_b.func_143004_u();
        switch (cPacketPlayerDigging2.func_180762_c()) {
            case SWAP_HELD_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    ItemStack itemStack = this.field_147369_b.func_184586_b(EnumHand.OFF_HAND);
                    this.field_147369_b.func_184611_a(EnumHand.OFF_HAND, this.field_147369_b.func_184586_b(EnumHand.MAIN_HAND));
                    this.field_147369_b.func_184611_a(EnumHand.MAIN_HAND, itemStack);
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_71040_bB(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_71040_bB(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.field_147369_b.func_184597_cx();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                double d = this.field_147369_b.field_70165_t - ((double)\u26032.func_177958_n() + 0.5);
                \u2603 = this.field_147369_b.field_70163_u - ((double)\u26032.func_177956_o() + 0.5) + 1.5;
                \u2603 = this.field_147369_b.field_70161_v - ((double)\u26032.func_177952_p() + 0.5);
                \u2603 = d * d + \u2603 * \u2603 + \u2603 * \u2603;
                if (\u2603 > 36.0) {
                    return;
                }
                if (\u26032.func_177956_o() < this.field_147367_d.func_71207_Z()) break;
                return;
            }
            default: {
                throw new IllegalArgumentException("Invalid player action");
            }
        }
        if (cPacketPlayerDigging2.func_180762_c() == CPacketPlayerDigging.Action.START_DESTROY_BLOCK) {
            if (!this.field_147367_d.func_175579_a(worldServer, \u26032, this.field_147369_b) && worldServer.func_175723_af().func_177746_a(\u26032)) {
                this.field_147369_b.field_71134_c.func_180784_a(\u26032, cPacketPlayerDigging2.func_179714_b());
            } else {
                this.field_147369_b.field_71135_a.func_147359_a(new SPacketBlockChange(worldServer, \u26032));
            }
        } else {
            if (cPacketPlayerDigging2.func_180762_c() == CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK) {
                this.field_147369_b.field_71134_c.func_180785_a(\u26032);
            } else if (cPacketPlayerDigging2.func_180762_c() == CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK) {
                this.field_147369_b.field_71134_c.func_180238_e();
            }
            if (!worldServer.func_180495_p(\u26032).func_196958_f()) {
                this.field_147369_b.field_71135_a.func_147359_a(new SPacketBlockChange(worldServer, \u26032));
            }
        }
    }

    @Override
    public void func_184337_a(CPacketPlayerTryUseItemOnBlock cPacketPlayerTryUseItemOnBlock) {
        PacketThreadUtil.func_180031_a(cPacketPlayerTryUseItemOnBlock, this, this.field_147369_b.func_71121_q());
        WorldServer worldServer = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        EnumHand \u26032 = cPacketPlayerTryUseItemOnBlock.func_187022_c();
        ItemStack \u26033 = this.field_147369_b.func_184586_b(\u26032);
        BlockPos \u26034 = cPacketPlayerTryUseItemOnBlock.func_187023_a();
        EnumFacing \u26035 = cPacketPlayerTryUseItemOnBlock.func_187024_b();
        this.field_147369_b.func_143004_u();
        if (\u26034.func_177956_o() < this.field_147367_d.func_71207_Z() - 1 || \u26035 != EnumFacing.UP && \u26034.func_177956_o() < this.field_147367_d.func_71207_Z()) {
            if (this.field_184362_y == null && this.field_147369_b.func_70092_e((double)\u26034.func_177958_n() + 0.5, (double)\u26034.func_177956_o() + 0.5, (double)\u26034.func_177952_p() + 0.5) < 64.0 && !this.field_147367_d.func_175579_a(worldServer, \u26034, this.field_147369_b) && worldServer.func_175723_af().func_177746_a(\u26034)) {
                this.field_147369_b.field_71134_c.func_187251_a(this.field_147369_b, worldServer, \u26033, \u26032, \u26034, \u26035, cPacketPlayerTryUseItemOnBlock.func_187026_d(), cPacketPlayerTryUseItemOnBlock.func_187025_e(), cPacketPlayerTryUseItemOnBlock.func_187020_f());
            }
        } else {
            ITextComponent iTextComponent = new TextComponentTranslation("build.tooHigh", this.field_147367_d.func_71207_Z()).func_211708_a(TextFormatting.RED);
            this.field_147369_b.field_71135_a.func_147359_a(new SPacketChat(iTextComponent, ChatType.GAME_INFO));
        }
        this.field_147369_b.field_71135_a.func_147359_a(new SPacketBlockChange(worldServer, \u26034));
        this.field_147369_b.field_71135_a.func_147359_a(new SPacketBlockChange(worldServer, \u26034.func_177972_a(\u26035)));
    }

    @Override
    public void func_147346_a(CPacketPlayerTryUseItem cPacketPlayerTryUseItem) {
        PacketThreadUtil.func_180031_a(cPacketPlayerTryUseItem, this, this.field_147369_b.func_71121_q());
        WorldServer worldServer = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        EnumHand \u26032 = cPacketPlayerTryUseItem.func_187028_a();
        ItemStack \u26033 = this.field_147369_b.func_184586_b(\u26032);
        this.field_147369_b.func_143004_u();
        if (\u26033.func_190926_b()) {
            return;
        }
        this.field_147369_b.field_71134_c.func_187250_a(this.field_147369_b, worldServer, \u26033, \u26032);
    }

    @Override
    public void func_175088_a(CPacketSpectate cPacketSpectate) {
        PacketThreadUtil.func_180031_a(cPacketSpectate, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_175149_v()) {
            Entity entity = null;
            Iterator<WorldServer> iterator = this.field_147367_d.func_212370_w().iterator();
            while (iterator.hasNext() && (entity = cPacketSpectate.func_179727_a(\u2603 = iterator.next())) == null) {
            }
            if (entity != null) {
                this.field_147369_b.func_200619_a((WorldServer)entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            }
        }
    }

    @Override
    public void func_175086_a(CPacketResourcePackStatus cPacketResourcePackStatus) {
    }

    @Override
    public void func_184340_a(CPacketSteerBoat cPacketSteerBoat) {
        PacketThreadUtil.func_180031_a(cPacketSteerBoat, this, this.field_147369_b.func_71121_q());
        Entity entity = this.field_147369_b.func_184187_bx();
        if (entity instanceof EntityBoat) {
            ((EntityBoat)entity).func_184445_a(cPacketSteerBoat.func_187012_a(), cPacketSteerBoat.func_187014_b());
        }
    }

    @Override
    public void func_147231_a(ITextComponent iTextComponent) {
        field_147370_c.info("{} lost connection: {}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)iTextComponent.getString());
        this.field_147367_d.func_147132_au();
        this.field_147367_d.func_184103_al().func_148539_a(new TextComponentTranslation("multiplayer.player.left", this.field_147369_b.func_145748_c_()).func_211708_a(TextFormatting.YELLOW));
        this.field_147369_b.func_71123_m();
        this.field_147367_d.func_184103_al().func_72367_e(this.field_147369_b);
        if (this.field_147367_d.func_71264_H() && this.field_147369_b.func_200200_C_().getString().equals(this.field_147367_d.func_71214_G())) {
            field_147370_c.info("Stopping singleplayer server as player logged out");
            this.field_147367_d.func_71263_m();
        }
    }

    public void func_147359_a(Packet<?> packet) {
        this.func_211148_a(packet, null);
    }

    public void func_211148_a(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        Object \u26032;
        if (packet instanceof SPacketChat) {
            SPacketChat sPacketChat = (SPacketChat)packet;
            \u26032 = this.field_147369_b.func_147096_v();
            if (\u26032 == EntityPlayer.EnumChatVisibility.HIDDEN && sPacketChat.func_192590_c() != ChatType.GAME_INFO) {
                return;
            }
            if (\u26032 == EntityPlayer.EnumChatVisibility.SYSTEM && !sPacketChat.func_148916_d()) {
                return;
            }
        }
        try {
            this.field_147371_a.func_201058_a(packet, genericFutureListener);
        }
        catch (Throwable throwable) {
            \u26032 = CrashReport.func_85055_a(throwable, "Sending packet");
            CrashReportCategory crashReportCategory = ((CrashReport)\u26032).func_85058_a("Packet being sent");
            crashReportCategory.func_189529_a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException((CrashReport)\u26032);
        }
    }

    @Override
    public void func_147355_a(CPacketHeldItemChange cPacketHeldItemChange) {
        PacketThreadUtil.func_180031_a(cPacketHeldItemChange, this, this.field_147369_b.func_71121_q());
        if (cPacketHeldItemChange.func_149614_c() < 0 || cPacketHeldItemChange.func_149614_c() >= InventoryPlayer.func_70451_h()) {
            field_147370_c.warn("{} tried to set an invalid carried item", (Object)this.field_147369_b.func_200200_C_().getString());
            return;
        }
        this.field_147369_b.field_71071_by.field_70461_c = cPacketHeldItemChange.func_149614_c();
        this.field_147369_b.func_143004_u();
    }

    @Override
    public void func_147354_a(CPacketChatMessage cPacketChatMessage) {
        PacketThreadUtil.func_180031_a(cPacketChatMessage, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_147096_v() == EntityPlayer.EnumChatVisibility.HIDDEN) {
            this.func_147359_a(new SPacketChat(new TextComponentTranslation("chat.cannotSend", new Object[0]).func_211708_a(TextFormatting.RED)));
            return;
        }
        this.field_147369_b.func_143004_u();
        String string = cPacketChatMessage.func_149439_c();
        string = org.apache.commons.lang3.StringUtils.normalizeSpace((String)string);
        for (int i = 0; i < string.length(); ++i) {
            if (SharedConstants.func_71566_a(string.charAt(i))) continue;
            this.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.illegal_characters", new Object[0]));
            return;
        }
        if (string.startsWith("/")) {
            this.func_147361_d(string);
        } else {
            TextComponentTranslation textComponentTranslation = new TextComponentTranslation("chat.type.text", this.field_147369_b.func_145748_c_(), string);
            this.field_147367_d.func_184103_al().func_148544_a(textComponentTranslation, false);
        }
        this.field_147374_l += 20;
        if (this.field_147374_l > 200 && !this.field_147367_d.func_184103_al().func_152596_g(this.field_147369_b.func_146103_bH())) {
            this.func_194028_b(new TextComponentTranslation("disconnect.spam", new Object[0]));
        }
    }

    private void func_147361_d(String string) {
        this.field_147367_d.func_195571_aL().func_197059_a(this.field_147369_b.func_195051_bN(), string);
    }

    @Override
    public void func_175087_a(CPacketAnimation cPacketAnimation) {
        PacketThreadUtil.func_180031_a(cPacketAnimation, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        this.field_147369_b.func_184609_a(cPacketAnimation.func_187018_a());
    }

    @Override
    public void func_147357_a(CPacketEntityAction cPacketEntityAction) {
        PacketThreadUtil.func_180031_a(cPacketEntityAction, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        switch (cPacketEntityAction.func_180764_b()) {
            case START_SNEAKING: {
                this.field_147369_b.func_70095_a(true);
                break;
            }
            case STOP_SNEAKING: {
                this.field_147369_b.func_70095_a(false);
                break;
            }
            case START_SPRINTING: {
                this.field_147369_b.func_70031_b(true);
                break;
            }
            case STOP_SPRINTING: {
                this.field_147369_b.func_70031_b(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.field_147369_b.func_70608_bn()) break;
                this.field_147369_b.func_70999_a(false, true, true);
                this.field_184362_y = new Vec3d(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v);
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount iJumpingMount = (IJumpingMount)((Object)this.field_147369_b.func_184187_bx());
                int \u26032 = cPacketEntityAction.func_149512_e();
                if (!iJumpingMount.func_184776_b() || \u26032 <= 0) break;
                iJumpingMount.func_184775_b(\u26032);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                \u2603 = (IJumpingMount)((Object)this.field_147369_b.func_184187_bx());
                \u2603.func_184777_r_();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.field_147369_b.func_184187_bx() instanceof AbstractHorse)) break;
                ((AbstractHorse)this.field_147369_b.func_184187_bx()).func_110199_f(this.field_147369_b);
                break;
            }
            case START_FALL_FLYING: {
                if (!this.field_147369_b.field_70122_E && this.field_147369_b.field_70181_x < 0.0 && !this.field_147369_b.func_184613_cA() && !this.field_147369_b.func_70090_H()) {
                    ItemStack itemStack = this.field_147369_b.func_184582_a(EntityEquipmentSlot.CHEST);
                    if (itemStack.func_77973_b() != Items.field_185160_cR || !ItemElytra.func_185069_d(itemStack)) break;
                    this.field_147369_b.func_184847_M();
                    break;
                }
                this.field_147369_b.func_189103_N();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    @Override
    public void func_147340_a(CPacketUseEntity cPacketUseEntity2) {
        PacketThreadUtil.func_180031_a(cPacketUseEntity2, this, this.field_147369_b.func_71121_q());
        WorldServer worldServer = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        Entity \u26032 = cPacketUseEntity2.func_149564_a(worldServer);
        this.field_147369_b.func_143004_u();
        if (\u26032 != null) {
            boolean bl = this.field_147369_b.func_70685_l(\u26032);
            double \u26033 = 36.0;
            if (!bl) {
                \u26033 = 9.0;
            }
            if (this.field_147369_b.func_70068_e(\u26032) < \u26033) {
                CPacketUseEntity cPacketUseEntity2;
                if (cPacketUseEntity2.func_149565_c() == CPacketUseEntity.Action.INTERACT) {
                    EnumHand enumHand = cPacketUseEntity2.func_186994_b();
                    this.field_147369_b.func_190775_a(\u26032, enumHand);
                } else if (cPacketUseEntity2.func_149565_c() == CPacketUseEntity.Action.INTERACT_AT) {
                    EnumHand enumHand = cPacketUseEntity2.func_186994_b();
                    \u26032.func_184199_a(this.field_147369_b, cPacketUseEntity2.func_179712_b(), enumHand);
                } else if (cPacketUseEntity2.func_149565_c() == CPacketUseEntity.Action.ATTACK) {
                    if (\u26032 instanceof EntityItem || \u26032 instanceof EntityXPOrb || \u26032 instanceof EntityArrow || \u26032 == this.field_147369_b) {
                        this.func_194028_b(new TextComponentTranslation("multiplayer.disconnect.invalid_entity_attacked", new Object[0]));
                        this.field_147367_d.func_71236_h("Player " + this.field_147369_b.func_200200_C_().getString() + " tried to attack an invalid entity");
                        return;
                    }
                    this.field_147369_b.func_71059_n(\u26032);
                }
            }
        }
    }

    @Override
    public void func_147342_a(CPacketClientStatus cPacketClientStatus) {
        PacketThreadUtil.func_180031_a(cPacketClientStatus, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        CPacketClientStatus.State state = cPacketClientStatus.func_149435_c();
        switch (state) {
            case PERFORM_RESPAWN: {
                if (this.field_147369_b.field_71136_j) {
                    this.field_147369_b.field_71136_j = false;
                    this.field_147369_b = this.field_147367_d.func_184103_al().func_72368_a(this.field_147369_b, DimensionType.OVERWORLD, true);
                    CriteriaTriggers.field_193134_u.func_193143_a(this.field_147369_b, DimensionType.THE_END, DimensionType.OVERWORLD);
                    break;
                }
                if (this.field_147369_b.func_110143_aJ() > 0.0f) {
                    return;
                }
                this.field_147369_b = this.field_147367_d.func_184103_al().func_72368_a(this.field_147369_b, DimensionType.OVERWORLD, false);
                if (!this.field_147367_d.func_71199_h()) break;
                this.field_147369_b.func_71033_a(GameType.SPECTATOR);
                this.field_147369_b.func_71121_q().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false", this.field_147367_d);
                break;
            }
            case REQUEST_STATS: {
                this.field_147369_b.func_147099_x().func_150876_a(this.field_147369_b);
            }
        }
    }

    @Override
    public void func_147356_a(CPacketCloseWindow cPacketCloseWindow) {
        PacketThreadUtil.func_180031_a(cPacketCloseWindow, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_71128_l();
    }

    @Override
    public void func_147351_a(CPacketClickWindow cPacketClickWindow2) {
        PacketThreadUtil.func_180031_a(cPacketClickWindow2, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == cPacketClickWindow2.func_149548_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b)) {
            if (this.field_147369_b.func_175149_v()) {
                NonNullList<ItemStack> nonNullList = NonNullList.func_191196_a();
                for (int i = 0; i < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++i) {
                    nonNullList.add(this.field_147369_b.field_71070_bA.field_75151_b.get(i).func_75211_c());
                }
                this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, nonNullList);
            } else {
                CPacketClickWindow cPacketClickWindow2;
                ItemStack \u26032 = this.field_147369_b.field_71070_bA.func_184996_a(cPacketClickWindow2.func_149544_d(), cPacketClickWindow2.func_149543_e(), cPacketClickWindow2.func_186993_f(), this.field_147369_b);
                if (ItemStack.func_77989_b(cPacketClickWindow2.func_149546_g(), \u26032)) {
                    this.field_147369_b.field_71135_a.func_147359_a(new SPacketConfirmTransaction(cPacketClickWindow2.func_149548_c(), cPacketClickWindow2.func_149547_f(), true));
                    this.field_147369_b.field_71137_h = true;
                    this.field_147369_b.field_71070_bA.func_75142_b();
                    this.field_147369_b.func_71113_k();
                    this.field_147369_b.field_71137_h = false;
                } else {
                    this.field_147372_n.func_76038_a(this.field_147369_b.field_71070_bA.field_75152_c, cPacketClickWindow2.func_149547_f());
                    this.field_147369_b.field_71135_a.func_147359_a(new SPacketConfirmTransaction(cPacketClickWindow2.func_149548_c(), cPacketClickWindow2.func_149547_f(), false));
                    this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, false);
                    NonNullList<ItemStack> nonNullList = NonNullList.func_191196_a();
                    for (int i = 0; i < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++i) {
                        ItemStack itemStack = this.field_147369_b.field_71070_bA.field_75151_b.get(i).func_75211_c();
                        nonNullList.add(itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack);
                    }
                    this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, nonNullList);
                }
            }
        }
    }

    @Override
    public void func_194308_a(CPacketPlaceRecipe cPacketPlaceRecipe) {
        PacketThreadUtil.func_180031_a(cPacketPlaceRecipe, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.func_175149_v() || this.field_147369_b.field_71070_bA.field_75152_c != cPacketPlaceRecipe.func_194318_a() || !this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b)) {
            return;
        }
        IRecipe iRecipe = this.field_147367_d.func_199529_aN().func_199517_a(cPacketPlaceRecipe.func_199618_b());
        if (this.field_147369_b.field_71070_bA instanceof ContainerFurnace) {
            new ServerRecipePlacerFurnace().func_194327_a(this.field_147369_b, iRecipe, cPacketPlaceRecipe.func_194319_c());
        } else {
            new ServerRecipePlacer().func_194327_a(this.field_147369_b, iRecipe, cPacketPlaceRecipe.func_194319_c());
        }
    }

    @Override
    public void func_147338_a(CPacketEnchantItem cPacketEnchantItem) {
        PacketThreadUtil.func_180031_a(cPacketEnchantItem, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == cPacketEnchantItem.func_149539_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75140_a(this.field_147369_b, cPacketEnchantItem.func_149537_d());
            this.field_147369_b.field_71070_bA.func_75142_b();
        }
    }

    @Override
    public void func_147344_a(CPacketCreativeInventoryAction cPacketCreativeInventoryAction2) {
        PacketThreadUtil.func_180031_a(cPacketCreativeInventoryAction2, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71134_c.func_73083_d()) {
            CPacketCreativeInventoryAction cPacketCreativeInventoryAction2;
            Object object;
            boolean bl = cPacketCreativeInventoryAction2.func_149627_c() < 0;
            ItemStack \u26032 = cPacketCreativeInventoryAction2.func_149625_d();
            NBTTagCompound \u26033 = \u26032.func_179543_a("BlockEntityTag");
            if (!\u26032.func_190926_b() && \u26033 != null && \u26033.func_74764_b("x") && \u26033.func_74764_b("y") && \u26033.func_74764_b("z") && (\u2603 = this.field_147369_b.field_70170_p.func_175625_s(\u2603 = new BlockPos(\u26033.func_74762_e("x"), \u26033.func_74762_e("y"), \u26033.func_74762_e("z")))) != null) {
                object = \u2603.func_189515_b(new NBTTagCompound());
                ((NBTTagCompound)object).func_82580_o("x");
                ((NBTTagCompound)object).func_82580_o("y");
                ((NBTTagCompound)object).func_82580_o("z");
                \u26032.func_77983_a("BlockEntityTag", (INBTBase)object);
            }
            boolean \u26034 = cPacketCreativeInventoryAction2.func_149627_c() >= 1 && cPacketCreativeInventoryAction2.func_149627_c() <= 45;
            boolean bl2 = \u2603 = \u26032.func_190926_b() || \u26032.func_77952_i() >= 0 && \u26032.func_190916_E() <= 64 && !\u26032.func_190926_b();
            if (\u26034 && \u2603) {
                if (\u26032.func_190926_b()) {
                    this.field_147369_b.field_71069_bz.func_75141_a(cPacketCreativeInventoryAction2.func_149627_c(), ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.field_71069_bz.func_75141_a(cPacketCreativeInventoryAction2.func_149627_c(), \u26032);
                }
                this.field_147369_b.field_71069_bz.func_75128_a(this.field_147369_b, true);
            } else if (bl && \u2603 && this.field_147375_m < 200) {
                this.field_147375_m += 20;
                object = this.field_147369_b.func_71019_a(\u26032, true);
                if (object != null) {
                    ((EntityItem)object).func_70288_d();
                }
            }
        }
    }

    @Override
    public void func_147339_a(CPacketConfirmTransaction cPacketConfirmTransaction) {
        PacketThreadUtil.func_180031_a(cPacketConfirmTransaction, this, this.field_147369_b.func_71121_q());
        Short s = this.field_147372_n.func_76041_a(this.field_147369_b.field_71070_bA.field_75152_c);
        if (s != null && cPacketConfirmTransaction.func_149533_d() == s.shortValue() && this.field_147369_b.field_71070_bA.field_75152_c == cPacketConfirmTransaction.func_149532_c() && !this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, true);
        }
    }

    @Override
    public void func_147343_a(CPacketUpdateSign cPacketUpdateSign) {
        PacketThreadUtil.func_180031_a(cPacketUpdateSign, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        WorldServer worldServer = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        BlockPos \u26032 = cPacketUpdateSign.func_179722_a();
        if (worldServer.func_175667_e(\u26032)) {
            IBlockState iBlockState = worldServer.func_180495_p(\u26032);
            TileEntity \u26033 = worldServer.func_175625_s(\u26032);
            if (!(\u26033 instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign \u26034 = (TileEntitySign)\u26033;
            if (!\u26034.func_145914_a() || \u26034.func_145911_b() != this.field_147369_b) {
                this.field_147367_d.func_71236_h("Player " + this.field_147369_b.func_200200_C_().getString() + " just tried to change non-editable sign");
                return;
            }
            String[] \u26035 = cPacketUpdateSign.func_187017_b();
            for (int i = 0; i < \u26035.length; ++i) {
                \u26034.func_212365_a(i, new TextComponentString(TextFormatting.func_110646_a(\u26035[i])));
            }
            \u26034.func_70296_d();
            worldServer.func_184138_a(\u26032, iBlockState, iBlockState, 3);
        }
    }

    @Override
    public void func_147353_a(CPacketKeepAlive cPacketKeepAlive) {
        if (this.field_194403_g && cPacketKeepAlive.func_149460_c() == this.field_194404_h) {
            int n = (int)(Util.func_211177_b() - this.field_194402_f);
            this.field_147369_b.field_71138_i = (this.field_147369_b.field_71138_i * 3 + n) / 4;
            this.field_194403_g = false;
        } else if (!this.field_147369_b.func_200200_C_().getString().equals(this.field_147367_d.func_71214_G())) {
            this.func_194028_b(new TextComponentTranslation("disconnect.timeout", new Object[0]));
        }
    }

    @Override
    public void func_147348_a(CPacketPlayerAbilities cPacketPlayerAbilities) {
        PacketThreadUtil.func_180031_a(cPacketPlayerAbilities, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71075_bZ.field_75100_b = cPacketPlayerAbilities.func_149488_d() && this.field_147369_b.field_71075_bZ.field_75101_c;
    }

    @Override
    public void func_147352_a(CPacketClientSettings cPacketClientSettings) {
        PacketThreadUtil.func_180031_a(cPacketClientSettings, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_147100_a(cPacketClientSettings);
    }

    @Override
    public void func_147349_a(CPacketCustomPayload cPacketCustomPayload) {
    }
}

