/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCollection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTTagList
extends NBTTagCollection<INBTBase> {
    private static final Logger field_179239_b = LogManager.getLogger();
    private List<INBTBase> field_74747_a = Lists.newArrayList();
    private byte field_74746_b = 0;

    @Override
    public void func_74734_a(DataOutput dataOutput) throws IOException {
        this.field_74746_b = this.field_74747_a.isEmpty() ? (byte)0 : this.field_74747_a.get(0).func_74732_a();
        dataOutput.writeByte(this.field_74746_b);
        dataOutput.writeInt(this.field_74747_a.size());
        for (int i = 0; i < this.field_74747_a.size(); ++i) {
            this.field_74747_a.get(i).func_74734_a(dataOutput);
        }
    }

    @Override
    public void func_152446_a(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        nBTSizeTracker.func_152450_a(296L);
        if (n > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.field_74746_b = dataInput.readByte();
        int n2 = dataInput.readInt();
        if (this.field_74746_b == 0 && n2 > 0) {
            throw new RuntimeException("Missing type on ListTag");
        }
        nBTSizeTracker.func_152450_a(32L * (long)n2);
        this.field_74747_a = Lists.newArrayListWithCapacity((int)n2);
        for (\u2603 = 0; \u2603 < n2; ++\u2603) {
            INBTBase iNBTBase = INBTBase.func_150284_a(this.field_74746_b);
            iNBTBase.func_152446_a(dataInput, n + 1, nBTSizeTracker);
            this.field_74747_a.add(iNBTBase);
        }
    }

    @Override
    public byte func_74732_a() {
        return 9;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.field_74747_a.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.field_74747_a.get(i));
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public boolean add(INBTBase iNBTBase) {
        if (iNBTBase.func_74732_a() == 0) {
            field_179239_b.warn("Invalid TagEnd added to ListTag");
            return false;
        }
        if (this.field_74746_b == 0) {
            this.field_74746_b = iNBTBase.func_74732_a();
        } else if (this.field_74746_b != iNBTBase.func_74732_a()) {
            field_179239_b.warn("Adding mismatching tag types to tag list");
            return false;
        }
        this.field_74747_a.add(iNBTBase);
        return true;
    }

    @Override
    public INBTBase set(int n, INBTBase iNBTBase) {
        if (iNBTBase.func_74732_a() == 0) {
            field_179239_b.warn("Invalid TagEnd added to ListTag");
            return this.field_74747_a.get(n);
        }
        if (n < 0 || n >= this.field_74747_a.size()) {
            field_179239_b.warn("index out of bounds to set tag in tag list");
            return null;
        }
        if (this.field_74746_b == 0) {
            this.field_74746_b = iNBTBase.func_74732_a();
        } else if (this.field_74746_b != iNBTBase.func_74732_a()) {
            field_179239_b.warn("Adding mismatching tag types to tag list");
            return this.field_74747_a.get(n);
        }
        return this.field_74747_a.set(n, iNBTBase);
    }

    @Override
    public INBTBase remove(int n) {
        return this.field_74747_a.remove(n);
    }

    @Override
    public boolean isEmpty() {
        return this.field_74747_a.isEmpty();
    }

    public NBTTagCompound func_150305_b(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 10) {
            return (NBTTagCompound)\u2603;
        }
        return new NBTTagCompound();
    }

    public NBTTagList func_202169_e(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 9) {
            return (NBTTagList)\u2603;
        }
        return new NBTTagList();
    }

    public short func_202170_f(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 2) {
            return ((NBTTagShort)\u2603).func_150289_e();
        }
        return 0;
    }

    public int func_186858_c(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 3) {
            return ((NBTTagInt)\u2603).func_150287_d();
        }
        return 0;
    }

    public int[] func_150306_c(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 11) {
            return ((NBTTagIntArray)\u2603).func_150302_c();
        }
        return new int[0];
    }

    public double func_150309_d(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 6) {
            return ((NBTTagDouble)\u2603).func_150286_g();
        }
        return 0.0;
    }

    public float func_150308_e(int n) {
        if (n >= 0 && n < this.field_74747_a.size() && (\u2603 = this.field_74747_a.get(n)).func_74732_a() == 5) {
            return ((NBTTagFloat)\u2603).func_150288_h();
        }
        return 0.0f;
    }

    public String func_150307_f(int n) {
        if (n < 0 || n >= this.field_74747_a.size()) {
            return "";
        }
        INBTBase iNBTBase = this.field_74747_a.get(n);
        if (iNBTBase.func_74732_a() == 8) {
            return iNBTBase.func_150285_a_();
        }
        return iNBTBase.toString();
    }

    @Override
    public INBTBase get(int n) {
        if (n < 0 || n >= this.field_74747_a.size()) {
            return new NBTTagEnd();
        }
        return this.field_74747_a.get(n);
    }

    @Override
    public int size() {
        return this.field_74747_a.size();
    }

    @Override
    public INBTBase func_197647_c(int n) {
        return this.field_74747_a.get(n);
    }

    @Override
    public void func_197648_a(int n, INBTBase iNBTBase) {
        this.field_74747_a.set(n, iNBTBase);
    }

    @Override
    public void func_197649_b(int n) {
        this.field_74747_a.remove(n);
    }

    @Override
    public NBTTagList func_74737_b() {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.field_74746_b = this.field_74746_b;
        for (INBTBase iNBTBase : this.field_74747_a) {
            \u2603 = iNBTBase.func_74737_b();
            nBTTagList.field_74747_a.add(\u2603);
        }
        return nBTTagList;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagList && Objects.equals(this.field_74747_a, ((NBTTagList)object).field_74747_a);
    }

    @Override
    public int hashCode() {
        return this.field_74747_a.hashCode();
    }

    @Override
    public ITextComponent func_199850_a(String string2, int n) {
        String string2;
        if (this.isEmpty()) {
            return new TextComponentString("[]");
        }
        TextComponentString textComponentString = new TextComponentString("[");
        if (!string2.isEmpty()) {
            textComponentString.func_150258_a("\n");
        }
        for (int i = 0; i < this.field_74747_a.size(); ++i) {
            TextComponentString textComponentString2 = new TextComponentString(Strings.repeat((String)string2, (int)(n + 1)));
            textComponentString2.func_150257_a(this.field_74747_a.get(i).func_199850_a(string2, n + 1));
            if (i != this.field_74747_a.size() - 1) {
                textComponentString2.func_150258_a(String.valueOf(',')).func_150258_a(string2.isEmpty() ? " " : "\n");
            }
            textComponentString.func_150257_a(textComponentString2);
        }
        if (!string2.isEmpty()) {
            textComponentString.func_150258_a("\n").func_150258_a(Strings.repeat((String)string2, (int)n));
        }
        textComponentString.func_150258_a("]");
        return textComponentString;
    }

    public int func_150303_d() {
        return this.field_74746_b;
    }

    @Override
    public /* synthetic */ INBTBase func_74737_b() {
        return this.func_74737_b();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (INBTBase)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        return this.add((INBTBase)object);
    }
}

