/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTurtleEgg;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityTurtle
extends EntityAnimal {
    private static final DataParameter<BlockPos> field_203030_by = EntityDataManager.func_187226_a(EntityTurtle.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_203031_bz = EntityDataManager.func_187226_a(EntityTurtle.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_203024_bB = EntityDataManager.func_187226_a(EntityTurtle.class, DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> field_203025_bC = EntityDataManager.func_187226_a(EntityTurtle.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_203026_bD = EntityDataManager.func_187226_a(EntityTurtle.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_203027_bE = EntityDataManager.func_187226_a(EntityTurtle.class, DataSerializers.field_187198_h);
    private int field_203028_bF;
    public static final Predicate<Entity> field_203029_bx = entity -> {
        if (entity instanceof EntityLivingBase) {
            return ((EntityLivingBase)entity).func_70631_g_() && !entity.func_70090_H();
        }
        return false;
    };

    public EntityTurtle(World world) {
        super(EntityType.field_203099_aq, world);
        this.func_70105_a(1.2f, 0.4f);
        this.field_70765_h = new MoveHelper(this);
        this.field_175506_bl = Blocks.field_150354_m;
        this.field_70138_W = 1.0f;
    }

    public void func_203011_g(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_203030_by, blockPos);
    }

    private BlockPos func_203018_dA() {
        return this.field_70180_af.func_187225_a(field_203030_by);
    }

    private void func_203019_h(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_203025_bC, blockPos);
    }

    private BlockPos func_203013_dB() {
        return this.field_70180_af.func_187225_a(field_203025_bC);
    }

    public boolean func_203020_dx() {
        return this.field_70180_af.func_187225_a(field_203031_bz);
    }

    private void func_203017_r(boolean bl) {
        this.field_70180_af.func_187227_b(field_203031_bz, bl);
    }

    public boolean func_203023_dy() {
        return this.field_70180_af.func_187225_a(field_203024_bB);
    }

    private void func_203015_s(boolean bl) {
        this.field_203028_bF = bl ? 1 : 0;
        this.field_70180_af.func_187227_b(field_203024_bB, bl);
    }

    private boolean func_203022_dF() {
        return this.field_70180_af.func_187225_a(field_203026_bD);
    }

    private void func_203012_t(boolean bl) {
        this.field_70180_af.func_187227_b(field_203026_bD, bl);
    }

    private boolean func_203014_dG() {
        return this.field_70180_af.func_187225_a(field_203027_bE);
    }

    private void func_203021_u(boolean bl) {
        this.field_70180_af.func_187227_b(field_203027_bE, bl);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203030_by, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_203031_bz, false);
        this.field_70180_af.func_187214_a(field_203025_bC, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_203026_bD, false);
        this.field_70180_af.func_187214_a(field_203027_bE, false);
        this.field_70180_af.func_187214_a(field_203024_bB, false);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("HomePosX", this.func_203018_dA().func_177958_n());
        nBTTagCompound.func_74768_a("HomePosY", this.func_203018_dA().func_177956_o());
        nBTTagCompound.func_74768_a("HomePosZ", this.func_203018_dA().func_177952_p());
        nBTTagCompound.func_74757_a("HasEgg", this.func_203020_dx());
        nBTTagCompound.func_74768_a("TravelPosX", this.func_203013_dB().func_177958_n());
        nBTTagCompound.func_74768_a("TravelPosY", this.func_203013_dB().func_177956_o());
        nBTTagCompound.func_74768_a("TravelPosZ", this.func_203013_dB().func_177952_p());
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        int n = nBTTagCompound.func_74762_e("HomePosX");
        \u2603 = nBTTagCompound.func_74762_e("HomePosY");
        \u2603 = nBTTagCompound.func_74762_e("HomePosZ");
        this.func_203011_g(new BlockPos(n, \u2603, \u2603));
        super.func_70037_a(nBTTagCompound);
        this.func_203017_r(nBTTagCompound.func_74767_n("HasEgg"));
        \u2603 = nBTTagCompound.func_74762_e("TravelPosX");
        \u2603 = nBTTagCompound.func_74762_e("TravelPosY");
        \u2603 = nBTTagCompound.func_74762_e("TravelPosZ");
        this.func_203019_h(new BlockPos(\u2603, \u2603, \u2603));
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData, @Nullable NBTTagCompound nBTTagCompound) {
        this.func_203011_g(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        this.func_203019_h(BlockPos.field_177992_a);
        return super.func_204210_a(difficultyInstance, iEntityLivingData, nBTTagCompound);
    }

    @Override
    public boolean func_205020_a(IWorld iWorld, boolean bl) {
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return blockPos.func_177956_o() < iWorld.func_181545_F() + 4 && super.func_205020_a(iWorld, bl);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new AIPanic(this, 1.2));
        this.field_70714_bg.func_75776_a(1, new AIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(1, new AILayEgg(this, 1.0));
        this.field_70714_bg.func_75776_a(2, new AIPlayerTempt(this, 1.1, Blocks.field_203198_aQ.func_199767_j()));
        this.field_70714_bg.func_75776_a(3, new AIGoToWater(this, 1.0));
        this.field_70714_bg.func_75776_a(4, new AIGoHome(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new AITravel(this, 1.0));
        this.field_70714_bg.func_75776_a(8, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, new AIWander(this, 1.0, 100));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    @Override
    public int func_70627_aG() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (!this.func_70090_H() && this.field_70122_E && !this.func_70631_g_()) {
            return SoundEvents.field_203277_iv;
        }
        return super.func_184639_G();
    }

    @Override
    protected void func_203006_d(float f) {
        super.func_203006_d(f * 1.5f);
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203265_iE;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.func_70631_g_()) {
            return SoundEvents.field_203262_iB;
        }
        return SoundEvents.field_203261_iA;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        if (this.func_70631_g_()) {
            return SoundEvents.field_203264_iD;
        }
        return SoundEvents.field_203263_iC;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        SoundEvent soundEvent = this.func_70631_g_() ? SoundEvents.field_203267_iG : SoundEvents.field_203266_iF;
        this.func_184185_a(soundEvent, 0.15f, 1.0f);
    }

    @Override
    public boolean func_204701_dC() {
        return super.func_204701_dC() && !this.func_203020_dx();
    }

    @Override
    protected float func_203009_ad() {
        return this.field_82151_R + 0.15f;
    }

    @Override
    public void func_98054_a(boolean bl) {
        this.func_98055_j(bl ? 0.3f : 1.0f);
    }

    @Override
    protected PathNavigate func_175447_b(World world) {
        return new PathNavigater(this, world);
    }

    @Override
    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return new EntityTurtle(this.field_70170_p);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b() == Blocks.field_203198_aQ.func_199767_j();
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReaderBase iWorldReaderBase) {
        if (!this.func_203022_dF() && iWorldReaderBase.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a)) {
            return 10.0f;
        }
        return super.func_205022_a(blockPos, iWorldReaderBase);
    }

    @Override
    public void func_70636_d() {
        BlockPos blockPos;
        super.func_70636_d();
        if (this.func_203023_dy() && this.field_203028_bF >= 1 && this.field_203028_bF % 5 == 0 && this.field_70170_p.func_180495_p((blockPos = new BlockPos(this)).func_177977_b()).func_177230_c() == Blocks.field_150354_m) {
            this.field_70170_p.func_175718_b(2001, blockPos, Block.func_196246_j(Blocks.field_150354_m.func_176223_P()));
        }
    }

    @Override
    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.func_199702_a(Items.field_203183_eM, 1);
        }
    }

    @Override
    public void func_191986_a(float f, float f2, float f3) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(f, f2, f3, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (!(this.func_70638_az() != null || this.func_203022_dF() && this.func_174818_b(this.func_203018_dA()) < 400.0)) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_191986_a(f, f2, f3);
        }
    }

    @Override
    public boolean func_184652_a(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_203249_aB;
    }

    @Override
    public void func_70077_a(EntityLightningBolt entityLightningBolt) {
        this.func_70097_a(DamageSource.field_180137_b, Float.MAX_VALUE);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (damageSource == DamageSource.field_180137_b) {
            this.func_70099_a(new ItemStack(Items.field_151054_z, 1), 0.0f);
        }
    }

    static class PathNavigater
    extends PathNavigateSwimmer {
        PathNavigater(EntityTurtle entityTurtle, World world) {
            super(entityTurtle, world);
        }

        @Override
        protected boolean func_75485_k() {
            return true;
        }

        @Override
        protected PathFinder func_179679_a() {
            return new PathFinder(new WalkAndSwimNodeProcessor());
        }

        @Override
        public boolean func_188555_b(BlockPos blockPos) {
            if (this.field_75515_a instanceof EntityTurtle && (\u2603 = (EntityTurtle)this.field_75515_a).func_203014_dG()) {
                return this.field_75513_b.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j;
            }
            return !this.field_75513_b.func_180495_p(blockPos.func_177977_b()).func_196958_f();
        }
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private final EntityTurtle field_203103_i;

        MoveHelper(EntityTurtle entityTurtle) {
            super(entityTurtle);
            this.field_203103_i = entityTurtle;
        }

        private void func_203102_g() {
            if (this.field_203103_i.func_70090_H()) {
                this.field_203103_i.field_70181_x += 0.005;
                if (this.field_203103_i.func_174818_b(this.field_203103_i.func_203018_dA()) > 256.0) {
                    this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 2.0f, 0.08f));
                }
                if (this.field_203103_i.func_70631_g_()) {
                    this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.field_203103_i.field_70122_E) {
                this.field_203103_i.func_70659_e(Math.max(this.field_203103_i.func_70689_ay() / 2.0f, 0.06f));
            }
        }

        @Override
        public void func_75641_c() {
            this.func_203102_g();
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO || this.field_203103_i.func_70661_as().func_75500_f()) {
                this.field_203103_i.func_70659_e(0.0f);
                return;
            }
            double d = this.field_75646_b - this.field_203103_i.field_70165_t;
            \u2603 = this.field_75647_c - this.field_203103_i.field_70163_u;
            \u2603 = this.field_75644_d - this.field_203103_i.field_70161_v;
            \u2603 = MathHelper.func_76133_a(d * d + \u2603 * \u2603 + \u2603 * \u2603);
            float \u26032 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
            this.field_203103_i.field_70761_aq = this.field_203103_i.field_70177_z = this.func_75639_a(this.field_203103_i.field_70177_z, \u26032, 90.0f);
            float \u26033 = (float)(this.field_75645_e * this.field_203103_i.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            this.field_203103_i.func_70659_e(this.field_203103_i.func_70689_ay() + (\u26033 - this.field_203103_i.func_70689_ay()) * 0.125f);
            this.field_203103_i.field_70181_x += (double)this.field_203103_i.func_70689_ay() * (\u2603 /= \u2603) * 0.1;
        }
    }

    static class AIGoToWater
    extends EntityAIMoveToBlock {
        private final EntityTurtle field_203121_f;

        private AIGoToWater(EntityTurtle entityTurtle, double d) {
            super(entityTurtle, entityTurtle.func_70631_g_() ? 2.0 : d, 24);
            this.field_203121_f = entityTurtle;
            this.field_203112_e = -1;
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_203121_f.func_70090_H() && this.field_179493_e <= 1200 && this.func_179488_a(this.field_203121_f.field_70170_p, this.field_179494_b);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203121_f.func_70631_g_() && !this.field_203121_f.func_70090_H()) {
                return super.func_75250_a();
            }
            if (!(this.field_203121_f.func_203022_dF() || this.field_203121_f.func_70090_H() || this.field_203121_f.func_203020_dx())) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public int func_203111_j() {
            return 1;
        }

        @Override
        public boolean func_203108_i() {
            return this.field_179493_e % 160 == 0;
        }

        @Override
        protected boolean func_179488_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
            Block block = iWorldReaderBase.func_180495_p(blockPos).func_177230_c();
            return block == Blocks.field_150355_j;
        }
    }

    static class AIWander
    extends EntityAIWander {
        private final EntityTurtle field_203123_h;

        private AIWander(EntityTurtle entityTurtle, double d, int n) {
            super(entityTurtle, d, n);
            this.field_203123_h = entityTurtle;
        }

        @Override
        public boolean func_75250_a() {
            if (!(this.field_75457_a.func_70090_H() || this.field_203123_h.func_203022_dF() || this.field_203123_h.func_203020_dx())) {
                return super.func_75250_a();
            }
            return false;
        }
    }

    static class AILayEgg
    extends EntityAIMoveToBlock {
        private final EntityTurtle field_203122_f;

        AILayEgg(EntityTurtle entityTurtle, double d) {
            super(entityTurtle, d, 16);
            this.field_203122_f = entityTurtle;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203122_f.func_203020_dx() && this.field_203122_f.func_174818_b(this.field_203122_f.func_203018_dA()) < 81.0) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_203122_f.func_203020_dx() && this.field_203122_f.func_174818_b(this.field_203122_f.func_203018_dA()) < 81.0;
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockPos = new BlockPos(this.field_203122_f);
            if (!this.field_203122_f.func_70090_H() && this.func_179487_f()) {
                if (this.field_203122_f.field_203028_bF < 1) {
                    this.field_203122_f.func_203015_s(true);
                } else if (this.field_203122_f.field_203028_bF > 200) {
                    World world = this.field_203122_f.field_70170_p;
                    world.func_184133_a(null, blockPos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (IBlockState)Blocks.field_203213_jA.func_176223_P().func_206870_a(BlockTurtleEgg.field_203171_b, this.field_203122_f.field_70146_Z.nextInt(4) + 1), 3);
                    this.field_203122_f.func_203017_r(false);
                    this.field_203122_f.func_203015_s(false);
                    this.field_203122_f.func_204700_e(600);
                }
                if (this.field_203122_f.func_203023_dy()) {
                    this.field_203122_f.field_203028_bF++;
                }
            }
        }

        @Override
        protected boolean func_179488_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
            if (!iWorldReaderBase.func_175623_d(blockPos.func_177984_a())) {
                return false;
            }
            Block block = iWorldReaderBase.func_180495_p(blockPos).func_177230_c();
            return block == Blocks.field_150354_m;
        }
    }

    static class AIMate
    extends EntityAIMate {
        private final EntityTurtle field_203107_f;

        AIMate(EntityTurtle entityTurtle, double d) {
            super(entityTurtle, d);
            this.field_203107_f = entityTurtle;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_203107_f.func_203020_dx();
        }

        @Override
        protected void func_75388_i() {
            EntityPlayerMP entityPlayerMP = this.field_75390_d.func_191993_do();
            if (entityPlayerMP == null && this.field_75391_e.func_191993_do() != null) {
                entityPlayerMP = this.field_75391_e.func_191993_do();
            }
            if (entityPlayerMP != null) {
                entityPlayerMP.func_195066_a(StatList.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(entityPlayerMP, this.field_75390_d, this.field_75391_e, null);
            }
            this.field_203107_f.func_203017_r(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random \u26032 = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_82766_b("doMobLoot")) {
                this.field_75394_a.func_72838_d(new EntityXPOrb(this.field_75394_a, this.field_75390_d.field_70165_t, this.field_75390_d.field_70163_u, this.field_75390_d.field_70161_v, \u26032.nextInt(7) + 1));
            }
        }
    }

    static class AIPlayerTempt
    extends EntityAIBase {
        private final EntityTurtle field_203132_a;
        private final double field_203133_b;
        private EntityPlayer field_203134_c;
        private int field_203135_d;
        private final Set<Item> field_203136_e;

        AIPlayerTempt(EntityTurtle entityTurtle, double d, Item item) {
            this.field_203132_a = entityTurtle;
            this.field_203133_b = d;
            this.field_203136_e = Sets.newHashSet((Object[])new Item[]{item});
            this.func_75248_a(3);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203135_d > 0) {
                --this.field_203135_d;
                return false;
            }
            this.field_203134_c = this.field_203132_a.field_70170_p.func_72890_a(this.field_203132_a, 10.0);
            if (this.field_203134_c == null) {
                return false;
            }
            return this.func_203131_a(this.field_203134_c.func_184614_ca()) || this.func_203131_a(this.field_203134_c.func_184592_cb());
        }

        private boolean func_203131_a(ItemStack itemStack) {
            return this.field_203136_e.contains(itemStack.func_77973_b());
        }

        @Override
        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        @Override
        public void func_75251_c() {
            this.field_203134_c = null;
            this.field_203132_a.func_70661_as().func_75499_g();
            this.field_203135_d = 100;
        }

        @Override
        public void func_75246_d() {
            this.field_203132_a.func_70671_ap().func_75651_a(this.field_203134_c, this.field_203132_a.func_184649_cE() + 20, this.field_203132_a.func_70646_bf());
            if (this.field_203132_a.func_70068_e(this.field_203134_c) < 6.25) {
                this.field_203132_a.func_70661_as().func_75499_g();
            } else {
                this.field_203132_a.func_70661_as().func_75497_a(this.field_203134_c, this.field_203133_b);
            }
        }
    }

    static class AIGoHome
    extends EntityAIBase {
        private final EntityTurtle field_203127_a;
        private final double field_203128_b;
        private boolean field_203129_c;
        private int field_203130_d;

        AIGoHome(EntityTurtle entityTurtle, double d) {
            this.field_203127_a = entityTurtle;
            this.field_203128_b = d;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203127_a.func_70631_g_()) {
                return false;
            }
            if (this.field_203127_a.func_203020_dx()) {
                return true;
            }
            if (this.field_203127_a.func_70681_au().nextInt(700) != 0) {
                return false;
            }
            return this.field_203127_a.func_174818_b(this.field_203127_a.func_203018_dA()) >= 4096.0;
        }

        @Override
        public void func_75249_e() {
            this.field_203127_a.func_203012_t(true);
            this.field_203129_c = false;
            this.field_203130_d = 0;
        }

        @Override
        public void func_75251_c() {
            this.field_203127_a.func_203012_t(false);
        }

        @Override
        public boolean func_75253_b() {
            return this.field_203127_a.func_174818_b(this.field_203127_a.func_203018_dA()) >= 49.0 && !this.field_203129_c && this.field_203130_d <= 600;
        }

        @Override
        public void func_75246_d() {
            BlockPos blockPos = this.field_203127_a.func_203018_dA();
            boolean bl = \u2603 = this.field_203127_a.func_174818_b(blockPos) <= 256.0;
            if (\u2603) {
                ++this.field_203130_d;
            }
            if (this.field_203127_a.func_70661_as().func_75500_f()) {
                Vec3d vec3d = RandomPositionGenerator.func_203155_a(this.field_203127_a, 16, 3, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), 0.3141592741012573);
                if (vec3d == null) {
                    vec3d = RandomPositionGenerator.func_75464_a(this.field_203127_a, 8, 7, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
                if (vec3d != null && !\u2603 && this.field_203127_a.field_70170_p.func_180495_p(new BlockPos(vec3d)).func_177230_c() != Blocks.field_150355_j) {
                    vec3d = RandomPositionGenerator.func_75464_a(this.field_203127_a, 16, 5, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
                if (vec3d == null) {
                    this.field_203129_c = true;
                    return;
                }
                this.field_203127_a.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.field_203128_b);
            }
        }
    }

    static class AITravel
    extends EntityAIBase {
        private final EntityTurtle field_203137_a;
        private final double field_203138_b;
        private boolean field_203139_c;

        AITravel(EntityTurtle entityTurtle, double d) {
            this.field_203137_a = entityTurtle;
            this.field_203138_b = d;
        }

        @Override
        public boolean func_75250_a() {
            return !this.field_203137_a.func_203022_dF() && !this.field_203137_a.func_203020_dx() && this.field_203137_a.func_70090_H();
        }

        @Override
        public void func_75249_e() {
            int n = 512;
            \u2603 = 4;
            Random \u26032 = this.field_203137_a.field_70146_Z;
            \u2603 = \u26032.nextInt(1025) - 512;
            \u2603 = \u26032.nextInt(9) - 4;
            \u2603 = \u26032.nextInt(1025) - 512;
            if ((double)\u2603 + this.field_203137_a.field_70163_u > (double)(this.field_203137_a.field_70170_p.func_181545_F() - 1)) {
                \u2603 = 0;
            }
            BlockPos \u26033 = new BlockPos((double)\u2603 + this.field_203137_a.field_70165_t, (double)\u2603 + this.field_203137_a.field_70163_u, (double)\u2603 + this.field_203137_a.field_70161_v);
            this.field_203137_a.func_203019_h(\u26033);
            this.field_203137_a.func_203021_u(true);
            this.field_203139_c = false;
        }

        @Override
        public void func_75246_d() {
            if (this.field_203137_a.func_70661_as().func_75500_f()) {
                BlockPos blockPos = this.field_203137_a.func_203013_dB();
                Vec3d \u26032 = RandomPositionGenerator.func_203155_a(this.field_203137_a, 16, 3, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), 0.3141592741012573);
                if (\u26032 == null) {
                    \u26032 = RandomPositionGenerator.func_75464_a(this.field_203137_a, 8, 7, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
                if (\u26032 != null) {
                    int n = MathHelper.func_76128_c(\u26032.field_72450_a);
                    \u2603 = MathHelper.func_76128_c(\u26032.field_72449_c);
                    \u2603 = 34;
                    MutableBoundingBox \u26033 = new MutableBoundingBox(n - 34, 0, \u2603 - 34, n + 34, 0, \u2603 + 34);
                    if (!this.field_203137_a.field_70170_p.func_175711_a(\u26033)) {
                        \u26032 = null;
                    }
                }
                if (\u26032 == null) {
                    this.field_203139_c = true;
                    return;
                }
                this.field_203137_a.func_70661_as().func_75492_a(\u26032.field_72450_a, \u26032.field_72448_b, \u26032.field_72449_c, this.field_203138_b);
            }
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_203137_a.func_70661_as().func_75500_f() && !this.field_203139_c && !this.field_203137_a.func_203022_dF() && !this.field_203137_a.func_70880_s() && !this.field_203137_a.func_203020_dx();
        }

        @Override
        public void func_75251_c() {
            this.field_203137_a.func_203021_u(false);
            super.func_75251_c();
        }
    }

    static class AIPanic
    extends EntityAIPanic {
        AIPanic(EntityTurtle entityTurtle, double d) {
            super(entityTurtle, d);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_75267_a.func_70643_av() == null && !this.field_75267_a.func_70027_ad()) {
                return false;
            }
            BlockPos blockPos = this.func_188497_a(this.field_75267_a.field_70170_p, this.field_75267_a, 7, 4);
            if (blockPos != null) {
                this.field_75266_c = blockPos.func_177958_n();
                this.field_75263_d = blockPos.func_177956_o();
                this.field_75264_e = blockPos.func_177952_p();
                return true;
            }
            return this.func_190863_f();
        }
    }
}

