/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityPig
extends EntityAnimal {
    private static final DataParameter<Boolean> field_184763_bv = EntityDataManager.func_187226_a(EntityPig.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_191520_bx = EntityDataManager.func_187226_a(EntityPig.class, DataSerializers.field_187192_b);
    private static final Ingredient field_184764_bw = Ingredient.func_199804_a(Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV);
    private boolean field_184765_bx;
    private int field_184766_bz;
    private int field_184767_bA;

    public EntityPig(World world) {
        super(EntityType.field_200784_X, world);
        this.func_70105_a(0.9f, 0.9f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, new EntityAIPanic(this, 1.25));
        this.field_70714_bg.func_75776_a(3, new EntityAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(4, new EntityAITempt((EntityCreature)this, 1.2, Ingredient.func_199804_a(Items.field_151146_bM), false));
        this.field_70714_bg.func_75776_a(4, new EntityAITempt((EntityCreature)this, 1.2, false, field_184764_bw));
        this.field_70714_bg.func_75776_a(5, new EntityAIFollowParent(this, 1.1));
        this.field_70714_bg.func_75776_a(6, new EntityAIWanderAvoidWater(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_184188_bt().get(0);
    }

    @Override
    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer \u26032 = (EntityPlayer)entity;
        return \u26032.func_184614_ca().func_77973_b() == Items.field_151146_bM || \u26032.func_184592_cb().func_77973_b() == Items.field_151146_bM;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_191520_bx.equals(dataParameter) && this.field_70170_p.field_72995_K) {
            this.field_184765_bx = true;
            this.field_184766_bz = 0;
            this.field_184767_bA = this.field_70180_af.func_187225_a(field_191520_bx);
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184763_bv, false);
        this.field_70180_af.func_187214_a(field_191520_bx, 0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Saddle", this.func_70901_n());
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.func_70900_e(nBTTagCompound.func_74767_n("Saddle"));
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187703_dN;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityPlayer, EnumHand enumHand) {
        if (!super.func_184645_a(entityPlayer, enumHand)) {
            ItemStack itemStack = entityPlayer.func_184586_b(enumHand);
            if (itemStack.func_77973_b() == Items.field_151057_cb) {
                itemStack.func_111282_a(entityPlayer, this, enumHand);
                return true;
            }
            if (this.func_70901_n() && !this.func_184207_aI()) {
                if (!this.field_70170_p.field_72995_K) {
                    entityPlayer.func_184220_m(this);
                }
                return true;
            }
            if (itemStack.func_77973_b() == Items.field_151141_av) {
                itemStack.func_111282_a(entityPlayer, this, enumHand);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70901_n()) {
            this.func_199703_a(Items.field_151141_av);
        }
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186395_C;
    }

    public boolean func_70901_n() {
        return this.field_70180_af.func_187225_a(field_184763_bv);
    }

    public void func_70900_e(boolean bl) {
        if (bl) {
            this.field_70180_af.func_187227_b(field_184763_bv, true);
        } else {
            this.field_70180_af.func_187227_b(field_184763_bv, false);
        }
    }

    @Override
    public void func_70077_a(EntityLightningBolt entityLightningBolt) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return;
        }
        EntityPigZombie entityPigZombie = new EntityPigZombie(this.field_70170_p);
        entityPigZombie.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
        entityPigZombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        entityPigZombie.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            entityPigZombie.func_200203_b(this.func_200201_e());
            entityPigZombie.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_72838_d(entityPigZombie);
        this.func_70106_y();
    }

    @Override
    public void func_191986_a(float f, float f2, float f3) {
        Entity entity = \u2603 = this.func_184188_bt().isEmpty() ? null : this.func_184188_bt().get(0);
        if (!this.func_184207_aI() || !this.func_82171_bF()) {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(f, f2, f3);
            return;
        }
        this.field_70126_B = this.field_70177_z = \u2603.field_70177_z;
        this.field_70125_A = \u2603.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70761_aq = this.field_70177_z;
        this.field_70759_as = this.field_70177_z;
        this.field_70138_W = 1.0f;
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        if (this.field_184765_bx && this.field_184766_bz++ > this.field_184767_bA) {
            this.field_184765_bx = false;
        }
        if (this.func_184186_bw()) {
            \u2603 = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
            if (this.field_184765_bx) {
                \u2603 += \u2603 * 1.15f * MathHelper.func_76126_a((float)this.field_184766_bz / (float)this.field_184767_bA * (float)Math.PI);
            }
            this.func_70659_e(\u2603);
            super.func_191986_a(0.0f, 0.0f, 1.0f);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d = this.field_70165_t - this.field_70169_q;
        \u2603 = this.field_70161_v - this.field_70166_s;
        float \u26032 = MathHelper.func_76133_a(d * d + \u2603 * \u2603) * 4.0f;
        if (\u26032 > 1.0f) {
            \u26032 = 1.0f;
        }
        this.field_70721_aZ += (\u26032 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_184762_da() {
        if (this.field_184765_bx) {
            return false;
        }
        this.field_184765_bx = true;
        this.field_184766_bz = 0;
        this.field_184767_bA = this.func_70681_au().nextInt(841) + 140;
        this.func_184212_Q().func_187227_b(field_191520_bx, this.field_184767_bA);
        return true;
    }

    @Override
    public EntityPig func_90011_a(EntityAgeable entityAgeable) {
        return new EntityPig(this.field_70170_p);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return field_184764_bw.test(itemStack);
    }

    @Override
    public /* synthetic */ EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return this.func_90011_a(entityAgeable);
    }
}

