/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySpider
extends EntityMob {
    private static final DataParameter<Byte> field_184729_a = EntityDataManager.func_187226_a(EntitySpider.class, DataSerializers.field_187191_a);

    protected EntitySpider(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.func_70105_a(1.4f, 0.9f);
    }

    public EntitySpider(World world) {
        this(EntityType.field_200748_an, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, new EntityAILeapAtTarget(this, 0.4f));
        this.field_70714_bg.func_75776_a(4, new AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(5, new EntityAIWanderAvoidWater(this, 0.8));
        this.field_70714_bg.func_75776_a(6, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AISpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, new AISpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    @Override
    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateClimber(this, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184729_a, (byte)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70839_e(this.field_70123_F);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3f);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187821_fM;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186435_q;
    }

    @Override
    public boolean func_70617_f_() {
        return this.func_70841_p();
    }

    @Override
    public void func_70110_aj() {
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    public boolean func_70841_p() {
        return (this.field_70180_af.func_187225_a(field_184729_a) & 1) != 0;
    }

    public void func_70839_e(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184729_a);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(field_184729_a, by);
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData2, @Nullable NBTTagCompound nBTTagCompound) {
        IEntityLivingData iEntityLivingData2 = super.func_204210_a(difficultyInstance, iEntityLivingData2, nBTTagCompound);
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            Object object = new EntitySkeleton(this.field_70170_p);
            ((Entity)object).func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            ((AbstractSkeleton)object).func_204210_a(difficultyInstance, null, null);
            this.field_70170_p.func_72838_d((Entity)object);
            ((Entity)object).func_184220_m(this);
        }
        if (iEntityLivingData2 == null) {
            iEntityLivingData2 = new GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficultyInstance.func_180170_c()) {
                ((GroupData)iEntityLivingData2).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (iEntityLivingData2 instanceof GroupData && (object = ((GroupData)iEntityLivingData2).field_188478_a) != null) {
            this.func_195064_c(new PotionEffect((Potion)object, Integer.MAX_VALUE));
        }
        return iEntityLivingData2;
    }

    @Override
    public float func_70047_e() {
        return 0.65f;
    }

    static class AISpiderTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpiderTarget(EntitySpider entitySpider, Class<T> clazz) {
            super((EntityCreature)entitySpider, clazz, true);
        }

        @Override
        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            if (f >= 0.5f) {
                return false;
            }
            return super.func_75250_a();
        }
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(EntitySpider entitySpider) {
            super(entitySpider, 1.0, true);
        }

        @Override
        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        @Override
        protected double func_179512_a(EntityLivingBase entityLivingBase) {
            return 4.0f + entityLivingBase.field_70130_N;
        }
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion field_188478_a;

        public void func_111104_a(Random random) {
            int n = random.nextInt(5);
            if (n <= 1) {
                this.field_188478_a = MobEffects.field_76424_c;
            } else if (n <= 2) {
                this.field_188478_a = MobEffects.field_76420_g;
            } else if (n <= 3) {
                this.field_188478_a = MobEffects.field_76428_l;
            } else if (n <= 4) {
                this.field_188478_a = MobEffects.field_76441_p;
            }
        }
    }
}

