/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityShulker
extends EntityGolem
implements IMob {
    private static final UUID field_184703_bv = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier field_184704_bw = new AttributeModifier(field_184703_bv, "Covered armor bonus", 20.0, 0).func_111168_a(false);
    protected static final DataParameter<EnumFacing> field_184700_a = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187202_l);
    protected static final DataParameter<Optional<BlockPos>> field_184701_b = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187201_k);
    protected static final DataParameter<Byte> field_184702_c = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> field_190770_bw = EntityDataManager.func_187226_a(EntityShulker.class, DataSerializers.field_187191_a);
    private float field_184705_bx;
    private float field_184706_by;
    private BlockPos field_184707_bz;
    private int field_184708_bA;

    public EntityShulker(World world) {
        super(EntityType.field_200738_ad, world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70178_ae = true;
        this.field_184707_bz = null;
        this.field_70728_aV = 5;
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData, @Nullable NBTTagCompound nBTTagCompound) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        return super.func_204210_a(difficultyInstance, iEntityLivingData, nBTTagCompound);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, new AIAttack());
        this.field_70714_bg.func_75776_a(7, new AIPeek());
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIAttackNearest(this));
        this.field_70715_bh.func_75776_a(3, new AIDefenseAttack(this));
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    @Override
    public void func_70642_aH() {
        if (!this.func_184686_df()) {
            super.func_70642_aH();
        }
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.func_184686_df()) {
            return SoundEvents.field_187785_eU;
        }
        return SoundEvents.field_187783_eT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184700_a, EnumFacing.DOWN);
        this.field_70180_af.func_187214_a(field_184701_b, Optional.empty());
        this.field_70180_af.func_187214_a(field_184702_c, (byte)0);
        this.field_70180_af.func_187214_a(field_190770_bw, (byte)16);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    protected EntityBodyHelper func_184650_s() {
        return new BodyHelper(this);
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.field_70180_af.func_187227_b(field_184700_a, EnumFacing.func_82600_a(nBTTagCompound.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(field_184702_c, nBTTagCompound.func_74771_c("Peek"));
        this.field_70180_af.func_187227_b(field_190770_bw, nBTTagCompound.func_74771_c("Color"));
        if (nBTTagCompound.func_74764_b("APX")) {
            int n = nBTTagCompound.func_74762_e("APX");
            \u2603 = nBTTagCompound.func_74762_e("APY");
            \u2603 = nBTTagCompound.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(new BlockPos(n, \u2603, \u2603)));
        } else {
            this.field_70180_af.func_187227_b(field_184701_b, Optional.empty());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("AttachFace", (byte)this.field_70180_af.func_187225_a(field_184700_a).func_176745_a());
        nBTTagCompound.func_74774_a("Peek", this.field_70180_af.func_187225_a(field_184702_c));
        nBTTagCompound.func_74774_a("Color", this.field_70180_af.func_187225_a(field_190770_bw));
        BlockPos blockPos = this.func_184699_da();
        if (blockPos != null) {
            nBTTagCompound.func_74768_a("APX", blockPos.func_177958_n());
            nBTTagCompound.func_74768_a("APY", blockPos.func_177956_o());
            nBTTagCompound.func_74768_a("APZ", blockPos.func_177952_p());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos blockPos = this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
        if (blockPos == null && !this.field_70170_p.field_72995_K) {
            blockPos = new BlockPos(this);
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos));
        }
        if (this.func_184218_aH()) {
            blockPos = null;
            this.field_70177_z = f = this.func_184187_bx().field_70177_z;
            this.field_70761_aq = f;
            this.field_70760_ar = f;
            this.field_184708_bA = 0;
        } else if (!this.field_70170_p.field_72995_K) {
            Object object;
            IBlockState iBlockState = this.field_70170_p.func_180495_p(blockPos);
            if (!iBlockState.func_196958_f()) {
                if (iBlockState.func_177230_c() == Blocks.field_196603_bb) {
                    object = iBlockState.func_177229_b(BlockPistonBase.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockPos.func_177972_a((EnumFacing)object))) {
                        blockPos = blockPos.func_177972_a((EnumFacing)object);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos));
                    } else {
                        this.func_184689_o();
                    }
                } else if (iBlockState.func_177230_c() == Blocks.field_150332_K) {
                    object = iBlockState.func_177229_b(BlockPistonExtension.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockPos.func_177972_a((EnumFacing)object))) {
                        blockPos = blockPos.func_177972_a((EnumFacing)object);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos));
                    } else {
                        this.func_184689_o();
                    }
                } else {
                    this.func_184689_o();
                }
            }
            if (!this.field_70170_p.func_195595_w((BlockPos)(object = blockPos.func_177972_a(this.func_184696_cZ())))) {
                boolean \u26032 = false;
                for (EnumFacing enumFacing : EnumFacing.values()) {
                    object = blockPos.func_177972_a(enumFacing);
                    if (!this.field_70170_p.func_195595_w((BlockPos)object)) continue;
                    this.field_70180_af.func_187227_b(field_184700_a, enumFacing);
                    \u26032 = true;
                    break;
                }
                if (!\u26032) {
                    this.func_184689_o();
                }
            }
            if (this.field_70170_p.func_195595_w(\u2603 = blockPos.func_177972_a(this.func_184696_cZ().func_176734_d()))) {
                this.func_184689_o();
            }
        }
        float f = (float)this.func_184684_db() * 0.01f;
        this.field_184705_bx = this.field_184706_by;
        if (this.field_184706_by > f) {
            this.field_184706_by = MathHelper.func_76131_a(this.field_184706_by - 0.05f, f, 1.0f);
        } else if (this.field_184706_by < f) {
            this.field_184706_by = MathHelper.func_76131_a(this.field_184706_by + 0.05f, 0.0f, f);
        }
        if (blockPos != null) {
            if (this.field_70170_p.field_72995_K) {
                if (this.field_184708_bA > 0 && this.field_184707_bz != null) {
                    --this.field_184708_bA;
                } else {
                    this.field_184707_bz = blockPos;
                }
            }
            this.field_70165_t = (double)blockPos.func_177958_n() + 0.5;
            this.field_70163_u = blockPos.func_177956_o();
            this.field_70161_v = (double)blockPos.func_177952_p() + 0.5;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            double d = 0.5 - (double)MathHelper.func_76126_a((0.5f + this.field_184706_by) * (float)Math.PI) * 0.5;
            \u2603 = 0.5 - (double)MathHelper.func_76126_a((0.5f + this.field_184705_bx) * (float)Math.PI) * 0.5;
            \u2603 = d - \u2603;
            \u2603 = 0.0;
            \u2603 = 0.0;
            \u2603 = 0.0;
            EnumFacing \u26033 = this.func_184696_cZ();
            switch (\u26033) {
                case DOWN: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0 + d, this.field_70161_v + 0.5));
                    \u2603 = \u2603;
                    break;
                }
                case UP: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - d, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    \u2603 = -\u2603;
                    break;
                }
                case NORTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5 + d));
                    \u2603 = \u2603;
                    break;
                }
                case SOUTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5 - d, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    \u2603 = -\u2603;
                    break;
                }
                case WEST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5 + d, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    \u2603 = \u2603;
                    break;
                }
                case EAST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5 - d, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    \u2603 = -\u2603;
                }
            }
            if (\u2603 > 0.0 && !(\u2603 = this.field_70170_p.func_72839_b(this, this.func_174813_aQ())).isEmpty()) {
                for (Entity entity : \u2603) {
                    if (entity instanceof EntityShulker || entity.field_70145_X) continue;
                    entity.func_70091_d(MoverType.SHULKER, \u2603, \u2603, \u2603);
                }
            }
        }
    }

    @Override
    public void func_70091_d(MoverType moverType, double d, double d2, double d3) {
        if (moverType == MoverType.SHULKER_BOX) {
            this.func_184689_o();
        } else {
            super.func_70091_d(moverType, d, d2, d3);
        }
    }

    @Override
    public void func_70107_b(double d, double d2, double d3) {
        super.func_70107_b(d, d2, d3);
        if (this.field_70180_af == null || this.field_70173_aa == 0) {
            return;
        }
        Optional<BlockPos> optional = this.field_70180_af.func_187225_a(field_184701_b);
        \u2603 = Optional.of(new BlockPos(d, d2, d3));
        if (!\u2603.equals(optional)) {
            this.field_70180_af.func_187227_b(field_184701_b, \u2603);
            this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
            this.field_70160_al = true;
        }
    }

    protected boolean func_184689_o() {
        if (this.func_175446_cd() || !this.func_70089_S()) {
            return true;
        }
        BlockPos blockPos = new BlockPos(this);
        for (int i = 0; i < 5; ++i) {
            BlockPos blockPos2 = blockPos.func_177982_a(8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17));
            if (blockPos2.func_177956_o() <= 0 || !this.field_70170_p.func_175623_d(blockPos2) || !this.field_70170_p.func_191503_g(this) || !this.field_70170_p.func_195586_b(this, new AxisAlignedBB(blockPos2))) continue;
            boolean \u26032 = false;
            for (EnumFacing enumFacing : EnumFacing.values()) {
                if (!this.field_70170_p.func_195595_w(blockPos2.func_177972_a(enumFacing))) continue;
                this.field_70180_af.func_187227_b(field_184700_a, enumFacing);
                \u26032 = true;
                break;
            }
            if (!\u26032) continue;
            this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos2));
            this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
            this.func_70624_b(null);
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70177_z = 180.0f;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184701_b.equals(dataParameter) && this.field_70170_p.field_72995_K && !this.func_184218_aH() && (\u2603 = this.func_184699_da()) != null) {
            if (this.field_184707_bz == null) {
                this.field_184707_bz = \u2603;
            } else {
                this.field_184708_bA = 6;
            }
            this.field_70165_t = (double)\u2603.func_177958_n() + 0.5;
            this.field_70163_u = \u2603.func_177956_o();
            this.field_70161_v = (double)\u2603.func_177952_p() + 0.5;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_184686_df() && (\u2603 = damageSource.func_76364_f()) instanceof EntityArrow) {
            return false;
        }
        if (super.func_70097_a(damageSource, f)) {
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5 && this.field_70146_Z.nextInt(4) == 0) {
                this.func_184689_o();
            }
            return true;
        }
        return false;
    }

    private boolean func_184686_df() {
        return this.func_184684_db() == 0;
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public EnumFacing func_184696_cZ() {
        return this.field_70180_af.func_187225_a(field_184700_a);
    }

    @Nullable
    public BlockPos func_184699_da() {
        return this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
    }

    public void func_184694_g(@Nullable BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_184701_b, Optional.ofNullable(blockPos));
    }

    public int func_184684_db() {
        return this.field_70180_af.func_187225_a(field_184702_c).byteValue();
    }

    public void func_184691_a(int n) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(field_184704_bw);
            if (n == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(field_184704_bw);
                this.func_184185_a(SoundEvents.field_187779_eR, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187787_eV, 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(field_184702_c, (byte)n);
    }

    @Override
    public float func_70047_e() {
        return 0.5f;
    }

    @Override
    public int func_70646_bf() {
        return 180;
    }

    @Override
    public int func_184649_cE() {
        return 180;
    }

    @Override
    public void func_70108_f(Entity entity) {
    }

    @Override
    public float func_70111_Y() {
        return 0.0f;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186442_x;
    }

    static class AIDefenseAttack
    extends EntityAINearestAttackableTarget<EntityLivingBase> {
        public AIDefenseAttack(EntityShulker entityShulker) {
            super(entityShulker, EntityLivingBase.class, 10, true, false, entityLivingBase -> entityLivingBase instanceof IMob);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_75299_d.func_96124_cp() == null) {
                return false;
            }
            return super.func_75250_a();
        }

        @Override
        protected AxisAlignedBB func_188511_a(double d) {
            EnumFacing enumFacing = ((EntityShulker)this.field_75299_d).func_184696_cZ();
            if (enumFacing.func_176740_k() == EnumFacing.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, d, d);
            }
            if (enumFacing.func_176740_k() == EnumFacing.Axis.Z) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(d, d, 4.0);
            }
            return this.field_75299_d.func_174813_aQ().func_72314_b(d, 4.0, d);
        }
    }

    class AIAttackNearest
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackNearest(EntityShulker entityShulker2) {
            super((EntityCreature)entityShulker2, EntityPlayer.class, true);
        }

        @Override
        public boolean func_75250_a() {
            if (EntityShulker.this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                return false;
            }
            return super.func_75250_a();
        }

        @Override
        protected AxisAlignedBB func_188511_a(double d) {
            EnumFacing enumFacing = ((EntityShulker)this.field_75299_d).func_184696_cZ();
            if (enumFacing.func_176740_k() == EnumFacing.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, d, d);
            }
            if (enumFacing.func_176740_k() == EnumFacing.Axis.Z) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(d, d, 4.0);
            }
            return this.field_75299_d.func_174813_aQ().func_72314_b(d, 4.0, d);
        }
    }

    class AIAttack
    extends EntityAIBase {
        private int field_188520_b;

        public AIAttack() {
            this.func_75248_a(3);
        }

        @Override
        public boolean func_75250_a() {
            EntityLivingBase entityLivingBase = EntityShulker.this.func_70638_az();
            if (entityLivingBase == null || !entityLivingBase.func_70089_S()) {
                return false;
            }
            return EntityShulker.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
        }

        @Override
        public void func_75249_e() {
            this.field_188520_b = 20;
            EntityShulker.this.func_184691_a(100);
        }

        @Override
        public void func_75251_c() {
            EntityShulker.this.func_184691_a(0);
        }

        @Override
        public void func_75246_d() {
            if (EntityShulker.this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                return;
            }
            --this.field_188520_b;
            EntityLivingBase entityLivingBase = EntityShulker.this.func_70638_az();
            EntityShulker.this.func_70671_ap().func_75651_a(entityLivingBase, 180.0f, 180.0f);
            double \u26032 = EntityShulker.this.func_70068_e(entityLivingBase);
            if (\u26032 < 400.0) {
                if (this.field_188520_b <= 0) {
                    this.field_188520_b = 20 + EntityShulker.this.field_70146_Z.nextInt(10) * 20 / 2;
                    EntityShulkerBullet entityShulkerBullet = new EntityShulkerBullet(EntityShulker.this.field_70170_p, EntityShulker.this, entityLivingBase, EntityShulker.this.func_184696_cZ().func_176740_k());
                    EntityShulker.this.field_70170_p.func_72838_d(entityShulkerBullet);
                    EntityShulker.this.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (EntityShulker.this.field_70146_Z.nextFloat() - EntityShulker.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                EntityShulker.this.func_70624_b(null);
            }
            super.func_75246_d();
        }
    }

    class AIPeek
    extends EntityAIBase {
        private int field_188522_b;

        private AIPeek() {
        }

        @Override
        public boolean func_75250_a() {
            return EntityShulker.this.func_70638_az() == null && EntityShulker.this.field_70146_Z.nextInt(40) == 0;
        }

        @Override
        public boolean func_75253_b() {
            return EntityShulker.this.func_70638_az() == null && this.field_188522_b > 0;
        }

        @Override
        public void func_75249_e() {
            this.field_188522_b = 20 * (1 + EntityShulker.this.field_70146_Z.nextInt(3));
            EntityShulker.this.func_184691_a(30);
        }

        @Override
        public void func_75251_c() {
            if (EntityShulker.this.func_70638_az() == null) {
                EntityShulker.this.func_184691_a(0);
            }
        }

        @Override
        public void func_75246_d() {
            --this.field_188522_b;
        }
    }

    class BodyHelper
    extends EntityBodyHelper {
        public BodyHelper(EntityLivingBase entityLivingBase) {
            super(entityLivingBase);
        }

        @Override
        public void func_75664_a() {
        }
    }
}

