/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityPolarBear
extends EntityAnimal {
    private static final DataParameter<Boolean> field_189798_bx = EntityDataManager.func_187226_a(EntityPolarBear.class, DataSerializers.field_187198_h);
    private float field_189799_by;
    private float field_189800_bz;
    private int field_189797_bB;

    public EntityPolarBear(World world) {
        super(EntityType.field_200786_Z, world);
        this.func_70105_a(1.3f, 1.4f);
    }

    @Override
    public EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return new EntityPolarBear(this.field_70170_p);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return false;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, new AIMeleeAttack());
        this.field_70714_bg.func_75776_a(1, new AIPanic());
        this.field_70714_bg.func_75776_a(4, new EntityAIFollowParent(this, 1.25));
        this.field_70714_bg.func_75776_a(5, new EntityAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new AIHurtByTarget());
        this.field_70715_bh.func_75776_a(2, new AIAttackPlayer());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public boolean func_205020_a(IWorld iWorld, boolean bl) {
        int n = MathHelper.func_76128_c(this.field_70165_t);
        BlockPos \u26032 = new BlockPos(n, \u2603 = MathHelper.func_76128_c(this.func_174813_aQ().field_72338_b), \u2603 = MathHelper.func_76128_c(this.field_70161_v));
        Biome \u26033 = iWorld.func_180494_b(\u26032);
        if (\u26033 == Biomes.field_76776_l || \u26033 == Biomes.field_203620_Z) {
            return iWorld.func_201669_a(\u26032, 0) > 8 && iWorld.func_180495_p(\u26032.func_177977_b()).func_177230_c() == Blocks.field_150432_aD;
        }
        return super.func_205020_a(iWorld, bl);
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_70631_g_()) {
            return SoundEvents.field_190027_es;
        }
        return SoundEvents.field_190026_er;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_190029_eu;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void func_189796_de() {
        if (this.field_189797_bB <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.field_189797_bB = 40;
        }
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_189969_E;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_189798_bx, false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_189799_by = this.field_189800_bz;
            this.field_189800_bz = this.func_189793_df() ? MathHelper.func_76131_a(this.field_189800_bz + 1.0f, 0.0f, 6.0f) : MathHelper.func_76131_a(this.field_189800_bz - 1.0f, 0.0f, 6.0f);
        }
        if (this.field_189797_bB > 0) {
            --this.field_189797_bB;
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (bl) {
            this.func_174815_a(this, entity);
        }
        return bl;
    }

    public boolean func_189793_df() {
        return this.field_70180_af.func_187225_a(field_189798_bx);
    }

    public void func_189794_p(boolean bl) {
        this.field_70180_af.func_187227_b(field_189798_bx, bl);
    }

    @Override
    protected float func_189749_co() {
        return 0.98f;
    }

    @Override
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData \u260322, @Nullable NBTTagCompound nBTTagCompound) {
        IEntityLivingData \u260322;
        if (\u260322 instanceof GroupData) {
            if (((GroupData)\u260322).field_190101_a) {
                this.func_70873_a(-24000);
            }
        } else {
            GroupData groupData = new GroupData();
            groupData.field_190101_a = true;
            \u260322 = groupData;
        }
        return \u260322;
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic() {
            super(EntityPolarBear.this, 2.0);
        }

        @Override
        public boolean func_75250_a() {
            if (!EntityPolarBear.this.func_70631_g_() && !EntityPolarBear.this.func_70027_ad()) {
                return false;
            }
            return super.func_75250_a();
        }
    }

    class AIMeleeAttack
    extends EntityAIAttackMelee {
        public AIMeleeAttack() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void func_190102_a(EntityLivingBase entityLivingBase, double d) {
            \u2603 = this.func_179512_a(entityLivingBase);
            if (d <= \u2603 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k(entityLivingBase);
                EntityPolarBear.this.func_189794_p(false);
            } else if (d <= \u2603 * 2.0) {
                if (this.field_75439_d <= 0) {
                    EntityPolarBear.this.func_189794_p(false);
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    EntityPolarBear.this.func_189794_p(true);
                    EntityPolarBear.this.func_189796_de();
                }
            } else {
                this.field_75439_d = 20;
                EntityPolarBear.this.func_189794_p(false);
            }
        }

        @Override
        public void func_75251_c() {
            EntityPolarBear.this.func_189794_p(false);
            super.func_75251_c();
        }

        @Override
        protected double func_179512_a(EntityLivingBase entityLivingBase) {
            return 4.0f + entityLivingBase.field_70130_N;
        }
    }

    class AIAttackPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackPlayer() {
            super(EntityPolarBear.this, EntityPlayer.class, 20, true, true, null);
        }

        @Override
        public boolean func_75250_a() {
            if (EntityPolarBear.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                List<EntityPolarBear> list = EntityPolarBear.this.field_70170_p.func_72872_a(EntityPolarBear.class, EntityPolarBear.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                for (EntityPolarBear entityPolarBear : list) {
                    if (!entityPolarBear.func_70631_g_()) continue;
                    return true;
                }
            }
            EntityPolarBear.this.func_70624_b(null);
            return false;
        }

        @Override
        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityPolarBear.this, false, new Class[0]);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            if (EntityPolarBear.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        @Override
        protected void func_179446_a(EntityCreature entityCreature, EntityLivingBase entityLivingBase) {
            if (entityCreature instanceof EntityPolarBear && !entityCreature.func_70631_g_()) {
                super.func_179446_a(entityCreature, entityLivingBase);
            }
        }
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean field_190101_a;

        private GroupData() {
        }
    }
}

