/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedRecipeBuilder {
    private static final Logger field_200474_a = LogManager.getLogger();
    private final Item field_200475_b;
    private final int field_200476_c;
    private final List<String> field_200477_d = Lists.newArrayList();
    private final Map<Character, Ingredient> field_200478_e = Maps.newLinkedHashMap();
    private final Advancement.Builder field_200479_f = Advancement.Builder.func_200278_a();
    private String field_200480_g;

    public ShapedRecipeBuilder(IItemProvider iItemProvider, int n) {
        this.field_200475_b = iItemProvider.func_199767_j();
        this.field_200476_c = n;
    }

    public static ShapedRecipeBuilder func_200470_a(IItemProvider iItemProvider) {
        return ShapedRecipeBuilder.func_200468_a(iItemProvider, 1);
    }

    public static ShapedRecipeBuilder func_200468_a(IItemProvider iItemProvider, int n) {
        return new ShapedRecipeBuilder(iItemProvider, n);
    }

    public ShapedRecipeBuilder func_200469_a(Character c, Tag<Item> tag) {
        return this.func_200471_a(c, Ingredient.func_199805_a(tag));
    }

    public ShapedRecipeBuilder func_200462_a(Character c, IItemProvider iItemProvider) {
        return this.func_200471_a(c, Ingredient.func_199804_a(iItemProvider));
    }

    public ShapedRecipeBuilder func_200471_a(Character c, Ingredient ingredient) {
        if (this.field_200478_e.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.field_200478_e.put(c, ingredient);
        return this;
    }

    public ShapedRecipeBuilder func_200472_a(String string) {
        if (!this.field_200477_d.isEmpty() && string.length() != this.field_200477_d.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.field_200477_d.add(string);
        return this;
    }

    public ShapedRecipeBuilder func_200465_a(String string, ICriterionInstance iCriterionInstance) {
        this.field_200479_f.func_200275_a(string, iCriterionInstance);
        return this;
    }

    public ShapedRecipeBuilder func_200473_b(String string) {
        this.field_200480_g = string;
        return this;
    }

    public void func_200464_a(Consumer<IFinishedRecipe> consumer) {
        this.func_200467_a(consumer, IRegistry.field_212630_s.func_177774_c(this.field_200475_b));
    }

    public void func_200466_a(Consumer<IFinishedRecipe> consumer, String string) {
        ResourceLocation resourceLocation = IRegistry.field_212630_s.func_177774_c(this.field_200475_b);
        if (new ResourceLocation(string).equals(resourceLocation)) {
            throw new IllegalStateException("Shaped Recipe " + string + " should remove its 'save' argument");
        }
        this.func_200467_a(consumer, new ResourceLocation(string));
    }

    public void func_200467_a(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.func_200463_a(resourceLocation);
        this.field_200479_f.func_200272_a(new ResourceLocation("minecraft:recipes/root")).func_200275_a("has_the_recipe", new RecipeUnlockedTrigger.Instance(resourceLocation)).func_200271_a(AdvancementRewards.Builder.func_200280_c(resourceLocation)).func_200270_a(RequirementsStrategy.OR);
        consumer.accept(new Result(resourceLocation, this.field_200475_b, this.field_200476_c, this.field_200480_g == null ? "" : this.field_200480_g, this.field_200477_d, this.field_200478_e, this.field_200479_f, new ResourceLocation(resourceLocation.func_110624_b(), "recipes/" + this.field_200475_b.func_77640_w().func_200300_c() + "/" + resourceLocation.func_110623_a())));
    }

    private void func_200463_a(ResourceLocation resourceLocation) {
        if (this.field_200477_d.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + resourceLocation + "!");
        }
        HashSet hashSet = Sets.newHashSet(this.field_200478_e.keySet());
        hashSet.remove(Character.valueOf(' '));
        for (String string : this.field_200477_d) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!this.field_200478_e.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + resourceLocation + " uses undefined symbol '" + c + "'");
                }
                hashSet.remove(Character.valueOf(c));
            }
        }
        if (!hashSet.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + resourceLocation);
        }
        if (this.field_200477_d.size() == 1 && this.field_200477_d.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + resourceLocation + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.field_200479_f.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    class Result
    implements IFinishedRecipe {
        private final ResourceLocation field_200445_b;
        private final Item field_200446_c;
        private final int field_200447_d;
        private final String field_200448_e;
        private final List<String> field_200449_f;
        private final Map<Character, Ingredient> field_200450_g;
        private final Advancement.Builder field_200451_h;
        private final ResourceLocation field_200452_i;

        public Result(ResourceLocation resourceLocation, Item item, int n, String string, List<String> list, Map<Character, Ingredient> map, Advancement.Builder builder, ResourceLocation resourceLocation2) {
            this.field_200445_b = resourceLocation;
            this.field_200446_c = item;
            this.field_200447_d = n;
            this.field_200448_e = string;
            this.field_200449_f = list;
            this.field_200450_g = map;
            this.field_200451_h = builder;
            this.field_200452_i = resourceLocation2;
        }

        @Override
        public JsonObject func_200441_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", "crafting_shaped");
            if (!this.field_200448_e.isEmpty()) {
                jsonObject.addProperty("group", this.field_200448_e);
            }
            JsonArray \u26032 = new JsonArray();
            for (String string : this.field_200449_f) {
                \u26032.add(string);
            }
            jsonObject.add("pattern", (JsonElement)\u26032);
            JsonObject jsonObject2 = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.field_200450_g.entrySet()) {
                jsonObject2.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            jsonObject.add("key", (JsonElement)jsonObject2);
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty("item", IRegistry.field_212630_s.func_177774_c(this.field_200446_c).toString());
            if (this.field_200447_d > 1) {
                jsonObject3.addProperty("count", (Number)this.field_200447_d);
            }
            jsonObject.add("result", (JsonElement)jsonObject3);
            return jsonObject;
        }

        @Override
        public ResourceLocation func_200442_b() {
            return this.field_200445_b;
        }

        @Override
        @Nullable
        public JsonObject func_200440_c() {
            return this.field_200451_h.func_200273_b();
        }

        @Override
        @Nullable
        public ResourceLocation func_200443_d() {
            return this.field_200452_i;
        }
    }
}

