/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl.data;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.command.impl.data.DataCommand;
import net.minecraft.command.impl.data.IDataAccessor;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class BlockDataAccessor
implements IDataAccessor {
    private static final SimpleCommandExceptionType field_198931_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.data.block.invalid", new Object[0]));
    public static final DataCommand.IDataProvider field_198930_a = new DataCommand.IDataProvider(){

        @Override
        public IDataAccessor func_198919_a(CommandContext<CommandSource> commandContext) throws CommandSyntaxException {
            BlockPos blockPos = BlockPosArgument.func_197273_a(commandContext, "pos");
            TileEntity \u26032 = ((CommandSource)commandContext.getSource()).func_197023_e().func_175625_s(blockPos);
            if (\u26032 == null) {
                throw field_198931_b.create();
            }
            return new BlockDataAccessor(\u26032, blockPos);
        }

        @Override
        public ArgumentBuilder<CommandSource, ?> func_198920_a(ArgumentBuilder<CommandSource, ?> argumentBuilder, Function<ArgumentBuilder<CommandSource, ?>, ArgumentBuilder<CommandSource, ?>> function) {
            return argumentBuilder.then(Commands.func_197057_a("block").then(function.apply((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("pos", BlockPosArgument.func_197276_a()))));
        }
    };
    private final TileEntity field_198932_c;
    private final BlockPos field_198933_d;

    public BlockDataAccessor(TileEntity tileEntity, BlockPos blockPos) {
        this.field_198932_c = tileEntity;
        this.field_198933_d = blockPos;
    }

    @Override
    public void func_198925_a(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("x", this.field_198933_d.func_177958_n());
        nBTTagCompound.func_74768_a("y", this.field_198933_d.func_177956_o());
        nBTTagCompound.func_74768_a("z", this.field_198933_d.func_177952_p());
        this.field_198932_c.func_145839_a(nBTTagCompound);
        this.field_198932_c.func_70296_d();
        IBlockState iBlockState = this.field_198932_c.func_145831_w().func_180495_p(this.field_198933_d);
        this.field_198932_c.func_145831_w().func_184138_a(this.field_198933_d, iBlockState, iBlockState, 3);
    }

    @Override
    public NBTTagCompound func_198923_a() {
        return this.field_198932_c.func_189515_b(new NBTTagCompound());
    }

    @Override
    public ITextComponent func_198921_b() {
        return new TextComponentTranslation("commands.data.block.modified", this.field_198933_d.func_177958_n(), this.field_198933_d.func_177956_o(), this.field_198933_d.func_177952_p());
    }

    @Override
    public ITextComponent func_198924_b(INBTBase iNBTBase) {
        return new TextComponentTranslation("commands.data.block.query", this.field_198933_d.func_177958_n(), this.field_198933_d.func_177956_o(), this.field_198933_d.func_177952_p(), iNBTBase.func_197637_c());
    }

    @Override
    public ITextComponent func_198922_a(NBTPathArgument.NBTPath nBTPath, double d, int n) {
        return new TextComponentTranslation("commands.data.block.get", nBTPath, this.field_198933_d.func_177958_n(), this.field_198933_d.func_177956_o(), this.field_198933_d.func_177952_p(), String.format(Locale.ROOT, "%.2f", d), n);
    }
}

