/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.TextComponentTranslation;

public class SuggestionProviders {
    private static final Map<ResourceLocation, SuggestionProvider<ISuggestionProvider>> field_197506_e = Maps.newHashMap();
    private static final ResourceLocation field_197507_f = new ResourceLocation("minecraft:ask_server");
    public static final SuggestionProvider<ISuggestionProvider> field_197502_a = SuggestionProviders.func_197494_a(field_197507_f, (SuggestionProvider<ISuggestionProvider>)((SuggestionProvider)(commandContext, suggestionsBuilder) -> ((ISuggestionProvider)commandContext.getSource()).func_197009_a((CommandContext<ISuggestionProvider>)commandContext, suggestionsBuilder)));
    public static final SuggestionProvider<CommandSource> field_197503_b = SuggestionProviders.func_197494_a(new ResourceLocation("minecraft:all_recipes"), (SuggestionProvider<ISuggestionProvider>)((SuggestionProvider)(commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197014_a(((ISuggestionProvider)commandContext.getSource()).func_199612_m(), suggestionsBuilder)));
    public static final SuggestionProvider<CommandSource> field_197504_c = SuggestionProviders.func_197494_a(new ResourceLocation("minecraft:available_sounds"), (SuggestionProvider<ISuggestionProvider>)((SuggestionProvider)(commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197014_a(((ISuggestionProvider)commandContext.getSource()).func_197010_l(), suggestionsBuilder)));
    public static final SuggestionProvider<CommandSource> field_197505_d = SuggestionProviders.func_197494_a(new ResourceLocation("minecraft:summonable_entities"), (SuggestionProvider<ISuggestionProvider>)((SuggestionProvider)(commandContext, suggestionsBuilder) -> ISuggestionProvider.func_201725_a(IRegistry.field_212629_r.func_201756_e().filter(EntityType::func_200720_b), suggestionsBuilder, EntityType::func_200718_a, entityType -> new TextComponentTranslation(Util.func_200697_a("entity", EntityType.func_200718_a(entityType)), new Object[0]))));

    public static <S extends ISuggestionProvider> SuggestionProvider<S> func_197494_a(ResourceLocation resourceLocation, SuggestionProvider<ISuggestionProvider> suggestionProvider) {
        if (field_197506_e.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("A command suggestion provider is already registered with the name " + resourceLocation);
        }
        field_197506_e.put(resourceLocation, suggestionProvider);
        return new Wrapper(resourceLocation, suggestionProvider);
    }

    public static SuggestionProvider<ISuggestionProvider> func_197498_a(ResourceLocation resourceLocation) {
        return field_197506_e.getOrDefault(resourceLocation, field_197502_a);
    }

    public static ResourceLocation func_197497_a(SuggestionProvider<ISuggestionProvider> suggestionProvider) {
        if (suggestionProvider instanceof Wrapper) {
            return ((Wrapper)suggestionProvider).field_197493_b;
        }
        return field_197507_f;
    }

    public static SuggestionProvider<ISuggestionProvider> func_197496_b(SuggestionProvider<ISuggestionProvider> suggestionProvider) {
        if (suggestionProvider instanceof Wrapper) {
            return suggestionProvider;
        }
        return field_197502_a;
    }

    public static class Wrapper
    implements SuggestionProvider<ISuggestionProvider> {
        private final SuggestionProvider<ISuggestionProvider> field_197492_a;
        private final ResourceLocation field_197493_b;

        public Wrapper(ResourceLocation resourceLocation, SuggestionProvider<ISuggestionProvider> suggestionProvider) {
            this.field_197492_a = suggestionProvider;
            this.field_197493_b = resourceLocation;
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<ISuggestionProvider> commandContext, SuggestionsBuilder suggestionsBuilder) throws CommandSyntaxException {
            return this.field_197492_a.getSuggestions(commandContext, suggestionsBuilder);
        }
    }
}

