/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.MinMaxBoundsWrapped;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;

public class EntityOptions {
    private static final Map<String, IOptionHandler> field_197478_k = Maps.newHashMap();
    public static final DynamicCommandExceptionType field_197468_a = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.entity.options.unknown", object));
    public static final DynamicCommandExceptionType field_202058_b = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.entity.options.inapplicable", object));
    public static final SimpleCommandExceptionType field_197469_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.options.distance.negative", new Object[0]));
    public static final SimpleCommandExceptionType field_197471_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.options.level.negative", new Object[0]));
    public static final SimpleCommandExceptionType field_197472_e = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.options.limit.toosmall", new Object[0]));
    public static final DynamicCommandExceptionType field_197475_h = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.entity.options.sort.irreversible", object));
    public static final DynamicCommandExceptionType field_197476_i = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.entity.options.mode.invalid", object));
    public static final DynamicCommandExceptionType field_197477_j = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.entity.options.type.invalid", object));

    private static void func_202024_a(String string, Filter filter, Predicate<EntitySelectorParser> predicate, ITextComponent iTextComponent) {
        field_197478_k.put(string, new IOptionHandler(filter, predicate, iTextComponent));
    }

    public static void func_197445_a() {
        if (!field_197478_k.isEmpty()) {
            return;
        }
        EntityOptions.func_202024_a("name", entitySelectorParser -> {
            int n = entitySelectorParser.func_197398_f().getCursor();
            boolean \u26032 = entitySelectorParser.func_197378_e();
            String \u26033 = entitySelectorParser.func_197398_f().readString();
            if (entitySelectorParser.func_201997_v() && !\u26032) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_202058_b.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f(), (Object)"name");
            }
            if (\u26032) {
                entitySelectorParser.func_201998_d(true);
            } else {
                entitySelectorParser.func_201990_c(true);
            }
            entitySelectorParser.func_197401_a(entity -> entity.func_200200_C_().func_150261_e().equals(\u26033) != \u26032);
        }, entitySelectorParser -> !entitySelectorParser.func_201984_u(), new TextComponentTranslation("argument.entity.options.name.description", new Object[0]));
        EntityOptions.func_202024_a("distance", entitySelectorParser -> {
            int n = entitySelectorParser.func_197398_f().getCursor();
            MinMaxBounds.FloatBound \u26032 = MinMaxBounds.FloatBound.func_211357_a(entitySelectorParser.func_197398_f());
            if (\u26032.func_196973_a() != null && ((Float)\u26032.func_196973_a()).floatValue() < 0.0f || \u26032.func_196977_b() != null && ((Float)\u26032.func_196977_b()).floatValue() < 0.0f) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_197469_b.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f());
            }
            entitySelectorParser.func_197397_a(\u26032);
            entitySelectorParser.func_197365_g();
        }, entitySelectorParser -> entitySelectorParser.func_197370_h().func_211335_c(), new TextComponentTranslation("argument.entity.options.distance.description", new Object[0]));
        EntityOptions.func_202024_a("level", entitySelectorParser -> {
            int n = entitySelectorParser.func_197398_f().getCursor();
            MinMaxBounds.IntBound \u26032 = MinMaxBounds.IntBound.func_211342_a(entitySelectorParser.func_197398_f());
            if (\u26032.func_196973_a() != null && (Integer)\u26032.func_196973_a() < 0 || \u26032.func_196977_b() != null && (Integer)\u26032.func_196977_b() < 0) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_197471_d.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f());
            }
            entitySelectorParser.func_197399_b(\u26032);
            entitySelectorParser.func_197373_a(false);
        }, entitySelectorParser -> entitySelectorParser.func_197394_i().func_211335_c(), new TextComponentTranslation("argument.entity.options.level.description", new Object[0]));
        EntityOptions.func_202024_a("x", entitySelectorParser -> {
            entitySelectorParser.func_197365_g();
            entitySelectorParser.func_197384_a(entitySelectorParser.func_197398_f().readDouble());
        }, entitySelectorParser -> entitySelectorParser.func_201965_l() == null, new TextComponentTranslation("argument.entity.options.x.description", new Object[0]));
        EntityOptions.func_202024_a("y", entitySelectorParser -> {
            entitySelectorParser.func_197365_g();
            entitySelectorParser.func_197395_b(entitySelectorParser.func_197398_f().readDouble());
        }, entitySelectorParser -> entitySelectorParser.func_201991_m() == null, new TextComponentTranslation("argument.entity.options.y.description", new Object[0]));
        EntityOptions.func_202024_a("z", entitySelectorParser -> {
            entitySelectorParser.func_197365_g();
            entitySelectorParser.func_197372_c(entitySelectorParser.func_197398_f().readDouble());
        }, entitySelectorParser -> entitySelectorParser.func_201983_n() == null, new TextComponentTranslation("argument.entity.options.z.description", new Object[0]));
        EntityOptions.func_202024_a("dx", entitySelectorParser -> {
            entitySelectorParser.func_197365_g();
            entitySelectorParser.func_197377_d(entitySelectorParser.func_197398_f().readDouble());
        }, entitySelectorParser -> entitySelectorParser.func_201977_o() == null, new TextComponentTranslation("argument.entity.options.dx.description", new Object[0]));
        EntityOptions.func_202024_a("dy", entitySelectorParser -> {
            entitySelectorParser.func_197365_g();
            entitySelectorParser.func_197391_e(entitySelectorParser.func_197398_f().readDouble());
        }, entitySelectorParser -> entitySelectorParser.func_201971_p() == null, new TextComponentTranslation("argument.entity.options.dy.description", new Object[0]));
        EntityOptions.func_202024_a("dz", entitySelectorParser -> {
            entitySelectorParser.func_197365_g();
            entitySelectorParser.func_197405_f(entitySelectorParser.func_197398_f().readDouble());
        }, entitySelectorParser -> entitySelectorParser.func_201962_q() == null, new TextComponentTranslation("argument.entity.options.dz.description", new Object[0]));
        EntityOptions.func_202024_a("x_rotation", entitySelectorParser -> entitySelectorParser.func_197389_c(MinMaxBoundsWrapped.func_207921_a(entitySelectorParser.func_197398_f(), true, MathHelper::func_76142_g)), entitySelectorParser -> entitySelectorParser.func_201968_j() == MinMaxBoundsWrapped.field_207926_a, new TextComponentTranslation("argument.entity.options.x_rotation.description", new Object[0]));
        EntityOptions.func_202024_a("y_rotation", entitySelectorParser -> entitySelectorParser.func_197387_d(MinMaxBoundsWrapped.func_207921_a(entitySelectorParser.func_197398_f(), true, MathHelper::func_76142_g)), entitySelectorParser -> entitySelectorParser.func_201980_k() == MinMaxBoundsWrapped.field_207926_a, new TextComponentTranslation("argument.entity.options.y_rotation.description", new Object[0]));
        EntityOptions.func_202024_a("limit", entitySelectorParser -> {
            int n = entitySelectorParser.func_197398_f().getCursor();
            \u2603 = entitySelectorParser.func_197398_f().readInt();
            if (\u2603 < 1) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_197472_e.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f());
            }
            entitySelectorParser.func_197388_a(\u2603);
            entitySelectorParser.func_201979_e(true);
        }, entitySelectorParser -> !entitySelectorParser.func_197381_m() && !entitySelectorParser.func_201967_w(), new TextComponentTranslation("argument.entity.options.limit.description", new Object[0]));
        EntityOptions.func_202024_a("sort", entitySelectorParser2 -> {
            EntitySelectorParser entitySelectorParser2;
            int n = entitySelectorParser2.func_197398_f().getCursor();
            String \u26032 = entitySelectorParser2.func_197398_f().readUnquotedString();
            entitySelectorParser2.func_201978_a((suggestionsBuilder, consumer) -> ISuggestionProvider.func_197005_b(Arrays.asList("nearest", "furthest", "random", "arbitrary"), suggestionsBuilder));
            switch (\u26032) {
                case "nearest": {
                    BiConsumer<Vec3d, List<? extends Entity>> biConsumer = EntitySelectorParser.field_197414_g;
                    break;
                }
                case "furthest": {
                    BiConsumer<Vec3d, List<? extends Entity>> biConsumer = EntitySelectorParser.field_197415_h;
                    break;
                }
                case "random": {
                    BiConsumer<Vec3d, List<? extends Entity>> biConsumer = EntitySelectorParser.field_197416_i;
                    break;
                }
                case "arbitrary": {
                    BiConsumer<Vec3d, List<? extends Entity>> biConsumer = EntitySelectorParser.field_197413_f;
                    break;
                }
                default: {
                    entitySelectorParser2.func_197398_f().setCursor(n);
                    throw field_197475_h.createWithContext((ImmutableStringReader)entitySelectorParser2.func_197398_f(), (Object)\u26032);
                }
            }
            entitySelectorParser2.func_197376_a(biConsumer);
            entitySelectorParser2.func_201986_f(true);
        }, entitySelectorParser -> !entitySelectorParser.func_197381_m() && !entitySelectorParser.func_201976_x(), new TextComponentTranslation("argument.entity.options.sort.description", new Object[0]));
        EntityOptions.func_202024_a("gamemode", entitySelectorParser -> {
            entitySelectorParser.func_201978_a((suggestionsBuilder2, consumer) -> {
                SuggestionsBuilder suggestionsBuilder2;
                String string = suggestionsBuilder2.getRemaining().toLowerCase(Locale.ROOT);
                boolean \u26032 = !entitySelectorParser.func_201961_z();
                boolean \u26033 = true;
                if (!string.isEmpty()) {
                    if (string.charAt(0) == '!') {
                        \u26032 = false;
                        string = string.substring(1);
                    } else {
                        \u26033 = false;
                    }
                }
                for (GameType gameType : GameType.values()) {
                    if (gameType == GameType.NOT_SET || !gameType.func_77149_b().toLowerCase(Locale.ROOT).startsWith(string)) continue;
                    if (\u26033) {
                        suggestionsBuilder2.suggest('!' + gameType.func_77149_b());
                    }
                    if (!\u26032) continue;
                    suggestionsBuilder2.suggest(gameType.func_77149_b());
                }
                return suggestionsBuilder2.buildFuture();
            });
            int n = entitySelectorParser.func_197398_f().getCursor();
            boolean \u26032 = entitySelectorParser.func_197378_e();
            if (entitySelectorParser.func_201961_z() && !\u26032) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_202058_b.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f(), (Object)"gamemode");
            }
            String \u26033 = entitySelectorParser.func_197398_f().readUnquotedString();
            GameType \u26034 = GameType.func_185328_a(\u26033, GameType.NOT_SET);
            if (\u26034 == GameType.NOT_SET) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_197476_i.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f(), (Object)\u26033);
            }
            entitySelectorParser.func_197373_a(false);
            entitySelectorParser.func_197401_a(entity -> {
                if (!(entity instanceof EntityPlayerMP)) {
                    return false;
                }
                GameType gameType2 = ((EntityPlayerMP)entity).field_71134_c.func_73081_b();
                return \u26032 ? gameType2 != \u26034 : gameType2 == \u26034;
            });
            if (\u26032) {
                entitySelectorParser.func_201973_h(true);
            } else {
                entitySelectorParser.func_201988_g(true);
            }
        }, entitySelectorParser -> !entitySelectorParser.func_201987_y(), new TextComponentTranslation("argument.entity.options.gamemode.description", new Object[0]));
        EntityOptions.func_202024_a("team", entitySelectorParser -> {
            boolean bl = entitySelectorParser.func_197378_e();
            String \u26032 = entitySelectorParser.func_197398_f().readUnquotedString();
            entitySelectorParser.func_197401_a(entity -> {
                if (!(entity instanceof EntityLivingBase)) {
                    return false;
                }
                Team team = entity.func_96124_cp();
                String \u26032 = team == null ? "" : team.func_96661_b();
                return \u26032.equals(\u26032) != bl;
            });
            if (bl) {
                entitySelectorParser.func_201958_j(true);
            } else {
                entitySelectorParser.func_201975_i(true);
            }
        }, entitySelectorParser -> !entitySelectorParser.func_201960_A(), new TextComponentTranslation("argument.entity.options.team.description", new Object[0]));
        EntityOptions.func_202024_a("type", entitySelectorParser -> {
            entitySelectorParser.func_201978_a((suggestionsBuilder, consumer) -> {
                ISuggestionProvider.func_197006_a(IRegistry.field_212629_r.func_148742_b(), suggestionsBuilder, String.valueOf('!'));
                if (!entitySelectorParser.func_201985_F()) {
                    ISuggestionProvider.func_197014_a(IRegistry.field_212629_r.func_148742_b(), suggestionsBuilder);
                }
                return suggestionsBuilder.buildFuture();
            });
            int n = entitySelectorParser.func_197398_f().getCursor();
            boolean \u26032 = entitySelectorParser.func_197378_e();
            if (entitySelectorParser.func_201985_F() && !\u26032) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_202058_b.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f(), (Object)"type");
            }
            ResourceLocation \u26033 = ResourceLocation.func_195826_a(entitySelectorParser.func_197398_f());
            EntityType<?> \u26034 = IRegistry.field_212629_r.func_212608_b(\u26033);
            if (\u26034 == null) {
                entitySelectorParser.func_197398_f().setCursor(n);
                throw field_197477_j.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f(), (Object)\u26033.toString());
            }
            if (Objects.equals(EntityType.field_200729_aH, \u26034) && !\u26032) {
                entitySelectorParser.func_197373_a(false);
            }
            entitySelectorParser.func_197401_a(entity -> Objects.equals(\u26034, entity.func_200600_R()) != \u26032);
            if (\u26032) {
                entitySelectorParser.func_201982_C();
            } else {
                entitySelectorParser.func_201964_a(\u26034.func_201760_c());
            }
        }, entitySelectorParser -> !entitySelectorParser.func_201963_E(), new TextComponentTranslation("argument.entity.options.type.description", new Object[0]));
        EntityOptions.func_202024_a("tag", entitySelectorParser -> {
            boolean bl = entitySelectorParser.func_197378_e();
            String \u26032 = entitySelectorParser.func_197398_f().readUnquotedString();
            entitySelectorParser.func_197401_a(entity -> {
                if ("".equals(\u26032)) {
                    return entity.func_184216_O().isEmpty() != bl;
                }
                return entity.func_184216_O().contains(\u26032) != bl;
            });
        }, entitySelectorParser -> true, new TextComponentTranslation("argument.entity.options.tag.description", new Object[0]));
        EntityOptions.func_202024_a("nbt", entitySelectorParser -> {
            boolean bl = entitySelectorParser.func_197378_e();
            NBTTagCompound \u26032 = new JsonToNBT(entitySelectorParser.func_197398_f()).func_193593_f();
            entitySelectorParser.func_197401_a(entity -> {
                NBTTagCompound nBTTagCompound2 = entity.func_189511_e(new NBTTagCompound());
                if (entity instanceof EntityPlayerMP && !(\u2603 = ((EntityPlayerMP)entity).field_71071_by.func_70448_g()).func_190926_b()) {
                    nBTTagCompound2.func_74782_a("SelectedItem", \u2603.func_77955_b(new NBTTagCompound()));
                }
                return NBTUtil.func_181123_a(\u26032, nBTTagCompound2, true) != bl;
            });
        }, entitySelectorParser -> true, new TextComponentTranslation("argument.entity.options.nbt.description", new Object[0]));
        EntityOptions.func_202024_a("scores", entitySelectorParser -> {
            StringReader stringReader = entitySelectorParser.func_197398_f();
            HashMap \u26032 = Maps.newHashMap();
            stringReader.expect('{');
            stringReader.skipWhitespace();
            while (stringReader.canRead() && stringReader.peek() != '}') {
                stringReader.skipWhitespace();
                String string = stringReader.readUnquotedString();
                stringReader.skipWhitespace();
                stringReader.expect('=');
                stringReader.skipWhitespace();
                MinMaxBounds.IntBound \u26033 = MinMaxBounds.IntBound.func_211342_a(stringReader);
                \u26032.put(string, \u26033);
                stringReader.skipWhitespace();
                if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                stringReader.skip();
            }
            stringReader.expect('}');
            if (!\u26032.isEmpty()) {
                entitySelectorParser.func_197401_a(entity -> {
                    ServerScoreboard serverScoreboard = entity.func_184102_h().func_200251_aP();
                    String \u26032 = entity.func_195047_I_();
                    for (Map.Entry entry : \u26032.entrySet()) {
                        ScoreObjective scoreObjective = serverScoreboard.func_96518_b((String)entry.getKey());
                        if (scoreObjective == null) {
                            return false;
                        }
                        if (!serverScoreboard.func_178819_b(\u26032, scoreObjective)) {
                            return false;
                        }
                        Score \u26033 = serverScoreboard.func_96529_a(\u26032, scoreObjective);
                        int \u26034 = \u26033.func_96652_c();
                        if (((MinMaxBounds.IntBound)entry.getValue()).func_211339_d(\u26034)) continue;
                        return false;
                    }
                    return true;
                });
            }
            entitySelectorParser.func_201970_k(true);
        }, entitySelectorParser -> !entitySelectorParser.func_201995_G(), new TextComponentTranslation("argument.entity.options.scores.description", new Object[0]));
        EntityOptions.func_202024_a("advancements", entitySelectorParser -> {
            StringReader stringReader = entitySelectorParser.func_197398_f();
            HashMap \u26032 = Maps.newHashMap();
            stringReader.expect('{');
            stringReader.skipWhitespace();
            while (stringReader.canRead() && stringReader.peek() != '}') {
                stringReader.skipWhitespace();
                ResourceLocation resourceLocation = ResourceLocation.func_195826_a(stringReader);
                stringReader.skipWhitespace();
                stringReader.expect('=');
                stringReader.skipWhitespace();
                if (stringReader.canRead() && stringReader.peek() == '{') {
                    HashMap hashMap = Maps.newHashMap();
                    stringReader.skipWhitespace();
                    stringReader.expect('{');
                    stringReader.skipWhitespace();
                    while (stringReader.canRead() && stringReader.peek() != '}') {
                        stringReader.skipWhitespace();
                        String string = stringReader.readUnquotedString();
                        stringReader.skipWhitespace();
                        stringReader.expect('=');
                        stringReader.skipWhitespace();
                        boolean \u26033 = stringReader.readBoolean();
                        hashMap.put(string, criterionProgress -> criterionProgress.func_192151_a() == \u26033);
                        stringReader.skipWhitespace();
                        if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                        stringReader.skip();
                    }
                    stringReader.skipWhitespace();
                    stringReader.expect('}');
                    stringReader.skipWhitespace();
                    \u26032.put(resourceLocation, advancementProgress -> {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            CriterionProgress criterionProgress = advancementProgress.func_192106_c((String)entry.getKey());
                            if (criterionProgress != null && ((Predicate)entry.getValue()).test(criterionProgress)) continue;
                            return false;
                        }
                        return true;
                    });
                } else {
                    boolean bl = stringReader.readBoolean();
                    \u26032.put(resourceLocation, advancementProgress -> advancementProgress.func_192105_a() == bl);
                }
                stringReader.skipWhitespace();
                if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                stringReader.skip();
            }
            stringReader.expect('}');
            if (!\u26032.isEmpty()) {
                entitySelectorParser.func_197401_a(entity -> {
                    if (!(entity instanceof EntityPlayerMP)) {
                        return false;
                    }
                    EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
                    PlayerAdvancements \u26032 = entityPlayerMP.func_192039_O();
                    AdvancementManager \u26033 = entityPlayerMP.func_184102_h().func_191949_aK();
                    for (Map.Entry entry : \u26032.entrySet()) {
                        Advancement advancement = \u26033.func_192778_a((ResourceLocation)entry.getKey());
                        if (advancement != null && ((Predicate)entry.getValue()).test(\u26032.func_192747_a(advancement))) continue;
                        return false;
                    }
                    return true;
                });
                entitySelectorParser.func_197373_a(false);
            }
            entitySelectorParser.func_201992_l(true);
        }, entitySelectorParser -> !entitySelectorParser.func_201966_H(), new TextComponentTranslation("argument.entity.options.advancements.description", new Object[0]));
    }

    public static Filter func_202017_a(EntitySelectorParser entitySelectorParser, String string, int n) throws CommandSyntaxException {
        IOptionHandler iOptionHandler = field_197478_k.get(string);
        if (iOptionHandler != null) {
            if (iOptionHandler.field_202013_b.test(entitySelectorParser)) {
                return iOptionHandler.field_202012_a;
            }
            throw field_202058_b.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f(), (Object)string);
        }
        entitySelectorParser.func_197398_f().setCursor(n);
        throw field_197468_a.createWithContext((ImmutableStringReader)entitySelectorParser.func_197398_f(), (Object)string);
    }

    public static void func_202049_a(EntitySelectorParser entitySelectorParser, SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, IOptionHandler> entry : field_197478_k.entrySet()) {
            if (!entry.getValue().field_202013_b.test(entitySelectorParser) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(string)) continue;
            suggestionsBuilder.suggest(entry.getKey() + '=', (Message)entry.getValue().field_202014_c);
        }
    }

    static class IOptionHandler {
        public final Filter field_202012_a;
        public final Predicate<EntitySelectorParser> field_202013_b;
        public final ITextComponent field_202014_c;

        private IOptionHandler(Filter filter, Predicate<EntitySelectorParser> predicate, ITextComponent iTextComponent) {
            this.field_202012_a = filter;
            this.field_202013_b = predicate;
            this.field_202014_c = iTextComponent;
        }
    }

    public static interface Filter {
        public void handle(EntitySelectorParser var1) throws CommandSyntaxException;
    }
}

