/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockSnowLayer
extends Block {
    public static final IntegerProperty field_176315_a = BlockStateProperties.field_208129_ad;
    protected static final VoxelShape[] field_196508_b = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    protected BlockSnowLayer(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176315_a, 1));
    }

    @Override
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        switch (pathType) {
            case LAND: {
                return iBlockState.func_177229_b(field_176315_a) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_176315_a) == 8;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        if (enumFacing == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return field_196508_b[iBlockState.func_177229_b(field_176315_a)];
    }

    @Override
    public VoxelShape func_196268_f(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return field_196508_b[iBlockState.func_177229_b(field_176315_a) - 1];
    }

    @Override
    public boolean func_196260_a(IBlockState iBlockState, IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        IBlockState iBlockState2 = iWorldReaderBase.func_180495_p(blockPos.func_177977_b());
        Block \u26032 = iBlockState2.func_177230_c();
        if (\u26032 == Blocks.field_150432_aD || \u26032 == Blocks.field_150403_cj || \u26032 == Blocks.field_180401_cv) {
            return false;
        }
        BlockFaceShape \u26033 = iBlockState2.func_193401_d(iWorldReaderBase, blockPos.func_177977_b(), EnumFacing.UP);
        return \u26033 == BlockFaceShape.SOLID || iBlockState2.func_203425_a(BlockTags.field_206952_E) || \u26032 == this && iBlockState2.func_177229_b(field_176315_a) == 8;
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (!iBlockState.func_196955_c(iWorld, blockPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(iBlockState, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public void func_180657_a(World world2, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        World world2;
        Integer n = iBlockState.func_177229_b(field_176315_a);
        if (this.func_149700_E() && EnchantmentHelper.func_77506_a(Enchantments.field_185306_r, itemStack) > 0) {
            if (n == 8) {
                BlockSnowLayer.func_180635_a(world2, blockPos, new ItemStack(Blocks.field_196604_cC));
            } else {
                for (int i = 0; i < n; ++i) {
                    BlockSnowLayer.func_180635_a(world2, blockPos, this.func_180643_i(iBlockState));
                }
            }
        } else {
            BlockSnowLayer.func_180635_a(world2, blockPos, new ItemStack(Items.field_151126_ay, n));
        }
        world2.func_175698_g(blockPos);
        entityPlayer.func_71029_a(StatList.field_188065_ae.func_199076_b(this));
        entityPlayer.func_71020_j(0.005f);
    }

    @Override
    public IItemProvider func_199769_a(IBlockState iBlockState, World world, BlockPos blockPos, int n) {
        return Items.field_190931_a;
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (world.func_175642_b(EnumLightType.BLOCK, blockPos) > 11) {
            iBlockState.func_196949_c(world, blockPos, 0);
            world.func_175698_g(blockPos);
        }
    }

    @Override
    public boolean func_196253_a(IBlockState iBlockState, BlockItemUseContext blockItemUseContext) {
        int n = iBlockState.func_177229_b(field_176315_a);
        if (blockItemUseContext.func_195996_i().func_77973_b() == this.func_199767_j() && n < 8) {
            if (blockItemUseContext.func_196012_c()) {
                return blockItemUseContext.func_196000_l() == EnumFacing.UP;
            }
            return true;
        }
        return n == 1;
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext2) {
        BlockItemUseContext blockItemUseContext2;
        IBlockState iBlockState = blockItemUseContext2.func_195991_k().func_180495_p(blockItemUseContext2.func_195995_a());
        if (iBlockState.func_177230_c() == this) {
            int n = iBlockState.func_177229_b(field_176315_a);
            return (IBlockState)iBlockState.func_206870_a(field_176315_a, Math.min(8, n + 1));
        }
        return super.func_196258_a(blockItemUseContext2);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176315_a);
    }

    @Override
    protected boolean func_149700_E() {
        return true;
    }
}

