/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockRailDetector
extends BlockRailBase {
    public static final EnumProperty<RailShape> field_176573_b = BlockStateProperties.field_208166_S;
    public static final BooleanProperty field_176574_M = BlockStateProperties.field_208194_u;

    public BlockRailDetector(Block.Properties properties) {
        super(true, properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176574_M, false)).func_206870_a(field_176573_b, RailShape.NORTH_SOUTH));
    }

    @Override
    public int func_149738_a(IWorldReaderBase iWorldReaderBase) {
        return 20;
    }

    @Override
    public boolean func_149744_f(IBlockState iBlockState) {
        return true;
    }

    @Override
    public void func_196262_a(IBlockState iBlockState, World world, BlockPos blockPos, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (iBlockState.func_177229_b(field_176574_M).booleanValue()) {
            return;
        }
        this.func_176570_e(world, blockPos, iBlockState);
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (world.field_72995_K || !iBlockState.func_177229_b(field_176574_M).booleanValue()) {
            return;
        }
        this.func_176570_e(world, blockPos, iBlockState);
    }

    @Override
    public int func_180656_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        return iBlockState.func_177229_b(field_176574_M) != false ? 15 : 0;
    }

    @Override
    public int func_176211_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        if (!iBlockState.func_177229_b(field_176574_M).booleanValue()) {
            return 0;
        }
        return enumFacing == EnumFacing.UP ? 15 : 0;
    }

    private void func_176570_e(World world, BlockPos blockPos, IBlockState iBlockState) {
        boolean bl = iBlockState.func_177229_b(field_176574_M);
        \u2603 = false;
        List<EntityMinecart> \u26032 = this.func_200878_a(world, blockPos, EntityMinecart.class, null);
        if (!\u26032.isEmpty()) {
            \u2603 = true;
        }
        if (\u2603 && !bl) {
            world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176574_M, true), 3);
            this.func_185592_b(world, blockPos, iBlockState, true);
            world.func_195593_d(blockPos, this);
            world.func_195593_d(blockPos.func_177977_b(), this);
            world.func_175704_b(blockPos, blockPos);
        }
        if (!\u2603 && bl) {
            world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176574_M, false), 3);
            this.func_185592_b(world, blockPos, iBlockState, false);
            world.func_195593_d(blockPos, this);
            world.func_195593_d(blockPos.func_177977_b(), this);
            world.func_175704_b(blockPos, blockPos);
        }
        if (\u2603) {
            world.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world));
        }
        world.func_175666_e(blockPos, this);
    }

    protected void func_185592_b(World world, BlockPos blockPos, IBlockState iBlockState, boolean bl) {
        BlockRailState blockRailState = new BlockRailState(world, blockPos, iBlockState);
        List<BlockPos> \u26032 = blockRailState.func_196907_a();
        for (BlockPos blockPos2 : \u26032) {
            IBlockState iBlockState2 = world.func_180495_p(blockPos2);
            iBlockState2.func_189546_a(world, blockPos2, iBlockState2.func_177230_c(), blockPos);
        }
    }

    @Override
    public void func_196259_b(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2) {
        if (iBlockState2.func_177230_c() == iBlockState.func_177230_c()) {
            return;
        }
        super.func_196259_b(iBlockState, world, blockPos, iBlockState2);
        this.func_176570_e(world, blockPos, iBlockState);
    }

    @Override
    public IProperty<RailShape> func_176560_l() {
        return field_176573_b;
    }

    @Override
    public boolean func_149740_M(IBlockState iBlockState) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState iBlockState, World world, BlockPos blockPos) {
        if (iBlockState.func_177229_b(field_176574_M).booleanValue()) {
            List<EntityMinecartCommandBlock> list = this.func_200878_a(world, blockPos, EntityMinecartCommandBlock.class, null);
            if (!list.isEmpty()) {
                return list.get(0).func_145822_e().func_145760_g();
            }
            List<EntityMinecart> \u26032 = this.func_200878_a(world, blockPos, EntityMinecart.class, EntitySelectors.field_96566_b);
            if (!\u26032.isEmpty()) {
                return Container.func_94526_b((IInventory)((Object)\u26032.get(0)));
            }
        }
        return 0;
    }

    protected <T extends EntityMinecart> List<T> func_200878_a(World world, BlockPos blockPos, Class<T> clazz, @Nullable Predicate<Entity> predicate) {
        return world.func_175647_a(clazz, this.func_176572_a(blockPos), predicate);
    }

    private AxisAlignedBB func_176572_a(BlockPos blockPos) {
        float f = 0.2f;
        return new AxisAlignedBB((float)blockPos.func_177958_n() + 0.2f, blockPos.func_177956_o(), (float)blockPos.func_177952_p() + 0.2f, (float)(blockPos.func_177958_n() + 1) - 0.2f, (float)(blockPos.func_177956_o() + 1) - 0.2f, (float)(blockPos.func_177952_p() + 1) - 0.2f);
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                switch (iBlockState.func_177229_b(field_176573_b)) {
                    case ASCENDING_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (iBlockState.func_177229_b(field_176573_b)) {
                    case NORTH_SOUTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (iBlockState.func_177229_b(field_176573_b)) {
                    case NORTH_SOUTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_EAST);
                    }
                }
            }
        }
        return iBlockState;
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        RailShape railShape = iBlockState.func_177229_b(field_176573_b);
        switch (mirror) {
            case LEFT_RIGHT: {
                switch (railShape) {
                    case ASCENDING_NORTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch (railShape) {
                    case ASCENDING_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)iBlockState.func_206870_a(field_176573_b, RailShape.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.func_185471_a(iBlockState, mirror);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176573_b, field_176574_M);
    }
}

